/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.logging.asynclogs;

import com.adventnet.wms.servercommon.logging.asynclogs.AsyncLogsProcessor;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class AsyncLogger
extends Logger {
    private Logger logger = null;

    public AsyncLogger(String name) {
        super(name, null);
        this.logger = Logger.getLogger(name);
    }

    public AsyncLogger(String name, String resourceBundleName) {
        super(name, resourceBundleName);
        this.logger = Logger.getLogger(name, resourceBundleName);
    }

    @Override
    public void log(Level level, String msg) {
        AsyncLogsProcessor.process(this.logger, level, msg);
    }

    @Override
    public void log(Level level, String msg, Object param) {
        AsyncLogsProcessor.process(this.logger, level, msg, param);
    }

    @Override
    public void log(Level level, String msg, Object[] params) {
        AsyncLogsProcessor.process(this.logger, level, msg, params);
    }

    @Override
    public void log(Level level, String msg, Throwable thrown) {
        AsyncLogsProcessor.process(this.logger, level, msg, thrown);
    }

    @Override
    public void log(LogRecord record) {
        AsyncLogsProcessor.process(this.logger, record);
    }

    @Override
    public void severe(String msg) {
        AsyncLogsProcessor.process(this.logger, Level.SEVERE, msg);
    }

    @Override
    public void warning(String msg) {
        AsyncLogsProcessor.process(this.logger, Level.WARNING, msg);
    }

    @Override
    public void info(String msg) {
        AsyncLogsProcessor.process(this.logger, Level.INFO, msg);
    }

    @Override
    public void config(String msg) {
        AsyncLogsProcessor.process(this.logger, Level.CONFIG, msg);
    }

    @Override
    public void fine(String msg) {
        AsyncLogsProcessor.process(this.logger, Level.FINE, msg);
    }

    @Override
    public void finer(String msg) {
        AsyncLogsProcessor.process(this.logger, Level.FINER, msg);
    }

    @Override
    public void finest(String msg) {
        AsyncLogsProcessor.process(this.logger, Level.FINEST, msg);
    }

    public int getQueueSize() {
        return AsyncLogsProcessor.queueSize();
    }
}

