/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.logging;

import java.io.File;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogLevelChange {
    private static Logger logger = Logger.getLogger(LogLevelChange.class.getName());

    public static Hashtable<String, String> changeLevelForPackage(String packageName, Level level) {
        HashSet<String> resultClasses = new HashSet<String>();
        Hashtable<String, String> resultHash = new Hashtable<String, String>();
        try {
            String path = packageName.replace(".", "/");
            Set directories = LogLevelChange.getDirectories(path);
            for (Object directory : directories) {
                File dir = new File(directory.toString());
                resultClasses.addAll(LogLevelChange.findClasses(dir, packageName));
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error while checking classess for package : " + packageName, e);
        }
        if (resultClasses == null || resultClasses.size() < 1) {
            resultHash.put(packageName, "Invalid Package Name");
            return resultHash;
        }
        resultHash = LogLevelChange.setLevel(resultClasses, level);
        return resultHash;
    }

    public static Hashtable<String, String> changeLevelOfAFile(String fileName, Level level) {
        Hashtable<String, String> resultHash = new Hashtable<String, String>();
        if (fileName.contains(".class")) {
            fileName = fileName.substring(0, fileName.indexOf(".class"));
        }
        fileName = fileName.replace(".", "/") + ".class";
        HashSet<String> resultClasses = new HashSet<String>();
        Set directories = LogLevelChange.getDirectories(fileName);
        for (Object directory : directories) {
            File dir = new File(directory.toString());
            resultClasses.addAll(LogLevelChange.findClasses(dir, fileName.replaceAll("/", ".")));
        }
        if (resultClasses == null || resultClasses.size() < 1) {
            resultHash.put(fileName.replaceAll("/", "."), "File not Found");
            return resultHash;
        }
        resultHash = LogLevelChange.setLevel(resultClasses, level);
        return resultHash;
    }

    private static Set getDirectories(String path) {
        HashSet<File> directories = new HashSet<File>();
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Enumeration<URL> resources = classLoader.getResources(path);
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                directories.add(new File(resource.getFile()));
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error while checking classes for package : " + path, e);
        }
        return directories;
    }

    private static Hashtable<String, String> setLevel(Set<String> classes, Level level) {
        Hashtable<String, String> result = new Hashtable<String, String>();
        for (String classPath : classes) {
            try {
                Logger.getLogger(classPath).setLevel(level);
                result.put(classPath, level.getName());
            }
            catch (Exception e) {
                result.put(classPath, "Failed");
                logger.log(Level.SEVERE, "Error while setting log level for class:" + classes, e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<String> findClasses(File directory, String packageName) {
        HashSet<String> classes;
        block12: {
            block11: {
                File[] files;
                classes = new HashSet<String>();
                if (!directory.exists()) break block11;
                if (directory.toString().contains(".class")) {
                    String className = directory.getPath();
                    classes.add(className.substring(className.indexOf("com")).replace(".class", "").replaceAll("/", "."));
                    return classes;
                }
                for (File file : files = directory.listFiles()) {
                    if (file.isDirectory()) {
                        classes.addAll(LogLevelChange.findClasses(file, packageName + "." + file.getName()));
                        continue;
                    }
                    if (!file.getName().endsWith(".class")) continue;
                    String className = file.getPath();
                    classes.add(className.substring(className.indexOf("com")).replace(".class", "").replaceAll("/", "."));
                }
                break block12;
            }
            if (!directory.toString().contains(".jar")) break block12;
            try (JarFile jar = new JarFile(directory.getPath().replace("file:", "").split("!")[0]);){
                Enumeration<JarEntry> enn = jar.entries();
                while (enn.hasMoreElements()) {
                    JarEntry entry = enn.nextElement();
                    if (!entry.getName().replaceAll("/", ".").contains(packageName) || !entry.getName().contains(".class")) continue;
                    classes.add(entry.getName().replace(".class", "").replaceAll("/", "."));
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error while working on directory : " + directory.getPath(), e);
            }
        }
        return classes;
    }
}

