/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.logging;

import java.io.OutputStream;
import java.util.logging.Logger;

public class ConsoleLogger
extends OutputStream {
    String newLineSeparator;
    Logger logger;

    public ConsoleLogger(String loggername) {
        this.logger = Logger.getLogger(loggername);
        this.newLineSeparator = System.getProperty("line.separator");
    }

    @Override
    public void write(byte[] b, int off, int len) {
        try {
            if (b != null && b.length > 0) {
                String data = new String(b, off, len);
                if (data == null || data.equals(this.newLineSeparator)) {
                    return;
                }
                this.logger.info(data);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void write(int b) {
        try {
            byte[] bytes = new byte[4];
            for (int i = 0; i < 4; ++i) {
                bytes[i] = (byte)(b >>> i * 8);
            }
            this.write(bytes, 0, 4);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void write(byte[] b) {
        try {
            this.write(b, 0, b.length);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

