/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.kafka;

import com.adventnet.wms.common.CommonUtil;
import com.adventnet.wms.servercommon.kafka.KafkaEventListener;
import com.adventnet.wms.servercommon.kafka.WMSKafkaQueueException;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class WMSKafkaProperties {
    private static String kafkapropFile = System.getProperty("server.home") + File.separator + "conf" + File.separator + "kafkaproducer.properties";
    private static String kafkatopicspropFile = System.getProperty("server.home") + File.separator + "conf" + File.separator + "kafkaproducertopics.properties";
    private static String kafkaConsumerPropFile = System.getProperty("server.home") + File.separator + "conf" + File.separator + "kafkaconsumer.properties";
    private static String kafkaConfPropFile = System.getProperty("server.home") + File.separator + "conf" + File.separator + "kafkaconf.properties";
    private static String kafkaConsumerTopicListenerPropFile = System.getProperty("server.home") + File.separator + "conf" + File.separator + "kafkaconsumertopiclistener.properties";
    private static boolean isConsumerConfigInitialized = false;
    private static Properties kafkaConfProps = null;
    private static Properties kafkaProps = null;
    private static Properties kafkaTopicsProps = null;
    private static Properties kafkaConsumerProps = null;
    private static Properties kafkaConsumerTopicsListenerProps = null;
    private static Hashtable consumerTopicMap = new Hashtable();
    private static Hashtable consumerPartitionMap = new Hashtable();
    private static Hashtable<String, Hashtable> categoryTopicsPartitions = new Hashtable();
    private static Hashtable<String, KafkaEventListener> consumerCategoryEventListenerMap = new Hashtable();
    private static Hashtable<String, Integer> categoryCommitModeMap = new Hashtable();
    private static Hashtable<String, Integer> categoryInitDelayMap = new Hashtable();
    private static int consumerDispatcherTPECount = 2;
    private static int consumerDispatcherTPEMaxCount = 2;

    public static void setKafkaConfDirectory(String direc) {
        if (direc != null) {
            if (!direc.endsWith(File.separator)) {
                direc = direc + File.separator;
            }
            kafkapropFile = direc + "kafkaproducer.properties";
            kafkatopicspropFile = direc + "kafkaproducertopics.properties";
            kafkaConsumerPropFile = direc + "kafkaconsumer.properties";
            kafkaConfPropFile = direc + "kafkaconf.properties";
            kafkaConsumerTopicListenerPropFile = direc + "kafkaconsumertopiclistener.properties";
        }
    }

    public static void setKafkaConsumerPropertiesFile(String file) {
        kafkaConsumerPropFile = file;
    }

    public static void loadKafkaConf() {
        kafkaConfProps = WMSKafkaProperties.getProperties(kafkaConfPropFile);
    }

    public static boolean loadConfigurations() throws WMSKafkaQueueException {
        kafkaProps = WMSKafkaProperties.getProperties(kafkapropFile);
        kafkaTopicsProps = WMSKafkaProperties.getProperties(kafkatopicspropFile);
        if (kafkaProps == null || kafkaTopicsProps == null) {
            throw new WMSKafkaQueueException("Unable to load kafka conf file ");
        }
        WMSKafkaProperties.initializeTopicsAndPartitions();
        return true;
    }

    public static boolean loadConsumerConfigurations() throws WMSKafkaQueueException {
        if (!isConsumerConfigInitialized) {
            kafkaConsumerProps = WMSKafkaProperties.getProperties(kafkaConsumerPropFile);
            kafkaConsumerTopicsListenerProps = WMSKafkaProperties.getProperties(kafkaConsumerTopicListenerPropFile);
            WMSKafkaProperties.loadKafkaConf();
            if (kafkaConsumerProps == null || kafkaConsumerTopicsListenerProps == null || kafkaConfProps == null) {
                throw new WMSKafkaQueueException("Unable to load kafka consumer conf file ");
            }
            WMSKafkaProperties.initializeTopicsAndEventListeners();
            WMSKafkaProperties.initKafkaConf();
            isConsumerConfigInitialized = true;
        }
        return true;
    }

    public static Properties getProperties(String propsFile) {
        try {
            Properties props = new Properties();
            props.load(new FileInputStream(propsFile));
            return props;
        }
        catch (Exception s) {
            s.printStackTrace();
            return null;
        }
    }

    private static void initKafkaConf() {
        try {
            consumerDispatcherTPECount = Integer.parseInt(kafkaConfProps.getProperty("consumerdispatchertpecount", "" + consumerDispatcherTPECount));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            consumerDispatcherTPEMaxCount = Integer.parseInt(kafkaConfProps.getProperty("consumerdispatchertpemaxcount", "" + consumerDispatcherTPEMaxCount));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void initializeTopicsAndEventListeners() {
        try {
            Enumeration<Object> e = kafkaConsumerTopicsListenerProps.keys();
            while (e.hasMoreElements()) {
                String category = (String)e.nextElement();
                String[] values = kafkaConsumerTopicsListenerProps.getProperty(category).split("\\|");
                String eventListenerClass = values[0];
                String topic = values[1];
                String partiion = values[2];
                if (values.length >= 4 && Integer.parseInt(values[3]) > 0) {
                    categoryCommitModeMap.put(category, Integer.parseInt(values[3]));
                }
                if (values.length >= 5 && Integer.parseInt(values[4]) > 0) {
                    categoryInitDelayMap.put(category, Integer.parseInt(values[4]));
                }
                consumerCategoryEventListenerMap.put(category, (KafkaEventListener)Class.forName(eventListenerClass).newInstance());
                consumerTopicMap.put(category, topic);
                consumerPartitionMap.put(category, partiion);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void initializeTopicsAndPartitions() {
        try {
            Properties kafkaTopicsPartitions = kafkaTopicsProps;
            Enumeration e = ((Hashtable)kafkaTopicsPartitions).keys();
            while (e.hasMoreElements()) {
                try {
                    String category = "" + e.nextElement();
                    ArrayList topicsPartitionsArr = CommonUtil.getList((String)("" + ((Hashtable)kafkaTopicsPartitions).get(category)));
                    if (topicsPartitionsArr == null) continue;
                    Hashtable<String, String> topicsPartition = new Hashtable<String, String>();
                    for (int topiccount = 0; topiccount < topicsPartitionsArr.size(); ++topiccount) {
                        try {
                            String[] topicsPartitionStr = ((String)topicsPartitionsArr.get(topiccount)).split("\\|");
                            String topic = topicsPartitionStr[0];
                            String partition = topicsPartitionStr[1];
                            topicsPartition.put(topic, partition);
                            continue;
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    categoryTopicsPartitions.put(category, topicsPartition);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static KafkaEventListener getConsumerTopicListenerObject(String category) {
        return consumerCategoryEventListenerMap.get(category);
    }

    public static ArrayList getCategoryTopicsList(String category) {
        if (kafkaTopicsProps != null && kafkaTopicsProps.getProperty(category) != null) {
            return CommonUtil.getList((String)kafkaTopicsProps.getProperty(category));
        }
        return null;
    }

    public static int getTopicPartitionCount(String category, String topic) {
        Hashtable topicsPartition;
        if (categoryTopicsPartitions != null && (topicsPartition = categoryTopicsPartitions.get(category)) != null && topicsPartition.get(topic) != null) {
            return Integer.parseInt("" + topicsPartition.get(topic));
        }
        return -1;
    }

    public static Hashtable<String, Hashtable> getCategoryTopicsTable() {
        return categoryTopicsPartitions;
    }

    public static String getConsumerTopic(String category) {
        return (String)consumerTopicMap.get(category);
    }

    public static int getConsumerPartition(String category) {
        return Integer.parseInt("" + consumerPartitionMap.get(category));
    }

    public static int getConsumerCommitMode(String category) {
        return categoryCommitModeMap.get(category) == null ? 0 : categoryCommitModeMap.get(category);
    }

    public static int getConsumerInitDelay(String category) {
        return categoryInitDelayMap.get(category) == null ? 0 : categoryInitDelayMap.get(category);
    }

    public static Properties getKafkaConsumerProps() {
        return kafkaConsumerProps;
    }

    public static Properties getKafkaProps() {
        return kafkaProps;
    }

    public static int getConsumerDispatcherTPECount() {
        return consumerDispatcherTPECount;
    }

    public static int getConsumerDispatcherTPEMaxCount() {
        return consumerDispatcherTPEMaxCount;
    }

    public static class CommitMode {
        public static final int NONE = 0;
        public static final int COMMIT_ON_RECEIVE = 1;
        public static final int COMMIT_ON_PROCESS = 2;
    }
}

