/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.kafka;

import com.adventnet.wms.common.HttpDataWraper;
import com.adventnet.wms.common.WmsEvent;
import com.adventnet.wms.servercommon.constants.KafkaConstants;
import com.adventnet.wms.servercommon.kafka.KafkaConsumer;
import com.adventnet.wms.servercommon.kafka.KafkaHighLevelConsumerImpl;
import com.adventnet.wms.servercommon.kafka.KafkaProducer;
import com.adventnet.wms.servercommon.kafka.KafkaProducerImpl;
import com.adventnet.wms.servercommon.kafka.KafkaWMSListener;
import com.adventnet.wms.servercommon.kafka.WMSKafkaProperties;
import com.adventnet.wms.servercommon.kafka.WMSKafkaQueueException;
import java.util.HashMap;
import java.util.Properties;
import org.apache.kafka.clients.producer.Callback;

public class KafkaManager {
    private static boolean asyncInitialized = false;
    private static boolean syncInitialized = false;
    private static HashMap<KafkaConstants.ProducerType, KafkaProducer> producerQueueMap = new HashMap();
    private static HashMap<String, KafkaConsumer> highLevelConsumerQueueMap = new HashMap();
    private static KafkaWMSListener kafkawmslistener;

    public static void setConfDirectory(String confDirectory) {
        WMSKafkaProperties.setKafkaConfDirectory(confDirectory);
    }

    public static void addProducerCallback(Callback producerCallback) {
        KafkaProducer producer = producerQueueMap.get((Object)KafkaConstants.ProducerType.ASYNC);
        if (producer != null) {
            producer.setProducerCallback(producerCallback);
        }
    }

    public static void setListener(KafkaWMSListener listener) {
        kafkawmslistener = listener;
    }

    public static boolean initializeProducer(int producerCount) throws WMSKafkaQueueException {
        return KafkaManager.initializeProducer(producerCount, null, 0, null);
    }

    public static boolean initializeProducer(int asyncProducerCount, int syncProducerCount) {
        return KafkaManager.initializeProducer(asyncProducerCount, null, syncProducerCount, null);
    }

    public static boolean initializeProducer(int asyncProducerCount, Properties asyncProducerProps, int syncProducerCount, Properties syncProducerProps) throws WMSKafkaQueueException {
        KafkaProducerImpl producer;
        WMSKafkaProperties.loadConfigurations();
        if (!asyncInitialized && asyncProducerCount > 0) {
            producer = new KafkaProducerImpl(asyncProducerCount, KafkaConstants.ProducerType.ASYNC, asyncProducerProps, kafkawmslistener);
            producerQueueMap.put(KafkaConstants.ProducerType.ASYNC, producer);
            asyncInitialized = true;
        }
        if (!syncInitialized && syncProducerCount > 0) {
            producer = new KafkaProducerImpl(syncProducerCount, KafkaConstants.ProducerType.SYNC, syncProducerProps, kafkawmslistener);
            producerQueueMap.put(KafkaConstants.ProducerType.SYNC, producer);
            syncInitialized = true;
        }
        if (asyncInitialized || syncInitialized) {
            return true;
        }
        return false;
    }

    public static boolean initializeSyncProducer(int syncProducerCount, Properties syncProducerProps) {
        return KafkaManager.initializeProducer(0, null, syncProducerCount, syncProducerProps);
    }

    public static boolean initializeAsyncProducer(int asyncProducerCount, Properties asyncProducerConfig) {
        return KafkaManager.initializeProducer(asyncProducerCount, asyncProducerConfig, 0, null);
    }

    public static boolean initializeHighLevelConsumer(String category, int highLevelConsumerCount, Properties highLevelConsumerProps, KafkaConstants.ConsumerDispatchType dispatchType) {
        WMSKafkaProperties.loadConsumerConfigurations();
        if (highLevelConsumerCount > 0) {
            KafkaHighLevelConsumerImpl consumer = new KafkaHighLevelConsumerImpl(category, highLevelConsumerCount, KafkaConstants.ConsumerType.HIGHLEVEL, highLevelConsumerProps, dispatchType);
            highLevelConsumerQueueMap.put(category, consumer);
        }
        return true;
    }

    public static void pushMessage(String topic, WmsEvent event) throws WMSKafkaQueueException {
        KafkaManager.pushMessage(KafkaConstants.ProducerType.ASYNC, topic, event);
    }

    public static void pushMessage(String topic, int partitionCount, String partitionkey, WmsEvent event) throws WMSKafkaQueueException {
        KafkaManager.pushMessage(KafkaConstants.ProducerType.ASYNC, -1, topic, partitionCount, partitionkey, event);
    }

    public static void pushMessage(KafkaConstants.ProducerType producerType, String topic, WmsEvent event) throws WMSKafkaQueueException {
        KafkaManager.pushMessage(producerType, topic, HttpDataWraper.getString((Object)event));
    }

    public static void pushMessage(KafkaConstants.ProducerType producerType, int produceSelectCount, String topic, int partitionCount, String partitionkey, WmsEvent event) throws WMSKafkaQueueException {
        KafkaManager.pushMessage(producerType, produceSelectCount, topic, partitionCount, partitionkey, HttpDataWraper.getString((Object)event));
    }

    public static void pushMessage(KafkaConstants.ProducerType producerType, int producerSelectCount, String topic, int partitionCount, String partitionkey, WmsEvent event, Callback msgCallback) throws WMSKafkaQueueException {
        if (!syncInitialized && !asyncInitialized) {
            throw new WMSKafkaQueueException("WMSKafkaQueue not initialized ");
        }
        KafkaProducer producer = producerQueueMap.get((Object)producerType);
        producer.addToQueue(producerSelectCount, topic, partitionCount, partitionkey, HttpDataWraper.getString((Object)event), msgCallback);
    }

    public static void pushMessage(String topic, String msg) throws WMSKafkaQueueException {
        KafkaManager.pushMessage(KafkaConstants.ProducerType.ASYNC, topic, -1, null, msg);
    }

    public static void pushMessage(KafkaConstants.ProducerType type, String topic, String msg) throws WMSKafkaQueueException {
        KafkaManager.pushMessage(type, topic, -1, null, msg);
    }

    public static void pushMessage(KafkaConstants.ProducerType producerType, String topic, int partitionCount, String partitionkey, String msg) throws WMSKafkaQueueException {
        KafkaManager.pushMessage(producerType, -1, topic, partitionCount, partitionkey, msg);
    }

    public static void pushMessage(KafkaConstants.ProducerType producerType, int producerSelectCount, String topic, int partitionCount, String partitionkey, String msg) throws WMSKafkaQueueException {
        if (!syncInitialized && !asyncInitialized) {
            throw new WMSKafkaQueueException("WMSKafkaQueue not initialized ");
        }
        KafkaProducer producer = producerQueueMap.get((Object)producerType);
        producer.addToQueue(producerSelectCount, topic, partitionCount, partitionkey, msg);
    }

    public static void startConsumer(String category) throws WMSKafkaQueueException {
        KafkaConsumer consumer = highLevelConsumerQueueMap.get(category);
        consumer.listen();
    }

    public static void shutdownAsyncProducer() {
        KafkaProducer producer = producerQueueMap.get((Object)KafkaConstants.ProducerType.ASYNC);
        producer.closeAllProducer();
        asyncInitialized = false;
    }

    public static void shutdownConsumer(String category) {
        KafkaConsumer consumer = highLevelConsumerQueueMap.get(category);
        highLevelConsumerQueueMap.remove(category);
        consumer.shutdown();
    }
}

