/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.kafka;

import com.adventnet.wms.servercommon.constants.KafkaConstants;
import com.adventnet.wms.servercommon.kafka.KafkaConsumer;
import com.adventnet.wms.servercommon.kafka.KafkaEventListener;
import com.adventnet.wms.servercommon.kafka.MessageDispatcher;
import com.adventnet.wms.servercommon.kafka.WMSKafkaProperties;
import com.adventnet.wms.servercommon.kafka.WMSKafkaQueueException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kafka.consumer.Consumer;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.ConsumerIterator;
import kafka.consumer.KafkaStream;
import kafka.javaapi.consumer.ConsumerConnector;

public class KafkaHighLevelConsumerImpl
extends KafkaConsumer {
    private static final String PROP_AUTO_COMMIT_ENABLE = "auto.commit.enable";
    private String category;
    private ConsumerConnector consumer;
    private ExecutorService executor;
    private KafkaEventListener eventListener = null;
    private KafkaConstants.ConsumerType consumerType;
    private Properties consumerProp = null;
    private KafkaConstants.ConsumerDispatchType dispatchType;
    private int numThreads = 1;
    private int commitmode = 0;
    private int initdelay = 0;

    public KafkaHighLevelConsumerImpl(String category, int numThreads, KafkaConstants.ConsumerType type, Properties prop, KafkaConstants.ConsumerDispatchType dispatchType) {
        this.dispatchType = dispatchType;
        this.category = category;
        this.consumerType = type;
        this.numThreads = numThreads;
        this.eventListener = WMSKafkaProperties.getConsumerTopicListenerObject(category);
        this.consumerProp = WMSKafkaProperties.getKafkaConsumerProps();
        this.commitmode = WMSKafkaProperties.getConsumerCommitMode(category);
        this.initdelay = WMSKafkaProperties.getConsumerInitDelay(category);
        this.consumerProp.putAll((Map<?, ?>)prop);
        if (this.commitmode != 0) {
            this.consumerProp.put(PROP_AUTO_COMMIT_ENABLE, "false");
        }
    }

    @Override
    public void shutdown() {
        if (this.consumer != null) {
            this.consumer.shutdown();
        }
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }

    @Override
    public void listen() throws WMSKafkaQueueException {
        String topic = WMSKafkaProperties.getConsumerTopic(this.category);
        this.consumer = Consumer.createJavaConsumerConnector((ConsumerConfig)new ConsumerConfig(this.consumerProp));
        HashMap<String, Integer> topicCountMap = new HashMap<String, Integer>();
        topicCountMap.put(topic, new Integer(this.numThreads));
        Map consumerMap = this.consumer.createMessageStreams(topicCountMap);
        List streams = (List)consumerMap.get(topic);
        this.executor = Executors.newFixedThreadPool(this.numThreads);
        for (KafkaStream stream : streams) {
            this.executor.submit(new ConsumerThread(this.eventListener, stream, this.dispatchType));
        }
    }

    class ConsumerThread
    implements Runnable {
        private KafkaEventListener listener;
        private KafkaStream stream;
        private KafkaConstants.ConsumerDispatchType disptachType;

        public ConsumerThread(KafkaEventListener listener, KafkaStream stream, KafkaConstants.ConsumerDispatchType dispatchType) {
            this.listener = listener;
            this.stream = stream;
        }

        @Override
        public void run() {
            ConsumerIterator it = this.stream.iterator();
            if (KafkaHighLevelConsumerImpl.this.initdelay > 0) {
                try {
                    Thread.sleep(KafkaHighLevelConsumerImpl.this.initdelay);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            while (it.hasNext()) {
                String msg = new String((byte[])it.next().message());
                if (KafkaHighLevelConsumerImpl.this.commitmode == 1) {
                    this.commitOffsets();
                }
                if (KafkaHighLevelConsumerImpl.this.dispatchType == KafkaConstants.ConsumerDispatchType.SYNC) {
                    boolean cont = this.listener.onMessage(msg);
                    if (!cont) {
                        break;
                    }
                } else {
                    MessageDispatcher.dispatchData(this.listener, msg);
                }
                if (KafkaHighLevelConsumerImpl.this.commitmode != 2) continue;
                this.commitOffsets();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void commitOffsets() {
            ConsumerConnector consumerConnector = KafkaHighLevelConsumerImpl.this.consumer;
            synchronized (consumerConnector) {
                KafkaHighLevelConsumerImpl.this.consumer.commitOffsets();
            }
        }
    }
}

