/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.grid;

import com.adventnet.wms.common.HttpDataWraper;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class PreCheckHandler {
    private static Logger logger = Logger.getLogger(PreCheckHandler.class.getName());
    private String name;
    private static Map<String, PreCheckHandler> preCheckHandlers = new HashMap<String, PreCheckHandler>();

    public PreCheckHandler(String name) {
        this.name = name;
    }

    public abstract PreCheckStatus preCheck();

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }

    public static boolean registerHandler(PreCheckHandler preCheckHandler) {
        try {
            if (!preCheckHandlers.containsKey(preCheckHandler.getName())) {
                preCheckHandlers.put(preCheckHandler.getName(), preCheckHandler);
                logger.info("PreCheckHandler " + preCheckHandler.getName() + " registered successfuly.");
                return true;
            }
            logger.info("PreCheckHandler " + preCheckHandler.getName() + " already registered successfuly.");
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error while registering preCheckHandler " + preCheckHandler, e);
        }
        return false;
    }

    public static PreCheckStatus runPreCheck(String name) {
        PreCheckHandler preCheckHandler = preCheckHandlers.get(name);
        if (preCheckHandler == null) {
            return PreCheckStatus.NOT_REGISTERED;
        }
        return preCheckHandler.preCheck();
    }

    public static Map<String, PreCheckStatus> runPreCheck() {
        HashMap<String, PreCheckStatus> preCheckStatus = new HashMap<String, PreCheckStatus>();
        for (String name : preCheckHandlers.keySet()) {
            try {
                preCheckStatus.put(name, preCheckHandlers.get(name).preCheck());
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error while running pre check : handlername=" + name, e);
                preCheckStatus.put(name, PreCheckStatus.FAILED_DUE_TO_RUNTIME_EXECUTION);
            }
        }
        return preCheckStatus;
    }

    public static enum PreCheckStatus {
        NOT_REGISTERED(-1, "PreCheck Handler not registered"),
        SUCCESS(1, "Precheck success"),
        FAILED(2, "Precheck failed"),
        WARNING(3, "Warning - Partial precheck passed"),
        FAILED_DUE_TO_RUNTIME_EXECUTION(4, "Failed due to runtime execution");

        private int statusCode;
        private String statusMessage;

        private PreCheckStatus(int statusCode, String statusMessage) {
            this.statusCode = statusCode;
            this.statusMessage = statusMessage;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getStatusMessage() {
            return this.statusMessage;
        }

        public String toString() {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("statuscode", this.statusCode);
            data.put("statusmsg", this.statusMessage);
            return HttpDataWraper.getString(data);
        }
    }
}

