/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.grid;

import com.adventnet.wms.servercommon.dc.DC;
import com.adventnet.wms.servercommon.grid.GeoMap;
import com.adventnet.wms.servercommon.grid.IPMap;
import com.adventnet.wms.servercommon.grid.WCH;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class DistributionManager {
    private static final Logger LOGGER = Logger.getLogger(DistributionManager.class.getName());
    protected static Map<String, List<String>> recentCDMap = new HashMap<String, List<String>>();
    protected static Map<String, WCH> cdMap = new ConcurrentHashMap<String, WCH>();
    protected static Map<String, String> refreshStatus = new ConcurrentHashMap<String, String>();
    protected static Map<String, Object> refreshLockObject = new ConcurrentHashMap<String, Object>();

    public abstract boolean handleCDChange(String var1, String var2, Map<String, WCH> var3, String var4);

    public abstract boolean handleIPMChange(String var1, String var2, IPMap var3);

    public abstract boolean handleGeoChange(String var1, String var2, GeoMap var3);

    public List<String> getRecentCDList(String cluster) {
        return recentCDMap.get(cluster);
    }

    public void addRecentCDList(String cluster, String rcd) {
        List<String> cdList = recentCDMap.get(cluster);
        if (cdList == null) {
            cdList = new ArrayList<String>(30);
        }
        cdList.add(rcd);
        recentCDMap.put(cluster, cdList);
    }

    public void setCurrentWCH(String cluster, WCH wch) {
        Object lockObject = refreshLockObject.get(cluster);
        if (lockObject == null) {
            lockObject = new Object();
            refreshLockObject.put(cluster, lockObject);
        }
        cdMap.put(cluster, wch);
    }

    public static String getClusterVersion(String cluster) {
        if (cdMap.containsKey(cluster)) {
            return cdMap.get(cluster).getVersion();
        }
        return null;
    }

    public static boolean isSameClusterVersion(String cluster, String version) throws Exception {
        return cdMap.get(cluster).isSameVersion(version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshClusterVersion(String cluster) {
        if (DistributionManager.isRefreshInProgress(cluster)) {
            return;
        }
        Object lockObject = refreshLockObject.get(cluster);
        if (lockObject == null) {
            lockObject = new Object();
            refreshLockObject.put(cluster, lockObject);
        }
        Object object = lockObject;
        synchronized (object) {
            if (DistributionManager.isRefreshInProgress(cluster)) {
                return;
            }
            new RefreshClusterVersion(cluster).start();
        }
    }

    public static boolean isRefreshInProgress(String cluster) {
        return refreshStatus.containsKey(cluster);
    }

    public static class ClusterChangeReason {
        public static final int ADDITION = 1;
        public static final int DETACH = 2;
        public static final int FAILED = 3;
        public static final int ACTIVE_REPLACEMENT = 4;
        public static final int FAILED_REPLACEMENT = 5;
        public static final int DUMMY = 6;
    }

    static class RefreshClusterVersion
    extends Thread {
        private String cluster;

        public RefreshClusterVersion(String cluster) {
            super("RefreshCV/RefreshClusterVersion-" + cluster);
            this.cluster = cluster;
        }

        @Override
        public void run() {
            if (DistributionManager.isRefreshInProgress(this.cluster)) {
                return;
            }
            try {
                refreshStatus.put(this.cluster, "");
                LOGGER.info("RefreshClusterVersion thread started for cluster = " + this.cluster);
                if (DC.updateClusterDistribution(this.cluster, null)) {
                    LOGGER.info("RefreshClusterVersion--> ClusterVersion updated successfully for cluster = " + this.cluster);
                    Thread.sleep(5000L);
                } else {
                    LOGGER.warning("RefreshClusterVersion--> Failed to update ClusterVersion for cluster = " + this.cluster);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "RefreshClusterVersion--> Exception while updating ClusterVersion for cluster = " + this.cluster, e);
            }
            finally {
                refreshStatus.remove(this.cluster);
            }
        }
    }
}

