/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.dc;

import com.adventnet.wms.common.CommonUtil;
import com.adventnet.wms.common.HttpConnection;
import com.adventnet.wms.common.HttpDataWraper;
import com.adventnet.wms.common.WmsService;
import com.adventnet.wms.servercommon.components.backup.NBMHandler;
import com.adventnet.wms.servercommon.components.constants.ComponentConstants;
import com.adventnet.wms.servercommon.components.logging.WmsLogger;
import com.adventnet.wms.servercommon.components.logging.util.CassandraUtil;
import com.adventnet.wms.servercommon.components.mdckms.MultiDCKeyMgmtConfHandler;
import com.adventnet.wms.servercommon.components.net.WCPConfManager;
import com.adventnet.wms.servercommon.components.security.WMSSecurityUtil;
import com.adventnet.wms.servercommon.dc.DCConstants;
import com.adventnet.wms.servercommon.dc.DCUtil;
import com.adventnet.wms.servercommon.grid.CommandExecutionInfo;
import com.adventnet.wms.servercommon.grid.ConfHandler;
import com.adventnet.wms.servercommon.grid.DistributionManager;
import com.adventnet.wms.servercommon.grid.GeoMap;
import com.adventnet.wms.servercommon.grid.GridEventHandler;
import com.adventnet.wms.servercommon.grid.IPMap;
import com.adventnet.wms.servercommon.grid.ProvisionHandler;
import com.adventnet.wms.servercommon.grid.ServingMode;
import com.adventnet.wms.servercommon.grid.SharedConf;
import com.adventnet.wms.servercommon.grid.VerifyIDCAccessKeyInfo;
import com.adventnet.wms.servercommon.grid.WCH;
import com.adventnet.wms.servercommon.grid.ar.ARHandler;
import com.adventnet.wms.servercommon.grid.ar.ARManager;
import com.adventnet.wms.servercommon.logging.TraceLogger;
import com.adventnet.wms.servercommon.mitigation.MitigationEngine;
import com.adventnet.wms.servercommon.qos.QOSClient;
import com.adventnet.wms.servercommon.stats.influx.StatsDB;
import com.adventnet.wms.servercommon.stats.influx.StatsDispatchManager;
import com.adventnet.wms.servercommon.stats.influx.conf.StatsConf;
import com.adventnet.wms.servercommon.util.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;

public class DC {
    private static final Logger LOGGER = Logger.getLogger(DC.class.getName());
    private static String dcId = null;
    private static String drDCID = null;
    private static String qosurl = null;
    private static String qosport = null;
    private static String cluster = null;
    private static String country = null;
    private static String region = null;
    private static String adminurl = null;
    private static String dradminurl = null;
    private static String reqOrigin = null;
    private static String servertype = null;
    private static String serverSecKey = null;
    private static String gridAccessKey = null;
    private static boolean isAssociated = false;
    private static boolean isExternal = false;
    private static long machineUpTime = -1L;
    private static long provisionId = -1L;
    private static int gaRetryCount = 10;
    private static long gaRetryInterval = 5000L;
    private static NBMHandler nbmHandler;
    private static ConfHandler confHandler;
    private static GridEventHandler geHandler;
    private static ProvisionHandler provisionHandler;
    private static ARHandler arHandler;
    private static Map<String, DistributionManager> cdManagerMap;
    private static Properties buildLog;
    private static boolean readonly;
    private static String servingMode;
    private static String startupArgs;
    private static boolean isPidStatsNeeded;
    private static boolean serverStartStatus;

    private static void loadBlog() {
        try {
            String serverHome = System.getProperty("server.home");
            buildLog = FileUtil.getFileAsProperties(serverHome + File.separator + "blog" + File.separator + "version.txt");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean loadDCConf() {
        try {
            String regionName;
            String startupargs;
            String servingmode;
            String gaRetry;
            String provisionid;
            String serverHome = System.getProperty("server.home");
            Properties dcProp = FileUtil.getFileAsProperties(serverHome + File.separator + "conf" + File.separator + "dc.conf");
            if (dcProp == null || dcProp.isEmpty()) {
                LOGGER.warning("dc.conf file is missing or null");
                return false;
            }
            dcId = dcProp.getProperty("dcid");
            drDCID = dcProp.getProperty("drdcid");
            cluster = dcProp.getProperty("cluster");
            if (cluster != null) {
                servertype = DC.getCluster().split("-")[0];
                reqOrigin = dcId + "/" + cluster + "/" + StatsConf.getServerIp();
            }
            qosport = dcProp.getProperty("qosport");
            serverSecKey = dcProp.getProperty("serverid");
            adminurl = dcProp.getProperty("adminurl");
            if (adminurl != null && qosport != null) {
                qosurl = adminurl.split(":")[0] + ":" + qosport;
            }
            dradminurl = dcProp.getProperty("adminurl-dr");
            String isassociated = dcProp.getProperty("isAssociated");
            if (isassociated != null) {
                isAssociated = Boolean.parseBoolean(isassociated);
            }
            if (!CommonUtil.isEmpty((String)(provisionid = dcProp.getProperty("pid")))) {
                try {
                    provisionId = Long.parseLong(provisionid);
                }
                catch (Exception e) {
                    LOGGER.severe("NS--> Exception while parsing provisionId to long");
                }
            }
            if (!CommonUtil.isEmpty((String)(gaRetry = dcProp.getProperty("garetry")))) {
                try {
                    gaRetryCount = Integer.parseInt(gaRetry.split(",")[0]);
                    gaRetryInterval = Long.parseLong(gaRetry.split(",")[1]);
                }
                catch (Exception e) {
                    LOGGER.severe("NS--> Exception while parsing gaRetry key. Setting it to default values. retryCount=10; retryInterval=5000");
                    gaRetryCount = 10;
                    gaRetryInterval = 5000L;
                }
            }
            if ((servingmode = dcProp.getProperty("mode")) != null) {
                servingMode = servingmode;
            }
            if ((startupargs = dcProp.getProperty("startup-args")) != null) {
                startupArgs = startupargs;
            }
            String dcType = dcProp.getProperty("dctype");
            isExternal = "external".equals(dcType);
            String countryName = dcProp.getProperty("country");
            if (countryName != null) {
                country = countryName;
            }
            if ((regionName = dcProp.getProperty("region")) != null) {
                region = regionName;
            }
            HashMap<String, String> influxInventory = new HashMap<String, String>();
            String influxCluster = dcProp.getProperty("influx.clusters");
            for (String cluster : CommonUtil.getList((String)influxCluster)) {
                influxInventory.put(cluster, dcProp.getProperty(cluster + ".ip"));
            }
            StatsConf.initialiseInfluxInventory(influxInventory);
            LOGGER.info("DC Configurations loaded successfully.");
            return true;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NS--> Error while loading DC Conf. \n", e);
            LOGGER.severe("Failed to load DC Configurations.");
            return false;
        }
    }

    public static boolean initialise(Map<String, String> dcProp) {
        try {
            dcId = dcProp.get("dcid");
            cluster = dcProp.get("cluster");
            if (cluster != null) {
                servertype = DC.getCluster().split("-")[0];
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NS--> Error while inside initialise. \n", e);
            return false;
        }
    }

    public static String getAdminUrl() {
        return adminurl;
    }

    public static String getDrAdminUrl() {
        return dradminurl;
    }

    public static String getCluster() {
        return cluster;
    }

    public static String getServertype() {
        return servertype;
    }

    public static String getReqOriginKey() {
        return "x-req-origin";
    }

    public static String getReqOriginValue() {
        return reqOrigin;
    }

    public static String getDCId() {
        if (dcId != null) {
            return dcId;
        }
        return "";
    }

    public static String getDrDCId() {
        if (drDCID != null) {
            return drDCID;
        }
        return "";
    }

    public static int getDCIdAsInt() {
        return DCUtil.getDCIdAsInt(DC.getDCId());
    }

    public static int getDrDCIdAsInt() {
        return DCUtil.getDCIdAsInt(DC.getDrDCId());
    }

    public static String getServingMode() {
        return servingMode;
    }

    public static Properties getBuildLog() {
        return buildLog;
    }

    public static String getBLogValue(String key) {
        return buildLog.getProperty(key);
    }

    public static int getProvisionType() {
        if (provisionHandler != null) {
            return provisionHandler.getProvType();
        }
        return -1;
    }

    public static String getStartupArgs() {
        return startupArgs;
    }

    public static String getCountry() {
        return country;
    }

    public static String getRegion() {
        return region;
    }

    public static boolean isReadOnlyMode() {
        return readonly;
    }

    public static boolean isExternal() {
        return isExternal;
    }

    public static long getMachineUpTime() {
        return machineUpTime;
    }

    public static void setReadOnlyMode(boolean readonlyMode) {
        readonly = readonlyMode;
        servingMode = readonly ? "RO" : "RW";
    }

    public static void setAndUpdateToAdmin(boolean readonlyMode) {
        DC.setReadOnlyMode(readonlyMode);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("servingmode", servingMode);
        QOSClient.send(HttpDataWraper.getString(data));
    }

    public static void registerNBMHandler(NBMHandler handler) {
        try {
            nbmHandler = handler;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NS--> Error while registering NBM handler. \n", e);
        }
    }

    public static void registerProvisionHandler(ProvisionHandler pobj) {
        try {
            provisionHandler = pobj;
            provisionHandler.initialise(provisionId);
            LOGGER.info("Provision handler initialized.");
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NS--> Error while registering provision handler. \n", e);
        }
    }

    public static void registerConfHandler(ConfHandler cobj) {
        try {
            confHandler = cobj;
            LOGGER.info("Conf handler initialized.");
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NS--> Error while registering configuration handler. \n", e);
        }
    }

    public static void registerGridEventHandler(GridEventHandler gobj) {
        try {
            geHandler = gobj;
            LOGGER.info("GridEvent handler initialized.");
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NS--> Error while registering GridEvent handler. \n", e);
        }
    }

    public static void registerDistributionManager(String cdName, DistributionManager cdobj) {
        try {
            cdManagerMap.put(cdName, cdobj);
            LOGGER.info("NS--> Distribution Manager initialized. cdName=" + cdName);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NS--> Error while registering distribution handler. \n", e);
        }
    }

    public static boolean isRegisteredCD(String cdName) {
        return cdManagerMap.containsKey(cdName);
    }

    public static void registerARHandler(ARHandler arObj) {
        try {
            arHandler = arObj;
            LOGGER.info("ActiveReplacement handler initialized.");
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NS--> Error while registering ActiveReplacement handler. \n", e);
        }
    }

    public static List<String> getRecentCDList(String cluster, String cdName) {
        try {
            DistributionManager dManager = cdManagerMap.get(cdName);
            return dManager.getRecentCDList(cluster);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NS--> Error while getting RecentRCDList for cd: " + cdName + ". \n", e);
            return null;
        }
    }

    public static boolean loadConf() {
        try {
            if (isAssociated) {
                DC.associateWithGrid();
            }
            DC.startQOSDispatcher();
            Hashtable<String, String> params = new Hashtable<String, String>();
            params.put("conf-type", "initial");
            params.put("cluster", cluster);
            String confValue = HttpDataWraper.getString((Object)DC.getDataFromAdmin("/getServerConf.do", params, 2));
            if (confValue != null) {
                return DC.handleConfChange("all", confValue);
            }
            LOGGER.info("NS--> GetServerConf response is null inside DC.");
            return true;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NS--> Error while loading conf inside loadConf(). \n", e);
            return false;
        }
    }

    private static boolean updateTraceConf(String traceConf) {
        try {
            Map traceConfMap = (Map)HttpDataWraper.getObject((String)traceConf);
            Map trackMap = (Map)traceConfMap.get("tracklist");
            Map<String, List<String>> taillMap = new HashMap<String, List<String>>();
            if (traceConfMap.containsKey("taillist")) {
                taillMap = (Map)traceConfMap.get("taillist");
            }
            return TraceLogger.updateTraceConf(trackMap, taillMap);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NS--> Error while updating trace conf. \n", e);
            return false;
        }
    }

    private static boolean updateMitigationConf(String mitigationConf) {
        try {
            ArrayList mitigationConfMap = (ArrayList)HttpDataWraper.getObject((String)mitigationConf);
            if (mitigationConfMap == null) {
                mitigationConfMap = new ArrayList();
            }
            return MitigationEngine.initialise(mitigationConfMap);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NS--> Error while updating mitigation conf. MitigationConf string: " + mitigationConf + " \n", e);
            return false;
        }
    }

    private static boolean updateSharedConf(String sharedConf) {
        try {
            HashMap sharedConfMap = (HashMap)HttpDataWraper.getObject((String)sharedConf);
            if (sharedConfMap == null) {
                sharedConfMap = new HashMap();
            }
            return SharedConf.initialise(sharedConfMap);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NS--> Error while updating shared conf. SharedConf string: " + sharedConf + " \n", e);
            return false;
        }
    }

    public static void updateServerConf(String confName) {
        try {
            Hashtable<String, String> params = new Hashtable<String, String>();
            params.put("conf-type", confName);
            params.put("cluster", cluster);
            String response = HttpDataWraper.getString((Object)DC.getDataFromAdmin("/getServerConf.do", params, 1));
            Hashtable confValue = (Hashtable)HttpDataWraper.getObject((String)response);
            confHandler.handleConfChange(confName, confValue);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NS--> Error inside updateServerConf for confName: " + confName + " \n", e);
        }
    }

    public static boolean updateClusterDistribution(String cluster, String version) throws Exception {
        return DC.updateClusterDistribution(dcId, cluster, version);
    }

    public static boolean updateClusterDistribution(String dcid, String cluster, String version) throws Exception {
        if (cluster == null) {
            throw new Exception("Cluster cannot be null");
        }
        if (dcid == null) {
            dcid = dcId;
        }
        try {
            Object dataObject;
            Hashtable<String, String> params = new Hashtable<String, String>();
            params.put("cluster", cluster);
            params.put("dcid", dcid);
            if (version != null && !version.isEmpty()) {
                params.put("version", version);
            }
            if ((dataObject = DC.getDataFromAdmin("/getClusterDistribution.do", params, 1)) instanceof Hashtable) {
                Hashtable cdData = (Hashtable)DC.getDataFromAdmin("/getClusterDistribution.do", params, 1);
                return DC.handleCDChange(cdData);
            }
            if (dataObject instanceof String) {
                LOGGER.severe("NS--> Error in DC - updateClusterDistribution for cdData : " + dataObject + " for cluster=" + cluster + " dcid=" + dcid);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NS--> Error inside updateClusterDistribution for version: " + version + " cluster=" + cluster + " dcid=" + dcid, e);
            throw e;
        }
        return false;
    }

    private static void startQOSDispatcher() {
        if (DC.isExternal()) {
            return;
        }
        try {
            QOSClient.init("ws://" + qosurl + "/qos", true);
            LOGGER.info("NS--> QOS Connection made succcessfully");
            QOSClient.stopQOSDispatcher();
            QOSClient.startQOSDispatcher();
            LOGGER.info("NS--> QOS Dispatcher started successfully");
            HashMap<String, Serializable> data = new HashMap<String, Serializable>();
            data.put("blog", buildLog);
            if (provisionHandler != null) {
                data.put("prov_type", Integer.valueOf(provisionHandler.getProvType()));
            }
            QOSClient.send(HttpDataWraper.getString(data));
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NS--> Error while starting QOSDispatcher. \n", e);
        }
    }

    public static boolean startProvisioning() {
        return provisionHandler.startProvisioning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void changeProvisionStatus() {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            String provisionConfPath = System.getProperty("server.home") + File.separator + "conf" + File.separator + provisionId + ".properties";
            in = new FileInputStream(provisionConfPath);
            Properties props = new Properties();
            props.load(in);
            out = new FileOutputStream(provisionConfPath);
            props.setProperty("status", "false");
            props.setProperty("provtype", "4");
            props.store(out, null);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NS--> Error while changing Provision status. \n", e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static boolean notifyARStart(int serverMode) {
        if (arHandler != null) {
            return arHandler.onStart(serverMode, provisionHandler.getProvMap());
        }
        return false;
    }

    public static boolean notifyARComplete(int serverMode) {
        return DC.notifyARComplete(serverMode, null);
    }

    public static boolean notifyARComplete(int serverMode, String operation) {
        if (arHandler == null) {
            LOGGER.warning("ARWARN--> ARHandler not registered with DC. servermode=" + serverMode);
            return false;
        }
        switch (serverMode) {
            case 1: {
                boolean onCompleteStatus = arHandler.onComplete();
                if (!onCompleteStatus) break;
                ARManager.notifyOnComplete();
                return onCompleteStatus;
            }
            case 2: {
                if (CommonUtil.isEmpty((String)operation) || !"switch".equals(operation)) {
                    boolean takeOverStatus = arHandler.takeOver();
                    if (!takeOverStatus) break;
                    ARManager.notifyOnComplete();
                    return takeOverStatus;
                }
                return arHandler.takeOverForSwitch();
            }
            default: {
                LOGGER.warning("ARWARN--> Invalid serverMode inside notifyARComplete; servermode=" + serverMode);
            }
        }
        return false;
    }

    public static boolean notifyARFailure(int serverMode, int moduleId, int errorCode) {
        if (arHandler != null) {
            return arHandler.onFailure(serverMode, moduleId, errorCode);
        }
        return false;
    }

    private static boolean associateWithGrid() {
        try {
            Hashtable<String, String> params = new Hashtable<String, String>();
            params.put("cluster", cluster);
            DC.getDataFromAdmin("/associateWithGrid.do", params, 2);
            LOGGER.info("NS--> Successfully associated to grid.");
            DC.startQOSDispatcher();
            return true;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NS--> Error inside associateWithGrid. \n", e);
            return false;
        }
    }

    public static boolean reAssociate(String ip) {
        try {
            Hashtable<String, String> params = new Hashtable<String, String>();
            params.put("ip", ip);
            String response = (String)DC.getDataFromAdmin("/reAssociate.do", params, 1);
            if (CommonUtil.isEmpty((String)response)) {
                LOGGER.info("NS--> Response is empty | null inside reAssociateWithGrid");
            } else {
                if (response.equals("Success")) {
                    LOGGER.info("NS--> Successfully reAssociated IP: " + ip);
                    return true;
                }
                LOGGER.info("NS--> Invalid response inside reAssociateWithGrid. Response--> " + response);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NS--> Error inside reAssociateWithGrid. \n", e);
        }
        return false;
    }

    public static boolean attachToGrid() {
        int type = -1;
        Map<String, String> provMap = null;
        try {
            type = provisionHandler.getProvType();
            provMap = provisionHandler.getProvMap();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NS--> Error while getting provType and provMap inside attachToGrid. \n", e);
        }
        try {
            Hashtable<String, String> params = new Hashtable<String, String>();
            params.put("cluster", cluster);
            params.put("prov-type", Integer.toString(type));
            params.put("prov-map", HttpDataWraper.getString(provMap));
            params.put("provid", Long.toString(provisionId));
            for (int i = 0; i < gaRetryCount; ++i) {
                LOGGER.info("NS--> AttachToGrid retry=" + i);
                try {
                    String response = (String)DC.getDataFromAdmin("/attachToGrid.do", params, 2);
                    if (!CommonUtil.isEmpty((String)response)) {
                        if (response.equals("success")) {
                            LOGGER.info("NS--> Successfully attached to grid.");
                            DC.changeProvisionStatus();
                            return true;
                        }
                        if (response.equals("falied")) {
                            LOGGER.severe("NS--> Response from admin server for attachToGrid is " + response);
                            continue;
                        }
                        LOGGER.severe("NS--> Invalid response from admin server for attachToGrid. Response:" + response);
                        continue;
                    }
                    LOGGER.severe("NS--> Response for attachToGrid is null | empty.");
                    continue;
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "NS--> Error while calling attachToGrid. \n", e);
                    try {
                        Thread.sleep(gaRetryInterval);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NS--> Error inside attachToGrid. \n", e);
        }
        return false;
    }

    public static boolean detachFromGrid(int type, Map<String, String> provMap) {
        try {
            Hashtable<String, String> params = new Hashtable<String, String>();
            params.put("cluster", cluster);
            for (int i = 0; i < gaRetryCount; ++i) {
                try {
                    String response = (String)DC.getDataFromAdmin("/detachFromGrid.do", params, 1);
                    if (!CommonUtil.isEmpty((String)response)) {
                        if (response.equals("success")) {
                            LOGGER.severe("NS--> Successfully detached from grid.");
                            return true;
                        }
                        if (response.equals("falied")) {
                            LOGGER.severe("NS--> Response from admin server for detachFromGrid is " + response);
                            continue;
                        }
                        LOGGER.severe("NS--> Invalid response from admin server for detachFromGrid. Response:" + response);
                        continue;
                    }
                    LOGGER.severe("NS--> Response for detachFromGrid is null | empty.");
                    continue;
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "NS--> Error inside detachFromGrid. \n", e);
                    try {
                        Thread.sleep(gaRetryInterval);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NS--> Error inside detachFromGrid. \n", e);
        }
        return false;
    }

    public static boolean notifyPreparedState() {
        try {
            Hashtable<String, String> params = new Hashtable<String, String>();
            params.put("cluster", cluster);
            for (int i = 0; i < gaRetryCount; ++i) {
                try {
                    String response = (String)DC.getDataFromAdmin("/attachToGrid.do", params, 1);
                    if (!CommonUtil.isEmpty((String)response)) {
                        if (response.equals("success")) {
                            LOGGER.info("NS--> Successfully changed to prepared state.");
                            return true;
                        }
                        if (response.equals("falied")) {
                            LOGGER.severe("NS--> Response from admin server for notifyPreparedState is " + response);
                            continue;
                        }
                        LOGGER.severe("NS--> Invalid response from admin server for notifyPreparedState. Response:" + response);
                        continue;
                    }
                    LOGGER.severe("NS--> Response for notifyPrepareState is null | empty.");
                    continue;
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "NS--> Error inside notifyPreparedState. \n", e);
                    try {
                        Thread.sleep(gaRetryInterval);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NS--> Error inside notifyPreparedState. \n", e);
        }
        return false;
    }

    public static Hashtable<String, List<String>> getIpsOfACluster(String clusterName) {
        return DC.getIpsOfACluster(clusterName, false);
    }

    public static Hashtable<String, List<String>> getIpsOfACluster(String clusterName, boolean withPort) {
        Hashtable ips = new Hashtable();
        try {
            Hashtable<String, String> params = new Hashtable<String, String>();
            params.put("withport", "" + withPort);
            params.put("clustername", clusterName);
            params.put("cluster", DC.getCluster());
            Object response = DC.getDataFromAdmin("/getserverips.do", params, 1);
            if (response instanceof Hashtable) {
                ips = (Hashtable)response;
            } else if (response instanceof String) {
                LOGGER.info("NS--> Invalid response for getIpsOfACluster. Response: " + response);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NS--> Error inside getIpsOfACluster. Cluster: " + clusterName + ". \n", e);
        }
        return ips;
    }

    public static Hashtable<String, Hashtable<String, String>> getIpsOfAClusterWithPosition(String clusterName) {
        return DC.getIpsOfAClusterWithPosition(clusterName, false, true);
    }

    public static Hashtable<String, Hashtable<String, String>> getIpsOfAClusterWithPosition(String clusterName, boolean withPort) {
        return DC.getIpsOfAClusterWithPosition(clusterName, withPort, true);
    }

    public static Hashtable<String, Hashtable<String, String>> getIpsOfAClusterWithPosition(String clusterName, boolean withPort, boolean isSelfConnEnabled) {
        Hashtable ipsWithPosition = new Hashtable();
        try {
            Hashtable<String, String> params = new Hashtable<String, String>();
            params.put("opr", "getposition");
            params.put("withport", String.valueOf(withPort));
            params.put("clustername", clusterName);
            params.put("selfconn", String.valueOf(isSelfConnEnabled));
            params.put("cluster", DC.getCluster());
            Object response = DC.getDataFromAdmin("/getserverips.do", params, 1);
            if (response instanceof Hashtable) {
                ipsWithPosition = (Hashtable)response;
            } else if (response instanceof String) {
                LOGGER.info("NS--> Invalid response for getIpsOfAClusterWithPosition. Response: " + response);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NS--> Error inside getIpsOfAClusterWithPosition. Cluster: " + clusterName + ". \n", e);
        }
        return ipsWithPosition;
    }

    public static Hashtable<String, List<String>> getIpsOfAServer(String servertype) {
        return DC.getIpsOfAServer(servertype, false);
    }

    public static Hashtable<String, List<String>> getIpsOfAServer(String servertype, boolean withPort) {
        Hashtable ips = new Hashtable();
        try {
            Hashtable<String, String> params = new Hashtable<String, String>();
            params.put("withport", "" + withPort);
            params.put("cluster", cluster);
            params.put("servertype", servertype);
            Object response = DC.getDataFromAdmin("/getserverips.do", params, 1);
            if (response instanceof Hashtable) {
                ips = (Hashtable)response;
            } else if (response instanceof String) {
                LOGGER.info("NS--> Invalid response for getIpsOfAServer. Response: " + response);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NS--> Error inside getIpsOfAServer. Servertype: " + servertype + ". \n", e);
        }
        return ips;
    }

    public static List<String> getAllowedIpsOfACluster(String clusterName) {
        List<String> ips = new ArrayList<String>();
        try {
            Hashtable<String, String> params = new Hashtable<String, String>();
            params.put("cluster", DC.getCluster());
            params.put("clustername", clusterName);
            Object response = DC.getDataFromAdmin("/getallowedips.do", params, 1);
            if (response instanceof List) {
                ips = (List)response;
            } else if (response instanceof String) {
                LOGGER.info("NS--> Invalid response for getAllowedIpsOfACluster. Response: " + response);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NS--> Error inside getAllowedIpsOfACluster. Servertype: " + servertype + ". \n", e);
        }
        return ips;
    }

    public static Hashtable<String, Object> getIpsOfAServerWithPosition(String serverType) {
        return DC.getIpsOfAServerWithPosition(serverType, false);
    }

    public static Hashtable<String, Object> getIpsOfAServerWithPosition(String serverType, boolean withPort) {
        Hashtable ipsWithPosition = new Hashtable();
        try {
            Hashtable<String, String> params = new Hashtable<String, String>();
            params.put("opr", "getposition");
            params.put("withport", "" + withPort);
            params.put("cluster", DC.getCluster());
            params.put("servertype", serverType);
            Object response = DC.getDataFromAdmin("/getserverips.do", params, 1);
            if (response instanceof Hashtable) {
                ipsWithPosition = (Hashtable)response;
            } else if (response instanceof String) {
                LOGGER.info("NS--> Invalid response for getIpsOfAServerWithPosition. Response: " + response);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NS--> Error inside getIpsOfAServerWithPosition. ServerType: " + serverType + ". \n", e);
        }
        return ipsWithPosition;
    }

    public static boolean abortAR(String activeReplacementIp) {
        try {
            Hashtable<String, String> params = new Hashtable<String, String>();
            params.put("cluster", cluster);
            params.put("ip", activeReplacementIp);
            for (int i = 0; i < gaRetryCount; ++i) {
                try {
                    String response = (String)DC.getDataFromAdmin("/abortar.do", params, 1);
                    if (!CommonUtil.isEmpty((String)response)) {
                        if (response.equals("success")) {
                            LOGGER.severe("NS--> Successfully notified active replacement abort.");
                            return true;
                        }
                        if (response.equals("failed")) {
                            LOGGER.severe("NS--> Response from admin server for active replacement abort is " + response);
                            continue;
                        }
                        LOGGER.severe("NS--> Invalid response from admin server for active replacement abort. Response:" + response);
                        continue;
                    }
                    LOGGER.severe("NS--> Response for active replacement abort is null | empty.");
                    continue;
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "NS--> Error inside active replacement abort. \n", e);
                    try {
                        Thread.sleep(gaRetryInterval);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NS--> Error inside active replacement abort. \n", e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static boolean handleGridOperation(Map<String, String> header, Map<String, String> params) {
        block25: {
            block39: {
                block38: {
                    block37: {
                        block36: {
                            block35: {
                                block34: {
                                    block33: {
                                        block32: {
                                            block31: {
                                                block30: {
                                                    block29: {
                                                        block28: {
                                                            block27: {
                                                                block26: {
                                                                    block23: {
                                                                        block24: {
                                                                            opr = 0;
                                                                            eventType = 0;
                                                                            stime = System.currentTimeMillis();
                                                                            opr = Integer.parseInt(header.get("opr"));
                                                                            if (opr != 3) ** GOTO lbl25
                                                                            serverKey = header.get("x-serverseckey");
                                                                            if (!DC.validateAuthKey(params.get("x-gackey"), serverKey)) break block23;
                                                                            DC.gridAccessKey = params.get("x-gackey");
                                                                            if (!DC.isAssociated) break block24;
                                                                            var7_20 = true;
                                                                            StatsDB.addData(new Object[]{"gridoperation", DCConstants.getGridOprString(opr, eventType), DC.getCluster(), 1, System.currentTimeMillis() - stime});
                                                                            return var7_20;
                                                                        }
                                                                        provType = Integer.parseInt(params.get("prov-type"));
                                                                        provMap = params.get("prov-map");
                                                                        var9_32 = DC.provisionHandler.handleProvision(opr, provType, provMap);
                                                                        StatsDB.addData(new Object[]{"gridoperation", DCConstants.getGridOprString(opr, eventType), DC.getCluster(), 1, System.currentTimeMillis() - stime});
                                                                        return var9_32;
                                                                    }
                                                                    DC.LOGGER.severe("NS--> GridAccessKey is not valid. Terminating provision operation.");
                                                                    break block25;
lbl25:
                                                                    // 1 sources

                                                                    if (opr != 12) ** GOTO lbl44
                                                                    serverKey = header.get("x-serverseckey");
                                                                    if (!DC.validateAuthKey(params.get("x-gackey"), serverKey)) break block26;
                                                                    DC.gridAccessKey = params.get("x-gackey");
                                                                    DC.LOGGER.info("NS--> Successfully stored GACKey");
                                                                    if (DC.isExternal()) {
                                                                        statsAccessKey = params.get("x-statsackey");
                                                                        if (!CommonUtil.isEmpty((String)statsAccessKey)) {
                                                                            StatsDispatchManager.setStatsAccessKey(statsAccessKey);
                                                                            DC.LOGGER.info("NS--> Successfully stored Stats AccessKey");
                                                                        } else {
                                                                            DC.LOGGER.info("NS--> Stats AccessKey is empty.");
                                                                        }
                                                                    }
                                                                    statsAccessKey = true;
                                                                    StatsDB.addData(new Object[]{"gridoperation", DCConstants.getGridOprString(opr, eventType), DC.getCluster(), 1, System.currentTimeMillis() - stime});
                                                                    return statsAccessKey;
                                                                }
                                                                DC.LOGGER.severe("NS--> GridAccessKey is not valid.");
                                                                break block25;
lbl44:
                                                                // 1 sources

                                                                if (opr != 1) ** GOTO lbl55
                                                                if (!DC.verifyGridAccessKey(header.get("x-gackey"))) break block27;
                                                                eventType = Integer.parseInt(params.get("event-type"));
                                                                eventValue = params.get("event-value");
                                                                statsAccessKey = DC.handleGridEvent(eventType, eventValue);
                                                                StatsDB.addData(new Object[]{"gridoperation", DCConstants.getGridOprString(opr, eventType), DC.getCluster(), 1, System.currentTimeMillis() - stime});
                                                                return statsAccessKey;
                                                            }
                                                            DC.LOGGER.severe("NS--> GridAccessKey is not valid. Terminating GridEvent operation.");
                                                            break block25;
lbl55:
                                                            // 1 sources

                                                            if (opr != 2) ** GOTO lbl64
                                                            if (!DC.verifyGridAccessKey(header.get("x-gackey"))) break block28;
                                                            eventValue = DC.handleConfChange(params.get("conf-type"), params.get("conf-value"));
                                                            StatsDB.addData(new Object[]{"gridoperation", DCConstants.getGridOprString(opr, eventType), DC.getCluster(), 1, System.currentTimeMillis() - stime});
                                                            return eventValue;
                                                        }
                                                        DC.LOGGER.severe("NS--> GridAccessKey is not valid. Terminating confchange operation.");
                                                        break block25;
lbl64:
                                                        // 1 sources

                                                        if (opr != 4) ** GOTO lbl75
                                                        if (!DC.verifyGridAccessKey(header.get("x-gackey"))) break block29;
                                                        provType = Integer.parseInt(params.get("deprov-type"));
                                                        provMap = params.get("deprov-map");
                                                        var8_29 = DC.provisionHandler.handleProvision(opr, provType, provMap);
                                                        StatsDB.addData(new Object[]{"gridoperation", DCConstants.getGridOprString(opr, eventType), DC.getCluster(), 1, System.currentTimeMillis() - stime});
                                                        return var8_29;
                                                    }
                                                    DC.LOGGER.severe("NS--> GridAccessKey is not valid. Terminating deprovision operation.");
                                                    break block25;
lbl75:
                                                    // 1 sources

                                                    if (opr != 5) ** GOTO lbl84
                                                    if (!DC.verifyGridAccessKey(header.get("x-gackey"))) break block30;
                                                    provType = DC.updateTraceConf(params.get("trace"));
                                                    StatsDB.addData(new Object[]{"gridoperation", DCConstants.getGridOprString(opr, eventType), DC.getCluster(), 1, System.currentTimeMillis() - stime});
                                                    return provType;
                                                }
                                                DC.LOGGER.severe("NS--> GridAccessKey is not valid. Terminating traceconf operation.");
                                                break block25;
lbl84:
                                                // 1 sources

                                                if (opr != 6) ** GOTO lbl94
                                                if (!DC.verifyGridAccessKey(header.get("x-gackey"))) break block31;
                                                QOSClient.stopQOSDispatcher();
                                                provType = true;
                                                StatsDB.addData(new Object[]{"gridoperation", DCConstants.getGridOprString(opr, eventType), DC.getCluster(), 1, System.currentTimeMillis() - stime});
                                                return provType;
                                            }
                                            DC.LOGGER.severe("NS--> GridAccessKey is not valid. Terminating dissociate operation.");
                                            break block25;
lbl94:
                                            // 1 sources

                                            if (opr != 7) ** GOTO lbl104
                                            DC.gridAccessKey = params.get("x-gackey");
                                            if (!DC.loadDCConf()) break block32;
                                            provType = DC.loadConf();
                                            StatsDB.addData(new Object[]{"gridoperation", DCConstants.getGridOprString(opr, eventType), DC.getCluster(), 1, System.currentTimeMillis() - stime});
                                            return provType;
                                        }
                                        DC.LOGGER.severe("NS--> Failed to load DC Conf. Unable to re-associate with admin server.");
                                        break block25;
lbl104:
                                        // 1 sources

                                        if (opr != 8) ** GOTO lbl113
                                        if (!DC.verifyGridAccessKey(header.get("x-gackey"))) break block33;
                                        provType = DC.updateMitigationConf(params.get("mitigationconf"));
                                        StatsDB.addData(new Object[]{"gridoperation", DCConstants.getGridOprString(opr, eventType), DC.getCluster(), 1, System.currentTimeMillis() - stime});
                                        return provType;
                                    }
                                    DC.LOGGER.severe("NS--> GridAccessKey is not valid. Terminating mitigation operation.");
                                    break block25;
lbl113:
                                    // 1 sources

                                    if (opr != 9) ** GOTO lbl122
                                    if (!DC.verifyGridAccessKey(header.get("x-gackey"))) break block34;
                                    provType = DC.updateSharedConf(params.get("sharedconf"));
                                    StatsDB.addData(new Object[]{"gridoperation", DCConstants.getGridOprString(opr, eventType), DC.getCluster(), 1, System.currentTimeMillis() - stime});
                                    return provType;
                                }
                                DC.LOGGER.severe("NS--> GridAccessKey is not valid. Terminating sharedconf operation.");
                                break block25;
lbl122:
                                // 1 sources

                                if (opr != 10) ** GOTO lbl131
                                if (!DC.verifyGridAccessKey(header.get("x-gackey"))) break block35;
                                provType = DC.handleImportConf(params.get("conflist"), params.get("username"));
                                StatsDB.addData(new Object[]{"gridoperation", DCConstants.getGridOprString(opr, eventType), DC.getCluster(), 1, System.currentTimeMillis() - stime});
                                return provType;
                            }
                            DC.LOGGER.severe("NS--> GridAccessKey is not valid. Terminating importconf operation.");
                            break block25;
lbl131:
                            // 1 sources

                            if (opr != 11) ** GOTO lbl142
                            if (!DC.verifyGridAccessKey(header.get("x-gackey"))) break block36;
                            provType = Integer.parseInt(params.get("prov-type"));
                            provMap = params.get("prov-map");
                            var8_30 = DC.provisionHandler.handleProvision(opr, provType, provMap);
                            StatsDB.addData(new Object[]{"gridoperation", DCConstants.getGridOprString(opr, eventType), DC.getCluster(), 1, System.currentTimeMillis() - stime});
                            return var8_30;
                        }
                        DC.LOGGER.severe("NS--> GridAccessKey is not valid. Terminating prepare for kill operation.");
                        break block25;
lbl142:
                        // 1 sources

                        if (opr != 13) break block37;
                        provType = DC.handleServicesMap((Map)HttpDataWraper.getObject((String)params.get("servicemap")));
                        StatsDB.addData(new Object[]{"gridoperation", DCConstants.getGridOprString(opr, eventType), DC.getCluster(), 1, System.currentTimeMillis() - stime});
                        return provType;
                    }
                    if (opr != 14) ** GOTO lbl159
                    if (!DC.verifyGridAccessKey(header.get("x-gackey"))) break block38;
                    influxInventory = params.get("influxinventory");
                    influxInventoryMap = (HashMap)HttpDataWraper.getObject((String)influxInventory);
                    var8_31 = StatsConf.initialiseInfluxInventory(influxInventoryMap);
                    StatsDB.addData(new Object[]{"gridoperation", DCConstants.getGridOprString(opr, eventType), DC.getCluster(), 1, System.currentTimeMillis() - stime});
                    return var8_31;
                }
                DC.LOGGER.severe("NS--> GridAccessKey is not valid for influx conf update operation.");
                break block25;
lbl159:
                // 1 sources

                if (opr != 15) ** GOTO lbl169
                if (!DC.verifyGridAccessKey(header.get("x-gackey"))) break block39;
                influxInventory = CassandraUtil.cleanup();
                StatsDB.addData(new Object[]{"gridoperation", DCConstants.getGridOprString(opr, eventType), DC.getCluster(), 1, System.currentTimeMillis() - stime});
                return influxInventory;
            }
            try {
                StatsDB.recordError(ComponentConstants.WMSLOGGER_ENUM.getModuleCode(), ComponentConstants.WMSLOGGER_ENUM.ERROR_VALIDATE_GACKEY.getErrorCode(), 1L);
                DC.LOGGER.severe("YG --> Grid Access Key is not valid for cassandra cf cleanup operation.");
                break block25;
lbl169:
                // 1 sources

                DC.LOGGER.severe("NS--> Invalid operation. Opr: " + opr);
            }
            catch (Exception e) {
                try {
                    DC.LOGGER.log(Level.SEVERE, "NS--> Error inside handleGridOperation. ", e);
                }
                catch (Throwable var10_33) {
                    StatsDB.addData(new Object[]{"gridoperation", DCConstants.getGridOprString(opr, eventType), DC.getCluster(), 1, System.currentTimeMillis() - stime});
                    throw var10_33;
                }
                StatsDB.addData(new Object[]{"gridoperation", DCConstants.getGridOprString(opr, eventType), DC.getCluster(), 1, System.currentTimeMillis() - stime});
            }
        }
        StatsDB.addData(new Object[]{"gridoperation", DCConstants.getGridOprString(opr, eventType), DC.getCluster(), 1, System.currentTimeMillis() - stime});
        return false;
    }

    private static boolean handleConfChange(String confName, String confValue) {
        try {
            Map confProp = (Map)HttpDataWraper.getObject((String)confValue);
            if (confName.equals("all")) {
                String[] confList;
                for (String confname : confList = ((String)confProp.get("serverconf-list")).split(",")) {
                    String props = (String)confProp.get(confname);
                    if (confname.equals("_traceconf")) {
                        DC.updateTraceConf(props);
                        continue;
                    }
                    if (confname.equals("_mitigationconf")) {
                        DC.updateMitigationConf(props);
                        continue;
                    }
                    if (confname.equals("_sharedconf")) {
                        DC.updateSharedConf(props);
                        continue;
                    }
                    if (confname.equals("stats")) {
                        StatsConf.initialize((Hashtable)HttpDataWraper.getObject((String)props));
                        if (!StatsConf.isStatsEnabled()) continue;
                        StatsDB.initialize();
                        DC.punchPidStats();
                        continue;
                    }
                    if (confname.equals("_wmssecurityconf")) {
                        WMSSecurityUtil.initialize(props);
                        LOGGER.log(Level.INFO, "NS--> WMSSecurityUtil conf initialized.");
                        continue;
                    }
                    if (confname.equals("wcpprops")) {
                        WCPConfManager.setSecurityProps(props);
                        LOGGER.log(Level.INFO, "NS--> WCPSecurity conf initialized.");
                        continue;
                    }
                    if (confname.equals("mdckms")) {
                        MultiDCKeyMgmtConfHandler.setProps(props);
                        LOGGER.log(Level.INFO, "NS--> MultiDCKeyMgmtHandler conf initialized");
                        continue;
                    }
                    if (confname.equals("wmslogger")) {
                        WmsLogger.handleConfChanges(props);
                        continue;
                    }
                    if (confHandler == null) continue;
                    String[] confNameArray = confname.split("=");
                    if (confNameArray.length == 2) {
                        String filePath = confNameArray[1];
                        confname = confNameArray[0];
                        confHandler.setFilePath(confname, filePath);
                    }
                    Hashtable propsMap = CommonUtil.isEmpty((String)props) ? new Hashtable() : (Hashtable)HttpDataWraper.getObject((String)props);
                    confHandler.handleConfChange(confname, propsMap);
                    confHandler.removeFilePath(confname);
                }
                return true;
            }
            if (confName.equals("stats")) {
                boolean status = StatsConf.initialize((Hashtable)confProp.get(confName));
                if (StatsConf.isStatsEnabled()) {
                    StatsDB.initialize();
                    DC.punchPidStats();
                }
                return status;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NS--> Error inside handleConfChange. ConfName: " + confName + "  ConfValue: " + confValue + "\n", e);
        }
        return false;
    }

    private static void punchPidStats() {
        if (isPidStatsNeeded) {
            try {
                RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
                String pid = bean.getName().split("@")[0];
                StatsDB.addDataInstant(System.currentTimeMillis(), "pidstats", DC.getServertype(), pid);
                isPidStatsNeeded = false;
            }
            catch (Exception e) {
                StatsDB.addDataInstant(System.currentTimeMillis(), "pidstats", DC.getServertype(), "ERR");
                LOGGER.log(Level.SEVERE, "PS --> Exception while finding pid", e);
            }
        }
    }

    private static boolean handleServicesMap(Map<String, Hashtable<String, Object>> servicesMap) {
        Hashtable<String, WmsService> servicesData = new Hashtable<String, WmsService>();
        for (Map.Entry<String, Hashtable<String, Object>> serviceSet : servicesMap.entrySet()) {
            servicesData.put(serviceSet.getKey(), new WmsService(serviceSet.getValue()));
        }
        return confHandler.handleServicesMap(servicesData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean handleImportConf(String confList, String userName) {
        FileInputStream input = null;
        HashMap<String, Properties> totalConfMap = new HashMap<String, Properties>();
        try {
            ArrayList serverConfList = CommonUtil.getList((String)confList);
            String serverHome = System.getProperty("server.home");
            for (String confName : serverConfList) {
                try {
                    Properties prop = new Properties();
                    input = !confName.contains("/") ? new FileInputStream(serverHome + File.separator + "conf" + File.separator + confName) : new FileInputStream(serverHome + File.separator + confName);
                    prop.load(input);
                    totalConfMap.put(confName, prop);
                }
                catch (Exception e) {
                    LOGGER.warning("NS--> Error while laoding this file: " + confName);
                }
                finally {
                    if (input == null) continue;
                    try {
                        input.close();
                    }
                    catch (Exception e1) {
                        LOGGER.log(Level.SEVERE, "", e1);
                    }
                }
            }
            Hashtable<String, String> params = new Hashtable<String, String>();
            params.put("cluster", cluster);
            params.put("username", userName);
            params.put("conf-map", HttpDataWraper.getString(totalConfMap));
            String response = (String)DC.getDataFromAdmin("/importConf.do", params, 1);
            LOGGER.info("NS--> Response from admin for import conf call; confList=" + confList + " response=" + response);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NS--> Error inside handle import conf. ConfList: " + confList + " \n", e);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }

    private static boolean handleGridEvent(int eventType, String eventValue) {
        try {
            if (eventType == 1) {
                return DC.handleCDChange(eventValue);
            }
            if (eventType == 2) {
                if (geHandler != null) {
                    return geHandler.handleNotification(eventValue);
                }
                LOGGER.info("NS--> GridEventHandler is null. Dropping the event for NOTIFICATION");
            } else if (eventType == 3) {
                if (geHandler != null) {
                    Map message = (Map)HttpDataWraper.getObject((String)eventValue);
                    return geHandler.handleSwitch(message);
                }
                LOGGER.info("NS--> GridEventHandler is null. Dropping the event for SWITCHMODE;");
            } else if (eventType == 4) {
                if (nbmHandler != null) {
                    nbmHandler.updateNBM((Map)HttpDataWraper.getObject((String)eventValue));
                    LOGGER.info("NS--> Update NBM for --> " + eventValue);
                } else {
                    LOGGER.severe("NS--> nbmHandler is not registered");
                }
            } else {
                LOGGER.severe("NS--> Invalid GridEvent type. Type: " + eventType);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NS--> Error inside handle GridEvent. \n", e);
        }
        return false;
    }

    private static boolean handleCDChange(String cdData) {
        Hashtable cdDetailsMap = (Hashtable)HttpDataWraper.getObject((String)cdData);
        return DC.handleCDChange(cdDetailsMap);
    }

    private static boolean handleCDChange(Hashtable cdDetailsMap) {
        try {
            LOGGER.info("UM-->CD  : " + cdDetailsMap + " clusterName : " + cdDetailsMap.get("cluster"));
            String dcid = (String)cdDetailsMap.get("dcid");
            String cdName = (String)cdDetailsMap.get("cdname");
            try {
                Hashtable servingModeMap = (Hashtable)cdDetailsMap.get("servingmode");
                if (dcid.equals(DC.getDCId())) {
                    ServingMode.addRecords(servingModeMap);
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "NS--> Error while handling serving mode. cdData=" + cdDetailsMap + "\n", ex);
            }
            Hashtable cdDetails = (Hashtable)cdDetailsMap.get("cddetails");
            for (String clusterName : cdDetails.keySet()) {
                DistributionManager dManager;
                Hashtable cdDetail = (Hashtable)HttpDataWraper.getObject((String)((String)cdDetails.get(clusterName)));
                String dType = (String)cdDetail.get("type");
                String filter = null;
                if (cdDetail.containsKey("filter")) {
                    filter = (String)cdDetail.get("filter");
                }
                if ("wch".equals(dType)) {
                    HashMap<String, WCH> wchMap = new HashMap<String, WCH>();
                    JSONObject curRCDMap = new JSONObject((Map)((Hashtable)cdDetail.get("cur")));
                    WCH curWCH = new WCH(curRCDMap);
                    wchMap.put("cur", curWCH);
                    if (cdDetail != null && cdDetail.containsKey("prv")) {
                        JSONObject prvRCDMap = new JSONObject((Map)((Hashtable)cdDetail.get("prv")));
                        WCH prvWCH = new WCH(prvRCDMap);
                        wchMap.put("prv", prvWCH);
                    }
                    dManager = cdManagerMap.get(cdName);
                    if (dcid.equals(DC.getDCId())) {
                        dManager.setCurrentWCH(clusterName, curWCH);
                    }
                    dManager.addRecentCDList(clusterName, (String)cdDetails.get(clusterName));
                    dManager.handleCDChange(dcid, clusterName, wchMap, filter);
                    continue;
                }
                if ("ipm".equals(dType)) {
                    long version = Long.parseLong("" + cdDetail.get("rcv"));
                    Map ipMap = (Map)cdDetail.get("ips");
                    IPMap ipMapObj = null;
                    Integer reason = (Integer)cdDetail.get("reason");
                    ipMapObj = reason == null ? new IPMap(version, ipMap) : new IPMap(version, ipMap, reason);
                    DistributionManager dManager2 = cdManagerMap.get(cdName);
                    dManager2.handleIPMChange(dcid, clusterName, ipMapObj);
                    continue;
                }
                if ("geo".equals(dType)) {
                    long version = Long.parseLong("" + cdDetail.get("version"));
                    GeoMap geoObj = new GeoMap(version, cdDetail);
                    dManager = cdManagerMap.get(cdName);
                    dManager.handleGeoChange(dcid, clusterName, geoObj);
                    continue;
                }
                LOGGER.info("NS--> Un-supported distribution logic dtype=" + dType + " for cluster=" + clusterName);
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NS--> Error while handling CD Change. cdData=" + cdDetailsMap + "\n", e);
            return false;
        }
    }

    public static boolean verifyGridAccessKey(String gacKey) {
        try {
            if (gacKey.equals(gridAccessKey)) {
                return true;
            }
            LOGGER.severe("NS--> GridAccessKey is not valid.");
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NS--> Error while verifying grid access key. \n", e);
        }
        return false;
    }

    public static boolean verifySecondarySecKey(String secondarySecretKey) {
        if (CommonUtil.isEmpty((String)secondarySecretKey)) {
            LOGGER.severe("NS--> SecondarySecKey inside DC is null | empty.");
            return false;
        }
        try {
            Hashtable<String, String> params = new Hashtable<String, String>();
            params.put("cluster", cluster);
            params.put("x-secondaryseckey", secondarySecretKey);
            String response = (String)DC.getDataFromAdmin("/verifyAccessKey.do", params, 1);
            if (response.equals("valid")) {
                return true;
            }
            LOGGER.log(Level.SEVERE, "NS--> HACK attempt. Invalid SecondarySecKey.");
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NS--> Error while verifying secondary secret key. \n", e);
        }
        return false;
    }

    private static boolean validateAuthKey(String gacKey, String serSecKey) {
        String tempSSK = "";
        try {
            Hashtable<String, String> params = new Hashtable<String, String>();
            params.put("x-gackey", gacKey);
            params.put("cluster", cluster);
            tempSSK = serverSecKey;
            serverSecKey = serSecKey;
            String response = (String)DC.getDataFromAdmin("/verifyAccessKey.do", params, 2);
            if (response.equals("valid")) {
                return true;
            }
            LOGGER.log(Level.SEVERE, "NS--> HACK attempt. Provison request has been made with an invalid GAC key.");
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NS--> Error while validating AuthKey. \n", e);
        }
        serverSecKey = tempSSK;
        return false;
    }

    public static void setServerStartStatus(boolean status) {
        serverStartStatus = status;
        machineUpTime = System.currentTimeMillis();
    }

    public static boolean getServerStartStatus() {
        return serverStartStatus;
    }

    public static LinkedHashMap<String, CommandExecutionInfo> executeCommand(LinkedHashMap<String, Hashtable<String, String>> exeCommandDetails) {
        LinkedHashMap<String, CommandExecutionInfo> responseMap = new LinkedHashMap<String, CommandExecutionInfo>();
        for (String command : exeCommandDetails.keySet()) {
            responseMap.put(command, DC.executeCommand(command, exeCommandDetails.get(command)));
        }
        return responseMap;
    }

    public static CommandExecutionInfo executeCommand(String command, Hashtable<String, String> replaceMap) {
        try {
            Hashtable<String, String> params = new Hashtable<String, String>();
            params.put("cluster", cluster);
            params.put("command", command);
            params.put("replace-map", HttpDataWraper.getString(replaceMap));
            Object response = DC.getDataFromAdmin("/executecommand.do", params, 1);
            if (response == null) {
                return new CommandExecutionInfo(command, replaceMap, 2, "Response from Admin is Null");
            }
            return new CommandExecutionInfo((Hashtable)response);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "DK--> Error inside execute command method for command : " + command, e);
            String result = "Error While getting data from admin for command : " + command + " Error Msg : " + e.getMessage();
            return new CommandExecutionInfo(command, replaceMap, 1, result);
        }
    }

    public static String getIDCAccessKey(long duration, TimeUnit timeUnit) {
        return DC.getIDCAccessKey(duration, timeUnit, null);
    }

    public static String getIDCAccessKey(long duration, TimeUnit timeUnit, String sourceIP) {
        try {
            Map statusMap;
            long expiryTime = TimeUnit.MILLISECONDS.convert(duration, timeUnit);
            Hashtable<String, String> params = new Hashtable<String, String>();
            params.put("opr", "getIDCkey");
            params.put("cluster", cluster);
            params.put("accesskeytype", "cluster");
            params.put("expirytime", Long.toString(expiryTime));
            if (sourceIP != null) {
                params.put("ip", sourceIP);
            }
            if (!CommonUtil.isEmpty((Map)(statusMap = (Map)DC.getDataFromAdmin("/verifyAccessKey.do", params, 1)))) {
                if ("100".equals(statusMap.get("status"))) {
                    return (String)statusMap.get("accesskey");
                }
                LOGGER.log(Level.SEVERE, "NS--> Error while getting IDC Access key for the DC - Error : " + (String)statusMap.get("err-msg"));
            } else {
                LOGGER.info("NS--> [IDCAccessKey Error] StatusMap is empty!");
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NS--> Error while getting IDC Access key. Duration:  " + duration + ".\n", e);
        }
        return null;
    }

    public static String getIDCAccessKey(String destDC, long duration, TimeUnit timeUnit) {
        return DC.getIDCAccessKey(null, destDC, duration, timeUnit);
    }

    public static String getIDCAccessKey(String sourceIP, String destDC, long duration, TimeUnit timeUnit) {
        try {
            Map statusMap;
            long expiryTime = TimeUnit.MILLISECONDS.convert(duration, timeUnit);
            Hashtable<String, String> params = new Hashtable<String, String>();
            params.put("dcid", destDC);
            params.put("opr", "getIDCkey");
            params.put("cluster", cluster);
            params.put("accesskeytype", "dc");
            params.put("expirytime", Long.toString(expiryTime));
            if (sourceIP != null) {
                params.put("ip", sourceIP);
            }
            if (!CommonUtil.isEmpty((Map)(statusMap = (Map)DC.getDataFromAdmin("/verifyAccessKey.do", params, 1)))) {
                if ("100".equals(statusMap.get("status"))) {
                    return (String)statusMap.get("accesskey");
                }
                LOGGER.log(Level.SEVERE, "NS--> Error while getting IDC Access key for the DC - Error : " + (String)statusMap.get("err-msg"));
            } else {
                LOGGER.info("NS--> [IDCAccessKey Error] StatusMap is empty!");
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NS--> Error while getting IDC Access key for the DC : " + destDC + ".\n" + (sourceIP != null ? " and sourceIP : " + sourceIP : ""), e);
        }
        return null;
    }

    public static String getIDCAccessKeyWithData(String data, String destDC, long duration, TimeUnit timeUnit) {
        try {
            long expiryTime = TimeUnit.MILLISECONDS.convert(duration, timeUnit);
            Hashtable<String, String> params = new Hashtable<String, String>();
            params.put("dcid", destDC);
            params.put("opr", "getIDCkey");
            params.put("cluster", cluster);
            params.put("accesskeytype", "data");
            params.put("expirytime", Long.toString(expiryTime));
            params.put("data", data);
            Map statusMap = (Map)DC.getDataFromAdmin("/verifyAccessKey.do", params, 1);
            if (!CommonUtil.isEmpty((Map)statusMap)) {
                if ("100".equals(statusMap.get("status"))) {
                    return (String)statusMap.get("accesskey");
                }
                LOGGER.info("NS--> Error while getting IDC Access key for the DC - Error : " + (String)statusMap.get("err-msg"));
            } else {
                LOGGER.info("NS--> [IDCAccessKey Error] StatusMap is empty!");
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NS--> Error while getting IDC Access key for the DC : " + destDC + ".\n", e);
        }
        return null;
    }

    public static int verifyIDCAccessKeyWithSrcIP(String accessKey, String sourceDC, String sourceIP) {
        try {
            Hashtable<String, String> params = new Hashtable<String, String>();
            params.put("dcid", sourceDC);
            params.put("cluster", cluster);
            params.put("opr", "verifyIDCkey");
            params.put("x-idcacckey", accessKey);
            params.put("accesskeytype", "cluster");
            params.put("ip", sourceIP);
            String response = (String)DC.getDataFromAdmin("/verifyAccessKey.do", params, 1);
            int status = Integer.parseInt(response);
            if (status == 200) {
                return 200;
            }
            if (status == 201) {
                return 201;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NS--> Error while verifing IDC Access key for the DC : " + sourceDC + " and sourceIP : " + sourceIP + ".\n", e);
            return 203;
        }
        return 202;
    }

    public static int verifyIDCAccessKey(String accessKey, String sourceDC) {
        try {
            Hashtable<String, String> params = new Hashtable<String, String>();
            params.put("dcid", sourceDC);
            params.put("cluster", cluster);
            params.put("opr", "verifyIDCkey");
            params.put("x-idcacckey", accessKey);
            params.put("accesskeytype", "cluster");
            String response = (String)DC.getDataFromAdmin("/verifyAccessKey.do", params, 1);
            int status = Integer.parseInt(response);
            if (status == 200) {
                return 200;
            }
            if (status == 201) {
                return 201;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NS--> Error while verifing IDC Access key for the DC : " + sourceDC + ".\n", e);
            return 203;
        }
        return 202;
    }

    public static int verifyIDCAccessKey(String accessKey, String sourceDC, String sourceIP) {
        try {
            Hashtable<String, String> params = new Hashtable<String, String>();
            params.put("ip", sourceIP);
            params.put("dcid", sourceDC);
            params.put("cluster", cluster);
            params.put("opr", "verifyIDCkey");
            params.put("accesskeytype", "dc");
            params.put("x-idcacckey", accessKey);
            String response = (String)DC.getDataFromAdmin("/verifyAccessKey.do", params, 1);
            int status = Integer.parseInt(response);
            if (status == 200) {
                return 200;
            }
            if (status == 201) {
                return 201;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NS--> Error while verifing IDC Access key for the DC : " + sourceDC + " and IP : " + sourceIP + ".\n", e);
            return 203;
        }
        return 202;
    }

    public static VerifyIDCAccessKeyInfo verifyIDCAccessKeyAndGetData(String accessKey, String sourceDC) {
        try {
            Hashtable<String, String> params = new Hashtable<String, String>();
            params.put("dcid", sourceDC);
            params.put("cluster", cluster);
            params.put("opr", "verifyIDCkey");
            params.put("accesskeytype", "data");
            params.put("x-idcacckey", accessKey);
            Object response = DC.getDataFromAdmin("/verifyAccessKey.do", params, 1);
            if (response == null) {
                return new VerifyIDCAccessKeyInfo("", 1, "Response from Admin is Null");
            }
            return new VerifyIDCAccessKeyInfo((Map)response);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NS--> Error while verifing IDC Access key for the DC : " + sourceDC, e);
            return new VerifyIDCAccessKeyInfo("", 1, "Error while verifing IDC Access key for the DC : " + sourceDC + " Exception : " + e);
        }
    }

    public static long startGridOperation(String msg, String user) {
        long version = -1L;
        try {
            Hashtable<String, String> params = new Hashtable<String, String>();
            params.put("msg", msg);
            params.put("user", user);
            params.put("opr", "start");
            params.put("cluster", DC.getCluster());
            String versionStr = (String)DC.getDataFromAdmin("/goaudit.do", params, 1);
            try {
                version = Long.parseLong(versionStr);
            }
            catch (NumberFormatException nfe) {
                LOGGER.log(Level.SEVERE, "NS--> Error while invoking start grid operation; NumberFormatException; version=" + versionStr, nfe);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NS--> Error while invoking start grid operation; user=" + user, e);
        }
        return version;
    }

    public static void endGridOperation(String msg, String user, long version) {
        try {
            Hashtable<String, String> params = new Hashtable<String, String>();
            params.put("msg", msg);
            params.put("opr", "stop");
            params.put("user", user);
            params.put("cluster", DC.getCluster());
            params.put("version", String.valueOf(version));
            DC.getDataFromAdmin("/goaudit.do", params, 1);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NS--> Error while invoking start grid operation; user=" + user, e);
        }
    }

    public static boolean isPrimary(String cluster) throws Exception {
        return ServingMode.isPrimary(cluster);
    }

    public static String getPrimaryDC(String cluster) throws Exception {
        if (ServingMode.isPrimary(cluster)) {
            return DC.getDCId();
        }
        return DC.getDrDCId();
    }

    public static Hashtable<String, String> checkVulnerability(String cluster) {
        Hashtable vulnerabilityDetails = null;
        try {
            Hashtable<String, String> params = new Hashtable<String, String>();
            params.put("cluster", cluster);
            Object response = DC.getDataFromAdmin("/checkvulnerability.do", params, 1);
            if (response instanceof Hashtable) {
                vulnerabilityDetails = (Hashtable)response;
            } else if (response instanceof String) {
                LOGGER.info("HR--> Invalid response for checkVulnerability. Response: " + response + " For Cluster :" + cluster);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "HR--> Error inside vulnerabilityDetails. Cluster: " + cluster + ". \n", e);
        }
        return vulnerabilityDetails;
    }

    private static Object getDataFromAdmin(String url, Hashtable<String, String> params, int authID) {
        Object response = null;
        Hashtable<String, String> headers = new Hashtable<String, String>();
        try {
            if (authID == 2) {
                headers.put("x-serverseckey", serverSecKey);
            } else if (authID == 1) {
                headers.put("x-gackey", gridAccessKey);
            }
            headers.put("x-req-origin", DC.getCluster());
            String protocol = DC.isExternal() ? "https://" : "http://";
            HttpConnection con = new HttpConnection(protocol + adminurl + url, DCConstants.readTimeOut, DCConstants.connectTimeOut);
            response = con.doPost(params, headers);
            LOGGER.info("NS--> Status code for the connected url ( " + url + " ) is " + con.getStatusCode());
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NS--> Error while getting data from admin server for the url call: " + url + " \n", e);
        }
        return response;
    }

    static {
        cdManagerMap = new HashMap<String, DistributionManager>();
        buildLog = new Properties();
        readonly = false;
        servingMode = "RW";
        startupArgs = "";
        isPidStatsNeeded = true;
        serverStartStatus = false;
        DC.loadDCConf();
        DC.loadBlog();
    }
}

