/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.sqm.usages;

import com.adventnet.wms.servercommon.components.net.WCPConnPoolConfig;
import com.adventnet.wms.servercommon.components.net.WCPDispatcher;
import com.adventnet.wms.servercommon.components.net.WCPSessionManager;
import com.adventnet.wms.servercommon.components.sqm.SQMDistributionManager;
import com.adventnet.wms.servercommon.components.sqm.usages.GFURDispatcher;
import com.adventnet.wms.servercommon.dc.DC;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GlobalFunctionalUsageRecorder {
    private static final Logger LOGGER = Logger.getLogger(GlobalFunctionalUsageRecorder.class.getName());
    public static final String GUR_POOL_NAME = "gur_sqm";
    public static final String GUR_SQM_CLUSTER = "sqmserver-main";
    private static boolean isInitialized = false;

    public static void init() {
        try {
            if (!WCPDispatcher.isInitialised() || !WCPSessionManager.isInitialised()) {
                LOGGER.severe("[GUR][Not initialized][WCPDispatcher init : " + WCPDispatcher.isInitialised() + "][WCPSessionManager init : " + WCPSessionManager.isInitialised() + "]");
            }
            WCPConnPoolConfig conf = new WCPConnPoolConfig(GUR_POOL_NAME, DC.getServertype(), "sqmserver").setContext(DC.getServertype() + "_sqm_gur").setClusterName(GUR_SQM_CLUSTER);
            WCPDispatcher.createWCPConnPool(conf);
            GFURDispatcher.init();
            if (!DC.isRegisteredCD("sqmcd")) {
                DC.registerDistributionManager("sqmcd", new SQMDistributionManager());
                DC.updateClusterDistribution(GUR_SQM_CLUSTER, null);
            }
            isInitialized = true;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "[WCP_INIT][createWCPConnPool - GUR]", e);
        }
    }

    public static void recordRegister(String remoteIp, String prd, String category, String subCategory) {
        if (!isInitialized) {
            LOGGER.severe("[GUR][Not initialized][recordRegister]");
            return;
        }
        Hashtable<String, String> sessionData = new Hashtable<String, String>();
        sessionData.put("remote_ip", remoteIp);
        sessionData.put("prd", prd);
        sessionData.put("category", category);
        sessionData.put("sub_category", subCategory);
        GFURDispatcher.recordSession(sessionData);
    }
}

