/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.sqm.usages;

import com.adventnet.wms.common.HttpDataWraper;
import com.adventnet.wms.servercommon.TimeOutListener;
import com.adventnet.wms.servercommon.components.net.WCPDispatcher;
import com.adventnet.wms.servercommon.components.sqm.usages.GFURDispatcher;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GFURTimeOutListener
extends TimeOutListener {
    private static final Logger LOGGER = Logger.getLogger(GFURTimeOutListener.class.getName());
    private static final Object SQM_SESSION_LOCK = new Object();
    private static final ArrayList<String> SESSION_LIST = new ArrayList(1600);
    private static final GFURTimeOutListener SESSION_LISTENER = new GFURTimeOutListener();
    private static long lastPushedTime = System.currentTimeMillis();

    private GFURTimeOutListener() {
        super("SQMSessionListener", 10000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void recordSession(Hashtable<String, String> session) {
        Object object = SQM_SESSION_LOCK;
        synchronized (object) {
            SESSION_LIST.add(HttpDataWraper.getString(session));
        }
        if (SESSION_LIST.size() > 1200) {
            GFURDispatcher.sendData();
        }
        SESSION_LISTENER.touch(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void sendDataToSQM() {
        String sessionData;
        Object object = SQM_SESSION_LOCK;
        synchronized (object) {
            sessionData = HttpDataWraper.getString(SESSION_LIST);
            SESSION_LIST.clear();
        }
        try {
            WCPDispatcher.sendData("gur_sqm", 3, sessionData);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "PS --> Error while sending data to SQM", e);
        }
        lastPushedTime = System.currentTimeMillis();
    }

    @Override
    public boolean isExpired(Object o) {
        return SESSION_LIST.size() > 0 && System.currentTimeMillis() - lastPushedTime > 5000L;
    }

    public void handleExpired(ArrayList arrayList) {
        GFURDispatcher.sendData();
    }
}

