/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.sqm.sessions;

import com.adventnet.wms.servercommon.components.net.WCPConnPoolConfig;
import com.adventnet.wms.servercommon.components.net.WCPDispatcher;
import com.adventnet.wms.servercommon.components.net.WCPSessionManager;
import com.adventnet.wms.servercommon.components.net.servlet.WCPServletMapper;
import com.adventnet.wms.servercommon.components.sqm.SQMDistributionManager;
import com.adventnet.wms.servercommon.components.sqm.sessions.AbsGSRListener;
import com.adventnet.wms.servercommon.components.sqm.sessions.GSRDispatcher;
import com.adventnet.wms.servercommon.dc.DC;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GlobalSessionRecorder {
    private static final Logger LOGGER = Logger.getLogger(GlobalSessionRecorder.class.getName());
    public static final String GSR_POOL_NAME = "gsr_sqm";
    public static final String GSR_SQM_CLUSTER = "sqmserver-main";
    private static boolean isInitialized = false;

    public static void init(AbsGSRListener listener) {
        try {
            if (!WCPDispatcher.isInitialised() || !WCPSessionManager.isInitialised()) {
                LOGGER.severe("[GSR][Not initialized][WCPDispatcher init : " + WCPDispatcher.isInitialised() + "][WCPSessionManager init : " + WCPSessionManager.isInitialised() + "]");
            }
            WCPConnPoolConfig conf = new WCPConnPoolConfig(GSR_POOL_NAME, DC.getServertype(), "sqmserver").setContext(DC.getServertype() + "_sqm_gsr").setClusterName(GSR_SQM_CLUSTER);
            WCPDispatcher.createWCPConnPool(conf);
            GSRDispatcher.init();
            if (!DC.isRegisteredCD("sqmcd")) {
                DC.registerDistributionManager("sqmcd", new SQMDistributionManager());
                DC.updateClusterDistribution(GSR_SQM_CLUSTER, null);
            }
            Properties properties = new Properties();
            properties.setProperty("sqm/gslistner", listener.getClass().getName());
            WCPServletMapper.initialize(properties);
            isInitialized = true;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "[WCP_INIT][createWCPConnPool - GSR]", e);
        }
    }

    public static void recordRegister(String sid, String remoteIp, String prd, String zaid, String orgId) {
        if (!isInitialized) {
            LOGGER.severe("[GSR][Not initialized][recordRegister]");
            return;
        }
        Hashtable<String, String> sessionData = new Hashtable<String, String>();
        sessionData.put("sid", sid);
        sessionData.put("remote_ip", remoteIp);
        sessionData.put("prd", prd);
        sessionData.put("zaid", zaid);
        sessionData.put("orgid", orgId);
        sessionData.put("opr", "register");
        GSRDispatcher.recordUsage(sessionData);
    }

    public static void recordUnRegister(String sid, String remoteIp, String prd, String zaid, String orgId, String unRegReason) {
        if (!isInitialized) {
            LOGGER.severe("[GSR][Not initialized][recordUnRegister]");
            return;
        }
        Hashtable<String, String> sessionData = new Hashtable<String, String>();
        sessionData.put("sid", sid);
        sessionData.put("remote_ip", remoteIp);
        sessionData.put("prd", prd);
        sessionData.put("zaid", zaid);
        sessionData.put("orgid", orgId);
        sessionData.put("opr", "unregister");
        sessionData.put("reason", unRegReason);
        GSRDispatcher.recordUsage(sessionData);
    }
}

