/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.sqm.sessions;

import com.adventnet.wms.servercommon.ServerUtil;
import com.adventnet.wms.servercommon.components.executor.WMSThreadPoolExecutor;
import com.adventnet.wms.servercommon.components.executor.WmsTask;
import com.adventnet.wms.servercommon.components.queue.BufferedQueue;
import com.adventnet.wms.servercommon.components.sqm.sessions.GSRTimeOutListener;
import java.util.Hashtable;
import java.util.concurrent.TimeUnit;

public class GSRDispatcher
extends Thread {
    public static final String GSR_DISPATCHER = "GSR_DISPATCHER";
    private static final int RECORD_SESSION = 1;
    private static final int SEND_GRP_SESSION_DATA = 2;
    private static WMSThreadPoolExecutor tpe;
    private static boolean isInitialized;

    static void init() {
        BufferedQueue bq = new BufferedQueue(ServerUtil.dataHome + "sqm", "gsr", 1000, false);
        tpe = new WMSThreadPoolExecutor(GSR_DISPATCHER, 3, 10, 5L, TimeUnit.SECONDS, bq, new SQMDispatchHandler());
        isInitialized = true;
    }

    static void recordUsage(Hashtable<String, String> sessionData) {
        if (isInitialized) {
            tpe.execute(new SQMDataDispatcher(1, sessionData));
        }
    }

    static void sendData() {
        if (isInitialized) {
            tpe.execute(new SQMDataDispatcher(2, null));
        }
    }

    static {
        isInitialized = false;
    }

    static class SQMDispatchHandler
    implements WmsTask {
        SQMDispatchHandler() {
        }

        @Override
        public void handle(Object obj) {
            SQMDataDispatcher dispatcher = (SQMDataDispatcher)obj;
            switch (dispatcher.processType) {
                case 1: {
                    GSRTimeOutListener.recordSession(dispatcher.dataMap);
                    break;
                }
                case 2: {
                    GSRTimeOutListener.sendDataToSQM();
                }
            }
        }
    }

    static class SQMDataDispatcher {
        private final int processType;
        private final Hashtable<String, String> dataMap;

        SQMDataDispatcher(int processType, Hashtable<String, String> dataMap) {
            this.processType = processType;
            this.dataMap = dataMap;
        }
    }
}

