/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.security;

import com.adventnet.wms.common.CommonUtil;
import com.adventnet.wms.common.HttpDataWraper;
import com.adventnet.wms.servercommon.components.security.AESAlgorithm;
import com.adventnet.wms.servercommon.components.security.CryptoAlgorithm;
import com.adventnet.wms.servercommon.dc.DC;
import com.adventnet.wms.servercommon.stats.influx.StatsDB;
import com.adventnet.wms.servercommon.stats.influx.conf.StatsConf;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WMSSecurityUtil {
    private static final Logger LOGGER = Logger.getLogger(WMSSecurityUtil.class.getName());
    private static boolean initialized = false;
    private static Hashtable<CryptoAlgorithm.ALGORITHM, CryptoAlgorithm> algoMap = new Hashtable();
    private static Hashtable<String, String> wmsSecurityConf = new Hashtable();

    public static boolean isInitialized() {
        return initialized;
    }

    public static boolean initialize(String securityProps) {
        try {
            wmsSecurityConf = (Hashtable)HttpDataWraper.getObject((String)securityProps);
            WMSSecurityUtil.initialiseStats();
            LOGGER.log(Level.INFO, "WMSSecurityUtil Initialized Successfully.");
            initialized = true;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception while initialise WMSSecurityUtil. securityProps=" + securityProps, e);
            initialized = false;
        }
        return initialized;
    }

    private static void initialiseStats() {
        Hashtable<String, String> defs = new Hashtable<String, String>();
        defs.put("wms_security", "[[\"qos\",\"qos_gridandsysteminfo\",\"\",\"wms_security\",false],[\"servertype\",\"algorithm_type\",\"method\"],[],[\"count\",\"processtime\"]]");
        if (StatsConf.loadStatsKeyDef(defs)) {
            StatsDB.initialize();
        }
    }

    public static String encrypt(CryptoAlgorithm.ALGORITHM algorithmType, String passPhrase, String salt, String data) throws Exception {
        if (!initialized) {
            throw new Exception("WMSSecurityUtil is not initialized.");
        }
        if (!CryptoAlgorithm.isValidAlgorithm(algorithmType)) {
            throw new UnsupportedOperationException("Invalid Algorithm. algorithmType=" + (Object)((Object)algorithmType));
        }
        long time = System.currentTimeMillis();
        String encryptedData = algoMap.get((Object)algorithmType).encrypt(passPhrase, salt, data);
        StatsDB.addData("wms_security", DC.getServertype(), algorithmType.toString(), "encryption", 1, System.currentTimeMillis() - time);
        return encryptedData;
    }

    public static String encrypt(CryptoAlgorithm.ALGORITHM algorithmType, String passwordKey, String passPhraseSuffix, String saltSuffix, String data) throws Exception {
        if (!initialized) {
            throw new Exception("WMSSecurityUtil is not initialized.");
        }
        if (!CryptoAlgorithm.isValidAlgorithm(algorithmType)) {
            throw new UnsupportedOperationException("Invalid Algorithm. algorithmType=" + (Object)((Object)algorithmType));
        }
        long time = System.currentTimeMillis();
        String passPhrase = wmsSecurityConf.get("WMS_SC_" + passwordKey + "_pp");
        String salt = wmsSecurityConf.get("WMS_SC_" + passwordKey + "_salt");
        if (CommonUtil.isEmpty((String)passPhrase)) {
            throw new Exception("passphrase is null or empty. passwordKey=" + passwordKey + " passPhrase=" + passPhrase);
        }
        if (CommonUtil.isEmpty((String)salt)) {
            throw new Exception("salt is null or empty. passwordKey=" + passwordKey + " salt=" + salt);
        }
        passPhrase = passPhrase + "@" + passPhraseSuffix;
        salt = salt + "@" + saltSuffix;
        String encryptedData = algoMap.get((Object)algorithmType).encrypt(passPhrase, salt, data);
        StatsDB.addData("wms_security", DC.getServertype(), algorithmType.toString(), "encryption", 1, System.currentTimeMillis() - time);
        return encryptedData;
    }

    public static String decrypt(CryptoAlgorithm.ALGORITHM algorithmType, String passPhrase, String salt, String encryptedData) throws Exception {
        if (!initialized) {
            throw new Exception("WMSSecurityUtil is not initialized.");
        }
        if (!CryptoAlgorithm.isValidAlgorithm(algorithmType)) {
            throw new UnsupportedOperationException("Invalid Algorithm. algorithmType=" + (Object)((Object)algorithmType));
        }
        long time = System.currentTimeMillis();
        String data = algoMap.get((Object)algorithmType).decrypt(passPhrase, salt, encryptedData);
        StatsDB.addData("wms_security", DC.getServertype(), algorithmType.toString(), "decryption", 1, System.currentTimeMillis() - time);
        return data;
    }

    public static String decrypt(CryptoAlgorithm.ALGORITHM algorithmType, String passwordKey, String passPharseSuffix, String saltSuffix, String encryptedData) throws Exception {
        if (!initialized) {
            throw new Exception("WMSSecurityUtil is not initialized.");
        }
        if (!CryptoAlgorithm.isValidAlgorithm(algorithmType)) {
            throw new UnsupportedOperationException("Invalid Algorithm. algorithmType=" + (Object)((Object)algorithmType));
        }
        long time = System.currentTimeMillis();
        String passPhrase = wmsSecurityConf.get("WMS_SC_" + passwordKey + "_pp");
        String salt = wmsSecurityConf.get("WMS_SC_" + passwordKey + "_salt");
        if (CommonUtil.isEmpty((String)passPhrase)) {
            throw new Exception("passphrase is null or empty. passwordKey=" + passwordKey + " passPhrase=" + passPhrase);
        }
        if (CommonUtil.isEmpty((String)salt)) {
            throw new Exception("salt is null or empty. passwordKey=" + passwordKey + " salt=" + salt);
        }
        passPhrase = passPhrase + "@" + passPharseSuffix;
        salt = salt + "@" + saltSuffix;
        String data = algoMap.get((Object)algorithmType).decrypt(passPhrase, salt, encryptedData);
        StatsDB.addData("wms_security", DC.getServertype(), algorithmType.toString(), "decryption", 1, System.currentTimeMillis() - time);
        return data;
    }

    static {
        algoMap.put(CryptoAlgorithm.ALGORITHM.AES, new AESAlgorithm());
    }
}

