/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.scn;

import com.adventnet.wms.common.service.callback.WMSServiceCBEvent;
import com.adventnet.wms.servercommon.ServerUtil;
import com.adventnet.wms.servercommon.components.net.WCPDispatcher;
import com.adventnet.wms.servercommon.components.net.WCPSessionManager;
import com.adventnet.wms.servercommon.components.scn.CallBackListener;
import com.adventnet.wms.servercommon.components.scn.NotificationExecutorService;
import com.adventnet.wms.servercommon.components.scn.listener.ServiceMessageListener;
import com.adventnet.wms.servercommon.dc.DC;
import java.io.File;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CallBackExecutorService {
    private static Logger logger = Logger.getLogger(CallBackExecutorService.class.getName());
    protected static boolean isInitialized = false;
    private static String cbConfDir = ServerUtil.serverHome + File.separator + "conf" + File.separator + "servicecb" + File.separator;

    public static boolean initialize() {
        if (!isInitialized) {
            try {
                Properties cbconf = ServerUtil.getProperties(cbConfDir + "servicecb.conf");
                for (String key : cbconf.stringPropertyNames()) {
                    int retryCount;
                    int timeoutInSecs;
                    int responseThreads;
                    String[] keySplit = key.split(",");
                    String category = keySplit[0];
                    String listener = keySplit[1];
                    String value = cbconf.getProperty(key);
                    String[] valueSplit = value.split(",");
                    int maxCount = Integer.parseInt(valueSplit[0]);
                    try {
                        responseThreads = Integer.parseInt(valueSplit[1]);
                    }
                    catch (Exception e) {
                        responseThreads = 0;
                    }
                    String taskClass = valueSplit[2];
                    CallBackListener cbListener = null;
                    try {
                        cbListener = (CallBackListener)Class.forName(taskClass).newInstance();
                    }
                    catch (Exception exp) {
                        logger.log(Level.SEVERE, "CB_ERR --> LISTENER_NOT_FOUND Unable to load category = " + category + " listener = " + listener, exp);
                        throw exp;
                    }
                    try {
                        timeoutInSecs = Integer.parseInt(valueSplit[3]);
                    }
                    catch (Exception e) {
                        timeoutInSecs = 30;
                    }
                    try {
                        retryCount = Integer.parseInt(valueSplit[4]);
                    }
                    catch (Exception e) {
                        retryCount = 3;
                    }
                    NotificationExecutorService.startEngine(category, listener, maxCount, responseThreads, timeoutInSecs, retryCount, cbListener);
                }
                CallBackExecutorService.intializeWCP();
                isInitialized = true;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "CB_ERR -->  Unable to Initialize CallBackExecutorService", e);
                return false;
            }
        }
        return true;
    }

    public static void sendCBEvent(WMSServiceCBEvent event) {
        try {
            NotificationExecutorService.sendCBNotification(event);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "CB_ERR -->  Unable to send service cb category " + event.getCategory() + " listener = " + event.getListener() + " prd = " + event.getPrd(), e);
        }
    }

    private static void intializeWCP() throws Exception {
        WCPDispatcher.createWCPConnPool("servicecb", DC.getServertype(), "rserver", "rserver-api", "servicecb");
        WCPSessionManager.registerListener("scn/callback", new ServiceMessageListener());
    }
}

