/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.queue;

import com.adventnet.wms.servercommon.components.queue.BQPacket;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BQPacketizer {
    private static Logger logger = Logger.getLogger(BQPacketizer.class.getName());

    public static BQPacket getDataFromPacket(byte[] packetData) {
        ByteBuffer bb = ByteBuffer.wrap(packetData);
        int position = 0;
        long packetId = bb.getLong(position);
        long fa = 0L;
        byte[] filePathData = new byte[]{};
        byte[] data = new byte[]{};
        fa = bb.getLong(position += 8);
        int filePathLenth = bb.getInt(position += 8);
        position += 4;
        if (filePathLenth > 0) {
            bb.position(position);
            filePathData = new byte[filePathLenth];
            bb.get(filePathData, 0, filePathLenth);
            position += filePathLenth;
        }
        int dataLenth = bb.getInt(position);
        position += 4;
        if (dataLenth > 0) {
            bb.position(position);
            data = new byte[dataLenth];
            bb.get(data, 0, dataLenth);
            position += dataLenth;
        }
        try {
            return new BQPacket(packetId, fa, filePathData, data);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "HB_ERR Error while converting to BQPacket", e);
            return null;
        }
    }

    public static BQPacket getPacketFromData(long packetId, long flag, String filePath, byte[] data) {
        try {
            return new BQPacket(packetId, flag, filePath.getBytes("UTF-8"), data);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "HB_ERR Error while converting to BQPacket", e);
            return null;
        }
    }
}

