/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.queue;

import java.io.Serializable;
import java.nio.ByteBuffer;

public class BQPacket
implements Serializable {
    long fa = 0L;
    byte[] data = null;
    long packetId = -1L;
    byte[] filePath = null;

    public BQPacket(long packetId, long fa, byte[] filePath, byte[] data) {
        this.packetId = packetId;
        this.fa = fa;
        this.filePath = filePath;
        this.data = data;
    }

    public void setPacketId(long packId) {
        this.packetId = packId;
    }

    public void setFilePath(byte[] filePath) {
        this.filePath = filePath;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public int getDataLength() {
        if (this.data != null) {
            return this.data.length;
        }
        return 0;
    }

    public int getFilePathLenght() {
        if (this.filePath != null) {
            return this.filePath.length;
        }
        return 0;
    }

    public byte[] getData() {
        return this.data;
    }

    public byte[] getFilePathData() {
        return this.filePath;
    }

    public byte[] getCompletePacketData() throws Exception {
        ByteBuffer bb = null;
        int filePathLenth = this.getFilePathLenght();
        int dataLenth = this.getDataLength();
        bb = ByteBuffer.allocate(24 + filePathLenth + dataLenth);
        bb.putLong(this.packetId);
        bb.putLong(this.fa);
        bb.putInt(filePathLenth);
        if (filePathLenth > 0) {
            bb.put(this.getFilePathData());
        }
        bb.putInt(dataLenth);
        if (dataLenth > 0) {
            bb.put(this.getData());
        }
        return bb.array();
    }
}

