/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.net.util;

import com.adventnet.wms.common.HttpDataWraper;
import com.adventnet.wms.servercommon.components.net.servlet.WCPRequest;
import com.adventnet.wms.servercommon.logging.asynclogs.AsyncLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WCPAccessLogger {
    private static Logger logger = Logger.getLogger(WCPAccessLogger.class.getName());
    private static AsyncLogger accesslogger = new AsyncLogger("accesslogger");
    private static Hashtable<String, String> headerKeyMap = new Hashtable();
    private static Hashtable<String, String> paramsKeyMap = new Hashtable();
    private static long resetTime = System.currentTimeMillis();
    private static boolean isAccessLogEnabled = false;

    public static void updateHideHeaders(ArrayList<String> hideHeaders) {
        if (hideHeaders != null) {
            for (String key : hideHeaders) {
                headerKeyMap.put(key, "");
            }
            logger.log(Level.INFO, "HB--> hideHeaderList updation. hideHeaderList={0}", hideHeaders);
        } else {
            logger.log(Level.INFO, "HB_ERR--> hideHeaderList is null");
        }
    }

    public static ArrayList<String> getHideHeaders() {
        return (ArrayList)((Object)headerKeyMap.keySet());
    }

    public static void updateHideParams(ArrayList<String> hideParams) {
        if (hideParams != null) {
            for (String key : hideParams) {
                paramsKeyMap.put(key, "");
            }
            logger.log(Level.INFO, "HB--> hideParamsList updation. hideParamsList={0}", hideParams);
        } else {
            logger.log(Level.INFO, "HB_ERR--> hideParamsList is null");
        }
    }

    public static ArrayList<String> getHideparams() {
        return (ArrayList)((Object)paramsKeyMap.keySet());
    }

    public static void hideHeader(String hideHeaderName) {
        if (hideHeaderName != null) {
            headerKeyMap.put(hideHeaderName, "");
        }
    }

    public static void hideParam(String hideParamName) {
        if (hideParamName != null) {
            paramsKeyMap.put(hideParamName, "");
        }
    }

    public static void viewHeader(String headerName) {
        if (headerName != null) {
            headerKeyMap.remove(headerName);
        }
    }

    public static void viewParam(String paramName) {
        if (paramName != null) {
            paramsKeyMap.remove(paramName);
        }
    }

    public static void log(WCPRequest request) {
        if (isAccessLogEnabled) {
            long time = System.currentTimeMillis();
            long queueSize = 0L;
            if (time - resetTime > 60000L) {
                queueSize = accesslogger.getQueueSize();
                resetTime = time;
            }
            accesslogger.log(Level.INFO, WCPAccessLogger.getAccessLog(request));
        }
    }

    public static void log(Hashtable data) {
        HashMap<String, Object> loginfo = new HashMap<String, Object>();
        if (isAccessLogEnabled) {
            try {
                loginfo.put("request_uri", "" + data.get("x-idb-data-type"));
                loginfo.put("param", "");
                loginfo.put("header", WCPAccessLogger.getFormattedList(data, headerKeyMap));
                loginfo.put("method", "IDB-" + data.get("x-idb-event-type"));
                loginfo.put("remote_ip", "");
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Exception in formatting accesslogger", e);
            }
            accesslogger.log(Level.INFO, HttpDataWraper.getString(loginfo));
        }
    }

    private static String getAccessLog(WCPRequest request) {
        HashMap<String, Object> loginfo = new HashMap<String, Object>();
        try {
            loginfo.put("request_uri", request.getURI());
            loginfo.put("param", WCPAccessLogger.getFormattedList(request.getParameters(), paramsKeyMap));
            loginfo.put("header", WCPAccessLogger.getFormattedList(request.getHeaders(), headerKeyMap));
            loginfo.put("method", request.getHeader("wcpuri"));
            loginfo.put("remote_ip", request.getRemoteIp());
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception in formatting accesslogger servletName=" + request.getURI() + " uri=" + request.getHeader("wcpuri") + " remoteIp=" + request.getRemoteIp(), e);
        }
        return HttpDataWraper.getString(loginfo);
    }

    private static ArrayList getFormattedList(Hashtable ht, Hashtable<String, String> hideMap) {
        ArrayList list = new ArrayList();
        Iterator iterator = ht.keySet().iterator();
        while (iterator.hasNext()) {
            HashMap<String, String> formattedMap = new HashMap<String, String>();
            String key = (String)iterator.next();
            formattedMap.put("name", key);
            if (!hideMap.containsKey(key)) {
                formattedMap.put("value", (String)ht.get(key));
            } else {
                formattedMap.put("value", "*****");
            }
            list.add(formattedMap);
        }
        return list;
    }

    public static void enableAccessLogs() {
        isAccessLogEnabled = true;
        logger.log(Level.INFO, "HB--> WCPAccessLogger Enabled");
    }

    public static void disableAccessLogs() {
        isAccessLogEnabled = false;
        logger.log(Level.INFO, "HB--> WCPAccessLogger Disabled");
    }
}

