/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.net.servlet;

import com.adventnet.wms.servercommon.components.net.servlet.DefaultServlet;
import com.adventnet.wms.servercommon.components.net.servlet.WCPServlet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Logger;

public class WCPServletMapper {
    private static Logger logger = Logger.getLogger(WCPServletMapper.class.getName());
    private static HashMap<String, WCPServlet> servletMap = new HashMap();
    private static WCPServlet defaultServlet = new DefaultServlet();

    public static boolean initialize(Properties servletMapping) {
        WCPServletMapper.loadServlets(servletMap, servletMapping);
        return true;
    }

    private static void loadServlets(HashMap instanceMap, Properties classMap) {
        Enumeration<?> e = classMap.propertyNames();
        while (e.hasMoreElements()) {
            String servletName = (String)e.nextElement();
            String servletClass = (String)classMap.get(servletName);
            try {
                instanceMap.put(servletName, (WCPServlet)Class.forName(servletClass).newInstance());
            }
            catch (Exception ex) {
                logger.info("[Exception - WCPServletMapper][loadServlets][" + servletName + "][" + servletClass + "][" + ex.getMessage() + "]");
            }
        }
    }

    public static WCPServlet getServlet(String reqUrl) throws Exception {
        return servletMap.get(reqUrl);
    }

    public static DefaultServlet getDefaultServlet() {
        return (DefaultServlet)defaultServlet;
    }
}

