/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.net.servlet;

import com.adventnet.wms.common.HttpDataWraper;
import com.adventnet.wms.servercommon.components.net.WCPSessionManager;
import java.util.Hashtable;

public class WCPResponse {
    private String reqId = null;
    private String resId = null;
    private String response_code = "200";
    private String response_str = "OK";
    private Hashtable<String, String> headers = null;
    private String response_data = null;
    private long time = 0L;

    public WCPResponse(String reqId, String resId) {
        this.reqId = reqId;
        this.resId = resId;
        this.headers = new Hashtable();
    }

    public WCPResponse(Hashtable<String, String> ht) {
        this.response_code = ht.get("code");
        this.response_str = ht.get("res_str");
        this.headers = (Hashtable)HttpDataWraper.getObject((String)ht.get("header"));
        this.response_data = ht.get("data");
    }

    public void setResponseCode(int code) {
        this.response_code = Integer.toString(code);
    }

    public void setResponseCode(String code) {
        this.response_code = code;
    }

    public void setResponseStr(String str) {
        this.response_str = str;
    }

    public void addHeader(String key, String value) {
        this.headers.put(key, value);
    }

    public void setHeaders(Hashtable<String, String> ht) {
        if (ht != null) {
            this.headers.putAll(ht);
        }
    }

    public void setResponseData(String res) {
        this.response_data = res;
    }

    public void setResponseTime(long time) {
        this.time = time;
    }

    public String getResponseCode() {
        return this.response_code;
    }

    public String getResponseStr() {
        return this.response_str;
    }

    public Hashtable<String, String> getResponseHeaders() {
        return this.headers;
    }

    public String getHeader(String key) {
        return this.headers.get(key);
    }

    public String getResponseData() {
        return this.response_data;
    }

    public String getResAsData() {
        Hashtable<String, String> ht = new Hashtable<String, String>();
        ht.put("code", this.response_code);
        if (this.response_str != null) {
            ht.put("res_str", this.response_str);
        }
        if (this.headers != null) {
            ht.put("header", HttpDataWraper.getString(this.headers));
        }
        if (this.response_data != null) {
            ht.put("data", this.response_data);
        }
        return HttpDataWraper.getString(ht);
    }

    public String getRequestId() {
        return this.reqId;
    }

    public String getResponseId() {
        return this.resId;
    }

    public long getResponseTime() {
        return this.time;
    }

    public void sendResponse() throws Exception {
        String sourceIp = this.headers.remove("x-req-source-ip");
        WCPSessionManager.sendResponsePacket(this.resId, this.reqId, this.getResAsData(), sourceIp);
    }
}

