/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.net.servlet;

import com.adventnet.wms.common.CommonUtil;
import com.adventnet.wms.common.HttpDataWraper;
import com.adventnet.wms.servercommon.components.net.WCPConfManager;
import com.adventnet.wms.servercommon.components.net.util.WCPUtil;
import java.util.Hashtable;

public class WCPRequest {
    private String uri = "";
    private String reqId = "-1";
    private String rkey = "";
    private long originTime = -1L;
    private long timeOutInMillis = WCPConfManager.getWCPRequestTimeOutInMillis();
    private long expiryTimeInMillis = -1L;
    private String data = null;
    private Hashtable<String, String> header = null;
    private Hashtable<String, String> params = null;
    private String remoteIp = "null";
    private String destIp = "unknown";

    public WCPRequest(String uri) {
        this.uri = uri;
        this.data = "";
        this.header = new Hashtable();
        this.params = new Hashtable();
    }

    public WCPRequest(String uri, Hashtable<String, String> header, Hashtable<String, String> params, String data) {
        this.uri = uri;
        this.header = header;
        this.params = params;
        this.data = data;
        if (CommonUtil.isEmpty(header)) {
            this.header = new Hashtable();
        }
        if (CommonUtil.isEmpty(params)) {
            this.params = new Hashtable();
        }
    }

    public WCPRequest(Hashtable<String, String> ht) {
        this.uri = ht.get("uri");
        this.header = !CommonUtil.isEmpty((String)ht.get("header")) ? (Hashtable)HttpDataWraper.getObject((String)ht.get("header")) : new Hashtable();
        this.params = !CommonUtil.isEmpty((String)ht.get("param")) ? (Hashtable)HttpDataWraper.getObject((String)ht.get("param")) : new Hashtable();
        this.data = ht.get("data");
        this.setTimeOutInMillis(WCPUtil.parseLong(ht.get("timeoutinmillis"), WCPConfManager.getWCPRequestTimeOutInMillis()));
        this.setOriginTime(WCPUtil.parseLong(ht.get("reqorigintimeinmillis"), System.currentTimeMillis()));
        this.setExpiryTimeInMillis(WCPUtil.parseLong(ht.get("expirytimeinmillis"), WCPConfManager.getWCPRequestTimeOutInMillis() + System.currentTimeMillis()));
    }

    public void addHeader(String key, String value) {
        this.header.put(key, value);
    }

    public void addParam(String key, String value) {
        this.params.put(key, value);
    }

    public void setURI(String uri) {
        this.uri = uri;
    }

    public void setData(String data) {
        this.data = data;
    }

    public void setReqId(String reqId) {
        this.reqId = reqId;
    }

    public void setRkey(String rkey) {
        this.rkey = rkey;
    }

    public void setRemoteIp(String ip) {
        this.remoteIp = ip;
    }

    public void setDestinationIp(String ip) {
        this.destIp = ip;
    }

    public void setOriginTime(long time) {
        this.originTime = time;
        this.setExpiryTimeInMillis(time + this.timeOutInMillis);
    }

    public String getData() {
        return this.data;
    }

    public Hashtable<String, String> getHeaders() {
        return this.header;
    }

    public Hashtable<String, String> getParameters() {
        return this.params;
    }

    public String getURI() {
        return this.uri;
    }

    public String getReqId() {
        return this.reqId;
    }

    public String getRKey() {
        return this.rkey;
    }

    public String getParam(String key) {
        return this.params.get(key);
    }

    public String getHeader(String key) {
        return this.header.get(key);
    }

    public String getRemoteIp() {
        return this.remoteIp;
    }

    public String getDestinationIp() {
        return this.destIp;
    }

    public long getOriginTime() {
        return this.originTime;
    }

    public String getReqAsData() {
        Hashtable<String, String> ht = new Hashtable<String, String>();
        ht.put("uri", this.uri);
        ht.put("timeoutinmillis", Long.toString(this.timeOutInMillis));
        ht.put("reqorigintimeinmillis", Long.toString(this.getOriginTime()));
        ht.put("expirytimeinmillis", Long.toString(this.getExpiryTime()));
        if (this.header != null) {
            ht.put("header", HttpDataWraper.getString(this.header));
        }
        if (this.params != null) {
            ht.put("param", HttpDataWraper.getString(this.params));
        }
        if (this.data != null) {
            ht.put("data", this.data);
        }
        return HttpDataWraper.getString(ht);
    }

    public void setTimeOut(int timeInSeconds) {
        this.timeOutInMillis = timeInSeconds * 1000;
    }

    public void setTimeOutInMillis(long timeInMillis) {
        this.timeOutInMillis = timeInMillis;
    }

    public long getTimeOutInMillis() {
        return this.timeOutInMillis;
    }

    public boolean isExpired() {
        return System.currentTimeMillis() > this.getExpiryTime();
    }

    public void setExpiryTimeInMillis(long timeInMillis) {
        this.expiryTimeInMillis = timeInMillis;
    }

    public long getExpiryTime() {
        return this.expiryTimeInMillis;
    }

    public WCPRequest duplicate() {
        WCPRequest req = new WCPRequest(this.uri, new Hashtable<String, String>(this.header), this.params, this.data);
        req.setTimeOutInMillis(this.getTimeOutInMillis());
        req.setExpiryTimeInMillis(this.getExpiryTime());
        return req;
    }
}

