/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.net.servlet;

import com.adventnet.wms.servercommon.components.net.WCPDispatcher;
import com.adventnet.wms.servercommon.components.net.callback.RedirectCBListener;
import com.adventnet.wms.servercommon.components.net.callback.WCPResponseCBListener;
import com.adventnet.wms.servercommon.components.net.servlet.WCPRequest;
import com.adventnet.wms.servercommon.components.net.servlet.WCPResponse;
import com.adventnet.wms.servercommon.components.net.stats.WCPStats;
import com.adventnet.wms.servercommon.components.net.timeoutlistener.WCPReqTimeOutListener;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WCPFuture
implements Future {
    private static Logger logger = Logger.getLogger(WCPFuture.class.getName());
    protected boolean response_received = false;
    protected boolean req_canceled = false;
    protected final Condition resAvailable;
    protected final ReentrantLock lock;
    protected WCPRequest req = null;
    protected WCPResponse res = null;
    protected String poolName = null;
    protected WCPResponseCBListener listener = null;
    private boolean isFutureofFrwdReq = false;
    private long requestStartTime = System.currentTimeMillis();
    private long responseReceivedTime = 0L;

    public WCPFuture(WCPRequest req, WCPResponse res, WCPResponseCBListener listener, String poolName) {
        this.req = req;
        this.res = res;
        this.listener = listener;
        this.poolName = poolName;
        this.lock = new ReentrantLock();
        this.resAvailable = this.lock.newCondition();
    }

    public WCPFuture(WCPRequest req, WCPResponse res, WCPResponseCBListener listener, String poolName, boolean isFutureofFrwdReq) {
        this.req = req;
        this.res = res;
        this.listener = listener;
        this.poolName = poolName;
        this.lock = new ReentrantLock();
        this.resAvailable = this.lock.newCondition();
        this.isFutureofFrwdReq = isFutureofFrwdReq;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.req_canceled = mayInterruptIfRunning;
        if (mayInterruptIfRunning) {
            this.lock.lock();
            try {
                this.resAvailable.signalAll();
            }
            catch (Exception exception) {
            }
            finally {
                this.lock.unlock();
            }
        }
        return mayInterruptIfRunning;
    }

    public WCPResponse get() {
        return this.get(-1L, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WCPResponse get(long timeout, TimeUnit unit) {
        if (this.isCancelled()) {
            throw new CancellationException("WCPRequest canceled");
        }
        if (!this.response_received) {
            this.lock.lock();
            try {
                if (timeout == -1L) {
                    this.resAvailable.await();
                } else {
                    this.resAvailable.await(timeout, unit);
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception exception) {
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResponse(WCPResponse res) {
        String responceCode = res.getResponseCode();
        if (responceCode.equals("307")) {
            try {
                if (res.getHeader("redirecturi") != null) {
                    this.req.setURI(res.getHeader("redirecturi"));
                }
                WCPDispatcher.sendRequest(this.poolName, "" + res.getHeader("redirectip"), this.req, new RedirectCBListener(this, "" + this.req.getRemoteIp()));
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "[Exception-Redirection][" + res.getHeader("redirecturi") + "][" + res.getHeader("redirectip") + "][" + this.req.getRemoteIp() + "]", e);
            }
            return;
        }
        this.res = res;
        this.response_received = true;
        this.calculateRequestTakenTime(responceCode);
        WCPReqTimeOutListener.TRACKER.remove(this.req.getExpiryTime(), this.poolName + "@" + this.req.getReqId() + "@" + this.req.getExpiryTime());
        if (this.listener != null) {
            if (responceCode.equals("200")) {
                this.listener.onResponse(this.req, res);
            } else {
                this.listener.onError(this.req, res);
            }
        } else {
            this.lock.lock();
            try {
                this.resAvailable.signalAll();
            }
            catch (Exception exception) {
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public boolean isFutureofFrwdReq() {
        return this.isFutureofFrwdReq;
    }

    @Override
    public boolean isCancelled() {
        return this.req_canceled;
    }

    @Override
    public boolean isDone() {
        return this.response_received;
    }

    public WCPRequest getRequest() {
        return this.req;
    }

    public void setListener(WCPResponseCBListener listener) {
        this.listener = listener;
    }

    private void calculateRequestTakenTime(String resCode) {
        this.responseReceivedTime = System.currentTimeMillis() - this.requestStartTime;
        WCPStats.addWCPRequestTakenTime(this.poolName, this.req.getDestinationIp(), this.req.getURI(), resCode, this.responseReceivedTime);
        this.res.setResponseTime(this.responseReceivedTime);
    }

    public long getResponseReceivedTime() {
        return this.responseReceivedTime;
    }
}

