/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.net.callback;

import com.adventnet.wms.servercommon.components.executor.WMSThreadPoolExecutor;
import com.adventnet.wms.servercommon.components.executor.WmsTask;
import com.adventnet.wms.servercommon.components.net.WCPServerConnPool;
import com.adventnet.wms.servercommon.components.net.callback.WCPCBEvent;
import com.adventnet.wms.servercommon.components.net.stats.WCPStats;
import com.adventnet.wms.servercommon.components.net.util.WCPConstants;
import com.adventnet.wms.servercommon.components.net.util.WCPPacket;
import com.adventnet.wms.servercommon.components.queue.BufferedQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WCPIDBCBNotifyHandler {
    private Logger logger = Logger.getLogger(WCPIDBCBNotifyHandler.class.getName());
    private boolean closed = false;
    private BufferedQueue bq = null;
    private WCPServerConnPool connPool = null;
    private WMSThreadPoolExecutor wmsTPE = null;

    public WCPIDBCBNotifyHandler(WCPServerConnPool connPool, String dir, String fileName, int queueSize) {
        this.connPool = connPool;
        this.bq = new BufferedQueue(dir, fileName, queueSize, false);
        this.wmsTPE = new WMSThreadPoolExecutor("WCP/" + connPool.getPoolName() + "-WCPIDBCBNotifyHandler", 1, 1, 5L, TimeUnit.SECONDS, this.bq, new WCPIDBCallBackNotifier());
    }

    public void putData(String poolName, String ip, WCPPacket packet) {
        try {
            if (!this.closed) {
                this.wmsTPE.execute(new WCPCBEvent(poolName, ip, packet));
            }
        }
        catch (Exception ex) {
            this.logger.log(Level.SEVERE, "Error while adding packet into TPE; connPool=" + poolName + " ip=" + ip, ex);
        }
    }

    public synchronized void setCorePoolSize(int corePoolSize) {
        this.wmsTPE.setCorePoolSize(corePoolSize);
    }

    public synchronized void setMaximumPoolSize(int maximumPoolSize) {
        this.wmsTPE.setMaximumPoolSize(maximumPoolSize);
    }

    public synchronized void setPoolSize(int corePoolSize, int maximumPoolSize) {
        this.wmsTPE.setPoolSize(corePoolSize, maximumPoolSize);
    }

    public void start() {
        this.wmsTPE.start();
        this.wmsTPE.prestartAllCoreThreads();
    }

    public void closeCBNotifyHandler() {
        this.closed = true;
    }

    public long getQueueSize() {
        return this.bq.size();
    }

    public int getActiveThreadsCount() {
        return this.wmsTPE.getActivePoolSize();
    }

    public int getMaxThreadsCount() {
        return this.wmsTPE.getMaximumPoolSize();
    }

    class WCPIDBCallBackNotifier
    implements WmsTask {
        WCPIDBCallBackNotifier() {
        }

        @Override
        public void handle(Object wcpCBEvent) {
            long processTime = System.currentTimeMillis();
            WCPCBEvent cbe = (WCPCBEvent)wcpCBEvent;
            if (cbe != null) {
                try {
                    int packetType = cbe.getWCPPacket().getPacketType();
                    if (packetType == 4 || packetType == 8 || packetType == 13) {
                        String sourceIp = cbe.getWCPPacket().getHeader("x-req-source-ip");
                        sourceIp = sourceIp + ":" + WCPConstants.PacketType.getPacketTypeString(packetType);
                        WCPIDBCBNotifyHandler.this.connPool.processIDBNotifyPackets(WCPIDBCBNotifyHandler.this.connPool.getContext(), cbe.getIP(), sourceIp, cbe.getWCPPacket().getCompletePacketData());
                    } else {
                        WCPIDBCBNotifyHandler.this.logger.warning("Invalid packet inside CallBack Handler; packettype=" + cbe.getWCPPacket().getPacketType() + " ConnPool=" + WCPIDBCBNotifyHandler.this.connPool.getPoolName());
                    }
                }
                catch (Exception ex) {
                    WCPIDBCBNotifyHandler.this.logger.log(Level.SEVERE, "WCPERR--> Error while executing callback inside connPool=" + WCPIDBCBNotifyHandler.this.connPool.getPoolName(), ex);
                }
            }
            WCPStats.addWCPHandlerProcessingTime(WCPIDBCBNotifyHandler.this.connPool.getServerType(), WCPIDBCBNotifyHandler.this.connPool.getRemoteServerType(), WCPIDBCBNotifyHandler.this.connPool.getClusterName(), WCPIDBCBNotifyHandler.this.connPool.getPoolName(), WCPIDBCBNotifyHandler.this.connPool.getContext(), "IDBCallBackNotifier", System.currentTimeMillis() - processTime);
        }
    }
}

