/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.net.callback;

import com.adventnet.wms.servercommon.components.executor.WMSThreadPoolExecutor;
import com.adventnet.wms.servercommon.components.executor.WmsTask;
import com.adventnet.wms.servercommon.components.net.WCPServerConnPool;
import com.adventnet.wms.servercommon.components.net.WCPSessionManager;
import com.adventnet.wms.servercommon.components.net.callback.WCPCBEvent;
import com.adventnet.wms.servercommon.components.net.stats.WCPStats;
import com.adventnet.wms.servercommon.components.net.util.WCPPacket;
import com.adventnet.wms.servercommon.components.queue.BufferedQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WCPCBNotifyHandler {
    private Logger logger = Logger.getLogger(WCPCBNotifyHandler.class.getName());
    private boolean closed = false;
    private BufferedQueue bq = null;
    private WCPServerConnPool connPool = null;
    private WMSThreadPoolExecutor wmsTPE = null;

    public WCPCBNotifyHandler(WCPServerConnPool connPool, String dir, String fileName, int queueSize) {
        this.connPool = connPool;
        this.bq = new BufferedQueue(dir, fileName, queueSize, false);
        this.wmsTPE = new WMSThreadPoolExecutor("WCP/" + connPool.getPoolName() + "-CBNotifyHandler", 1, 1, 5L, TimeUnit.SECONDS, this.bq, new WCPCallBackNotifier());
    }

    public void putData(String poolName, String ip, WCPPacket packet) {
        try {
            if (!this.closed) {
                this.wmsTPE.execute(new WCPCBEvent(poolName, ip, packet));
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "WCPERR--> [Exception - closeUnnecessaryConn][" + poolName + "][" + ip + "]", e);
        }
    }

    public synchronized void setCorePoolSize(int corePoolSize) {
        this.wmsTPE.setCorePoolSize(corePoolSize);
    }

    public synchronized void setMaximumPoolSize(int maximumPoolSize) {
        this.wmsTPE.setMaximumPoolSize(maximumPoolSize);
    }

    public synchronized void setPoolSize(int corePoolSize, int maximumPoolSize) {
        this.wmsTPE.setPoolSize(corePoolSize, maximumPoolSize);
    }

    public void start() {
        this.wmsTPE.start();
        this.wmsTPE.prestartAllCoreThreads();
    }

    public void closeCBNotifyHandler() {
        this.closed = true;
    }

    public long getQueueSize() {
        return this.bq.size();
    }

    public int getActiveThreadsCount() {
        return this.wmsTPE.getActivePoolSize();
    }

    public int getMaxThreadsCount() {
        return this.wmsTPE.getMaximumPoolSize();
    }

    class WCPCallBackNotifier
    implements WmsTask {
        WCPCallBackNotifier() {
        }

        @Override
        public void handle(Object wcpCBEvent) {
            long processTime = System.currentTimeMillis();
            WCPCBEvent cbe = (WCPCBEvent)wcpCBEvent;
            if (cbe != null) {
                try {
                    if (cbe.getWCPPacket().getPacketType() == 4) {
                        String sourceIp = cbe.getWCPPacket().getHeader("x-req-source-ip");
                        if (sourceIp != null) {
                            WCPSessionManager.processNotifyPackets(WCPCBNotifyHandler.this.connPool.getContext(), cbe.getIP(), sourceIp, new String(cbe.getWCPPacket().getPayLoadData(), "UTF-8"));
                        } else {
                            WCPSessionManager.processNotifyPackets(WCPCBNotifyHandler.this.connPool.getContext(), cbe.getSource(), cbe.getIP(), new String(cbe.getWCPPacket().getPayLoadData(), "UTF-8"));
                        }
                    } else {
                        WCPCBNotifyHandler.this.logger.warning("Invalid packet inside CallBack Handler; packettype=" + cbe.getWCPPacket().getPacketType() + " ConnPool=" + WCPCBNotifyHandler.this.connPool.getPoolName());
                    }
                }
                catch (Exception ex) {
                    WCPCBNotifyHandler.this.logger.log(Level.SEVERE, "WCPERR--> Error while executing callback inside connPool=" + WCPCBNotifyHandler.this.connPool.getPoolName(), ex);
                }
            }
            WCPStats.addWCPHandlerProcessingTime(WCPCBNotifyHandler.this.connPool.getServerType(), WCPCBNotifyHandler.this.connPool.getRemoteServerType(), WCPCBNotifyHandler.this.connPool.getClusterName(), WCPCBNotifyHandler.this.connPool.getPoolName(), WCPCBNotifyHandler.this.connPool.getContext(), "CBNotifyHandler", System.currentTimeMillis() - processTime);
        }
    }
}

