/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.net.callback;

import com.adventnet.wms.servercommon.components.net.WCPConfManager;
import com.adventnet.wms.servercommon.components.net.WCPDispatcher;
import com.adventnet.wms.servercommon.components.net.WCPServerConnPool;
import com.adventnet.wms.servercommon.components.net.WCPSessionManager;
import com.adventnet.wms.servercommon.components.net.callback.WCPCBEvent;
import com.adventnet.wms.servercommon.components.net.stats.WCPStats;
import com.adventnet.wms.servercommon.components.net.util.WCPPacket;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WCPCBMetaHandler
extends Thread {
    private static Logger logger = Logger.getLogger(WCPCBMetaHandler.class.getName());
    private LinkedBlockingQueue<WCPCBEvent> callbackQueue = new LinkedBlockingQueue();
    private boolean closed = false;
    private WCPServerConnPool connPool = null;
    private long lastStatusUpdateTime = 0L;
    private boolean isForceCloseEnabled = true;

    public WCPCBMetaHandler(WCPServerConnPool connPool) {
        this.connPool = connPool;
    }

    public void putData(String cluster, String ip, WCPPacket packet) {
        try {
            this.callbackQueue.put(new WCPCBEvent(cluster, ip, packet));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "WCPERR--> [Exception - WCPCBMetaHandler putData][" + cluster + "][" + ip + "]", e);
            WCPSessionManager.returnErrorMsg(this.connPool.getContext(), cluster, 0, "Meta CallBack Queue Error", e.getMessage());
        }
    }

    @Override
    public void run() {
        this.setName("WCP/" + this.connPool.getPoolName() + "-CBMetaHandler");
        while (!this.closed) {
            try {
                this.updateLiveStats();
                WCPCBEvent cbe = this.callbackQueue.poll(60000L, TimeUnit.MILLISECONDS);
                if (cbe == null) continue;
                this.execute(cbe);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "WCPERR--> [Exception - WCPCBMetaHandler]", e);
            }
        }
    }

    private void updateLiveStats() {
        try {
            if (System.currentTimeMillis() - this.lastStatusUpdateTime >= 60000L) {
                Set<String> keySet = this.connPool.getIPSidMap().keySet();
                for (String key : keySet) {
                    long optimalLimit;
                    long liveConnCount = this.connPool.getIPSidMap().get(key).size();
                    long bqRatePerMin = this.connPool.getBqRatePerMin(key);
                    long currRatePerConn = bqRatePerMin / (liveConnCount > 0L ? liveConnCount : 1L);
                    this.connPool.setAvgRatePerConn(key, currRatePerConn);
                    long maxRatePerConn = this.connPool.getAvgRatePerConn(key);
                    long optimalConnCount = 0L;
                    if (maxRatePerConn > 0L) {
                        optimalConnCount = (long)Math.floor(bqRatePerMin / maxRatePerConn);
                    }
                    if (maxRatePerConn > currRatePerConn && liveConnCount > (long)this.connPool.getMinConnPerIp()) {
                        optimalLimit = liveConnCount - 1L;
                        if (optimalConnCount > 0L && optimalLimit > optimalConnCount) {
                            optimalConnCount = optimalLimit;
                            if (this.isForceCloseEnabled) {
                                this.connPool.closeUnnecessaryConn(key);
                            }
                            WCPStats.addUnnecessaryClose(this.connPool.getServerType(), this.connPool.getRemoteServerType(), this.connPool.getPoolName(), key);
                        }
                    } else if (maxRatePerConn <= currRatePerConn && liveConnCount < (long)WCPConfManager.getWCPMaxConnPerIP()) {
                        optimalLimit = liveConnCount + 1L;
                        if (optimalConnCount < (long)WCPConfManager.getWCPMaxConnPerIP() && optimalLimit < optimalConnCount) {
                            optimalConnCount = optimalLimit;
                        }
                    } else {
                        optimalConnCount = liveConnCount;
                    }
                    if (liveConnCount <= 0L) continue;
                    WCPStats.updateLiveStats(this.connPool.getServerType(), this.connPool.getRemoteServerType(), this.connPool.getPoolName(), key, liveConnCount, optimalConnCount, bqRatePerMin, this.connPool.getLiveBQSize(key), this.connPool.getNotifyHandlerQueueSize(), this.connPool.getResponseHandlerQueueSize(), this.connPool.getIDBNotifyHandlerQueueSize(), WCPSessionManager.getCBResponseHandlerQueueSize(), this.callbackQueue.size(), this.connPool.getPendingResponses());
                }
                this.lastStatusUpdateTime = System.currentTimeMillis();
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "WCPERR--> [WCPCBMetaHandler - updateLiveConnections]", e);
        }
    }

    public void execute(WCPCBEvent cbe) {
        WCPDispatcher.processMetaPackets(cbe);
    }

    public void closeCBNotifyHandler() {
        this.closed = false;
        this.callbackQueue = null;
    }

    public void enableForceCloseConn() {
        this.isForceCloseEnabled = true;
        logger.info("HB--> ForceClose Connection is Enabled. poolName=" + this.connPool.getPoolName());
    }

    public void disableForceCloseConn() {
        this.isForceCloseEnabled = false;
        logger.info("HB--> ForceClose Connection is Disabled. poolName=" + this.connPool.getPoolName());
    }
}

