/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.net;

import com.adventnet.wms.common.CommonUtil;
import com.adventnet.wms.common.HttpDataWraper;
import com.adventnet.wms.servercommon.LockManager;
import com.adventnet.wms.servercommon.components.constants.ComponentConstants;
import com.adventnet.wms.servercommon.components.net.WCPConfManager;
import com.adventnet.wms.servercommon.components.net.WCPConnPoolConfig;
import com.adventnet.wms.servercommon.components.net.WCPDispatcher;
import com.adventnet.wms.servercommon.components.net.WCPThreadLocal;
import com.adventnet.wms.servercommon.components.net.callback.BroadcastResponceCBListener;
import com.adventnet.wms.servercommon.components.net.callback.WCPBrdCstCBListnr;
import com.adventnet.wms.servercommon.components.net.callback.WCPCBMetaHandler;
import com.adventnet.wms.servercommon.components.net.callback.WCPCBNotifyHandler;
import com.adventnet.wms.servercommon.components.net.callback.WCPIDBCBListener;
import com.adventnet.wms.servercommon.components.net.callback.WCPIDBCBNotifyHandler;
import com.adventnet.wms.servercommon.components.net.callback.WCPResponseCBListener;
import com.adventnet.wms.servercommon.components.net.callback.WCPResponseHandler;
import com.adventnet.wms.servercommon.components.net.connection.WCPBIOClientConn;
import com.adventnet.wms.servercommon.components.net.connection.WCPConnection;
import com.adventnet.wms.servercommon.components.net.security.ServerAccessTokenProviderImpl;
import com.adventnet.wms.servercommon.components.net.servlet.WCPBroadcastFuture;
import com.adventnet.wms.servercommon.components.net.servlet.WCPFuture;
import com.adventnet.wms.servercommon.components.net.servlet.WCPRequest;
import com.adventnet.wms.servercommon.components.net.servlet.WCPResponse;
import com.adventnet.wms.servercommon.components.net.stats.WCPStats;
import com.adventnet.wms.servercommon.components.net.timeoutlistener.WCPReqTimeOutListener;
import com.adventnet.wms.servercommon.components.net.util.LimitedQueue;
import com.adventnet.wms.servercommon.components.net.util.WCPConstants;
import com.adventnet.wms.servercommon.components.net.util.WCPPacket;
import com.adventnet.wms.servercommon.components.net.util.WCPPacketizer;
import com.adventnet.wms.servercommon.components.net.util.WCPSessionIDGenerator;
import com.adventnet.wms.servercommon.components.net.util.WCPUtil;
import com.adventnet.wms.servercommon.components.queue.BQInventory;
import com.adventnet.wms.servercommon.components.queue.BufferedQueue;
import com.adventnet.wms.servercommon.components.security.AccessTokenProvider;
import com.adventnet.wms.servercommon.dc.DC;
import com.adventnet.wms.servercommon.grid.DistributionManager;
import com.adventnet.wms.servercommon.stats.influx.StatsDB;
import com.adventnet.wms.servercommon.util.WMSUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WCPServerConnPool {
    private static Logger logger = Logger.getLogger(WCPServerConnPool.class.getName());
    private static LockManager connectionLock = new LockManager();
    private int seedsCount = 0;
    private Hashtable<String, String> seedsMap;
    private Hashtable<String, ArrayList<String>> ipSidMap;
    private Hashtable<String, WCPConnection> sidConnMap;
    private Hashtable<String, BufferedQueue> positionQueueMap;
    private Hashtable<String, WCPConnection> drainConnMap;
    private Hashtable<String, BufferedQueue> drainQueueMap;
    private Hashtable<String, AtomicLong> bqStats;
    private Hashtable<String, LimitedQueue<Long>> avgRatePerConn;
    private WCPCBMetaHandler metaHandler;
    private WCPCBNotifyHandler callbackHandler;
    private WCPResponseHandler responseHandler;
    private WCPIDBCBNotifyHandler idbCallBackHandler;
    private WCPIDBCBListener idbCBListener = null;
    private AtomicInteger connectionCount = new AtomicInteger(0);
    private String poolName = null;
    private String serverType = null;
    private String remoteServerType = null;
    private String clusterName = null;
    private String context = null;
    private String uri = null;
    private int port = 0;
    private String lb_tech = null;
    private int ipQueueSize = 0;
    private int ackQueueSize = 0;
    private int minConnPerIp = 0;
    private int maxConnPerIp = 0;
    private int maxDataPerConn = 0;
    private int maxDataAddRetryCount = 0;
    private ArrayList<String> ipList = null;
    private AtomicInteger lb_rr_index = new AtomicInteger(0);
    private long lb_ll_lastValCalTime = 0L;
    private String lb_ll_ip = null;
    private AtomicLong wcpRequestId = new AtomicLong(0L);
    private Hashtable<String, WCPFuture> wcpRequestMap;
    private boolean onDemand = false;
    private boolean enableAR = false;
    private int arOpCode = -1;
    private boolean isCVDependent = false;
    private boolean handleAsBB = false;
    private boolean isSelfConnEnabled = true;
    private boolean forceCreateConnections = false;
    private HashMap<String, AtomicLong> blockedIPCount = new HashMap();
    private Set<String> blockedIP = new HashSet<String>();
    private boolean isSSLBased = false;
    private AccessTokenProvider accessTokenProvider = new ServerAccessTokenProviderImpl();
    private Hashtable<String, String> ht = new Hashtable();
    private WCPConnPoolConfig conf;

    public WCPServerConnPool(String poolName, String serverType, String remoteServerType, String clusterName, Hashtable<String, String> seedsMap, String context, boolean enableAR, int arOpCode, String uri, int port, boolean handleAsBB, String lb_tech, int ipQueueSize, int ackQueueSize, int minConnPerIp, int maxConnPerIp, int maxDataPerConn, int maxDataAddRetryCount) throws Exception {
        this.poolName = poolName;
        this.clusterName = clusterName;
        if (clusterName == null) {
            this.clusterName = "direct";
            this.setOnDemand(true);
        }
        this.serverType = serverType;
        this.remoteServerType = remoteServerType;
        this.context = context;
        this.uri = uri;
        this.port = port;
        this.lb_tech = lb_tech;
        this.ipQueueSize = ipQueueSize;
        this.ackQueueSize = ackQueueSize;
        this.minConnPerIp = minConnPerIp;
        this.maxConnPerIp = maxConnPerIp;
        this.maxDataPerConn = maxDataPerConn;
        this.maxDataAddRetryCount = maxDataAddRetryCount;
        this.enableAR = enableAR;
        this.arOpCode = arOpCode;
        this.handleAsBB = handleAsBB;
        this.seedsMap = seedsMap;
        this.seedsCount = seedsMap.size();
        this.initMaps();
        this.createConnections();
        logger.info("[WCP - New WCPServerConnPool Created][" + poolName + "] ClusterName=" + clusterName + " OnDemand=" + this.onDemand);
    }

    public WCPServerConnPool(WCPConnPoolConfig info) throws Exception {
        this.conf = info;
        info.setConnPool(this);
        this.poolName = info.getPoolName();
        this.clusterName = info.getClusterName();
        if (this.clusterName == null) {
            this.clusterName = "direct";
            this.setOnDemand(true);
        }
        this.serverType = info.getServerType();
        this.remoteServerType = info.getRemoteServerType();
        this.context = info.getContext();
        this.uri = info.getURI();
        this.port = info.getPort();
        this.lb_tech = info.getLbTech();
        this.ipQueueSize = info.getIpQueueSize();
        this.ackQueueSize = info.getAckQueueSize();
        this.minConnPerIp = info.getMinConnPerIp();
        this.isSSLBased = info.isSSLBased();
        this.isSelfConnEnabled = info.isSelfConnEnabled();
        this.accessTokenProvider = info.getAccessTokenProvider();
        this.maxConnPerIp = info.getMaxConnPerIp();
        this.maxDataPerConn = info.getMaxDataPerConn();
        this.maxDataAddRetryCount = info.getMaxDataAddRetryCount();
        this.enableAR = info.getEnableAR();
        this.arOpCode = info.getArOpCode();
        this.idbCBListener = info.getIDBCBListener();
        this.handleAsBB = info.getHandleAsBB();
        this.seedsMap = info.getSeedsMap();
        this.seedsCount = this.seedsMap.size();
        this.initMaps();
        this.createConnections();
        logger.info("[WCP - New WCPServerConnPool Created][" + this.poolName + "] ClusterName=" + this.clusterName + " OnDemand=" + this.onDemand);
    }

    private void initMaps() throws Exception {
        this.ipList = new ArrayList();
        this.bqStats = new Hashtable();
        this.ipSidMap = new Hashtable();
        this.sidConnMap = new Hashtable();
        this.drainConnMap = new Hashtable();
        this.avgRatePerConn = new Hashtable();
        this.drainQueueMap = new Hashtable();
        this.positionQueueMap = new Hashtable();
        this.wcpRequestMap = new Hashtable();
        this.metaHandler = new WCPCBMetaHandler(this);
        this.metaHandler.start();
        this.callbackHandler = new WCPCBNotifyHandler(this, WCPConfManager.getWCPHome() + "callback" + File.separator + this.poolName, this.poolName, this.ipQueueSize);
        this.callbackHandler.start();
        this.responseHandler = new WCPResponseHandler(this, WCPConfManager.getWCPHome() + "response" + File.separator + this.poolName, this.poolName, this.ipQueueSize);
        this.responseHandler.start();
        this.idbCallBackHandler = new WCPIDBCBNotifyHandler(this, WCPConfManager.getWCPHome() + "idbcallback" + File.separator + this.poolName, this.poolName, this.ipQueueSize);
        this.idbCallBackHandler.start();
    }

    private void createConnections() throws Exception {
        this.lb_ll_lastValCalTime = 0L;
        this.ipList = new ArrayList<String>(this.seedsMap.keySet());
        for (String ip : this.seedsMap.keySet()) {
            try {
                if (this.ipSidMap.get(ip) != null || ip.equals(WCPConfManager.getServerIp())) continue;
                this.createConnection(ip);
            }
            catch (Exception ex) {
                StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.CREATE_CONNECTIONS.getErrorCode(), 1L);
                WCPStats.addErrorStats("EXCEPTION_IN_CREATE_CONNECTIONS", "[remoteIP : " + ip + "]");
            }
        }
    }

    public WCPConnPoolConfig getConnPoolConfig() {
        return this.conf;
    }

    public void manageConnections(Hashtable<String, String> newSeedsMap) throws Exception {
        logger.info("HB--> refereshSeeds. oldSeedsMap=" + this.seedsMap + " newSeedsMap=" + newSeedsMap);
        List<String> removedIps = this.getRemovedIpsList(newSeedsMap, this.ipSidMap);
        logger.info("HBDEBUG--> refereshSeeds. oldSeedsMap=" + this.seedsMap + " newSeedsMap=" + newSeedsMap + " removedIps=" + removedIps);
        for (String removedIp : removedIps) {
            logger.info("HB--> refereshSeeds. closing unapproved connections. ip=" + removedIp + " sidList=" + this.ipSidMap.get(removedIp));
            this.closeUnapprovedConns(this.ipSidMap.get(removedIp));
            String position = this.seedsMap.get(removedIp);
            if (CommonUtil.isEmpty((String)position)) {
                logger.info("HBDEBUG--> refereshSeeds. removedIP=" + removedIp);
                continue;
            }
            if (newSeedsMap.containsValue(position)) {
                logger.info("HB--> drain skipped for position=" + this.seedsMap.get(removedIp) + " seedsMap=" + this.seedsMap + " newSeedsMap=" + newSeedsMap);
                continue;
            }
            this.drainQueue(removedIp, newSeedsMap);
        }
        this.seedsMap = newSeedsMap;
        this.seedsCount = newSeedsMap.size();
        this.createConnections();
    }

    public void registerAccessTokenProvider(AccessTokenProvider accessTokenProvider) {
        this.accessTokenProvider = accessTokenProvider;
        logger.log(Level.INFO, "registerAccessTokenProvider {0}", new Object[]{accessTokenProvider.getClass()});
    }

    public boolean setCVDependency(boolean isCVDependent) {
        if (this.isOnDemand()) {
            logger.warning("WCPWARN--> Cannot set Cluster version dependent in OnDemand ConnPool=" + this.poolName);
            return false;
        }
        this.isCVDependent = isCVDependent;
        return true;
    }

    public synchronized void setCallBackHandlerPoolSize(int corePoolSize, int maximumPoolSize) {
        this.callbackHandler.setPoolSize(corePoolSize, maximumPoolSize);
    }

    public synchronized void setCallBackHandlerCorePoolSize(int corePoolSize) {
        this.callbackHandler.setCorePoolSize(corePoolSize);
    }

    public synchronized void setCallBackHandlerMaxPoolSize(int maximumPoolSize) {
        this.callbackHandler.setMaximumPoolSize(maximumPoolSize);
    }

    public synchronized void setResponseHandlerPoolSize(int corePoolSize, int maximumPoolSize) {
        this.responseHandler.setPoolSize(corePoolSize, maximumPoolSize);
    }

    public synchronized void setResponseHandlerCorePoolSize(int corePoolSize) {
        this.responseHandler.setCorePoolSize(corePoolSize);
    }

    public synchronized void setResponseHandlerMaxPoolSize(int maximumPoolSize) {
        this.responseHandler.setMaximumPoolSize(maximumPoolSize);
    }

    public synchronized void setIDBCallBackHandlerPoolSize(int corePoolSize, int maximumPoolSize) {
        this.idbCallBackHandler.setPoolSize(corePoolSize, maximumPoolSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void createConnection(String ip) throws Exception {
        block15: {
            Object object = connectionLock.lock(ip);
            // MONITORENTER : object
            if (this.seedsMap.get(ip) == null) {
                logger.info("[WCP][createConnection] failed. Ip not present in the seedsMap. poolName=" + this.poolName + " Ip=" + ip + " seedsMap=" + this.seedsMap);
                StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.CREATE_CONNECTION_FAILED.getErrorCode(), 1L);
                WCPStats.addErrorStats("CREATE_CONNECTION_FAILED", "[remoteIP : " + ip + "]");
                // MONITOREXIT : object
                connectionLock.release(ip);
                return;
            }
            if (this.ipSidMap.get(ip) == null || this.ipSidMap.get(ip).size() < this.maxConnPerIp) break block15;
            logger.info("[WCP][createConnection] failed. max connection limit reached. poolName=" + this.poolName + " Ip=" + ip + " connections=" + this.ipSidMap.get(ip).size());
            StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.CREATE_CONNECTION_FAILED_MAX_LIMIT_REACHED.getErrorCode(), 1L);
            WCPStats.addErrorStats("CREATE_CONNECTION_FAILED_MAX_LIMIT_REACHED", "[remoteIP : " + ip + "]");
            // MONITOREXIT : object
            connectionLock.release(ip);
            return;
        }
        try {
            String sid;
            ArrayList<Object> sidList = null;
            if (this.ipSidMap.get(ip) == null) {
                sidList = new ArrayList(this.maxConnPerIp);
                this.ipSidMap.put(ip, sidList);
            }
            if (!(sidList = this.ipSidMap.get(ip)).contains(sid = WCPSessionIDGenerator.getSid())) {
                sidList.add(sid);
            }
            this.ipSidMap.put(ip, sidList);
            WCPBIOClientConn conn = null;
            try {
                String ipPosition = this.seedsMap.get(ip);
                if (ipPosition == null) {
                    logger.warning("WCPUNKNOWN--> Error inside createConnection. poolName=" + this.poolName);
                }
                if (this.positionQueueMap.get(ipPosition) == null) {
                    BufferedQueue bq = new BufferedQueue(WCPConfManager.getWCPHome() + this.poolName + File.separator + ipPosition, ipPosition, this.ipQueueSize, this.ackQueueSize, this.enableAR);
                    this.positionQueueMap.put(ipPosition, bq);
                }
                WCPStats.addBQSize(this.serverType, this.remoteServerType, this.poolName, ip, this.positionQueueMap.get(ipPosition).size());
                conn = new WCPBIOClientConn(this.serverType, this.remoteServerType, this.poolName, this.clusterName, ip, sid, this, this.positionQueueMap.get(ipPosition), this.connectionCount.incrementAndGet());
            }
            catch (Exception ex) {
                this.ipSidMap.get(ip).remove(sid);
                logger.log(Level.SEVERE, "WCPERR--> Error while creating WCPConnection ip=" + ip + " poolname=" + this.poolName, ex);
                throw ex;
            }
            this.sidConnMap.put(sid, conn);
            logger.info("[WCP][New Connection added To ConnectionPool][" + this.poolName + "][" + this.clusterName + "][" + ip + "][" + sid + "][" + this.ipSidMap.get(ip).size() + "]");
            // MONITOREXIT : object
            return;
        }
        finally {
            connectionLock.release(ip);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnFromPool(String ip, String sid) {
        if (this.sidConnMap.get(sid) != null) {
            ArrayList<String> sidList = this.ipSidMap.get(ip);
            if (sidList == null) {
                logger.info("WCPERR--> sidList is null. ip=" + ip + " sid=" + sid + " poolName=" + this.poolName);
                return;
            }
            ArrayList<String> arrayList = sidList;
            synchronized (arrayList) {
                if (!sidList.remove(sid)) {
                    logger.info("WCPERR--> sid not present in the sidList. sid=" + sid + " sidList=" + sidList + " ip=" + ip + " poolaName=" + this.poolName);
                }
                this.sidConnMap.remove(sid);
                if (sidList.size() == 0) {
                    BufferedQueue bq;
                    String ipPosition = this.seedsMap.get(ip);
                    if (ipPosition != null && this.positionQueueMap.get(ipPosition) != null && (bq = this.positionQueueMap.get(ipPosition)) != null && bq.isEmpty()) {
                        bq.close();
                        this.positionQueueMap.remove(ipPosition);
                        BQInventory.unRegister(bq);
                        logger.info("HBDEBUG--> removed from positionQueueMap. ipPosition=" + ipPosition);
                    }
                    this.ipSidMap.remove(ip);
                }
                logger.info("[WCP][Closed Connection Removed From ConnectionPool][" + this.poolName + "][" + this.clusterName + "][" + ip + "][" + sid + "]");
            }
        } else if (this.drainConnMap.get(sid) != null) {
            this.drainConnMap.remove(sid);
            this.drainQueueMap.remove(sid).close();
            logger.info("[WCP][Drain Connection Closed][" + this.poolName + "][" + this.clusterName + "][" + ip + "][" + sid + "]");
        } else {
            logger.warning("WCPUNKNOWN--> Invalid sid inside removeConnFromPool. ip=" + ip + " sid=" + sid);
        }
    }

    private List<String> getRemovedIpsList(Hashtable<String, String> newSeedsMap, Hashtable<String, ArrayList<String>> ipSidMap) {
        ArrayList<String> removedIpsList = new ArrayList<String>(ipSidMap.keySet());
        removedIpsList.removeAll(newSeedsMap.keySet());
        return removedIpsList;
    }

    private void closeUnapprovedConns(ArrayList<String> sidList) {
        if (sidList != null) {
            for (String sid : sidList) {
                try {
                    this.closeConn(this.sidConnMap.get(sid), "UnapprovedConn");
                }
                catch (Exception ex) {
                    StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.CLOSE_UN_APPROVED_CONNECTION.getErrorCode(), 1L);
                    WCPStats.addErrorStats("CLOSE_UN_APPROVED_CONNECTION", "[sid : " + sid + "][exception : " + ex.getMessage() + "]");
                }
            }
        }
    }

    private void closeConn(WCPConnection conn, String reason) throws Exception {
        if (conn == null) {
            return;
        }
        conn.setCloseReason(reason);
        conn.close();
    }

    public void receiveResponse(String id, WCPPacket packet) {
        String[] data = id.split("@");
        String ip = data[1];
        String sid = data[2];
        String reqid = data[3];
        if (this.wcpRequestMap.get(reqid) != null) {
            try {
                if (packet != null && packet.getPacketType() == 8) {
                    this.responseHandler.putData(this.poolName, ip, packet);
                }
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "[Exception - processWCPData][" + this.poolName + "][" + ip + "][" + ex.getMessage() + "]", ex);
            }
        } else {
            logger.info("[WCP][No WCPFutureObject][" + this.poolName + "][" + this.clusterName + "][" + ip + "][" + sid + "][" + reqid + "]");
        }
    }

    public WCPFuture sendRequest(WCPRequest req, WCPResponseCBListener listener, boolean isFrwdRequest, String dcName) throws Exception {
        return this.sendRequest(req, listener, isFrwdRequest, dcName, null, null);
    }

    public WCPFuture sendRequest(WCPRequest req, WCPResponseCBListener listener, boolean isFrwdRequest, String dcName, String rkey, String cluster) throws Exception {
        return this.sendRequest(req, listener, null, isFrwdRequest, dcName, rkey, cluster);
    }

    public WCPFuture sendRequest(WCPRequest wcpRequest, WCPResponseCBListener listener, String ip, boolean isFrwdRequest, String dcName) throws Exception {
        return this.sendRequest(wcpRequest, listener, ip, isFrwdRequest, dcName, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WCPFuture sendRequest(WCPRequest wcpRequest, WCPResponseCBListener listener, String ip, boolean isFrwdRequest, String dcName, String rkey, String cluster) throws Exception {
        String reqId = Long.toString(this.wcpRequestId.incrementAndGet());
        Hashtable<String, String> header = new Hashtable<String, String>();
        header.put("reqid", reqId);
        header.put("uri", wcpRequest.getURI());
        WCPFuture future = null;
        if (isFrwdRequest) {
            WCPRequest frwdRequest = new WCPRequest(wcpRequest.getURI(), wcpRequest.getHeaders(), null, null);
            if (wcpRequest.getTimeOutInMillis() != -1L) {
                frwdRequest.setTimeOutInMillis(wcpRequest.getTimeOutInMillis());
            }
            if (wcpRequest.getOriginTime() != -1L) {
                frwdRequest.setOriginTime(wcpRequest.getOriginTime());
            } else {
                frwdRequest.setOriginTime(System.currentTimeMillis());
            }
            ArrayList frwdIps = null;
            frwdRequest.addHeader("x-isforward-request", String.valueOf(true));
            if (WCPUtil.isNull(frwdRequest.getHeader("x-request-path"))) {
                frwdIps = new ArrayList();
                frwdIps.add(wcpRequest.getRemoteIp());
            } else {
                frwdIps = (ArrayList)HttpDataWraper.getObject((String)frwdRequest.getHeader("x-request-path"));
            }
            frwdIps.add(WCPConfManager.getServerIp());
            frwdRequest.addHeader("x-request-path", HttpDataWraper.getString((Object)frwdIps));
            frwdRequest.addHeader("x-request-origin-ip", (String)frwdIps.get(0));
            frwdRequest.addHeader("x-wcp-reqid", reqId);
            frwdRequest.setDestinationIp(ip);
            frwdRequest.setReqId(reqId);
            WCPStats.addWCPForwardRequests(this.serverType, this.remoteServerType, this.clusterName, this.poolName, wcpRequest.getRemoteIp(), ip, wcpRequest.getURI(), frwdIps.toString(), reqId);
            future = new WCPFuture(frwdRequest, null, listener, this.poolName, true);
        } else {
            if (ip != null) {
                wcpRequest.setDestinationIp(ip);
            }
            wcpRequest.addHeader("x-wcp-reqid", reqId);
            wcpRequest.setReqId(reqId);
            wcpRequest.setOriginTime(System.currentTimeMillis());
            future = new WCPFuture(wcpRequest, null, listener, this.poolName);
        }
        if (!CommonUtil.isEmpty((String)wcpRequest.getRKey()) && !CommonUtil.isEmpty((String)wcpRequest.getURI())) {
            header.put("rkey", wcpRequest.getRKey());
            header.put("uri", wcpRequest.getURI());
            header.put("startime", System.currentTimeMillis() + "");
            header.put("requestimeout", String.valueOf(wcpRequest.getTimeOutInMillis()));
            header.put("expirytime", String.valueOf(wcpRequest.getExpiryTime()));
        }
        boolean result = false;
        try {
            this.wcpRequestMap.put(reqId, future);
            WCPReqTimeOutListener.TRACKER.touch(wcpRequest.getExpiryTime(), this.poolName + "@" + reqId + "@" + wcpRequest.getExpiryTime());
            WCPPacket packet = WCPPacketizer.getPacketFromData(-1L, 7, 0L, header, -1, wcpRequest.getReqAsData());
            result = dcName != null ? (rkey != null || cluster != null ? WCPDispatcher.sendPacketToIDB(dcName, packet, this.poolName, rkey, cluster) : WCPDispatcher.sendPacketToIDB(dcName, packet, this.poolName)) : (ip == null ? this.sendPacket(packet) : this.sendPacket(packet, ip));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error while sending WCPRequest. poolname=" + this.poolName, e);
        }
        finally {
            if (!result) {
                WCPReqTimeOutListener.TRACKER.remove(wcpRequest.getExpiryTime(), this.poolName + "@" + reqId + "@" + wcpRequest.getExpiryTime());
                future = this.wcpRequestMap.remove(reqId);
                if (future != null) {
                    future.cancel(true);
                    future = null;
                }
            }
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WCPFuture forwardRequest(WCPPacket packet, String ip, WCPResponseCBListener listener) throws Exception {
        String reqId = Long.toString(this.wcpRequestId.incrementAndGet());
        WCPRequest req = new WCPRequest(packet.getHeader("uri"));
        req.setTimeOutInMillis(WMSUtil.getLong(packet.getHeader("requestimeout"), 10000L));
        req.setExpiryTimeInMillis(WMSUtil.getLong(packet.getHeader("expirytime"), System.currentTimeMillis() + 10000L));
        req.setDestinationIp(ip);
        req.setReqId(reqId);
        WCPFuture future = new WCPFuture(req, null, listener, this.poolName, true);
        ArrayList frwdIps = null;
        if (WCPUtil.isNull(packet.getHeader("x-request-path"))) {
            frwdIps = new ArrayList();
            frwdIps.add(WCPThreadLocal.getRemoteIp());
        } else {
            frwdIps = (ArrayList)HttpDataWraper.getObject((String)packet.getHeader("x-request-path"));
        }
        frwdIps.add(WCPConfManager.getServerIp());
        packet.addHeader("x-isforward-request", String.valueOf(true));
        packet.addHeader("x-wcp-reqid", reqId);
        packet.addHeader("reqid", reqId);
        packet.addHeader("x-request-path", HttpDataWraper.getString((Object)frwdIps));
        packet.addHeader("x-request-origin-ip", (String)frwdIps.get(0));
        boolean result = false;
        try {
            this.wcpRequestMap.put(reqId, future);
            WCPReqTimeOutListener.TRACKER.touch(req.getExpiryTime(), this.poolName + "@" + reqId + "@" + req.getExpiryTime());
            result = ip == null ? this.sendPacket(packet) : this.sendPacket(packet, ip);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error while sending WCPRequest. poolname=" + this.poolName, e);
        }
        finally {
            if (!result) {
                WCPReqTimeOutListener.TRACKER.remove(req.getExpiryTime(), this.poolName + "@" + reqId + "@" + req.getExpiryTime());
                future = this.wcpRequestMap.remove(reqId);
                if (future != null) {
                    future.cancel(true);
                    future = null;
                }
            }
        }
        return future;
    }

    public WCPBroadcastFuture sendBroadCastRequest(WCPRequest req, WCPBrdCstCBListnr listener, Set<String> broadcastIpList) throws Exception {
        WCPBroadcastFuture broadcastFuture = new WCPBroadcastFuture(req, null, listener, this.poolName);
        if (broadcastIpList == null) {
            broadcastIpList = new HashSet<String>(this.ipList);
        }
        for (String ip : broadcastIpList) {
            String reqId = Long.toString(this.wcpRequestId.incrementAndGet());
            Hashtable<String, String> header = new Hashtable<String, String>();
            header.put("reqid", reqId);
            WCPRequest newReq = req.duplicate();
            newReq.setReqId(reqId);
            newReq.setOriginTime(System.currentTimeMillis());
            newReq.addHeader("x-wcp-reqid", reqId);
            newReq.setDestinationIp(ip);
            newReq.addHeader("x-broadcast-request", String.valueOf(true));
            WCPFuture future = new WCPFuture(newReq, null, new BroadcastResponceCBListener(ip, broadcastFuture), this.poolName);
            broadcastFuture.addFuture(ip, future);
            this.wcpRequestMap.put(reqId, future);
            WCPReqTimeOutListener.TRACKER.touch(newReq.getExpiryTime(), this.poolName + "@" + reqId + "@" + newReq.getExpiryTime());
            WCPPacket packet = WCPPacketizer.getPacketFromData(-1L, 7, 0L, header, -1, newReq.getReqAsData());
            boolean result = false;
            result = ip == null ? this.sendPacket(packet) : this.sendPacket(packet, ip);
            if (result) continue;
            logger.severe("WCPERR--> [WCPServerConnPool][sendBroadCastRequest] Not able to send the request ip=" + ip + ", reqId=" + reqId + " poolname=" + this.poolName + " servlet=" + newReq.getURI());
            WCPReqTimeOutListener.TRACKER.remove(newReq.getExpiryTime(), this.poolName + "@" + reqId + "@" + newReq.getExpiryTime());
            future = this.wcpRequestMap.remove(reqId);
            if (future == null) continue;
            future.cancel(true);
            future = null;
        }
        return broadcastFuture;
    }

    public WCPBroadcastFuture sendBroadCastRequestToDcs(WCPRequest req, WCPBrdCstCBListnr listener, Set<String> dcNameList) throws Exception {
        WCPBroadcastFuture broadcastFuture = new WCPBroadcastFuture(req, null, listener, this.poolName);
        for (String dcName : dcNameList) {
            if (CommonUtil.isEmpty((String)dcName)) {
                throw new Exception("DC Name is null or empty. dcName=" + dcName);
            }
            if (!WCPConstants.IDB.DcNames.isValidDcName(dcName)) {
                throw new Exception("Invalid DcName. dcName=" + dcName);
            }
            String reqId = Long.toString(this.wcpRequestId.incrementAndGet());
            Hashtable<String, String> header = new Hashtable<String, String>();
            header.put("reqid", reqId);
            WCPRequest newReq = req.duplicate();
            newReq.setReqId(reqId);
            newReq.addHeader("x-wcp-reqid", reqId);
            newReq.addHeader("x-broadcast-request", String.valueOf(true));
            newReq.addHeader("x-broadcast-dest-dc", dcName);
            newReq.setOriginTime(System.currentTimeMillis());
            WCPFuture future = new WCPFuture(newReq, null, new BroadcastResponceCBListener(dcName, broadcastFuture), this.poolName);
            broadcastFuture.addFuture(dcName, future);
            this.wcpRequestMap.put(reqId, future);
            WCPReqTimeOutListener.TRACKER.touch(newReq.getExpiryTime(), this.poolName + "@" + reqId + "@" + newReq.getExpiryTime());
            WCPPacket packet = WCPPacketizer.getPacketFromData(-1L, 7, 0L, header, -1, newReq.getReqAsData());
            boolean result = false;
            result = WCPDispatcher.sendPacketToIDB(dcName, packet, this.poolName);
            if (result) continue;
            logger.severe("WCPERR--> [WCPServerConnPool][sendBroadCastRequestToDcs] Not able to send the request dcName=" + dcName + " reqId=" + reqId + " poolname=" + this.poolName + " servlet=" + newReq.getURI());
            WCPReqTimeOutListener.TRACKER.remove(newReq.getExpiryTime(), this.poolName + "@" + reqId + "@" + newReq.getExpiryTime());
            future = this.wcpRequestMap.remove(reqId);
            if (future == null) continue;
            future.cancel(true);
            future = null;
        }
        return broadcastFuture;
    }

    public boolean sendPacket(WCPPacket packet) throws Exception {
        if (this.sidConnMap.size() == 0 && this.seedsMap.size() > 0) {
            this.createConnections();
        }
        switch (this.lb_tech) {
            case "df": {
                Set<String> keys = this.seedsMap.keySet();
                for (String key : keys) {
                    if (!this.sendPacket(packet, key, true)) continue;
                    return true;
                }
                break;
            }
            case "rr": {
                int index = this.lb_rr_index.incrementAndGet();
                if (index >= this.seedsCount) {
                    this.lb_rr_index.set(0);
                    index = 0;
                }
                return this.sendPacket(packet, this.ipList.get(index));
            }
            case "ll": {
                if (System.currentTimeMillis() - this.lb_ll_lastValCalTime > 60000L) {
                    int size = -1;
                    Set<String> keys = this.positionQueueMap.keySet();
                    for (String key : keys) {
                        int sz = this.positionQueueMap.get(this.seedsMap.get(key)).size();
                        if (size != -1 && sz >= size) continue;
                        size = sz;
                        this.lb_ll_ip = key;
                    }
                    this.lb_ll_lastValCalTime = System.currentTimeMillis();
                }
                return this.sendPacket(packet, this.lb_ll_ip);
            }
        }
        return false;
    }

    public boolean sendPacket(WCPPacket packet, String ip) throws Exception {
        return this.sendPacket(packet, ip, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendPacket(WCPPacket packet, String ip, boolean deflt) throws Exception {
        if (this.blockedIP.contains(ip)) {
            AtomicLong atomicLong = this.blockedIPCount.get(ip);
            if (atomicLong != null) {
                atomicLong.incrementAndGet();
            } else {
                atomicLong = new AtomicLong(1L);
            }
            this.blockedIPCount.put(ip, atomicLong);
            return true;
        }
        String ipPosition = this.seedsMap.get(ip);
        if (this.onDemand && ipPosition == null) {
            ipPosition = "od-" + ip;
            this.seedsMap.put(ip, ipPosition);
        }
        if (ipPosition == null) {
            logger.info("HB_ERR--> IP is not present in the seedsMap. ip=" + ip + " seedsMap=" + this.seedsMap);
            StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.IP_NOT_PRESENT_IN_SEEDS_MAP.getErrorCode(), 1L);
            WCPStats.addErrorStats("IP_NOT_PRESENT_IN_SEEDS_MAP", "[remoteIP : " + ip + "][method : sendPacket][param : wcpPacketObject]");
            return false;
        }
        if (this.positionQueueMap.get(ipPosition) == null || this.ipSidMap.get(ip) == null) {
            String string = ipPosition;
            synchronized (string) {
                if (this.positionQueueMap.get(ipPosition) == null || this.ipSidMap.get(ip) == null) {
                    this.createConnection(ip);
                    logger.info("NSDEBUG--> Connection created for OnDemand. ipPosition=" + ipPosition + " ip=" + ip + " poolname=" + this.poolName);
                }
            }
        }
        if (this.isCVDependent) {
            packet.addHeader("x-cluster-version", DistributionManager.getClusterVersion(this.clusterName));
        }
        if (this.positionQueueMap.get(ipPosition) != null) {
            BufferedQueue bq = this.positionQueueMap.get(ipPosition);
            if (deflt) {
                for (int count = 0; count <= this.maxDataAddRetryCount; ++count) {
                    int limit = this.ipSidMap.get(ip).size() * this.maxDataPerConn;
                    if (bq.size() < limit) {
                        packet.setQueueInTime(System.currentTimeMillis());
                        bq.add(packet);
                        this.setBqStats(ip);
                        return true;
                    }
                    String string = ipPosition;
                    synchronized (string) {
                        limit = this.ipSidMap.get(ip).size() * this.maxDataPerConn;
                        if (bq.size() > limit) {
                            this.createConnection(ip);
                        }
                        continue;
                    }
                }
                throw new Exception("Max Data Limit Reached");
            }
            packet.setQueueInTime(System.currentTimeMillis());
            bq.add(packet);
            this.setBqStats(ip);
            if ((this.ipSidMap.get(ip) == null || bq.size() > this.ipSidMap.get(ip).size() * this.maxDataPerConn) && this.ipSidMap.get(ip).size() < this.maxConnPerIp) {
                String string = ipPosition;
                synchronized (string) {
                    if ((this.ipSidMap.get(ip) == null || bq.size() > this.ipSidMap.get(ip).size() * this.maxDataPerConn) && this.ipSidMap.get(ip).size() < this.maxConnPerIp) {
                        this.createConnection(ip);
                    }
                }
            }
            return true;
        }
        StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.QUEUE_NOT_PRESENT_FOR_IP.getErrorCode(), 1L);
        WCPStats.addErrorStats("QUEUE_NOT_PRESENT_FOR_IP", "[remoteIP : " + ip + "][method : sendPacket][param : wcpPacketObject]");
        throw new Exception("No Queue present to ip=" + ip + " poolname=" + this.poolName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendPacket(byte[] packet, String ip, boolean deflt) throws Exception {
        Object object;
        if (this.blockedIP.contains(ip)) {
            AtomicLong atomicLong = this.blockedIPCount.get(ip);
            if (atomicLong != null) {
                atomicLong.incrementAndGet();
            } else {
                atomicLong = new AtomicLong(1L);
            }
            this.blockedIPCount.put(ip, atomicLong);
            return true;
        }
        String ipPosition = this.seedsMap.get(ip);
        if (this.onDemand && ipPosition == null) {
            try {
                object = WCPUtil.getObjLock(ip);
                synchronized (object) {
                    ipPosition = this.seedsMap.get(ip);
                    if (ipPosition == null) {
                        ipPosition = "od-" + ip;
                        this.seedsMap.put(ip, ipPosition);
                    }
                }
            }
            finally {
                WCPUtil.releaseObjLock(ip);
            }
        }
        if (ipPosition == null) {
            logger.info("HB_ERR--> IP is not present in the seedsMap. poolName=" + this.poolName + " ip=" + ip + " seedsMap=" + this.seedsMap);
            StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.IP_NOT_PRESENT_IN_SEEDS_MAP.getErrorCode(), 1L);
            WCPStats.addErrorStats("IP_NOT_PRESENT_IN_SEEDS_MAP", "[remoteIP : " + ip + "][method : sendPacket][param : bytePacket]");
            return false;
        }
        if (this.positionQueueMap.get(ipPosition) == null || this.ipSidMap.get(ip) == null) {
            object = WCPUtil.getObjLock(ipPosition);
            synchronized (object) {
                if (this.positionQueueMap.get(ipPosition) == null || this.ipSidMap.get(ip) == null) {
                    this.createConnection(ip);
                    logger.info("NSDEBUG--> Connection created for OnDemand. ipPosition=" + ipPosition + " ip=" + ip + " poolname=" + this.poolName);
                    this.setMinConnPerIp(this.minConnPerIp, this.forceCreateConnections, ip);
                }
            }
        }
        if (this.positionQueueMap.get(ipPosition) != null) {
            BufferedQueue bq = this.positionQueueMap.get(ipPosition);
            if (deflt) {
                for (int count = 0; count <= this.maxDataAddRetryCount; ++count) {
                    int limit = this.ipSidMap.get(ip).size() * this.maxDataPerConn;
                    if (bq.size() < limit) {
                        bq.add(packet);
                        this.setBqStats(ip);
                        return true;
                    }
                    String string = ipPosition;
                    synchronized (string) {
                        limit = this.ipSidMap.get(ip).size() * this.maxDataPerConn;
                        if (bq.size() > limit) {
                            this.createConnection(ip);
                        }
                        continue;
                    }
                }
                throw new Exception("Max Data Limit Reached");
            }
            bq.add(packet);
            this.setBqStats(ip);
            if (this.ipSidMap.get(ip) == null || bq.size() > this.ipSidMap.get(ip).size() * this.maxDataPerConn) {
                String string = ipPosition;
                synchronized (string) {
                    if (this.ipSidMap.get(ip) == null || bq.size() > this.ipSidMap.get(ip).size() * this.maxDataPerConn) {
                        this.createConnection(ip);
                    }
                }
            }
            return true;
        }
        StatsDB.recordError(ComponentConstants.WCP_ENUM.getModuleCode(), ComponentConstants.WCP_ENUM.QUEUE_NOT_PRESENT_FOR_IP.getErrorCode(), 1L);
        WCPStats.addErrorStats("QUEUE_NOT_PRESENT_FOR_IP", "[remoteIP : " + ip + "][method : sendPacket][param : bytePacket]");
        throw new Exception("No Queue present to ip=" + ip + " poolname=" + this.poolName);
    }

    boolean blockIP(String ip) {
        return this.blockedIP.add(ip);
    }

    String unblockIP(String ip) {
        if (this.blockedIP.remove(ip)) {
            AtomicLong atomicLong = this.blockedIPCount.remove(ip);
            if (atomicLong != null) {
                return "Unblocked successfully, and " + atomicLong.get() + " packet(s) has been ignored by this IP";
            }
            return "Unblocked successfully, and no packets has been ignored by this IP";
        }
        return "IP does not contains in blocked list";
    }

    public Hashtable<String, Object> getBlockedIPs() {
        Hashtable<String, Object> ignoredPacketsMap = new Hashtable<String, Object>();
        for (String ip : this.blockedIP) {
            if (this.blockedIP.contains(ip)) {
                AtomicLong atomicLong = this.blockedIPCount.get(ip);
                if (atomicLong != null) {
                    ignoredPacketsMap.put(ip, atomicLong.get());
                    continue;
                }
                ignoredPacketsMap.put(ip, "0");
                continue;
            }
            ignoredPacketsMap.put(ip, "IP does not contains in blocked list");
        }
        return ignoredPacketsMap;
    }

    private void drainQueue(String ip, Hashtable<String, String> newSeedsMap) throws Exception {
        String ipPosition = this.seedsMap.get(ip);
        BufferedQueue bq = this.positionQueueMap.remove(ipPosition);
        if (bq == null || newSeedsMap.size() == 0) {
            return;
        }
        String drainIp = newSeedsMap.keys().nextElement();
        String sid = WCPSessionIDGenerator.getSid();
        WCPBIOClientConn conn = new WCPBIOClientConn(this.serverType, this.remoteServerType, this.poolName, this.clusterName, drainIp, sid, this, bq, this.connectionCount.incrementAndGet());
        this.drainConnMap.put(sid, conn);
        this.drainQueueMap.put(sid, bq);
        logger.info("[WCP][New Drain Connection added][" + this.poolName + "][" + this.clusterName + "][" + drainIp + "][" + sid + "]");
    }

    public void processWCPMetaData(String ip, WCPPacket packet) {
        try {
            if (packet != null && packet.getPacketType() != 1) {
                this.metaHandler.putData(this.poolName, ip, packet);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "WCPERR--> [Exception - processWCPMetaData][" + this.poolName + "][" + ip + "]", e);
        }
    }

    public void processWCPNotifyData(String ip, WCPPacket packet) {
        try {
            if (packet != null && packet.getPacketType() == 4) {
                this.callbackHandler.putData(this.poolName, ip, packet);
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "WCPERR--> [Exception - processWCPNotifyData][" + this.poolName + "][" + ip + "]", ex);
        }
    }

    public void processWCPIDBNotifyData(String ip, WCPPacket packet) {
        try {
            if (packet != null) {
                this.idbCallBackHandler.putData(this.poolName, ip, packet);
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "WCPERR--> [Exception - processWCPIDBNotifyData][" + this.poolName + "][" + ip + "]", ex);
        }
    }

    public void processIDBNotifyPackets(String context, String source, String ip, byte[] data) {
        if (WCPUtil.isNull(context)) {
            logger.severe("WCPERR--> Invalid context for IDBNotifyPackets; context" + context + " source=" + source + " ip=" + ip);
            return;
        }
        if (this.idbCBListener == null) {
            logger.severe("WCPERR--> IDBCBListener is not registered for IDBNotifyPackets; context" + context + " source=" + source + " ip=" + ip);
            return;
        }
        long currTime = System.currentTimeMillis();
        this.idbCBListener.onNotify(source, ip, data);
        WCPStats.addWCPListenerStats("on_notify", source, System.currentTimeMillis() - currTime);
    }

    public boolean isCVDependent() {
        return this.isCVDependent;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public String getContext() {
        return this.context;
    }

    public String getURI() {
        return this.uri;
    }

    public String getServerType() {
        return this.serverType;
    }

    public String getRemoteServerType() {
        return this.remoteServerType;
    }

    public int getPort() {
        return this.port;
    }

    private void setBqStats(String ip) {
        if (ip != null) {
            if (this.bqStats.get(ip) == null) {
                this.bqStats.put(ip, new AtomicLong(0L));
            }
            this.bqStats.get(ip).incrementAndGet();
        }
    }

    private long getBqStats(String ip) {
        if (this.bqStats != null && ip != null) {
            try {
                if (this.bqStats.get(ip).get() == 0L) {
                    this.bqStats.remove(ip);
                    return 0L;
                }
                return this.bqStats.get(ip).getAndSet(0L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0L;
    }

    public long getBqRatePerMin(String ip) {
        return this.getBqStats(ip);
    }

    public long getLiveBQSize(String ip) {
        String ipPosition;
        if (ip != null && (ipPosition = this.seedsMap.get(ip)) != null) {
            return this.positionQueueMap.containsKey(ipPosition) ? (long)this.positionQueueMap.get(ipPosition).size() : 0L;
        }
        return 0L;
    }

    public Hashtable<String, ArrayList<String>> getIPSidMap() {
        return this.ipSidMap;
    }

    public int getConnectionCount(String ip) {
        if (!CommonUtil.isEmpty((String)ip) && this.ipSidMap.containsKey(ip)) {
            return this.ipSidMap.get(ip).size();
        }
        return 0;
    }

    public void setIpQueueSize(int ipQueueSize) {
        this.ipQueueSize = ipQueueSize;
    }

    public void setAckQueueSize(int ackQueueSize) {
        this.ackQueueSize = ackQueueSize;
    }

    public void setMaxConnPerIp(int maxConnPerIp) {
        this.maxConnPerIp = maxConnPerIp;
    }

    public void setMinConnPerIp(int minConnPerIp) {
        this.setMinConnPerIp(minConnPerIp, false, null);
    }

    public void setMinConnPerIp(int minConnPerIp, boolean forceCreateConnections) {
        this.setMinConnPerIp(minConnPerIp, forceCreateConnections, null);
    }

    public void setMinConnPerIp(int minConnPerIp, boolean forceCreateConnections, String ip) {
        this.minConnPerIp = minConnPerIp;
        this.forceCreateConnections = forceCreateConnections;
        if (forceCreateConnections) {
            if (CommonUtil.isEmpty(this.seedsMap)) {
                logger.info("HB--> force connection creation skipped. seedsEmpty for poolName=" + this.poolName);
                return;
            }
            int currConnCount = 0;
            for (int i = 0; i < minConnPerIp; ++i) {
                try {
                    if (CommonUtil.isEmpty((String)ip)) {
                        for (String remoteIp : this.seedsMap.keySet()) {
                            currConnCount = this.getConnectionCount(remoteIp);
                            if (WCPConfManager.getServerIp().equals(remoteIp)) continue;
                            if (currConnCount >= minConnPerIp) {
                                logger.info("HB--> force connection creation skipped. remoteIp=" + remoteIp + " poolName=" + this.poolName + " ConnCount : " + currConnCount);
                                continue;
                            }
                            this.createConnection(remoteIp);
                            logger.info("HB--> force connection created. remoteIp=" + remoteIp + " poolName=" + this.poolName + " ConnCount : " + currConnCount);
                        }
                        continue;
                    }
                    currConnCount = this.getConnectionCount(ip);
                    if (this.getConnectionCount(ip) >= minConnPerIp) {
                        logger.info("HB--> force connection creation skipped. ip=" + ip + " poolName=" + this.poolName + " ConnCount : " + currConnCount);
                        break;
                    }
                    this.createConnection(ip);
                    logger.info("HB--> force connection created. ip=" + ip + " poolName=" + this.poolName + " ConnCount : " + currConnCount);
                    continue;
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "WCPERR--> Unable to create force connection. poolName=" + this.poolName, e);
                }
            }
        }
    }

    public void setMaxDataPerConn(int maxDataPerConn) {
        this.maxDataPerConn = maxDataPerConn;
    }

    public int getMinConnPerIp() {
        return this.minConnPerIp;
    }

    public void setLBTechnique(String lb_tech) {
        switch (lb_tech) {
            case "ll": {
                this.lb_tech = lb_tech;
                break;
            }
            case "rr": {
                this.lb_ll_ip = lb_tech;
                break;
            }
            default: {
                this.lb_tech = lb_tech;
            }
        }
    }

    public void setMaxDataAddRetryCount(int maxDataAddRetryCount) {
        this.maxDataAddRetryCount = maxDataAddRetryCount;
    }

    public Hashtable<String, Hashtable<String, String>> getWCPQStats() {
        Hashtable<String, Hashtable<String, String>> ht = new Hashtable<String, Hashtable<String, String>>();
        for (String ip : this.seedsMap.keySet()) {
            try {
                if (ip.equals(WCPConfManager.getServerIp())) continue;
                ht.put(ip, this.getWCPQStats(ip));
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error while getting WCPQStats for poolName=" + this.poolName + " ip=" + ip, e);
            }
        }
        return ht;
    }

    public int getTotalQueueSize() {
        int size = 0;
        for (String position : this.positionQueueMap.keySet()) {
            logger.info("HB--> DRAIN poolName=" + this.poolName + " position=" + position + " seedsMap=" + this.seedsMap + " bqsize=" + this.positionQueueMap.get(position).size());
            size += this.positionQueueMap.get(position).size();
        }
        return size;
    }

    public void closeQueue() {
        for (String position : this.positionQueueMap.keySet()) {
            this.positionQueueMap.get(position).close();
        }
    }

    public void openQueue() {
        for (String position : this.positionQueueMap.keySet()) {
            this.positionQueueMap.get(position).open();
        }
    }

    public Hashtable<String, String> getWCPQStats(String ip) {
        String ipPosition = this.seedsMap.get(ip);
        return this.positionQueueMap.get(ipPosition).getStats();
    }

    public void setAvgRatePerConn(String ip, long bqRate) {
        LimitedQueue<Long> bqRateList = null;
        if (ip != null && this.avgRatePerConn.get(ip) == null) {
            bqRateList = new LimitedQueue(WCPConfManager.getBqAvgRateTime());
            bqRateList.add(bqRate);
            this.avgRatePerConn.put(ip, bqRateList);
            return;
        }
        if (ip != null) {
            bqRateList = this.avgRatePerConn.get(ip);
            bqRateList.add(bqRate);
        }
    }

    public long getAvgRatePerConn(String ip) {
        try {
            if (ip != null && this.avgRatePerConn.get(ip) != null) {
                return WCPUtil.calculateAverage(this.avgRatePerConn.get(ip));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0L;
    }

    public void closeUnnecessaryConn(String ip) {
        try {
            this.closeConn(this.sidConnMap.get(this.ipSidMap.get(ip).get(0)), "Unnecessary Connection");
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "WCPERR--> [Exception - closeUnnecessaryConn][" + this.poolName + "][" + ip + "]", e);
        }
    }

    public WCPFuture removeWCPFutureObj(String reqid) {
        return this.wcpRequestMap.remove(reqid);
    }

    public void invalidateWCPRequest(String reqid) {
        WCPFuture future = this.removeWCPFutureObj(reqid);
        if (future != null) {
            WCPRequest request = future.getRequest();
            if (future.isFutureofFrwdReq()) {
                logger.info("[WCP][ WCPRequest Forwarded Canceled due to timeout][" + this.poolName + "][" + request.getDestinationIp() + "][" + this.clusterName + "][" + request.getURI() + "][" + reqid + "]");
            } else {
                WCPResponse response = new WCPResponse(null, null);
                response.setResponseCode("408");
                response.setResponseStr("request_timeout");
                future.setResponse(response);
                if (Boolean.parseBoolean(request.getHeader("x-broadcast-request"))) {
                    String destDcName = request.getHeader("x-broadcast-dest-dc");
                    if (!CommonUtil.isEmpty((String)destDcName)) {
                        logger.info("[WCP] InterDC WCPBroadcastRequest Canceled due to timeout. poolName=" + this.poolName + " destDc=" + destDcName + " clusterName=" + this.clusterName + " servlet=" + request.getURI() + " reqid=" + reqid);
                    } else {
                        logger.info("[WCP] WCPBroadcastRequest Canceled due to timeout. poolName=" + this.poolName + " destIp=" + request.getDestinationIp() + " clusterName=" + this.clusterName + " servlet=" + request.getURI() + " reqid=" + reqid);
                    }
                } else {
                    logger.info("[WCP][ WCPRequest Canceled due to timeout ][" + this.poolName + "][" + request.getDestinationIp() + "][" + this.clusterName + "][" + request.getURI() + "][" + reqid + "]");
                }
            }
            WCPStats.addWCPRequestTimeout(this.serverType, this.remoteServerType, this.poolName, DC.getCluster(), this.clusterName, request.getDestinationIp(), request.getURI(), String.valueOf(future.isFutureofFrwdReq()));
        }
    }

    public boolean isValidRequest(String reqid) {
        return this.wcpRequestMap.containsKey(reqid);
    }

    public int getPendingResponses() {
        return this.wcpRequestMap.size();
    }

    public void setOnDemand(boolean onDemand) {
        this.onDemand = onDemand;
    }

    public boolean isOnDemand() {
        return this.onDemand;
    }

    public boolean isAREnabled() {
        return this.enableAR;
    }

    public int getAROpCode() {
        return this.arOpCode;
    }

    public boolean isHandleAsBB() {
        return this.handleAsBB;
    }

    public long getNotifyHandlerQueueSize() {
        return this.callbackHandler.getQueueSize();
    }

    public long getResponseHandlerQueueSize() {
        return this.responseHandler.getQueueSize();
    }

    public long getIDBNotifyHandlerQueueSize() {
        return this.idbCallBackHandler.getQueueSize();
    }

    public void enableForceCloseConn() {
        this.metaHandler.enableForceCloseConn();
    }

    public void disableForceCloseConn() {
        this.metaHandler.disableForceCloseConn();
    }

    public void enableSelfConnection() {
        this.isSelfConnEnabled = true;
    }

    public void disableSelfConnection() {
        this.isSelfConnEnabled = false;
    }

    public boolean isSelfConnEnabled() {
        return this.isSelfConnEnabled;
    }

    public void enableSSL() {
        this.isSSLBased = true;
    }

    public void disableSSL() {
        this.isSSLBased = false;
    }

    public boolean isSSLBased() {
        return this.isSSLBased;
    }

    public String getAccessToken() {
        return this.accessTokenProvider.getAccessToken(this.poolName, this.serverType, WCPUtil.getServerType(this.clusterName), DC.getCluster(), this.clusterName);
    }

    public LinkedHashMap<String, Object> getStatus() {
        LinkedHashMap<String, Object> wcpStats = new LinkedHashMap<String, Object>();
        wcpStats.put("Pool Name", this.poolName);
        wcpStats.put("Server Type", this.serverType);
        wcpStats.put("Remote Server Type", this.remoteServerType);
        wcpStats.put("Clients Count", this.ipSidMap.size());
        wcpStats.put("SSL Based", this.isSSLBased());
        wcpStats.put("CallBackNotifier max Threads", this.callbackHandler.getMaxThreadsCount());
        wcpStats.put("CallBackNotifier Active Threads", this.callbackHandler.getActiveThreadsCount());
        wcpStats.put("ResponseNotifier max Threads", this.responseHandler.getMaxThreadsCount());
        wcpStats.put("ResponseNotifier Active Threads", this.responseHandler.getActiveThreadsCount());
        ArrayList wcpStatsOrder = new ArrayList(wcpStats.keySet());
        wcpStats.put("_order", wcpStatsOrder);
        return wcpStats;
    }

    public LinkedHashMap<String, Object> getDetailedStatus() {
        LinkedHashMap<String, Object> wcpStats = new LinkedHashMap<String, Object>();
        wcpStats.put("Seeds Map", this.seedsMap);
        wcpStats.put("Servertype", this.serverType);
        wcpStats.put("Remote Servertype", this.remoteServerType);
        wcpStats.put("On Demand Status", this.onDemand);
        wcpStats.put("Context", this.context);
        wcpStats.put("Pool Name", this.poolName);
        wcpStats.put("Clients", this.ipSidMap.keySet());
        wcpStats.put("WCP Queue Stats", this.getWCPQStats());
        wcpStats.put("CallBackNotifier max Threads", this.callbackHandler.getMaxThreadsCount());
        wcpStats.put("CallBackNotifier Active Threads", this.callbackHandler.getActiveThreadsCount());
        wcpStats.put("ResponseNotifier max Threads", this.responseHandler.getMaxThreadsCount());
        wcpStats.put("ResponseNotifier Active Threads", this.responseHandler.getActiveThreadsCount());
        ArrayList wcpStatsOrder = new ArrayList(wcpStats.keySet());
        wcpStats.put("_order", wcpStatsOrder);
        return wcpStats;
    }

    public int clearBQData() {
        return this.clearBQData(0);
    }

    public int clearBQData(int drainLimit) {
        for (String position : this.positionQueueMap.keySet()) {
            this.clearBQData(this.positionQueueMap.get(position), drainLimit);
        }
        logger.log(Level.INFO, "BufferedQueue Drained SuccessFully. poolName={0} drainLimit={1}", new Object[]{this.poolName, drainLimit});
        return 0;
    }

    protected int clearBQData(String ip) {
        return this.clearBQData(ip, 0);
    }

    protected int clearBQData(String ip, int drainLimit) {
        String position = null;
        if (this.seedsMap.containsKey(ip)) {
            position = this.seedsMap.get(ip);
            if (this.positionQueueMap.containsKey(position)) {
                this.clearBQData(this.positionQueueMap.get(position), drainLimit);
                return 0;
            }
            logger.log(Level.INFO, "BufferedQueue Drain FAILED. BQ not found. ip={0} position={1} drainLimit={2}", new Object[]{ip, position, drainLimit});
            return 2;
        }
        logger.log(Level.INFO, "BufferedQueue Drain FAILED. IP not found in seedsMap. ip={0} seedsMap={1} drainLimit={2}", new Object[]{ip, this.seedsMap, drainLimit});
        return 3;
    }

    protected void clearBQData(BufferedQueue bq) {
        this.clearBQData(bq, 0);
    }

    protected void clearBQData(BufferedQueue bq, int limit) {
        int drainLimit = limit > 0 ? limit : bq.size();
        drainLimit = drainLimit > bq.qSize() ? bq.qSize() : drainLimit;
        long time = System.currentTimeMillis();
        logger.log(Level.INFO, "BufferedQueue Drain Started. quque={0} limit={1}", new Object[]{bq.getFilePath(), drainLimit});
        for (int i = 0; i < drainLimit; ++i) {
            bq.get();
        }
        logger.log(Level.INFO, "BufferedQueue Drained SuccessFully. quque={0} limit={1} DrainTime={2}ms", new Object[]{bq.getFilePath(), drainLimit, System.currentTimeMillis() - time});
    }
}

