/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.net;

import com.adventnet.wms.common.CommonUtil;
import com.adventnet.wms.common.HttpDataWraper;
import com.adventnet.wms.servercommon.components.net.WCPSessionManager;
import com.adventnet.wms.servercommon.dc.DC;
import com.adventnet.wms.servercommon.grid.AbsAutoReBalancer;
import com.adventnet.wms.servercommon.stats.influx.StatsDB;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;

public class WCPApiReBalancer
extends AbsAutoReBalancer {
    private static final Logger LOGGER = Logger.getLogger(WCPApiReBalancer.class.getName());
    public static final String CONTEXT_ROUTER = "router";
    public static final String CONTEXT = "wcpapi";

    @Override
    public boolean rebalanceContext(Map<String, Object> redirectData, String context) {
        block5: {
            LOGGER.info("WMSAPI rebalancer--> " + redirectData + " for context : " + context);
            try {
                JSONObject rebalanceDetails = new JSONObject(HttpDataWraper.getString(redirectData));
                Iterator keys = rebalanceDetails.keys();
                if (!keys.hasNext()) break block5;
                String redirectip = (String)keys.next();
                long sessions = rebalanceDetails.getLong(redirectip);
                int counter = 0;
                while ((long)counter < sessions) {
                    Hashtable<String, String> header = new Hashtable<String, String>();
                    header.put("redirectip", redirectip);
                    String remoteip = WCPSessionManager.getRemoteip(counter);
                    if (CommonUtil.isEmpty((String)remoteip)) break;
                    try {
                        WCPSessionManager.sendControlData(CONTEXT_ROUTER, remoteip, 5, header, "api");
                        StatsDB.addData("wcpapirebalancer", DC.getCluster(), redirectip, WCPSessionManager.getApiName(remoteip), WCPSessionManager.getPrd(remoteip), remoteip, "success", 1);
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.SEVERE, "ARB-->Exception while sending control packet to remoteip :" + remoteip + " for context : " + context, e);
                        StatsDB.addData("wcpapirebalancer", DC.getCluster(), redirectip, WCPSessionManager.getApiName(remoteip), WCPSessionManager.getPrd(remoteip), remoteip, "failed", 1);
                    }
                    ++counter;
                }
                return true;
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "ARB-->Exception while sending control packet for context : " + context, e);
            }
        }
        return false;
    }
}

