/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.net;

import com.adventnet.wms.common.CommonUtil;
import com.adventnet.wms.servercommon.components.net.WCPDispatcher;
import com.adventnet.wms.servercommon.components.net.WCPSessionManager;
import com.adventnet.wms.servercommon.grid.ar.ARManager;
import com.adventnet.wms.servercommon.grid.ar.ARModule;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WCPARModule
implements ARModule {
    private static Logger logger = Logger.getLogger(WCPARModule.class.getName());
    public static final long MAX_PREPARE_TIME = 60000L;
    private static long st = -1L;
    private static int totalSessions = -1;
    private static ReentrantLock lock = new ReentrantLock();
    private static Condition controlAck = lock.newCondition();
    private static Map<String, String> progress = new HashMap<String, String>();
    private static Hashtable<String, Long> controlSid = new Hashtable();
    private static Hashtable<String, Long> ackReceived = new Hashtable();
    private String redirectIP = null;
    private boolean proceedOnDrainFailure = false;

    public WCPARModule() {
        this(null);
    }

    public WCPARModule(boolean proceedOnDrainFailure) {
        this.proceedOnDrainFailure = proceedOnDrainFailure;
        logger.info("HB--> proceedOnDrainFailure=" + proceedOnDrainFailure);
    }

    public WCPARModule(String redirectIP) {
        this.redirectIP = redirectIP;
        logger.info("HB--> redirect IP " + redirectIP);
    }

    public WCPARModule(String redirectIP, boolean proceedOnDrainFailure) {
        this.redirectIP = redirectIP;
        this.proceedOnDrainFailure = proceedOnDrainFailure;
        logger.info("HB--> redirect IP " + redirectIP + " proceedOnDrainFailure=" + proceedOnDrainFailure);
    }

    @Override
    public boolean init(int serverMode) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare() {
        int drainedPools;
        boolean status = false;
        int redirectedSessions = 0;
        String message = "";
        try {
            this.reset();
            lock.lock();
            progress.put("Progress", "10");
            progress.put("Title", "Started");
            if (!CommonUtil.isEmpty((String)this.redirectIP)) {
                Hashtable<String, String> header = new Hashtable<String, String>();
                header.put("redirectip", this.redirectIP);
                redirectedSessions = WCPSessionManager.sendControlPacketToAll(5, "api", header);
            }
            progress.put("Progress", "25");
            progress.put("Title", "Going to pause data stream.");
            totalSessions = WCPDispatcher.pauseDataStream();
            progress.put("Progress", "50");
            progress.put("Title", "Datastream pause notified");
            drainedPools = WCPDispatcher.drainAndClose(5L, 1, this.proceedOnDrainFailure, TimeUnit.SECONDS);
            progress.put("Progress", "75");
            progress.put("Title", "Connection Pool drained");
            if (totalSessions == 0) {
                status = true;
            } else if (totalSessions > 0) {
                logger.info("[ARVERSION " + ARManager.getVersion() + "] HB--> initiateAR onProcess - going to wait. TotalSessions : " + totalSessions);
                st = System.currentTimeMillis();
                status = controlAck.await(15L, TimeUnit.SECONDS);
                if (!status && (float)ackReceived.size() / (float)totalSessions * 100.0f > 50.0f) {
                    logger.info("[ARVERSION " + ARManager.getVersion() + "] NSWCP--> Marking WCP pause status as true since 50% connection has been paused");
                    status = true;
                }
                logger.info("[ARVERSION " + ARManager.getVersion() + "] HB--> after await-initiateAR. status=" + status);
            } else {
                status = false;
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "[ARVERSION " + ARManager.getVersion() + "] Exception while initiateAR", e);
            try {
                ARManager.updateStatus(this, 101, "InitiateAR Failed. " + totalSessions + "/" + ackReceived.size() + " Sessions");
            }
            catch (Exception exp) {
                logger.log(Level.FINE, "NS--> Exception while calling updateStatus", exp);
            }
            return;
        }
        finally {
            lock.unlock();
        }
        try {
            if (totalSessions > 0) {
                message = ackReceived.size() + "/" + totalSessions + " Sessions Paused. ";
            }
            if (drainedPools != -1) {
                if (WCPDispatcher.getConnectionPoolCount() > 0) {
                    message = message + drainedPools + "/" + WCPDispatcher.getARConnectionPoolCount() + " Pools Drained. ";
                }
            } else {
                message = message + " Drain Failed. Proceed on Failure";
            }
            if (!CommonUtil.isEmpty((String)this.redirectIP)) {
                message = message + redirectedSessions + " sessions redirected to " + this.redirectIP;
            }
            if (status && (drainedPools == WCPDispatcher.getARConnectionPoolCount() || drainedPools == -1)) {
                ARManager.updateStatus(this, 100, message);
            } else if (!(status || drainedPools != WCPDispatcher.getARConnectionPoolCount() && drainedPools != -1)) {
                if (totalSessions > 0) {
                    ARManager.updateStatus(this, 101, "Pause Failed. " + ackReceived.size() + "/" + totalSessions + " Sessions - Time Exceeded [Control Ack]");
                }
            } else if (status && drainedPools != WCPDispatcher.getARConnectionPoolCount() && drainedPools != -1) {
                ARManager.updateStatus(this, 101, "Drain Failed.");
            } else {
                ARManager.updateStatus(this, 101, "Pause & Drain Failed. " + ackReceived.size() + "/" + totalSessions + " Sessions Paused. " + drainedPools + "/" + WCPDispatcher.getARConnectionPoolCount() + " pools drained");
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "[ARVERSION " + ARManager.getVersion() + "] NS--> Exception while calling updateStatus", e);
        }
        finally {
            logger.info("WCPAR--> status=" + status + " drainedPools=" + drainedPools + " ARConnectionPoolCount=" + WCPDispatcher.getARConnectionPoolCount());
        }
        progress = null;
    }

    private void reset() {
        st = -1L;
        totalSessions = -1;
        progress = new HashMap<String, String>();
        controlSid = new Hashtable();
        ackReceived = new Hashtable();
    }

    @Override
    public void perform() {
        try {
            ARManager.updateStatus(this, 200, "No Operation");
        }
        catch (Exception e) {
            logger.log(Level.FINE, "NS--> Exception while calling updateStatus", e);
        }
    }

    @Override
    public void onComplete(int serverMode) {
    }

    public void onFailure() {
    }

    @Override
    public void abort() {
        try {
            int sessionsCount = -1;
            logger.info("[ARVERSION " + ARManager.getVersion() + "] HB--> aborting WCPAR");
            sessionsCount = WCPDispatcher.abortAR();
            logger.info("[ARVERSION " + ARManager.getVersion() + "] HB--> aborted WCPAR Successfully, TotalSessions=" + sessionsCount);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception while aborting AR", e);
        }
    }

    @Override
    public Map<String, String> getProgress() {
        return progress;
    }

    @Override
    public int getExecutionType() {
        return 2;
    }

    @Override
    public int getModuleId() {
        return 103;
    }

    @Override
    public String getModuleName() {
        return "WCP";
    }

    @Override
    public Hashtable<String, Object> getStatus(int serverMode) {
        return null;
    }

    @Override
    public Hashtable<String, Object> getDetailedStatus(int serverMode) {
        Hashtable<String, Object> wcpInfo = new Hashtable<String, Object>();
        wcpInfo.put("Total Sessions", totalSessions);
        wcpInfo.put("Ack pending Sid's", controlSid.isEmpty() ? "Empty" : controlSid);
        wcpInfo.put("Ack Pending Count", controlSid.size());
        wcpInfo.put("Ack Received Count", ackReceived.size());
        return wcpInfo;
    }

    @Override
    public long getMaximumPrepareTime() {
        return 30000L;
    }

    @Override
    public long getMaximumPerformTime() {
        return 10000L;
    }

    public static void addControlAck(String sid) {
        lock.lock();
        try {
            controlSid.put(sid, System.currentTimeMillis());
        }
        finally {
            lock.unlock();
        }
    }

    public static void removeControlAck(String sid) {
        lock.lock();
        try {
            if (!controlSid.containsKey(sid)) {
                return;
            }
            ackReceived.put(sid, System.currentTimeMillis() - controlSid.remove(sid));
            logger.info("[ARVERSION " + ARManager.getVersion() + "] HB--> controlSidMap sid=" + sid + " size = " + controlSid.size());
            if (controlSid.isEmpty()) {
                logger.info("[ARVERSION " + ARManager.getVersion() + "] HB--> Signals, initiateAR completed, taken-time = " + (System.currentTimeMillis() - st) + " ms");
                controlAck.signal();
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception while removeControlAck. totalSessions=" + totalSessions + " ackReceived=" + ackReceived + " sid=" + sid, e);
        }
        finally {
            lock.unlock();
        }
    }
}

