/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.logging;

import com.adventnet.wms.common.HttpDataWraper;
import com.adventnet.wms.servercommon.components.logging.util.LoggingUtil;
import java.io.Serializable;
import java.util.Hashtable;

public class WmsLog
implements Serializable {
    private long ctime = -1L;
    private Hashtable data = new Hashtable();
    private Hashtable header = new Hashtable();

    public WmsLog() {
        this.ctime = LoggingUtil.getTimeStamp();
    }

    public WmsLog(Hashtable log) {
        this.header = (Hashtable)log.get("header");
        this.data = (Hashtable)log.get("data");
        this.ctime = log.containsKey("ctime") ? (Long)log.get("ctime") : LoggingUtil.getTimeStamp();
    }

    public String toString() {
        return "data=" + HttpDataWraper.getString((Object)this.data) + " ctime=" + this.ctime;
    }

    public Hashtable wrap() {
        Hashtable<String, Serializable> log = new Hashtable<String, Serializable>();
        log.put("header", this.header);
        log.put("data", this.data);
        log.put("ctime", Long.valueOf(this.ctime));
        return log;
    }

    public void setOpr(String value) {
        this.header.put("opr", value);
    }

    public String getOpr() {
        return (String)this.header.get("opr");
    }

    public void putHeader(String key, Object value) {
        this.header.put(key, value);
    }

    public String getHeader(String key) {
        return (String)this.header.get(key);
    }

    public Object getHeaderAsObject(String key) {
        return this.header.get(key);
    }

    public void putData(String key, Object value) {
        this.data.put(key, value);
    }

    public Object getData(String key) {
        return this.data.get(key);
    }

    public String getDataAsString(String key) {
        return (String)this.data.get(key);
    }

    public long getDataAsLong(String key) {
        return new Long(this.getDataAsString(key));
    }

    public long getCreatedTime() {
        return this.ctime;
    }

    public boolean isValidLog() {
        return this.data.containsKey("service") && this.data.containsKey("prd") && this.data.containsKey("category") && this.data.containsKey("entityid");
    }
}

