/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.file;

import java.io.File;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbsFileHandler {
    private static Logger logger = Logger.getLogger(AbsFileHandler.class.getName());
    private static Map<String, String> fileHandlerMap = new Hashtable<String, String>();

    public abstract void handleData(File var1, byte[] var2, boolean var3) throws Exception;

    public static boolean register(String componentName, String fileHandlerClass) {
        if (AbsFileHandler.isRegistered(componentName)) {
            logger.info("VS --> component " + componentName + "is already registered");
            return false;
        }
        fileHandlerMap.put(componentName, fileHandlerClass);
        logger.info("VS --> component " + componentName + "fileHandlerClass - " + fileHandlerClass + "is  registered");
        return true;
    }

    public static boolean isRegistered(String componentName) {
        return fileHandlerMap.containsKey(componentName);
    }

    public static AbsFileHandler getInstance(String componentName) {
        AbsFileHandler fileHandler = null;
        if (!fileHandlerMap.containsKey(componentName)) {
            logger.info("VS --> unregistered component" + componentName);
            return fileHandler;
        }
        try {
            fileHandler = (AbsFileHandler)Class.forName(fileHandlerMap.get(componentName)).newInstance();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "VS_ERR --> Exception in FileHandler for " + componentName, e);
        }
        return fileHandler;
    }

    static {
        AbsFileHandler.register("TES", "com.adventnet.wms.servercommon.components.executor.TESFileHandler");
    }
}

