/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.executor;

import com.adventnet.wms.common.WmsEvent;
import com.adventnet.wms.servercommon.components.constants.ComponentConstants;
import com.adventnet.wms.servercommon.components.executor.TaskEngine;
import com.adventnet.wms.servercommon.components.executor.TaskExecutorService;
import com.adventnet.wms.servercommon.stats.influx.StatsDB;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WMSThreadPoolManager {
    private Logger logger = Logger.getLogger(WMSThreadPoolManager.class.getName());
    private final String tmName;
    private String tesVersion = "";
    private BlockingQueue<WmsEvent> workQueue;
    private ReentrantLock blockingQueueLock = new ReentrantLock();
    private Condition blockingQueueFull = this.blockingQueueLock.newCondition();
    private final ReentrantLock mainLock = new ReentrantLock();
    private final HashSet<Worker> coreWorkers = new LinkedHashSet<Worker>();
    private final HashSet<Worker> nonCoreWorkers = new LinkedHashSet<Worker>();
    private final SortedSet<Integer> freeWorkerIds = new TreeSet<Integer>();
    private int largestPoolSize = 0;
    private int largestActivePoolSize = 0;
    private long maximumActivePoolSize = 0L;
    private AtomicInteger currentPoolSize = new AtomicInteger();
    private AtomicInteger activePoolSize = new AtomicInteger();
    private AtomicLong completedTaskCount = new AtomicLong();
    private HashMap<String, TaskEngine> taskEngineMap;
    private volatile long keepAliveTime;
    private TimeUnit unit;
    private boolean isShutDown = false;
    private volatile int corePoolSize;
    private volatile int maximumPoolSize;
    private String state = "Running";
    private ConcurrentHashMap<String, AtomicLong> currentThreadAllocationMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Long> maxThreadAllocationMap = new ConcurrentHashMap();

    public WMSThreadPoolManager(String tmName, String tesVersion, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit) {
        if (corePoolSize < 0 || maximumPoolSize <= 0 || maximumPoolSize < corePoolSize || keepAliveTime < 0L) {
            throw new IllegalArgumentException();
        }
        this.tmName = tmName;
        this.tesVersion = tesVersion;
        this.corePoolSize = corePoolSize;
        this.maximumPoolSize = maximumPoolSize;
        this.workQueue = new LinkedBlockingQueue<WmsEvent>();
        this.unit = unit;
        this.keepAliveTime = keepAliveTime;
    }

    public void initialize() {
        this.freeWorkerIds.clear();
        for (int i = this.corePoolSize + 1; i <= this.maximumPoolSize; ++i) {
            this.freeWorkerIds.add(i);
        }
        this.isShutDown = false;
        this.logger.info("VS -->  WMSThreadPoolManager initializedName = " + this.tmName + " CorePoolSize = " + this.corePoolSize + " MaxPoolSize = " + this.maximumPoolSize + " KeepAliveTime = " + this.keepAliveTime + " TimeUnit = " + (Object)((Object)this.unit));
    }

    public void add(WmsEvent event) {
        if (event == null) {
            throw new NullPointerException();
        }
        if (this.isShutDown) {
            return;
        }
        try {
            this.blockingQueueLock.lock();
            if (this.currentPoolSize.get() < this.corePoolSize) {
                this.addWorker(true);
            } else if (this.workQueue.size() >= this.maximumPoolSize && this.currentPoolSize.get() < this.maximumPoolSize) {
                this.addWorker(false);
            } else {
                while (this.workQueue.size() > this.maximumPoolSize - 1) {
                    try {
                        this.blockingQueueFull.await();
                    }
                    catch (Exception e) {
                        this.logger.fine("VS_ERR --> Exception while waiting for adding in blockingqueue in " + this.tmName);
                    }
                }
            }
            this.workQueue.add(event);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "VS_ERR --> Exception while adding in blockingqueue in " + this.tmName, e);
        }
        finally {
            this.blockingQueueLock.unlock();
        }
    }

    public int getActivePoolSize() {
        return this.activePoolSize.get();
    }

    public int getCurrentPoolSize() {
        return this.currentPoolSize.get();
    }

    public long getCompletedTaskCount() {
        return this.completedTaskCount.get();
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public long getKeepAliveTime(TimeUnit unit) {
        return unit.convert(this.keepAliveTime, TimeUnit.MILLISECONDS);
    }

    public int getLargestPoolSize() {
        return this.largestPoolSize;
    }

    public int getLargestActivePoolSize() {
        return this.largestActivePoolSize;
    }

    protected void resetLargestPoolSize() {
        this.largestPoolSize = this.currentPoolSize.get();
    }

    protected void resetLargestActivePoolSize() {
        this.largestActivePoolSize = this.activePoolSize.get();
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public ConcurrentHashMap<String, AtomicLong> getCurrentThreadAllotmentDetails() {
        ConcurrentHashMap<String, AtomicLong> threadAllocationMap = this.currentThreadAllocationMap;
        threadAllocationMap.put("currentThreads", new AtomicLong(this.activePoolSize.get()));
        return threadAllocationMap;
    }

    public ConcurrentHashMap<String, Long> getMaxThreadAllotmentDetails() {
        ConcurrentHashMap<String, Long> threadAllocationMap = this.maxThreadAllocationMap;
        threadAllocationMap.put("maxThreads", this.maximumActivePoolSize);
        threadAllocationMap.put("maxActiveThreadsFromBegining", Long.valueOf(this.largestActivePoolSize));
        threadAllocationMap.put("maxThreadsFromBegining", Long.valueOf(this.largestActivePoolSize));
        return threadAllocationMap;
    }

    public Hashtable<String, Object> getShutdownStatus() {
        Hashtable<String, Object> table = new Hashtable<String, Object>();
        table.put("blocking queue size", this.workQueue.size());
        table.put("remaining threads", this.currentPoolSize);
        return table;
    }

    public void resetMaxStats() {
        this.maxThreadAllocationMap = new ConcurrentHashMap();
        this.maximumActivePoolSize = this.activePoolSize.get();
    }

    public int prestartAllCoreThreads() {
        int n = 0;
        while (this.addWorker(true)) {
            ++n;
        }
        return n;
    }

    public String toString() {
        return super.toString() + "[" + this.state + ", pool size = " + this.currentPoolSize.get() + ", active threads = " + this.activePoolSize.get() + ", queued tasks = " + this.workQueue.size() + ", completed tasks = " + this.completedTaskCount.get() + "]";
    }

    public synchronized void setPoolSize(int corePoolSize, int maxPoolSize) {
        if (corePoolSize < 0 || maxPoolSize <= 0 || maxPoolSize < corePoolSize || this.keepAliveTime < 0L) {
            throw new IllegalArgumentException();
        }
        if (maxPoolSize < this.corePoolSize) {
            this.setCorePoolSize(corePoolSize);
            this.setMaximumPoolSize(maxPoolSize);
        } else {
            this.setMaximumPoolSize(maxPoolSize);
            this.setCorePoolSize(corePoolSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setCorePoolSize(int corePoolSize) {
        block8: {
            if (this.isShutDown) {
                return;
            }
            try {
                this.mainLock.lock();
                if (corePoolSize > this.maximumPoolSize || corePoolSize < 0) {
                    throw new IllegalArgumentException();
                }
                int delta = corePoolSize - this.corePoolSize;
                this.corePoolSize = corePoolSize;
                if (delta > 0) {
                    if (this.currentPoolSize.get() <= corePoolSize) break block8;
                    Iterator<Worker> iterator = this.nonCoreWorkers.iterator();
                    while (iterator.hasNext()) {
                        Worker worker = iterator.next();
                        worker.setasCore();
                        this.coreWorkers.add(worker);
                        iterator.remove();
                        if (--delta != 0) continue;
                        break block8;
                    }
                    break block8;
                }
                if (delta >= 0) break block8;
                Iterator<Worker> iterator = this.coreWorkers.iterator();
                while (iterator.hasNext()) {
                    Worker worker = iterator.next();
                    worker.removeAsCore();
                    worker.interrupt();
                    iterator.remove();
                    this.nonCoreWorkers.add(worker);
                    if (++delta != 0) continue;
                    break;
                }
            }
            finally {
                this.mainLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setMaximumPoolSize(int maximumPoolSize) {
        if (this.isShutDown) {
            return;
        }
        int delta = 0;
        try {
            this.mainLock.lock();
            if (this.corePoolSize > maximumPoolSize || maximumPoolSize < 1) {
                throw new IllegalArgumentException();
            }
            delta = maximumPoolSize - this.maximumPoolSize;
            if (delta < 0) {
                if (this.currentPoolSize.get() > maximumPoolSize) {
                    for (Worker worker : this.nonCoreWorkers) {
                        worker.shutdown();
                        worker.interrupt();
                        if (++delta != 0) continue;
                        break;
                    }
                }
            } else if (delta != 0) {
                for (int i = 1; i <= delta; ++i) {
                    this.freeWorkerIds.add(i + this.maximumPoolSize);
                }
            }
            this.maximumPoolSize = maximumPoolSize;
        }
        finally {
            this.mainLock.unlock();
        }
        for (int i = 0; i < delta; ++i) {
            this.addWorker(false);
        }
    }

    public void setKeepAliveTime(long time, TimeUnit unit) {
        if (this.isShutDown) {
            return;
        }
        this.keepAliveTime = unit.toMillis(time);
    }

    public void setTaskEngineMap(HashMap<String, TaskEngine> taskEngineMap) {
        this.taskEngineMap = taskEngineMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutdown() {
        if (this.isShutDown) {
            return false;
        }
        try {
            long count = 0L;
            long maxLimit = 400L;
            while (count++ < maxLimit && !this.workQueue.isEmpty()) {
                if (count % 100L == 0L) {
                    this.logger.info("VS --> WMSThreadPoolManager - " + this.tmName + " blocking queue size = " + this.workQueue.size());
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    this.logger.fine("VS_ERR --> InterruptedException while ShuttingDown " + this.tmName);
                }
            }
            TaskExecutorService.updateShutdownStatus(this.tmName, 25);
            this.mainLock.lock();
            this.state = "Shutting down";
            for (Worker worker : this.coreWorkers) {
                worker.shutdown();
                worker.interrupt();
            }
            for (Worker worker : this.nonCoreWorkers) {
                worker.shutdown();
                worker.interrupt();
            }
            maxLimit -= count;
            count = 0L;
            maxLimit += 800L;
            while (count++ < maxLimit) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    this.logger.fine("VS_ERR --> InterruptedException while ShuttingDown " + this.tmName);
                }
                if (this.activePoolSize.get() == 0) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        this.logger.fine("VS_ERR --> InterruptedException while ShuttingDown " + this.tmName);
                    }
                    if (this.activePoolSize.get() == 0) break;
                }
                if (count % 100L != 0L) continue;
                this.logger.info("VS --> WMSThreadPoolManager - " + this.tmName + " pending threads = " + this.activePoolSize.get());
            }
            this.state = "Terminated";
        }
        finally {
            this.mainLock.unlock();
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public boolean drain() {
        if (this.isShutDown) {
            return false;
        }
        this.state = "Draining";
        while (!this.workQueue.isEmpty()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                this.logger.fine("VS_ERR --> InterruptedException while ShuttingDown " + this.tmName);
            }
        }
        try {
            this.mainLock.lock();
            for (Worker worker : this.coreWorkers) {
                worker.shutdown();
                worker.interrupt();
            }
            for (Worker worker : this.nonCoreWorkers) {
                worker.shutdown();
                worker.interrupt();
            }
            do lbl-1000:
            // 3 sources

            {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    this.logger.fine("VS_ERR --> InterruptedException while ShuttingDown " + this.tmName);
                }
                if (this.activePoolSize.get() != 0) ** GOTO lbl-1000
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    this.logger.fine("VS_ERR --> InterruptedException while ShuttingDown " + this.tmName);
                }
            } while (this.activePoolSize.get() != 0);
            this.state = "Terminated";
        }
        finally {
            this.mainLock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean addWorker(boolean isCore) {
        if (this.currentPoolSize.get() >= (isCore ? this.corePoolSize : this.maximumPoolSize)) {
            return false;
        }
        if (!isCore && this.freeWorkerIds.isEmpty()) {
            return false;
        }
        int count = 0;
        try {
            this.mainLock.lock();
            count = this.currentPoolSize.incrementAndGet();
            if (!isCore) {
                count = (Integer)this.freeWorkerIds.iterator().next();
            }
            Worker worker = new Worker(isCore, this.keepAliveTime, this.workQueue, this.taskEngineMap, "TES/" + this.tesVersion + "-" + this.tmName + "-" + count, count);
            worker.start();
            if (isCore) {
                this.coreWorkers.add(worker);
            } else {
                this.nonCoreWorkers.add(worker);
            }
            this.freeWorkerIds.remove(count);
        }
        finally {
            this.mainLock.unlock();
        }
        if (this.currentPoolSize.get() > this.largestPoolSize) {
            this.largestPoolSize = count;
        }
        return true;
    }

    class Worker
    extends Thread {
        private int threadIndex;
        private boolean isCore;
        private BlockingQueue<WmsEvent> workQueue;
        private boolean isThreadAlive = true;
        private String opr = "";
        HashMap<String, TaskEngine> taskEngineMap;

        public Worker(boolean isCore, long keepAliveTime, BlockingQueue<WmsEvent> workQueue, HashMap<String, TaskEngine> taskEngineMap, String threadName, int index) {
            this.isCore = isCore;
            this.workQueue = workQueue;
            this.setName(threadName);
            this.threadIndex = index;
            this.taskEngineMap = taskEngineMap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.isThreadAlive) {
                try {
                    WmsEvent event = null;
                    if (this.isCore) {
                        try {
                            event = this.workQueue.take();
                        }
                        catch (InterruptedException e) {
                            WMSThreadPoolManager.this.logger.fine("VS_ERR --> Exception while getting element from blocking Queue ");
                        }
                    } else {
                        try {
                            event = this.workQueue.poll(WMSThreadPoolManager.this.keepAliveTime, WMSThreadPoolManager.this.unit);
                        }
                        catch (InterruptedException e) {
                            WMSThreadPoolManager.this.logger.fine("VS_ERR --> Exception while getting element from blocking Queue ");
                        }
                    }
                    if (event != null) {
                        try {
                            WMSThreadPoolManager.this.blockingQueueLock.lock();
                            WMSThreadPoolManager.this.blockingQueueFull.signal();
                        }
                        finally {
                            WMSThreadPoolManager.this.blockingQueueLock.unlock();
                        }
                        if (WMSThreadPoolManager.this.activePoolSize.incrementAndGet() > WMSThreadPoolManager.this.largestActivePoolSize) {
                            WMSThreadPoolManager.this.largestActivePoolSize = WMSThreadPoolManager.this.activePoolSize.get();
                        }
                        if ((long)WMSThreadPoolManager.this.activePoolSize.get() > WMSThreadPoolManager.this.maximumActivePoolSize) {
                            WMSThreadPoolManager.this.maximumActivePoolSize = WMSThreadPoolManager.this.activePoolSize.get();
                        }
                        this.opr = event.getOpr();
                        String engineName = this.opr.split("\\.")[0];
                        this.incrementThreadCount(engineName);
                        try {
                            this.taskEngineMap.get(engineName).process(event);
                        }
                        catch (Error e) {
                            WMSThreadPoolManager.this.activePoolSize.decrementAndGet();
                            StatsDB.recordError(ComponentConstants.TES.getModuleCode(), ComponentConstants.TES.TE_HANDLE_ERR.getErrorCode(), 1L);
                            WMSThreadPoolManager.this.logger.log(Level.SEVERE, "VS_ERR --> TE_HANDLE_ERR Error while processing in WMSThreadPoolManager in " + WMSThreadPoolManager.this.tmName + " for event opr " + event.getOpr(), e);
                            try {
                                WMSThreadPoolManager.this.mainLock.lock();
                                if (this.isCore) {
                                    WMSThreadPoolManager.this.coreWorkers.remove(this);
                                } else {
                                    WMSThreadPoolManager.this.nonCoreWorkers.remove(this);
                                }
                            }
                            finally {
                                WMSThreadPoolManager.this.mainLock.unlock();
                            }
                            if (WMSThreadPoolManager.this.coreWorkers.isEmpty() && WMSThreadPoolManager.this.nonCoreWorkers.isEmpty() && WMSThreadPoolManager.this.currentPoolSize.get() == WMSThreadPoolManager.this.maximumPoolSize) {
                                WMSThreadPoolManager.this.state = "Terminated due to Error";
                                WMSThreadPoolManager.this.isShutDown = true;
                            }
                            this.decrementThreadCount(engineName);
                            throw e;
                        }
                        this.decrementThreadCount(engineName);
                        WMSThreadPoolManager.this.activePoolSize.decrementAndGet();
                        continue;
                    }
                    try {
                        WMSThreadPoolManager.this.mainLock.lock();
                        if (this.isCore) continue;
                        this.isThreadAlive = false;
                        WMSThreadPoolManager.this.nonCoreWorkers.remove(this);
                        if (this.threadIndex > WMSThreadPoolManager.this.maximumPoolSize || this.threadIndex < WMSThreadPoolManager.this.corePoolSize) continue;
                        WMSThreadPoolManager.this.freeWorkerIds.add(this.threadIndex);
                    }
                    finally {
                        WMSThreadPoolManager.this.mainLock.unlock();
                    }
                }
                catch (Exception e) {
                    WMSThreadPoolManager.this.logger.log(Level.SEVERE, "VS_ERR --> Exception in worker threads in WMSThreadPoolManager", e);
                }
            }
            try {
                WMSThreadPoolManager.this.mainLock.lock();
                if (this.isCore) {
                    WMSThreadPoolManager.this.coreWorkers.remove(this);
                } else {
                    WMSThreadPoolManager.this.nonCoreWorkers.remove(this);
                }
                WMSThreadPoolManager.this.currentPoolSize.decrementAndGet();
            }
            finally {
                WMSThreadPoolManager.this.mainLock.unlock();
            }
        }

        private void incrementThreadCount(String engineName) {
            try {
                if (WMSThreadPoolManager.this.currentThreadAllocationMap.containsKey(engineName)) {
                    long counter = ((AtomicLong)WMSThreadPoolManager.this.currentThreadAllocationMap.get(engineName)).incrementAndGet();
                    if (WMSThreadPoolManager.this.maxThreadAllocationMap.containsKey(engineName)) {
                        if (counter > (Long)WMSThreadPoolManager.this.maxThreadAllocationMap.get(engineName)) {
                            WMSThreadPoolManager.this.maxThreadAllocationMap.put(engineName, counter);
                        }
                    } else {
                        WMSThreadPoolManager.this.maxThreadAllocationMap.put(engineName, counter);
                    }
                } else {
                    WMSThreadPoolManager.this.currentThreadAllocationMap.put(engineName, new AtomicLong(1L));
                    WMSThreadPoolManager.this.maxThreadAllocationMap.put(engineName, 1L);
                }
            }
            catch (Exception e) {
                WMSThreadPoolManager.this.logger.log(Level.FINE, "VS_ERR --> Exception while incrementing thread count in queueThreadCountMap", e);
            }
        }

        private void decrementThreadCount(String engineName) {
            try {
                if (((AtomicLong)WMSThreadPoolManager.this.currentThreadAllocationMap.get(engineName)).get() > 0L) {
                    ((AtomicLong)WMSThreadPoolManager.this.currentThreadAllocationMap.get(engineName)).decrementAndGet();
                }
            }
            catch (Exception e) {
                WMSThreadPoolManager.this.logger.log(Level.FINE, "VS_ERR --> Exception while decrementing thread count in queueThreadCountMap", e);
            }
        }

        void shutdown() {
            this.isThreadAlive = false;
        }

        void setasCore() {
            this.isCore = true;
        }

        void removeAsCore() {
            this.isCore = false;
        }
    }
}

