/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.executor;

import com.adventnet.wms.servercommon.components.executor.WMSThreadPoolExecutor;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class WMSThreadPoolExecutorInventory {
    private static ConcurrentHashMap<String, WMSThreadPoolExecutor> executorMap = new ConcurrentHashMap();

    protected static boolean register(String name, WMSThreadPoolExecutor executor) {
        if (!executorMap.containsKey(name)) {
            executorMap.put(name, executor);
            return true;
        }
        return false;
    }

    public static boolean setPoolSize(String name, int corePoolSize, int maxPoolSize) {
        if (executorMap.containsKey(name)) {
            executorMap.get(name).setPoolSize(corePoolSize, maxPoolSize);
            return true;
        }
        return false;
    }

    public static boolean setCorePoolSize(String name, int corePoolSize) {
        if (executorMap.containsKey(name)) {
            executorMap.get(name).setCorePoolSize(corePoolSize);
            return true;
        }
        return false;
    }

    public static boolean setMaximumPoolSize(String name, int maxPoolSize) {
        if (executorMap.containsKey(name)) {
            executorMap.get(name).setMaximumPoolSize(maxPoolSize);
            return true;
        }
        return false;
    }

    public static boolean setKeepAliveTime(String name, long time, TimeUnit unit) {
        if (executorMap.containsKey(name)) {
            executorMap.get(name).setKeepAliveTime(time, unit);
            return true;
        }
        return false;
    }

    public static Hashtable<String, String> getStats(String name) {
        Hashtable<String, String> table = new Hashtable<String, String>();
        WMSThreadPoolExecutor executor = executorMap.get(name);
        if (executor != null) {
            int activePoolSize = executor.getActivePoolSize();
            int currentPoolSize = executor.getCurrentPoolSize();
            table.put("CorePoolSize", Integer.toString(executor.getCorePoolSize()));
            table.put("MaxPoolSize", Integer.toString(executor.getMaximumPoolSize()));
            table.put("KeepAliveTime", Long.toString(executor.getKeepAliveTime(TimeUnit.MILLISECONDS)) + " ms");
            table.put("CompletedTaskCount", Long.toString(executor.getCompletedTaskCount()));
            table.put("ActivePoolSize", Integer.toString(activePoolSize));
            table.put("LargestPoolSize", Integer.toString(executor.getLargestPoolSize()));
            table.put("LargestActivePoolSize", Integer.toString(executor.getLargestActivePoolSize()));
            table.put("CurrentPoolSize", Integer.toString(currentPoolSize));
            table.put("WaitingThreadSize", Integer.toString(currentPoolSize - activePoolSize));
            table.put("BufferedQueueSize", Integer.toString(executor.getQueue().size()));
        }
        return table;
    }

    public static Hashtable<String, Hashtable<String, String>> getThreadStats() {
        Hashtable<String, Hashtable<String, String>> threadDetails = new Hashtable<String, Hashtable<String, String>>();
        for (Map.Entry<String, WMSThreadPoolExecutor> entry : executorMap.entrySet()) {
            Hashtable<String, String> table = new Hashtable<String, String>();
            WMSThreadPoolExecutor executor = entry.getValue();
            table.put("CorePoolSize", Integer.toString(executor.getCorePoolSize()));
            table.put("MaxPoolSize", Integer.toString(executor.getMaximumPoolSize()));
            table.put("LargestPoolSize", Integer.toString(executor.getLargestPoolSize()));
            table.put("LargestActivePoolSize", Integer.toString(executor.getLargestActivePoolSize()));
            threadDetails.put(entry.getKey(), table);
            executor.resetLargestActivePoolSize();
            executor.resetLargestPoolSize();
        }
        return threadDetails;
    }

    public static Hashtable<String, String> getBQStats() {
        Hashtable<String, String> bqDetails = new Hashtable<String, String>();
        for (Map.Entry<String, WMSThreadPoolExecutor> entry : executorMap.entrySet()) {
            int size = entry.getValue().getQueue().size();
            if (size <= 0) continue;
            bqDetails.put(entry.getKey(), Integer.toString(size));
        }
        return bqDetails;
    }
}

