/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.executor;

import com.adventnet.wms.common.WmsEvent;
import com.adventnet.wms.servercommon.components.constants.ComponentConstants;
import com.adventnet.wms.servercommon.components.executor.TaskEngine;
import com.adventnet.wms.servercommon.components.executor.TaskExecutorService;
import com.adventnet.wms.servercommon.components.executor.TaskQueueGroup;
import com.adventnet.wms.servercommon.components.executor.WMSThreadPoolManager;
import com.adventnet.wms.servercommon.stats.influx.StatsDB;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WMSQueueScheduler {
    private Logger logger = Logger.getLogger(WMSQueueScheduler.class.getName());
    private List<TaskQueueGroup> queueGroupList = new ArrayList<TaskQueueGroup>();
    private String tmName;
    private String tesVersion = "";
    private boolean isInitialized = false;
    private boolean isAREnabled = false;
    private volatile long keepAliveTime;
    private TimeUnit unit;
    private WMSThreadPoolManager wmsThreadPoolManager;
    private FairPolicyAllocater fairPolicyAllocater;
    private QueueOrganiser queueOrganiser = new QueueOrganiser();

    public WMSQueueScheduler(String tmName, String tesVersion, long keepAliveTime, TimeUnit unit) {
        this.unit = unit;
        this.tmName = tmName;
        this.tesVersion = tesVersion;
        this.keepAliveTime = unit.toMillis(keepAliveTime);
    }

    public void intialize(int corePoolSize, int maxPoolSize) {
        if (!this.isInitialized) {
            this.wmsThreadPoolManager = new WMSThreadPoolManager(this.tmName, this.tesVersion, corePoolSize, maxPoolSize, this.keepAliveTime, this.unit);
            this.wmsThreadPoolManager.initialize();
            this.fairPolicyAllocater = new FairPolicyAllocater(this.queueOrganiser, this.wmsThreadPoolManager);
            this.isInitialized = true;
            this.logger.info("TES --> Name = " + this.tmName + " new WMSQueueScheduler is initialized maxPoolSize = " + maxPoolSize);
        } else {
            this.logger.info("TES --> WMSQueueScheduler is already initialized");
        }
    }

    public boolean startFairPolicyAllocator() {
        if (this.fairPolicyAllocater != null) {
            this.fairPolicyAllocater.start();
            return true;
        }
        return false;
    }

    public boolean prepare(TaskQueueGroup queueGroup) {
        if (!this.isInitialized) {
            return this.queueOrganiser.prepare(queueGroup);
        }
        return false;
    }

    public void add(TaskQueueGroup queueGroup) {
        this.queueGroupList.add(queueGroup);
    }

    public void addQueue(TaskQueueGroup queueGroup) {
        this.queueOrganiser.addQueue(queueGroup);
    }

    public void setCorePoolSize(int corePoolSize) {
        this.wmsThreadPoolManager.setCorePoolSize(corePoolSize);
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.wmsThreadPoolManager.setMaximumPoolSize(maxPoolSize);
    }

    public void setPoolSize(int corePoolSize, int maxPoolSize) {
        this.wmsThreadPoolManager.setPoolSize(corePoolSize, maxPoolSize);
    }

    public void setTaskEngineMap(HashMap<String, TaskEngine> taskEngineMap) {
        this.wmsThreadPoolManager.setTaskEngineMap(taskEngineMap);
    }

    public ConcurrentHashMap<String, Long> resetAndGetMaxThreadAllotmentDetails() {
        ConcurrentHashMap<String, Long> map = this.wmsThreadPoolManager.getMaxThreadAllotmentDetails();
        this.wmsThreadPoolManager.resetMaxStats();
        return map;
    }

    public ConcurrentHashMap<String, Long> getMaxThreadAllotmentDetails() {
        return this.wmsThreadPoolManager.getMaxThreadAllotmentDetails();
    }

    public ConcurrentHashMap<String, AtomicLong> getCurrentThreadAllotmentDetails() {
        return this.wmsThreadPoolManager.getCurrentThreadAllotmentDetails();
    }

    public int getCurrentThreadCount() {
        return this.wmsThreadPoolManager.getCurrentPoolSize();
    }

    public int getActiveThreadCount() {
        return this.wmsThreadPoolManager.getActivePoolSize();
    }

    public void shutdown() {
        this.queueOrganiser.shutdown();
    }

    public Hashtable<String, Object> getShutdownStatus() {
        return this.wmsThreadPoolManager.getShutdownStatus();
    }

    class FairPolicyAllocater
    extends Thread {
        private QueueOrganiser queueOrganiser;
        private boolean process = true;
        private WMSThreadPoolManager wmsThreadPoolManager;

        public FairPolicyAllocater(QueueOrganiser queueOrganiser, WMSThreadPoolManager wmsThreadPoolManager) {
            this.queueOrganiser = queueOrganiser;
            this.wmsThreadPoolManager = wmsThreadPoolManager;
            this.setName("TES/" + WMSQueueScheduler.this.tesVersion + "-" + WMSQueueScheduler.this.tmName + "-FairPolicyAllocater");
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            WMSQueueScheduler.this.logger.info("TES --> FairPolicyAllocater started for " + WMSQueueScheduler.this.tmName);
            try {
                while (this.process) {
                    try {
                        WmsEvent event;
                        TaskQueueGroup queueGroup = this.queueOrganiser.getqueueGroup();
                        if (queueGroup == null || (event = queueGroup.getEvent()) == null) continue;
                        this.wmsThreadPoolManager.add(event);
                    }
                    catch (Exception e) {
                        WMSQueueScheduler.this.logger.log(Level.SEVERE, "TES_ERR --> WMS_QUEUE_SCHEDULER_EXCEPTION Exception in FairPolicyAllocater for " + WMSQueueScheduler.this.tmName, e);
                        StatsDB.recordError(ComponentConstants.TES.getModuleCode(), ComponentConstants.TES.WMS_QUEUE_SCHEDULER_EXCEPTION.getErrorCode(), 1L);
                    }
                }
                TaskExecutorService.updateShutdownStatus(WMSQueueScheduler.this.tmName, 5);
                Iterator e = WMSQueueScheduler.this.queueGroupList.iterator();
                while (true) {
                    if (!e.hasNext()) {
                        TaskExecutorService.updateShutdownStatus(WMSQueueScheduler.this.tmName, 15);
                        this.wmsThreadPoolManager.shutdown();
                        WMSQueueScheduler.this.logger.info("TES --> TES_SD FairPolicyAllocater stopped while shutting down in " + WMSQueueScheduler.this.tmName);
                        TaskExecutorService.shutdownCompleted(WMSQueueScheduler.this.tesVersion, WMSQueueScheduler.this.tmName);
                        return;
                    }
                    TaskQueueGroup queueGroup = (TaskQueueGroup)e.next();
                    WmsEvent event = queueGroup.shutDown();
                    if (event == null) continue;
                    this.wmsThreadPoolManager.add(event);
                }
            }
            catch (Error e) {
                WMSQueueScheduler.this.logger.log(Level.SEVERE, "TES_ERR --> WMS_QUEUE_SCHEDULER_ERROR Error while processing in FairPolicyAllocater in " + WMSQueueScheduler.this.tmName, e);
                StatsDB.recordError(ComponentConstants.TES.getModuleCode(), ComponentConstants.TES.WMS_QUEUE_SCHEDULER_ERROR.getErrorCode(), 1L);
                throw e;
            }
        }

        public void shutdown() {
            this.process = false;
        }
    }

    class QueueOrganiser {
        private List<TaskQueueGroup> currentProcessingList = new ArrayList<TaskQueueGroup>();
        private Map<TaskQueueGroup, Integer> currentProcessingMap = new LinkedHashMap<TaskQueueGroup, Integer>();
        private ReentrantLock listLock = new ReentrantLock();
        private Condition listEmpty = this.listLock.newCondition();
        private int tail = 0;
        private int currentSize = 0;

        QueueOrganiser() {
        }

        public boolean prepare(TaskQueueGroup queueGroup) {
            if (WMSQueueScheduler.this.isInitialized || queueGroup.isEmpty()) {
                return false;
            }
            try {
                this.listLock.lock();
                if (!this.currentProcessingMap.containsKey(queueGroup)) {
                    this.currentProcessingList.add(queueGroup);
                    this.currentProcessingMap.put(queueGroup, 0);
                    ++this.currentSize;
                }
                this.listEmpty.signal();
            }
            catch (Exception e) {
                WMSQueueScheduler.this.logger.log(Level.SEVERE, "TES_ERR --> WMS_QUEUE_SCHEDULER_EXCEPTION Exception in preparing in " + WMSQueueScheduler.this.tmName + " for queue " + queueGroup.getName(), e);
                StatsDB.recordError(ComponentConstants.TES.getModuleCode(), ComponentConstants.TES.WMS_QUEUE_SCHEDULER_EXCEPTION.getErrorCode(), 1L);
            }
            finally {
                this.listLock.unlock();
            }
            return true;
        }

        public void addQueue(TaskQueueGroup queueGroup) {
            try {
                this.listLock.lock();
                if (!this.currentProcessingMap.containsKey(queueGroup)) {
                    this.currentProcessingList.add(queueGroup);
                    this.currentProcessingMap.put(queueGroup, 0);
                    ++this.currentSize;
                }
                this.listEmpty.signal();
            }
            catch (Exception e) {
                WMSQueueScheduler.this.logger.log(Level.SEVERE, "TES_ERR --> WMS_QUEUE_SCHEDULER_EXCEPTION Exception in adding in " + WMSQueueScheduler.this.tmName + " for queue " + queueGroup.getName(), e);
                StatsDB.recordError(ComponentConstants.TES.getModuleCode(), ComponentConstants.TES.WMS_QUEUE_SCHEDULER_EXCEPTION.getErrorCode(), 1L);
            }
            finally {
                this.listLock.unlock();
            }
        }

        public TaskQueueGroup getqueueGroup() {
            TaskQueueGroup queueGroup = null;
            try {
                this.listLock.lock();
                while (this.currentProcessingList.isEmpty() && !WMSQueueScheduler.this.isAREnabled) {
                    try {
                        this.listEmpty.await();
                    }
                    catch (InterruptedException e) {
                        WMSQueueScheduler.this.logger.fine("TES_ERR -->  Exception while waiting when list is empty for " + WMSQueueScheduler.this.tmName);
                    }
                }
                if (!WMSQueueScheduler.this.isAREnabled) {
                    if ((queueGroup = this.currentProcessingList.get(this.tail++)).isEmpty()) {
                        this.currentProcessingList.remove(queueGroup);
                        this.currentProcessingMap.remove(queueGroup);
                        --this.currentSize;
                        --this.tail;
                    }
                    if (this.tail == this.currentSize) {
                        this.tail = 0;
                    }
                }
            }
            catch (Exception e) {
                WMSQueueScheduler.this.logger.log(Level.SEVERE, "TES_ERR --> WMS_QUEUE_SCHEDULER_EXCEPTION Exception while getting queue currentsize = " + this.currentSize + " tail = " + this.tail + "list size = " + this.currentProcessingList.size(), e);
                StatsDB.recordError(ComponentConstants.TES.getModuleCode(), ComponentConstants.TES.WMS_QUEUE_SCHEDULER_EXCEPTION.getErrorCode(), 1L);
            }
            finally {
                this.listLock.unlock();
            }
            return queueGroup;
        }

        public void shutdown() {
            WMSQueueScheduler.this.fairPolicyAllocater.shutdown();
            WMSQueueScheduler.this.isAREnabled = true;
            try {
                this.listLock.lock();
                this.listEmpty.signal();
            }
            catch (Exception e) {
                WMSQueueScheduler.this.logger.log(Level.SEVERE, "TES_ERR --> Exception while shuttingdown QueueScheduler currentsize = " + this.currentSize + " tail = " + this.tail + "list size = " + this.currentProcessingList.size(), e);
            }
            finally {
                this.listLock.unlock();
            }
        }
    }
}

