/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.executor;

import com.adventnet.wms.common.WmsEvent;
import com.adventnet.wms.servercommon.components.constants.ComponentConstants;
import com.adventnet.wms.servercommon.components.executor.TaskQueue;
import com.adventnet.wms.servercommon.stats.influx.StatsDB;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TaskQueueGroup {
    private Logger logger = Logger.getLogger(TaskQueueGroup.class.getName());
    private boolean isQueueEventAllocaterAlive = true;
    private String teName;
    private String tmName;
    private String tesVersion = "";
    int mediumpriorityratio = 0;
    int highpriorityratio = 0;
    int lowpriorityratio = 0;
    private Map<TaskQueue, Integer> queueMap = new HashMap<TaskQueue, Integer>();
    private TaskQueue mpqueue;
    private TaskQueue hpqueue;
    private TaskQueue lpqueue;
    private ReentrantLock queueLock = new ReentrantLock();
    private Condition queueEmpty = this.queueLock.newCondition();
    private Condition nextEventPresent = this.queueLock.newCondition();
    private QueueEventAllocater queueEventAllocater;
    private WmsEvent nextEvent = null;

    public TaskQueueGroup(String tmName, String teName, String tesVersion, int mediumprioritythreads, int highprioritythreads, int lowprioritythreads, int bufSize, boolean isAREnabled) {
        this.teName = teName;
        this.tmName = tmName;
        this.tesVersion = tesVersion;
        int totalThreads = mediumprioritythreads + highprioritythreads + lowprioritythreads;
        this.mediumpriorityratio = mediumprioritythreads > 0 ? (int)Math.ceil(totalThreads / mediumprioritythreads) : 1;
        if (highprioritythreads > 0) {
            this.highpriorityratio = (int)Math.ceil(totalThreads / highprioritythreads);
        }
        if (lowprioritythreads > 0) {
            this.lowpriorityratio = (int)Math.ceil(totalThreads / lowprioritythreads);
        }
        this.mpqueue = new TaskQueue(this.tmName, teName + "-mpqueue", bufSize, isAREnabled);
        if (!this.mpqueue.isEmpty()) {
            this.queueMap.put(this.mpqueue, 0);
        }
        if (highprioritythreads != 0) {
            this.hpqueue = new TaskQueue(tmName, teName + "-hpqueue", bufSize, isAREnabled);
            if (!this.hpqueue.isEmpty()) {
                this.queueMap.put(this.hpqueue, 0);
            }
        }
        if (lowprioritythreads != 0) {
            this.lpqueue = new TaskQueue(tmName, teName + "-lpqueue", bufSize, isAREnabled);
            if (!this.lpqueue.isEmpty()) {
                this.queueMap.put(this.lpqueue, 0);
            }
        }
        this.queueEventAllocater = new QueueEventAllocater();
        this.queueEventAllocater.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(WmsEvent event) {
        TaskQueue queue;
        if (event.getTaskPriority() == 1 && this.hpqueue != null) {
            this.hpqueue.add(event);
            queue = this.hpqueue;
        } else if (event.getTaskPriority() == -1 && this.lpqueue != null) {
            this.lpqueue.add(event);
            queue = this.lpqueue;
        } else {
            this.mpqueue.add(event);
            queue = this.mpqueue;
        }
        try {
            this.queueLock.lock();
            this.queueMap.put(queue, 0);
            this.queueEmpty.signal();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "VS_ERR --> Exception in TaskQueueGroup at add for " + this.teName + " tmName=" + this.tmName, e);
        }
        finally {
            this.queueLock.unlock();
        }
    }

    public WmsEvent getEvent() {
        WmsEvent event = null;
        try {
            this.queueLock.lock();
            event = this.nextEvent;
            this.nextEvent = null;
            this.nextEventPresent.signal();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "VS_ERR --> Exception in TaskQueueGroup at getEvent for " + this.teName + " tmName=" + this.tmName, e);
        }
        finally {
            this.queueLock.unlock();
        }
        return event;
    }

    public int size() {
        int size = 0;
        if (this.lpqueue != null) {
            size += this.lpqueue.size();
        }
        if (this.mpqueue != null) {
            size += this.mpqueue.size();
        }
        if (this.hpqueue != null) {
            size += this.hpqueue.size();
        }
        return size;
    }

    public boolean isEmpty() {
        boolean isEmpty = false;
        try {
            this.queueLock.lock();
            isEmpty = this.queueMap.isEmpty();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "VS_ERR --> Exception in TaskQueueGroup at isEmpty for " + this.teName + " tmName=" + this.tmName, e);
        }
        finally {
            this.queueLock.unlock();
        }
        return isEmpty;
    }

    public String drain(String queueID, int drainCount) {
        if (queueID.equals("mp")) {
            if (this.mpqueue != null) {
                return this.mpqueue.drop(drainCount);
            }
        } else if (queueID.equals("hp")) {
            if (this.hpqueue != null) {
                return this.hpqueue.drop(drainCount);
            }
        } else if (queueID.equals("lp")) {
            if (this.lpqueue != null) {
                return this.lpqueue.drop(drainCount);
            }
        } else if (queueID.equals("all")) {
            if (this.mpqueue != null) {
                return this.mpqueue.drop(drainCount);
            }
            if (this.hpqueue != null) {
                return this.hpqueue.drop(drainCount);
            }
            if (this.lpqueue != null) {
                return this.lpqueue.drop(drainCount);
            }
        }
        return "invalid queue id";
    }

    public void close() {
        if (this.lpqueue != null) {
            this.lpqueue.close();
        }
        if (this.mpqueue != null) {
            this.mpqueue.close();
        }
        if (this.hpqueue != null) {
            this.hpqueue.close();
        }
    }

    public void open() {
        if (this.lpqueue != null) {
            this.lpqueue.open();
        }
        if (this.mpqueue != null) {
            this.mpqueue.open();
        }
        if (this.hpqueue != null) {
            this.hpqueue.open();
        }
    }

    public Hashtable<String, String> getStats() {
        Hashtable<String, String> stats = this.mpqueue.getStats();
        int in = Integer.parseInt(stats.get("in"));
        int out = Integer.parseInt(stats.get("out"));
        int size = Integer.parseInt(stats.get("size"));
        if (this.hpqueue != null) {
            stats = this.hpqueue.getStats();
            in += Integer.parseInt(stats.get("in"));
            out += Integer.parseInt(stats.get("out"));
            size += Integer.parseInt(stats.get("size"));
        }
        if (this.lpqueue != null) {
            stats = this.lpqueue.getStats();
            in += Integer.parseInt(stats.get("in"));
            out += Integer.parseInt(stats.get("out"));
            size += Integer.parseInt(stats.get("size"));
        }
        Hashtable<String, String> returnhash = new Hashtable<String, String>();
        returnhash.put("in", "" + in);
        returnhash.put("out", "" + out);
        returnhash.put("size", "" + size);
        return returnhash;
    }

    public void clearStats() {
        if (this.lpqueue != null) {
            this.lpqueue.clearStats();
        }
        if (this.mpqueue != null) {
            this.mpqueue.clearStats();
        }
        if (this.hpqueue != null) {
            this.hpqueue.clearStats();
        }
    }

    public WmsEvent shutDown() {
        this.queueEventAllocater.shutDown();
        this.queueEventAllocater.interrupt();
        return this.nextEvent;
    }

    public ArrayList<Hashtable<String, String>> getWmsQStats() {
        ArrayList<Hashtable<String, String>> qstats = new ArrayList<Hashtable<String, String>>();
        if (this.mpqueue != null) {
            qstats.add(this.mpqueue.getWmsQStats());
        }
        if (this.hpqueue != null) {
            qstats.add(this.hpqueue.getWmsQStats());
        }
        if (this.lpqueue != null) {
            qstats.add(this.lpqueue.getWmsQStats());
        }
        return qstats;
    }

    public void handleQueue(TaskQueue queue, int count) {
        block7: {
            try {
                if (!this.queueMap.containsKey(queue)) break block7;
                for (int i = 0; i < count && this.isQueueEventAllocaterAlive; ++i) {
                    if (this.nextEvent != null) {
                        try {
                            this.nextEventPresent.await();
                        }
                        catch (Exception e) {
                            this.logger.fine("VS_ERR --> Exception in TaskQueueGroup in handleQueue for " + this.teName);
                        }
                    }
                    if (queue.isEmpty()) {
                        this.queueMap.remove(queue);
                        break;
                    }
                    this.nextEvent = queue.remove();
                }
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "TES_ERR --> TASKQUEUEGROUP_EXCEPTION Exception in handleQueue for " + queue.getname() + " tmName=" + this.tmName, e);
                StatsDB.recordError(ComponentConstants.TES.getModuleCode(), ComponentConstants.TES.TASKQUEUEGROUP_EXCEPTION.getErrorCode(), 1L);
            }
        }
    }

    public String getTMName() {
        return this.tmName;
    }

    public String getName() {
        return this.teName;
    }

    class QueueEventAllocater
    extends Thread {
        public QueueEventAllocater() {
            this.setName("TES/" + TaskQueueGroup.this.tesVersion + "-" + TaskQueueGroup.this.tmName + "-" + TaskQueueGroup.this.teName + "-eventAllocater");
        }

        @Override
        public void run() {
            while (TaskQueueGroup.this.isQueueEventAllocaterAlive) {
                try {
                    TaskQueueGroup.this.queueLock.lock();
                    if (TaskQueueGroup.this.queueMap.isEmpty()) {
                        try {
                            TaskQueueGroup.this.queueEmpty.await();
                        }
                        catch (Exception e) {
                            TaskQueueGroup.this.logger.fine("VS_ERR --> Exception in TaskQueueGroup " + TaskQueueGroup.this.teName);
                        }
                    }
                    TaskQueueGroup.this.handleQueue(TaskQueueGroup.this.mpqueue, TaskQueueGroup.this.mediumpriorityratio);
                    TaskQueueGroup.this.handleQueue(TaskQueueGroup.this.hpqueue, TaskQueueGroup.this.highpriorityratio);
                    TaskQueueGroup.this.handleQueue(TaskQueueGroup.this.lpqueue, TaskQueueGroup.this.lowpriorityratio);
                }
                catch (Exception e) {
                    TaskQueueGroup.this.logger.log(Level.SEVERE, "TES_ERR --> TASKQUEUEGROUP_EXCEPTION Exception in QueueEventAllocater for " + TaskQueueGroup.this.teName + " tmName=" + TaskQueueGroup.this.tmName, e);
                    StatsDB.recordError(ComponentConstants.TES.getModuleCode(), ComponentConstants.TES.TASKQUEUEGROUP_EXCEPTION.getErrorCode(), 1L);
                }
                finally {
                    TaskQueueGroup.this.queueLock.unlock();
                }
            }
        }

        protected void shutDown() {
            TaskQueueGroup.this.isQueueEventAllocaterAlive = false;
        }
    }
}

