/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.executor;

import com.adventnet.wms.common.WmsEvent;
import com.adventnet.wms.common.exception.WMSEventException;
import com.adventnet.wms.common.exception.WMSTaskNotFoundException;
import com.adventnet.wms.servercommon.ServerUtil;
import com.adventnet.wms.servercommon.components.constants.ComponentConstants;
import com.adventnet.wms.servercommon.components.executor.TaskQueueGroup;
import com.adventnet.wms.servercommon.components.executor.WMSQueueScheduler;
import com.adventnet.wms.servercommon.components.executor.WMSThreadPoolExecutor;
import com.adventnet.wms.servercommon.dc.DC;
import com.adventnet.wms.servercommon.stats.influx.StatsDB;
import com.adventnet.wms.servercommon.taskengine.WmsTask;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TaskEngine {
    private static Logger logger = Logger.getLogger(TaskEngine.class.getName());
    private static String taskConfDir;
    private final String name;
    private final String tmName;
    private final int inMemBufSize;
    private boolean drain;
    private boolean stopEngine = false;
    private boolean isBlocked = false;
    private boolean isIsolated = false;
    private TaskQueueGroup queueGroup;
    WMSQueueScheduler wmsQueueScheduler;
    WMSThreadPoolExecutor isolationExecutor;
    private HashMap<String, WmsTask> taskMap = new HashMap();
    private ConcurrentHashMap<String, AtomicLong> blockedTaskMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, AtomicLong> droppedTaskMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, ConcurrentHashMap<String, AtomicLong>> blockedRKeyMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, ConcurrentHashMap<String, AtomicLong>> blockedPrdMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, AtomicLong> isolatedTaskMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, AtomicLong> isolatedRKeyMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, AtomicLong> isolatedPrdMap = new ConcurrentHashMap();

    public TaskEngine(String name, String tmName, String tesVersion, int bufSize, int highprioritythreads, int mediumprioritythreads, int lowprioritythreads, WMSQueueScheduler wmsQueueScheduler, WMSThreadPoolExecutor isolationExecutor, boolean isAREnabled) {
        this.name = name;
        this.tmName = tmName;
        this.inMemBufSize = bufSize;
        this.wmsQueueScheduler = wmsQueueScheduler;
        this.isolationExecutor = isolationExecutor;
        this.queueGroup = new TaskQueueGroup(tmName, name, tesVersion, mediumprioritythreads, highprioritythreads, lowprioritythreads, this.inMemBufSize, isAREnabled);
    }

    public boolean start() {
        try {
            taskConfDir = ServerUtil.serverHome + File.separator + "conf" + File.separator + "taskmanager" + File.separator + this.tmName + File.separator;
            Properties classMap = ServerUtil.getProperties(taskConfDir + this.name + ".properties");
            Enumeration<?> e = classMap.propertyNames();
            while (e.hasMoreElements()) {
                String taskName = (String)e.nextElement();
                String taskClass = (String)classMap.get(taskName);
                try {
                    this.taskMap.put(taskName, (WmsTask)Class.forName(taskClass).newInstance());
                }
                catch (Exception exp) {
                    logger.log(Level.SEVERE, "TES_ERR --> TASK_NOT_FOUND Unable to load task " + taskName + " engine = " + this.name + " tmname = " + this.tmName, exp);
                    StatsDB.recordError(ComponentConstants.TES.getModuleCode(), ComponentConstants.TES.TASK_NOT_FOUND.getErrorCode(), 1L);
                }
            }
            if (!this.queueGroup.isEmpty()) {
                this.wmsQueueScheduler.prepare(this.queueGroup);
            }
            for (String task : this.taskMap.keySet()) {
                this.blockedRKeyMap.put(this.name + "." + task, new ConcurrentHashMap());
            }
            for (String task : this.taskMap.keySet()) {
                this.blockedPrdMap.put(this.name + "." + task, new ConcurrentHashMap());
            }
            this.wmsQueueScheduler.add(this.queueGroup);
            return true;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "TES_ERR--> TE_INITIALIZATION_FAILED " + this.name, e);
            StatsDB.recordError(ComponentConstants.TES.getModuleCode(), ComponentConstants.TES.TE_INITIALIZATION_FAILED.getErrorCode(), 1L);
            return false;
        }
    }

    public void restart() {
        this.queueGroup.open();
    }

    public void setDrain(boolean isdrain) {
        this.drain = isdrain;
    }

    public void stop() {
        this.stopEngine = true;
        this.queueGroup.close();
    }

    public void handle(WmsEvent event) {
        String rkey;
        if (this.stopEngine) {
            StatsDB.addData("stopengine", DC.getServertype(), DC.getCluster(), this.tmName, this.name, event.getOpr(), 1);
            StatsDB.recordError(ComponentConstants.TES.getModuleCode(), ComponentConstants.TES.TE_HANDLE_STOPPED.getErrorCode(), 1L);
            return;
        }
        String prd = event.getDataAsString("prd");
        if (prd == null) {
            prd = "null";
        }
        if ((rkey = event.getRKey()) == null) {
            rkey = "null";
        }
        if (this.isBlocked(event)) {
            return;
        }
        if (this.isolatedTaskMap.containsKey(event.getOpr()) || this.isolatedPrdMap.containsKey(prd) || this.isolatedRKeyMap.containsKey(rkey)) {
            this.isolationExecutor.execute(event);
            return;
        }
        this.queueGroup.add(event);
        this.wmsQueueScheduler.addQueue(this.queueGroup);
    }

    public boolean chain(WmsEvent event) {
        if (this.stopEngine) {
            StatsDB.addData("stopengine", DC.getServertype(), DC.getCluster(), this.tmName, this.name, event.getOpr(), 1);
            StatsDB.recordError(ComponentConstants.TES.getModuleCode(), ComponentConstants.TES.TE_CHAIN_STOPPED.getErrorCode(), 1L);
            return false;
        }
        String rkey = event.getRKey();
        if (rkey == null) {
            rkey = "null";
        }
        if (this.isBlocked(event)) {
            return false;
        }
        try {
            if (event.getOpr() == null) {
                throw new WMSEventException("Operation Not Defined");
            }
            WmsTask task = this.taskMap.get(event.getOpr().split("\\.")[1]);
            if (task == null) {
                StatsDB.recordError(ComponentConstants.TES.getModuleCode(), ComponentConstants.TES.INVALID_TASK.getErrorCode(), 1L);
                logger.log(Level.SEVERE, "TES_ERR --> INVALID_TASK Task {0} not found task manager - {1}", new Object[]{event.getOpr(), this.tmName});
                throw new WMSTaskNotFoundException("Task " + event.getOpr() + " not found");
            }
            if (!event.isBounced()) {
                event.putData("inqueuetime", (Object)("" + System.currentTimeMillis()));
                task.handle(event);
                return true;
            }
        }
        catch (Exception exp) {
            logger.log(Level.INFO, "TES_ERR --> Unable to chain task : " + exp.getMessage() + " : " + event.getOpr(), exp);
            StatsDB.recordError(ComponentConstants.TES.getModuleCode(), ComponentConstants.TES.TE_HANDLE_EXP.getErrorCode(), 1L);
        }
        return false;
    }

    public String drainQueue(String queueID, int drainCount) {
        int previousSize = this.queueGroup.size();
        logger.info("TES --> drain initiated taskmanager - " + this.tmName + " taskengine - " + this.name + " queueID - " + queueID + " drainCount - " + drainCount + " queue size - " + previousSize);
        String result = this.queueGroup.drain(queueID, drainCount);
        logger.info("TES --> drain completed taskmanager - " + this.tmName + " taskengine - " + this.name + " queueID - " + queueID + " drainCount - " + drainCount + " queue size - " + this.queueGroup.size());
        StatsDB.addDataInstant(System.currentTimeMillis(), "drainstats", DC.getServertype(), DC.getCluster(), this.tmName, this.name, queueID, previousSize - this.queueGroup.size());
        return result;
    }

    public String blockEngine() {
        if (this.isBlocked) {
            return "TaskEngine - " + this.name + " is already blocked";
        }
        for (String task : this.taskMap.keySet()) {
            if (this.blockedTaskMap.containsKey(task)) continue;
            this.blockedTaskMap.put(this.name + "." + task, new AtomicLong());
        }
        this.isBlocked = true;
        return "Blocked TaskEngine - " + this.name;
    }

    public String blockTask(String task) {
        if (this.isBlocked) {
            return "TaskEngine - " + this.name + " is blocked";
        }
        if (!this.taskMap.containsKey(task)) {
            return "invalid task";
        }
        if (!this.blockedTaskMap.containsKey(this.name + "." + task)) {
            this.blockedTaskMap.put(this.name + "." + task, new AtomicLong());
            return "Blocked Task - " + this.name + "." + task;
        }
        return "Task - " + this.name + "." + task + " is alredy blocked";
    }

    public String dropTask(String task, int count) {
        if (count <= 0) {
            return "Invalid count - " + count;
        }
        if (this.isBlocked) {
            return "TaskEngine - " + this.name + " is blocked";
        }
        if (!this.taskMap.containsKey(task)) {
            return "invalid task";
        }
        this.droppedTaskMap.put(this.name + "." + task, new AtomicLong(count));
        return "Dropped Task - " + this.name + "." + task;
    }

    public String blockRkey(String rkey) {
        for (String opr : this.blockedRKeyMap.keySet()) {
            this.blockedRKeyMap.get(opr).put(rkey, new AtomicLong());
        }
        return "Blocked Rkey - " + rkey;
    }

    public String blockRkey(String rkey, String task) {
        if (!this.taskMap.containsKey(task)) {
            return "invalid task";
        }
        this.blockedRKeyMap.get(this.name + "." + task).put(rkey, new AtomicLong());
        return "RKey - " + rkey + " is blocked";
    }

    public String blockPrd(String prd) {
        for (String opr : this.blockedPrdMap.keySet()) {
            this.blockedPrdMap.get(opr).put(prd, new AtomicLong());
        }
        return "Blocked prd - " + prd;
    }

    public String blockPrd(String prd, String task) {
        if (!this.taskMap.containsKey(task)) {
            return "invalid task";
        }
        this.blockedPrdMap.get(this.name + "." + task).put(prd, new AtomicLong());
        return "Prd - " + prd + " is blocked";
    }

    public String isolatedEngine() {
        if (this.isIsolated) {
            return "TaskEngine - " + this.name + " is already isolated";
        }
        for (String task : this.taskMap.keySet()) {
            if (this.isolatedTaskMap.containsKey(task)) continue;
            this.isolatedTaskMap.put(this.name + "." + task, new AtomicLong());
        }
        this.isIsolated = true;
        return "Isolated TaskEngine - " + this.name;
    }

    public String isolateTask(String task) {
        if (this.isIsolated) {
            return "TaskEngine - " + this.name + " is isolated";
        }
        if (!this.taskMap.containsKey(task)) {
            return "invalid task";
        }
        if (!this.isolatedTaskMap.containsKey(this.name + "." + task)) {
            this.isolatedTaskMap.put(this.name + "." + task, new AtomicLong());
            return "Isolated Task - " + this.name + "." + task;
        }
        return "Task - " + this.name + "." + task + " is alredy isolated";
    }

    public String isolatePrd(String prd) {
        if (this.isIsolated) {
            return "TaskEngine - " + this.name + " is isolated";
        }
        if (!this.isolatedPrdMap.containsKey(prd)) {
            this.isolatedPrdMap.put(prd, new AtomicLong());
            return "Isolated Prd - " + prd;
        }
        return "Prd - " + prd + " is alredy isolated";
    }

    public String isolateRkey(String rkey) {
        if (this.isIsolated) {
            return "TaskEngine - " + this.name + " is isolated";
        }
        if (!this.isolatedRKeyMap.containsKey(rkey)) {
            this.isolatedRKeyMap.put(rkey, new AtomicLong());
            return "Isolated RKey - " + rkey;
        }
        return "RKey - " + rkey + " is alredy isolated";
    }

    public String unblockEngine() {
        if (!this.isBlocked) {
            return "TaskEngine - " + this.name + " is already unblocked";
        }
        this.blockedTaskMap = new ConcurrentHashMap();
        this.isBlocked = false;
        return "Unblocked TaskEngine - " + this.name;
    }

    public String unblockTask(String task) {
        if (this.isBlocked) {
            return "TaskEngine - " + this.name + " is blocked";
        }
        if (!this.taskMap.containsKey(task)) {
            return "invalid task";
        }
        if (this.blockedTaskMap.containsKey(this.name + "." + task)) {
            this.blockedTaskMap.remove(this.name + "." + task);
            return "Unblocked Task - " + this.name + "." + task;
        }
        return "Task - " + this.name + "." + task + " is not blocked";
    }

    public String unblockRkey(String rkey) {
        for (String opr : this.blockedRKeyMap.keySet()) {
            this.blockedRKeyMap.get(opr).remove(rkey);
        }
        return "UnBlocked Rkey - " + rkey;
    }

    public String unblockRkey(String rkey, String task) {
        if (!this.taskMap.containsKey(task)) {
            return "invalid task";
        }
        this.blockedRKeyMap.get(this.name + "." + task).remove(rkey);
        return "RKey - " + rkey + " is unblocked";
    }

    public String unblockPrd(String prd) {
        for (String opr : this.blockedPrdMap.keySet()) {
            this.blockedPrdMap.get(opr).remove(prd);
        }
        return "UnBlocked prd - " + prd;
    }

    public String unblockPrd(String prd, String task) {
        if (!this.taskMap.containsKey(task)) {
            return "invalid task";
        }
        this.blockedPrdMap.get(this.name + "." + task).remove(prd);
        return "Prd - " + prd + " is unblocked";
    }

    public String deIsolateEngine() {
        if (!this.isIsolated) {
            return "TaskEngine - " + this.name + " is already deisolated";
        }
        this.isolatedTaskMap = new ConcurrentHashMap();
        this.isIsolated = false;
        return "Deisolated TaskEngine - " + this.name;
    }

    public String deIsolateTask(String task) {
        if (this.isIsolated) {
            return "TaskEngine - " + this.name + " is isolated";
        }
        if (!this.taskMap.containsKey(task)) {
            return "invalid task";
        }
        if (this.isolatedTaskMap.containsKey(this.name + "." + task)) {
            this.isolatedTaskMap.remove(this.name + "." + task);
            return "Deisolated Task - " + this.name + "." + task;
        }
        return "Task - " + this.name + "." + task + " is not isolated";
    }

    public String deIsolatePrd(String prd) {
        if (this.isIsolated) {
            return "TaskEngine - " + this.name + " is isolated";
        }
        if (this.isolatedPrdMap.containsKey(prd)) {
            this.isolatedPrdMap.remove(prd);
            return "Deisolated Prd - " + prd;
        }
        return "Prd - " + prd + " is not isolated";
    }

    public String deIsolateRkey(String rkey) {
        if (this.isIsolated) {
            return "TaskEngine - " + this.name + " is isolated";
        }
        if (this.isolatedRKeyMap.containsKey(rkey)) {
            this.isolatedRKeyMap.remove(rkey);
            return "Deisolated RKey - " + rkey;
        }
        return "RKey - " + rkey + " is not isolated";
    }

    public ConcurrentHashMap<String, Object> getBlockedStatus() {
        ConcurrentHashMap<String, Object> map = new ConcurrentHashMap<String, Object>();
        if (!this.blockedTaskMap.isEmpty()) {
            map.put("task", this.blockedTaskMap);
        }
        ConcurrentHashMap<String, ConcurrentHashMap<String, AtomicLong>> rkeyMap = new ConcurrentHashMap<String, ConcurrentHashMap<String, AtomicLong>>();
        rkeyMap.putAll(this.blockedRKeyMap);
        for (Map.Entry entry : rkeyMap.entrySet()) {
            if (!((ConcurrentHashMap)entry.getValue()).isEmpty()) continue;
            rkeyMap.remove(entry.getKey());
        }
        if (!rkeyMap.isEmpty()) {
            map.put("rkey", rkeyMap);
        }
        ConcurrentHashMap<String, ConcurrentHashMap<String, AtomicLong>> prdMap = new ConcurrentHashMap<String, ConcurrentHashMap<String, AtomicLong>>();
        prdMap.putAll(this.blockedPrdMap);
        for (Map.Entry entry : prdMap.entrySet()) {
            if (!((ConcurrentHashMap)entry.getValue()).isEmpty()) continue;
            prdMap.remove(entry.getKey());
        }
        if (!prdMap.isEmpty()) {
            map.put("prd", prdMap);
        }
        return map;
    }

    public HashMap<String, ConcurrentHashMap<String, AtomicLong>> getIsolationStatus() {
        HashMap<String, ConcurrentHashMap<String, AtomicLong>> map = new HashMap<String, ConcurrentHashMap<String, AtomicLong>>();
        if (!this.isolatedTaskMap.isEmpty()) {
            map.put("task", this.isolatedTaskMap);
        }
        if (!this.isolatedPrdMap.isEmpty()) {
            map.put("prd", this.isolatedPrdMap);
        }
        if (!this.isolatedRKeyMap.isEmpty()) {
            map.put("rkey", this.isolatedRKeyMap);
        }
        return map;
    }

    public Hashtable<String, String> getStats() {
        return this.queueGroup.getStats();
    }

    public ArrayList<Hashtable<String, String>> getWmsQStats() {
        return this.queueGroup.getWmsQStats();
    }

    public void clearStats() {
        this.queueGroup.clearStats();
    }

    public int getQueueSize() {
        return this.queueGroup.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(WmsEvent event) {
        try {
            WmsTask task;
            if (this.isBlocked(event)) {
                return;
            }
            String opr = event.getOpr();
            if (this.droppedTaskMap.containsKey(opr)) {
                try {
                    long count = this.droppedTaskMap.get(opr).decrementAndGet();
                    if (count <= 0L) {
                        this.droppedTaskMap.remove(opr);
                    }
                }
                catch (NullPointerException e) {
                    logger.fine("NullPointerException --> " + e.getMessage());
                }
                return;
            }
            long inqtime = -1L;
            if (event.getData("inqueuetime") != null) {
                inqtime = Long.parseLong((String)event.getData("inqueuetime"));
            }
            if ((task = this.taskMap.get(opr.split("\\.")[1])) == null) {
                StatsDB.recordError(ComponentConstants.TES.getModuleCode(), ComponentConstants.TES.INVALID_TASK.getErrorCode(), 1L);
                logger.log(Level.SEVERE, "TES_ERR --> INVALID_TASK Task {0} not found task manager - {1}", new Object[]{event.getOpr(), this.tmName});
                return;
            }
            WmsTask.setAsIsolatedTask(false);
            long stime = System.currentTimeMillis();
            String handleType = "";
            try {
                if (this.drain) {
                    handleType = "drain";
                    task.handleDrain(event);
                } else if (event.isBounced()) {
                    handleType = "bounce";
                    task.handleBounce(event.getBounceDetails(), event);
                } else if (Boolean.parseBoolean(event.getHeader("isdeferredevent"))) {
                    handleType = "defer";
                    task.handle((List)event.getData("desdata"));
                } else {
                    handleType = "handle";
                    task.handle(event);
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "TES_ERR --> Exception while handling Task Engine: opr - " + event.getOpr() + " isBounced - " + event.isBounced() + " drain - " + this.drain, e);
                StatsDB.recordError(ComponentConstants.TES.getModuleCode(), ComponentConstants.TES.TE_HANDLE_EXP.getErrorCode(), 1L);
            }
            finally {
                WmsTask.clear();
            }
            long currenttime = System.currentTimeMillis();
            long executiontime = currenttime - stime;
            StatsDB.addData("taskenginetime", this.tmName, this.name, event.getOpr(), 1, currenttime - inqtime - executiontime, executiontime);
            StatsDB.addData("tesoutstats", DC.getServertype(), DC.getCluster(), this.tmName, this.name, event.getOpr(), handleType, 1, currenttime - inqtime - executiontime, executiontime);
            ServerUtil.logExternal(event, "delegate", "event_end");
        }
        catch (Exception exp) {
            logger.log(Level.SEVERE, "TES_ERR --> TE_PROCESS_EXP Exception in task evt: opr = " + event.getOpr() + " tmname = " + this.tmName, exp);
            ServerUtil.logExternal(event, "delegate", "event_error:" + exp.getMessage());
            StatsDB.recordError(ComponentConstants.TES.getModuleCode(), ComponentConstants.TES.TE_PROCESS_EXP.getErrorCode(), 1L);
        }
    }

    private boolean isBlocked(WmsEvent event) {
        if (event.getOpr() == null) {
            ServerUtil.logExternal(event, "delegate", "event_opr_not_present");
            return true;
        }
        if (this.blockedTaskMap.containsKey(event.getOpr())) {
            try {
                this.blockedTaskMap.get(event.getOpr()).incrementAndGet();
            }
            catch (NullPointerException e) {
                logger.fine("NullPointerException --> " + e.getMessage());
            }
            ServerUtil.logExternal(event, "delegate", "event_dropped_opr_blocked");
            StatsDB.addData("blockedevents", DC.getServertype(), DC.getCluster(), this.tmName, this.name, event.getOpr(), 1);
            return true;
        }
        if (event.getRKey() != null && this.blockedRKeyMap.get(event.getOpr()).containsKey(event.getRKey())) {
            try {
                this.blockedRKeyMap.get(event.getOpr()).get(event.getRKey()).incrementAndGet();
            }
            catch (NullPointerException e) {
                logger.fine("NullPointerException --> " + e.getMessage());
            }
            ServerUtil.logExternal(event, "delegate", "event_dropped_rkey_blocked");
            StatsDB.addData("blockedevents", DC.getServertype(), DC.getCluster(), this.tmName, this.name, event.getOpr(), 1);
            return true;
        }
        if (event.getDataAsString("prd") != null && this.blockedPrdMap.get(event.getOpr()).containsKey(event.getDataAsString("prd"))) {
            try {
                this.blockedPrdMap.get(event.getOpr()).get(event.getDataAsString("prd")).incrementAndGet();
            }
            catch (NullPointerException e) {
                logger.fine("NullPointerException --> " + e.getMessage());
            }
            ServerUtil.logExternal(event, "delegate", "event_dropped_prd_blocked");
            StatsDB.addData("blockedevents", DC.getServertype(), DC.getCluster(), this.tmName, this.name, event.getOpr(), 1);
            return true;
        }
        if (event.getExpiryTime() > 0L && event.getExpiryTime() < System.currentTimeMillis()) {
            ServerUtil.logExternal(event, "delegate", "event_dropped_ttl");
            StatsDB.addData("droppedevents", DC.getServertype(), DC.getCluster(), this.tmName, this.name, event.getOpr(), 1);
            return true;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }
}

