/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.executor;

import com.adventnet.wms.servercommon.components.file.AbsFileHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TESFileHandler
extends AbsFileHandler {
    private static Logger logger = Logger.getLogger(TESFileHandler.class.getName());
    private FileOutputStream fout = null;

    @Override
    public void handleData(File file, byte[] data, boolean iscompleted) throws Exception {
        try {
            file.getParentFile().mkdirs();
            file.createNewFile();
            if (this.fout == null) {
                this.fout = new FileOutputStream(file);
            }
            this.fout.write(data);
            this.fout.flush();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "VS_ERR --> Exception in TesFileHandler for File - " + file.getName(), e);
            this.closeFile();
            throw e;
        }
        finally {
            if (iscompleted) {
                this.closeFile();
            }
        }
    }

    private void closeFile() {
        if (this.fout != null) {
            try {
                this.fout.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.fout = null;
        }
    }
}

