/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.executor;

import com.adventnet.wms.common.WmsEvent;
import com.adventnet.wms.servercommon.ServerUtil;
import com.adventnet.wms.servercommon.TraceLogConfManager;
import com.adventnet.wms.servercommon.components.constants.ComponentConstants;
import com.adventnet.wms.servercommon.components.executor.AbsTaskManager;
import com.adventnet.wms.servercommon.components.executor.SequentialTaskEngine;
import com.adventnet.wms.servercommon.components.executor.TaskExecutorService;
import com.adventnet.wms.servercommon.dc.DC;
import com.adventnet.wms.servercommon.stats.influx.StatsDB;
import com.adventnet.wms.servercommon.stats.influx.conf.StatsConf;
import com.adventnet.wms.servercommon.util.WMSUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SequentialTaskManager
extends AbsTaskManager {
    private Logger logger = Logger.getLogger(SequentialTaskManager.class.getName());
    private Logger msgtracelogger = Logger.getLogger("msgtracelogger");
    private String tmName;
    private String tesVersion = "";
    private boolean isAREnabled;
    private boolean isBlocked = false;
    private String taskConfDir;
    private HashMap<String, SequentialTaskEngine> taskEngine = new HashMap();
    private ConcurrentHashMap<String, AtomicLong> taskcounter = new ConcurrentHashMap(100, 0.75f, 16);
    private ConcurrentHashMap<String, Hashtable<String, AtomicLong>> prdtaskcounter = null;
    private ConcurrentHashMap<String, AtomicLong> tasksCountMap = new ConcurrentHashMap();
    private AtomicInteger engineCount = new AtomicInteger();
    private long timeout = -1L;
    private long startupTime = 0L;
    private Hashtable ignoretasks = new Hashtable();
    private boolean prdstatsenabled = false;

    public boolean initialize(String tmName, String tesVersion, long timelimit, boolean isAREnabled) {
        try {
            this.tmName = tmName;
            this.tesVersion = tesVersion;
            this.isAREnabled = isAREnabled;
            this.taskConfDir = ServerUtil.serverHome + File.separator + "conf" + File.separator + "taskmanager" + File.separator + tmName + File.separator;
            Properties tconf = ServerUtil.getProperties(this.taskConfDir + "taskengine.conf");
            Enumeration<?> e = tconf.propertyNames();
            while (e.hasMoreElements()) {
                int maxIsolationLimit;
                int isoThreshold;
                int maxEntriesforMap;
                String teName = (String)e.nextElement();
                String teParam = (String)tconf.get(teName);
                String[] teParams = teParam.split(",");
                int bufSize = new Integer(teParams[0]);
                int workerThreads = new Integer(teParams[1]);
                int isolationThreads = new Integer(teParams[2]);
                try {
                    maxEntriesforMap = Integer.parseInt(teParams[3]);
                    if (maxEntriesforMap <= 0) {
                        throw new Exception("maxEntriesforMap cannot be zero or negative");
                    }
                }
                catch (Exception exp) {
                    maxEntriesforMap = 1000;
                }
                try {
                    isoThreshold = Integer.parseInt(teParams[4]);
                    if (isoThreshold <= 0) {
                        throw new Exception("isoThreshold cannot be zero or negative");
                    }
                }
                catch (Exception exp) {
                    isoThreshold = 100;
                }
                try {
                    maxIsolationLimit = Integer.parseInt(teParams[5]);
                    if (maxIsolationLimit == 0) {
                        maxIsolationLimit = Integer.MAX_VALUE;
                    } else if (maxIsolationLimit < 0) {
                        throw new Exception("maxIsolationLimit cannot be negative");
                    }
                }
                catch (Exception exp) {
                    maxIsolationLimit = 1000;
                }
                SequentialTaskEngine engine = new SequentialTaskEngine(tmName, teName, tesVersion, bufSize, workerThreads, isolationThreads, isAREnabled, maxEntriesforMap, isoThreshold, maxIsolationLimit, this);
                if (!engine.start()) {
                    return false;
                }
                this.engineCount.incrementAndGet();
                this.taskEngine.put(teName, engine);
            }
            this.startupTime = System.currentTimeMillis();
            this.timeout = timelimit;
            this.logger.info("Task Manager intialized " + this.taskEngine);
            return true;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "TES_ERR --> TM_INITIALIZATION_FAILED " + tmName, e);
            StatsDB.recordError(ComponentConstants.TES.getModuleCode(), ComponentConstants.TES.TM_INITIALIZATION_FAILED.getErrorCode(), 1L);
            return false;
        }
    }

    @Override
    public void delegate(WmsEvent event, boolean needsDuplication) {
        try {
            if (event == null) {
                return;
            }
            if (this.isDisabledEvent(event)) {
                this.logger.fine("disabled event=" + event);
                return;
            }
            long starttime = System.currentTimeMillis();
            this.printTrace(event, "delegate");
            this.incrementTaskCount(event);
            event.putData("inqueuetime", (Object)("" + starttime));
            if (needsDuplication) {
                event = event.duplicate();
            }
            event.trackOpr("d");
            long duplicationtime = System.currentTimeMillis();
            this.hit(event.getOpr());
            ServerUtil.logExternal(event, "delegate", "event_start");
            this.taskEngine.get(event.getOpr().split("\\.")[0]).handle(event);
            long totaltime = System.currentTimeMillis();
            if (this.timeout != -1L && (totaltime - starttime >= this.timeout || totaltime - duplicationtime >= this.timeout)) {
                this.logger.info("Timeout in taskmanager totaltime: " + (totaltime - starttime) + " duplicationtime: " + (duplicationtime - starttime));
            }
            this.hit(event);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "TES_ERR --> TM_DELEGATE_FAILED Unable to delegate task event : " + event.getOpr(), e);
            StatsDB.recordError(ComponentConstants.TES.getModuleCode(), ComponentConstants.TES.TM_DELEGATE_FAILED.getErrorCode(), 1L);
        }
    }

    @Override
    public boolean chain(WmsEvent event) {
        try {
            if (event == null) {
                return false;
            }
            if (this.isDisabledEvent(event)) {
                return false;
            }
            this.printTrace(event, "chain");
            event.trackOpr("c");
            this.incrementTaskCount(event);
            ServerUtil.logExternal(event, "chain", "event_start");
            this.logger.fine("chain event opr = " + event.getOpr() + "  event = " + event);
            return this.taskEngine.get(event.getOpr().split("\\.")[0]).chain(event);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "TES_ERR --> TM_CHAIN_FAILED Unable to chain task event : " + event.getOpr(), e);
            StatsDB.recordError(ComponentConstants.TES.getModuleCode(), ComponentConstants.TES.TM_CHAIN_FAILED.getErrorCode(), 1L);
            return false;
        }
    }

    @Override
    public void printTrace(WmsEvent event, String method) {
        if (TraceLogConfManager.isDebugEnabled(event.getOpr(), event.getRKey())) {
            this.msgtracelogger.info("TaskManager [" + method + "] [" + event.getOpr() + "] [" + event.getRKey() + "] [Event] " + event.toString());
            event.enableTrace();
        }
    }

    @Override
    public boolean isAREnabled() {
        return this.isAREnabled;
    }

    @Override
    public void restart() {
        for (SequentialTaskEngine engine : this.taskEngine.values()) {
            engine.restart();
        }
    }

    @Override
    public ConcurrentHashMap<String, AtomicLong> getStats() {
        return this.taskcounter;
    }

    @Override
    public void resetStats() {
        this.taskcounter.clear();
    }

    private void hit(String taskName) {
        try {
            if (taskName == null) {
                return;
            }
            this.taskcounter.putIfAbsent(taskName, new AtomicLong());
            this.taskcounter.get(taskName).incrementAndGet();
        }
        catch (Exception exp) {
            this.logger.log(Level.INFO, "Error in adding stats. taskName :" + taskName, exp);
        }
    }

    @Override
    public void enablePrdStats() {
        this.prdstatsenabled = true;
        this.prdtaskcounter = new ConcurrentHashMap();
    }

    @Override
    public ConcurrentHashMap<String, Hashtable<String, AtomicLong>> getPrdStats() {
        return this.prdtaskcounter;
    }

    @Override
    public void resetPrdStats() {
        this.prdtaskcounter = new ConcurrentHashMap();
    }

    private void hit(WmsEvent event) {
        if (!this.prdstatsenabled) {
            return;
        }
        String taskname = event.getOpr();
        if (taskname == null) {
            return;
        }
        String prd = event.getDataAsString("prd");
        this.addPrdTask(prd, taskname);
        this.addPrdTask("wms", taskname);
    }

    private void addPrdTask(String prd, String taskname) {
        AtomicLong al;
        if (prd == null) {
            return;
        }
        if (StatsConf.isTaskEngineStatsEnabled()) {
            StatsDB.addData("tasks", this.tmName, prd, taskname, taskname.split("\\.")[0], 1);
            StatsDB.addData("tesinstats", DC.getServertype(), DC.getCluster(), prd, this.tmName, taskname.split("\\.")[0], taskname, 1);
            return;
        }
        Hashtable<String, AtomicLong> tcount = this.prdtaskcounter.get(prd);
        if (tcount == null) {
            tcount = new Hashtable();
            tcount.put(taskname, new AtomicLong());
            this.prdtaskcounter.put(prd, tcount);
        }
        if ((al = tcount.get(taskname)) == null) {
            al = new AtomicLong();
            tcount.put(taskname, al);
        }
        al.incrementAndGet();
    }

    @Override
    public void clearQueStats() {
        for (SequentialTaskEngine engine : this.taskEngine.values()) {
            engine.clearStats();
        }
    }

    @Override
    public boolean isDisabledEvent(WmsEvent event) {
        if (this.ignoretasks != null && this.ignoretasks.size() != 0) {
            Hashtable disabledprds = null;
            if (this.ignoretasks.containsKey(event.getOpr().split("\\.")[0]) ? (disabledprds = (Hashtable)this.ignoretasks.get(event.getOpr().split("\\.")[0])) == null || disabledprds.size() == 0 : this.ignoretasks.containsKey(event.getOpr()) && ((disabledprds = (Hashtable)this.ignoretasks.get(event.getOpr())) == null || disabledprds.size() == 0)) {
                return true;
            }
            if (event.getData("prd") != null && disabledprds != null && disabledprds.containsKey(event.getData("prd"))) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void setIgnoreTasks(Hashtable properties) {
        this.ignoretasks = properties;
    }

    @Override
    public void initiateDrain() {
        for (SequentialTaskEngine engine : this.taskEngine.values()) {
            engine.setDrain(true);
            engine.restart();
        }
    }

    @Override
    public void stopDrain() {
        for (SequentialTaskEngine engine : this.taskEngine.values()) {
            engine.setDrain(false);
        }
    }

    public boolean isolate(String teName, String seqID) {
        if (this.taskEngine.containsKey(teName)) {
            return this.taskEngine.get(teName).isolate(seqID);
        }
        return false;
    }

    public void isolate(String seqID) {
        for (SequentialTaskEngine engine : this.taskEngine.values()) {
            engine.isolate(seqID);
        }
    }

    public boolean deisolate(String teName, String seqID) {
        if (this.taskEngine.containsKey(teName)) {
            return this.taskEngine.get(teName).deisolate(seqID);
        }
        return false;
    }

    public void deisolate(String seqID) {
        for (SequentialTaskEngine engine : this.taskEngine.values()) {
            engine.deisolate(seqID);
        }
    }

    public HashMap<String, HashMap<String, ConcurrentHashMap<String, AtomicLong>>> getIsolatedSeqIDs() {
        HashMap<String, HashMap<String, ConcurrentHashMap<String, AtomicLong>>> map = new HashMap<String, HashMap<String, ConcurrentHashMap<String, AtomicLong>>>();
        for (SequentialTaskEngine engine : this.taskEngine.values()) {
            map.put(engine.getName(), engine.getIsolatedSeqIDs());
        }
        return map;
    }

    public String enableDebug(String teName, int queueid, long duration) {
        if (this.taskEngine.containsKey(teName)) {
            return this.taskEngine.get(teName).enableDebug(queueid, duration);
        }
        return "invalid taskenginename";
    }

    public String disableDebug(String teName, int queueid) {
        if (this.taskEngine.containsKey(teName)) {
            return this.taskEngine.get(teName).disableDebug(queueid);
        }
        return "invalid taskenginename";
    }

    @Override
    public String drainQueue(String teName, String queueID, int drainCount, boolean isIsolation) {
        if (this.taskEngine.containsKey(teName)) {
            return this.taskEngine.get(teName).drainQueue(queueID, drainCount, isIsolation);
        }
        return "invalid taskenginename";
    }

    @Override
    public String blockAllEngines() {
        if (this.isBlocked) {
            return "TaskManager - " + this.tmName + " is already blocked";
        }
        for (SequentialTaskEngine engine : this.taskEngine.values()) {
            engine.blockEngine();
        }
        this.isBlocked = true;
        return "blocked TaskManager - " + this.tmName;
    }

    @Override
    public String blockEngine(String teName) {
        if (this.isBlocked) {
            return "TaskManager - " + this.tmName + " is blocked";
        }
        if (this.taskEngine.containsKey(teName)) {
            return this.taskEngine.get(teName).blockEngine();
        }
        return "invalid taskenginename";
    }

    @Override
    public String blockTask(String teName, String task) {
        if (this.isBlocked) {
            return "TaskManager - " + this.tmName + " is blocked";
        }
        if (this.taskEngine.containsKey(teName)) {
            return this.taskEngine.get(teName).blockTask(task);
        }
        return "invalid taskenginename";
    }

    @Override
    public String dropTask(String teName, String task, int count) {
        if (this.isBlocked) {
            return "TaskManager - " + this.tmName + " is blocked";
        }
        if (this.taskEngine.containsKey(teName)) {
            return this.taskEngine.get(teName).dropTask(task, count);
        }
        return "invalid taskenginename";
    }

    @Override
    public String blockRkey(String teName, String task, String rkey) {
        if (this.taskEngine.containsKey(teName)) {
            return this.taskEngine.get(teName).blockRkey(rkey, task);
        }
        return "invalid taskenginename";
    }

    @Override
    public String blockRkey(String teName, String rkey) {
        if (this.taskEngine.containsKey(teName)) {
            return this.taskEngine.get(teName).blockRkey(rkey);
        }
        return "invalid taskenginename";
    }

    @Override
    public String blockRkey(String rkey) {
        for (SequentialTaskEngine engine : this.taskEngine.values()) {
            engine.blockRkey(rkey);
        }
        return "Blocked Rkey - " + rkey;
    }

    @Override
    public String blockPrd(String teName, String task, String prd) {
        if (this.taskEngine.containsKey(teName)) {
            return this.taskEngine.get(teName).blockPrd(prd, task);
        }
        return "invalid taskenginename";
    }

    @Override
    public String blockPrd(String teName, String prd) {
        if (this.taskEngine.containsKey(teName)) {
            return this.taskEngine.get(teName).blockPrd(prd);
        }
        return "invalid taskenginename";
    }

    @Override
    public String blockPrd(String prd) {
        for (SequentialTaskEngine engine : this.taskEngine.values()) {
            engine.blockPrd(prd);
        }
        return "Blocked Prd - " + prd;
    }

    @Override
    public String unblockAllEngines() {
        if (!this.isBlocked) {
            return "TaskManager - " + this.tmName + " is already unblocked";
        }
        for (SequentialTaskEngine engine : this.taskEngine.values()) {
            engine.unblockEngine();
        }
        this.isBlocked = false;
        return "unblocked TaskManager - " + this.tmName;
    }

    @Override
    public String unblockEngine(String teName) {
        if (this.isBlocked) {
            return "TaskManager - " + this.tmName + " is blocked";
        }
        if (this.taskEngine.containsKey(teName)) {
            return this.taskEngine.get(teName).unblockEngine();
        }
        return "invalid taskenginename";
    }

    @Override
    public String unblockTask(String teName, String task) {
        if (this.isBlocked) {
            return "TaskManager - " + this.tmName + " is blocked";
        }
        if (this.taskEngine.containsKey(teName)) {
            return this.taskEngine.get(teName).unblockTask(task);
        }
        return "invalid taskenginename";
    }

    @Override
    public String unblockRkey(String teName, String task, String rkey) {
        if (this.taskEngine.containsKey(teName)) {
            return this.taskEngine.get(teName).unblockRkey(rkey, task);
        }
        return "invalid taskenginename";
    }

    @Override
    public String unblockRkey(String teName, String rkey) {
        if (this.taskEngine.containsKey(teName)) {
            return this.taskEngine.get(teName).unblockRkey(rkey);
        }
        return "invalid taskenginename";
    }

    @Override
    public String unblockRkey(String rkey) {
        for (SequentialTaskEngine engine : this.taskEngine.values()) {
            engine.unblockRkey(rkey);
        }
        return "Blocked Rkey - " + rkey;
    }

    @Override
    public String unblockPrd(String teName, String task, String prd) {
        if (this.taskEngine.containsKey(teName)) {
            return this.taskEngine.get(teName).unblockPrd(prd, task);
        }
        return "invalid taskenginename";
    }

    @Override
    public String unblockPrd(String teName, String prd) {
        if (this.taskEngine.containsKey(teName)) {
            return this.taskEngine.get(teName).unblockPrd(prd);
        }
        return "invalid taskenginename";
    }

    @Override
    public String unblockPrd(String prd) {
        for (SequentialTaskEngine engine : this.taskEngine.values()) {
            engine.unblockPrd(prd);
        }
        return "UnBlocked Prd - " + prd;
    }

    @Override
    public HashMap<String, ConcurrentHashMap<String, Object>> getBlockedStatus() {
        HashMap<String, ConcurrentHashMap<String, Object>> result = new HashMap<String, ConcurrentHashMap<String, Object>>();
        for (SequentialTaskEngine engine : this.taskEngine.values()) {
            ConcurrentHashMap<String, Object> map = engine.getBlockedStatus();
            if (map.isEmpty()) continue;
            result.put(engine.getName(), map);
        }
        return result;
    }

    public Hashtable<String, Hashtable<String, Hashtable<String, String>>> getIsolationQueueStats() {
        Hashtable<String, Hashtable<String, Hashtable<String, String>>> returnHash = new Hashtable<String, Hashtable<String, Hashtable<String, String>>>();
        for (SequentialTaskEngine engine : this.taskEngine.values()) {
            returnHash.put(engine.getName(), engine.getIsolationQueueStats());
        }
        return returnHash;
    }

    @Override
    public void shutdown() {
        for (SequentialTaskEngine engine : this.taskEngine.values()) {
            engine.shutdown();
        }
    }

    @Override
    public void stopAllEngines() {
        for (SequentialTaskEngine engine : this.taskEngine.values()) {
            engine.stop();
        }
    }

    public void shutdownCompleted() {
        if (this.engineCount.decrementAndGet() == 0) {
            this.logger.info("VS --> TES_SD SeqTaskManager - " + this.tmName + " is shutdown");
            TaskExecutorService.shutdownCompleted(this.tesVersion, this.tmName);
        }
    }

    @Override
    public void disablePrdStats() {
        this.prdstatsenabled = false;
        this.prdtaskcounter = new ConcurrentHashMap();
    }

    @Override
    public Hashtable<String, Hashtable<String, String>> getQueStats() {
        Hashtable<String, Hashtable<String, String>> details = new Hashtable<String, Hashtable<String, String>>();
        for (SequentialTaskEngine engine : this.taskEngine.values()) {
            details.put(engine.getName(), engine.getStats());
        }
        return details;
    }

    @Override
    public Hashtable<String, ArrayList<Hashtable<String, String>>> getWmsQStats() {
        Hashtable<String, ArrayList<Hashtable<String, String>>> details = new Hashtable<String, ArrayList<Hashtable<String, String>>>();
        for (SequentialTaskEngine engine : this.taskEngine.values()) {
            details.put(engine.getName(), engine.getWmsQStats());
        }
        return details;
    }

    @Override
    public int getCurrentThreadCount() {
        int count = 0;
        for (SequentialTaskEngine engine : this.taskEngine.values()) {
            count += engine.getCurrentThreadCount();
        }
        return count;
    }

    @Override
    public int getActiveThreadCount() {
        int count = 0;
        for (SequentialTaskEngine engine : this.taskEngine.values()) {
            count += engine.getActiveThreadCount();
        }
        return count;
    }

    @Override
    public int getPoolSize() {
        int count = 0;
        for (SequentialTaskEngine engine : this.taskEngine.values()) {
            count += engine.getPoolSize();
        }
        return count;
    }

    @Override
    public int getTotalQueueSize() {
        int size = 0;
        for (SequentialTaskEngine engine : this.taskEngine.values()) {
            size += engine.getQueueSize();
        }
        return size;
    }

    public Hashtable<String, String> startThreads(String teName, String threadID) {
        Hashtable<String, String> table = new Hashtable<String, String>();
        if (teName == null) {
            for (SequentialTaskEngine engine : this.taskEngine.values()) {
                table.put(engine.getName(), engine.startThreads(threadID));
            }
        } else if (this.taskEngine.containsKey(teName)) {
            table.put(teName, this.taskEngine.get(teName).startThreads(threadID));
        } else {
            table.put(teName, "invalid taskenginename");
        }
        return table;
    }

    public Hashtable<String, String> getThreadStatus(String teName) {
        Hashtable<String, String> table = new Hashtable<String, String>();
        if (teName == null) {
            for (SequentialTaskEngine engine : this.taskEngine.values()) {
                table.put(engine.getName(), engine.getThreadStatus());
            }
        } else if (this.taskEngine.containsKey(teName)) {
            table.put(teName, this.taskEngine.get(teName).getThreadStatus());
        } else {
            table.put(teName, "invalid taskenginename");
        }
        return table;
    }

    @Override
    public String getName() {
        return this.tmName;
    }

    @Override
    public Hashtable<String, Object> getShutdownStatus() {
        Hashtable<String, Object> table = new Hashtable<String, Object>();
        table.put("remaining threads", this.getCurrentThreadCount());
        return table;
    }

    protected ArrayList<File> getArTransferFiles() {
        ArrayList<File> list = new ArrayList<File>();
        for (SequentialTaskEngine engine : this.taskEngine.values()) {
            list.addAll(engine.getARTransferFiles());
        }
        return list;
    }

    private void incrementTaskCount(WmsEvent event) {
        if (this.tasksCountMap.containsKey(event.getOpr())) {
            this.tasksCountMap.get(event.getOpr()).incrementAndGet();
        } else {
            this.tasksCountMap.put(event.getOpr(), new AtomicLong(1L));
        }
    }

    @Override
    public LinkedHashMap<String, Object> getStatus() {
        LinkedHashMap<String, Object> taskDetails = new LinkedHashMap<String, Object>();
        long duration = System.currentTimeMillis() - this.startupTime;
        int threadCount = 0;
        for (SequentialTaskEngine engine : this.taskEngine.values()) {
            threadCount += engine.getCurrentThreadCount();
        }
        taskDetails.put("Thread Count", threadCount);
        taskDetails.put("Total Execution Time", WMSUtil.HumanReadable.getDuration(duration, true));
        return taskDetails;
    }

    @Override
    public LinkedHashMap<String, Object> getDetailedStatus() {
        LinkedHashMap<String, Object> taskDetails = new LinkedHashMap<String, Object>();
        long duration = System.currentTimeMillis() - this.startupTime;
        Hashtable<String, Integer> threadDetails = new Hashtable<String, Integer>();
        Hashtable<String, Integer> isoThreadDetails = new Hashtable<String, Integer>();
        for (SequentialTaskEngine engine : this.taskEngine.values()) {
            threadDetails.put(engine.getName(), engine.getNormalThreadCount());
        }
        for (SequentialTaskEngine engine : this.taskEngine.values()) {
            isoThreadDetails.put(engine.getName(), engine.getIsolationThreadsCount());
        }
        taskDetails.put("Normal Thread Details", threadDetails);
        taskDetails.put("isolated Thread Details", isoThreadDetails);
        taskDetails.put("Basic threads ", this.engineCount.get());
        taskDetails.put("Total Execution Time", WMSUtil.HumanReadable.getDuration(duration, false));
        taskDetails.put("Task Details", this.tasksCountMap);
        return taskDetails;
    }

    public ConcurrentHashMap<String, AtomicLong> getCurrentThreadStats() {
        ConcurrentHashMap<String, AtomicLong> threadStats = new ConcurrentHashMap<String, AtomicLong>();
        long currentThreads = 0L;
        for (SequentialTaskEngine engine : this.taskEngine.values()) {
            threadStats.put(engine.getName(), new AtomicLong(engine.getCurrentThreadCount()));
            currentThreads += (long)engine.getCurrentThreadCount();
        }
        threadStats.put("currentThreads", new AtomicLong(currentThreads));
        return threadStats;
    }

    public ConcurrentHashMap<String, Long> getMaxThreadStats() {
        ConcurrentHashMap<String, Long> threadStats = new ConcurrentHashMap<String, Long>();
        long maxthreads = 0L;
        for (SequentialTaskEngine engine : this.taskEngine.values()) {
            threadStats.put(engine.getName(), Long.valueOf(engine.getMaximumThreadCount()));
            maxthreads += (long)engine.getMaximumThreadCount();
        }
        threadStats.put("maxThreads", maxthreads);
        return threadStats;
    }

    public HashMap<String, HashMap<String, Long>> getIsolationThreadStats() {
        HashMap<String, HashMap<String, Long>> threadStats = new HashMap<String, HashMap<String, Long>>();
        for (SequentialTaskEngine engine : this.taskEngine.values()) {
            HashMap<String, Long> stats = new HashMap<String, Long>();
            stats.put("isothreadcount", Long.valueOf(engine.getMaximumIsolationThreadCount()));
            stats.put("poolsize", Long.valueOf(engine.getIsolatedPoolSize()));
            stats.put("seqidcount", Long.valueOf(engine.getMaxIsolatedSeqIDs()));
            threadStats.put(engine.getName(), stats);
        }
        return threadStats;
    }
}

