/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.executor;

import com.adventnet.wms.common.CommonUtil;
import com.adventnet.wms.common.WmsEvent;
import com.adventnet.wms.common.exception.WMSEventException;
import com.adventnet.wms.common.exception.WMSTaskNotFoundException;
import com.adventnet.wms.servercommon.ServerUtil;
import com.adventnet.wms.servercommon.components.constants.ComponentConstants;
import com.adventnet.wms.servercommon.components.executor.DeferredExecutorService;
import com.adventnet.wms.servercommon.components.executor.IsolatedSequentialTaskEngine;
import com.adventnet.wms.servercommon.components.executor.SequentialTaskManager;
import com.adventnet.wms.servercommon.components.queue.BufferedQueue;
import com.adventnet.wms.servercommon.dc.DC;
import com.adventnet.wms.servercommon.stats.influx.StatsDB;
import com.adventnet.wms.servercommon.taskengine.WmsTask;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SequentialTaskEngine {
    private static Logger logger = Logger.getLogger(SequentialTaskEngine.class.getName());
    private static String taskConfDir;
    private final String teName;
    private final String tmName;
    private String tesVersion = "";
    private final int inMemBufSize;
    private SequentialTaskManager manager;
    private IsolatedSequentialTaskEngine isoEngine;
    private boolean isAREnabled;
    private final int workerThreads;
    private final int isolationThreads;
    private final int maxEntriesforMap;
    private final int isoThreshold;
    private int maxIsolationLimit;
    private String seqDir;
    private boolean drain;
    private boolean stopEngine;
    private boolean isBlocked = false;
    private AtomicInteger threadCount = new AtomicInteger();
    private AtomicInteger activeThreadCount = new AtomicInteger();
    private static final int REQUEST_TYPE = 121;
    private ConcurrentHashMap<String, ConcurrentHashMap<Integer, SequentialTaskQueue>> queuesMap = new ConcurrentHashMap();
    private ConcurrentHashMap<Integer, SequentialTaskQueue> currentQueueMap;
    private ConcurrentHashMap<TaskDispatcher, Integer> threadsMap = new ConcurrentHashMap();
    private ConcurrentHashMap<Integer, TaskDispatcher> threadsIndexMap = new ConcurrentHashMap();
    Map<String, AtomicLong> seqIDTracker;
    private ReentrantLock versionLock = new ReentrantLock();
    private Condition versionCondition = this.versionLock.newCondition();
    private HashMap<String, WmsTask> taskMap = new HashMap();
    private ConcurrentHashMap<String, AtomicLong> droppedTaskMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, AtomicLong> blockedTaskMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, ConcurrentHashMap<String, AtomicLong>> blockedRKeyMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, ConcurrentHashMap<String, AtomicLong>> blockedPrdMap = new ConcurrentHashMap();

    public SequentialTaskEngine(String tmName, String teName, String tesVersion, int bufSize, int workerThreads, int isolationThreads, boolean isAREnabled, int maxEntriesforMap, int isoThreshold, int maxIsolationLimit, SequentialTaskManager manager) {
        this.tmName = tmName;
        this.teName = teName;
        this.tesVersion = tesVersion;
        this.inMemBufSize = bufSize;
        this.workerThreads = workerThreads;
        this.isolationThreads = isolationThreads;
        this.maxEntriesforMap = maxEntriesforMap;
        this.isoThreshold = isoThreshold;
        this.maxIsolationLimit = maxIsolationLimit;
        this.isAREnabled = isAREnabled;
        this.manager = manager;
    }

    public String getName() {
        return this.teName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start() {
        try {
            this.seqDir = ServerUtil.dataHome + File.separator + "tes" + File.separator + this.tmName + File.separator + this.teName + File.separator;
            new File(this.seqDir).mkdirs();
            taskConfDir = ServerUtil.serverHome + File.separator + "conf" + File.separator + "taskmanager" + File.separator + this.tmName + File.separator;
            Properties classMap = ServerUtil.getProperties(taskConfDir + this.teName + ".properties");
            HashMap<String, String> deferredMap = new HashMap<String, String>();
            Enumeration<?> e = classMap.propertyNames();
            while (e.hasMoreElements()) {
                String taskName = (String)e.nextElement();
                String value = (String)classMap.get(taskName);
                String[] valueSplit = value.split(",");
                String taskClass = valueSplit[0];
                if (valueSplit.length > 1) {
                    long deferredTime = Long.parseLong(valueSplit[1]);
                    long interval = Long.parseLong(valueSplit[2]);
                    int maxLimit = Integer.parseInt(valueSplit[3]);
                    String opr = this.teName + "." + taskName;
                    String deferredName = "TES-" + this.tmName + "-" + this.teName + "-" + taskName;
                    deferredMap.put(opr, deferredName);
                    DeferredExecutorService.startEngine(deferredName, deferredTime, interval, maxLimit, this.tmName, opr, this.inMemBufSize, this.isAREnabled);
                }
                try {
                    this.taskMap.put(taskName, (WmsTask)Class.forName(taskClass).newInstance());
                }
                catch (Exception exp) {
                    logger.log(Level.SEVERE, "TES_ERR --> TASK_NOT_FOUND Unable to load task " + taskName + " engine = " + this.teName + " tmname = " + this.tmName, exp);
                    StatsDB.recordError(ComponentConstants.TES.getModuleCode(), ComponentConstants.TES.TASK_NOT_FOUND.getErrorCode(), 1L);
                }
            }
            this.isoEngine = new IsolatedSequentialTaskEngine(this.tmName, this.teName, this.tesVersion, this.inMemBufSize, this.isAREnabled, this.isolationThreads, this.maxIsolationLimit, this.taskMap, this.manager, this.blockedTaskMap, this.blockedRKeyMap, this.blockedPrdMap, deferredMap);
            this.isoEngine.start();
            try {
                this.versionLock.lock();
                VersionControler versionController = new VersionControler();
                versionController.start();
                this.versionCondition.await();
            }
            finally {
                this.versionLock.unlock();
            }
            this.seqIDTracker = Collections.synchronizedMap(new LruCacheMap(this.maxEntriesforMap));
            this.stopEngine = false;
            for (String task : this.taskMap.keySet()) {
                this.blockedRKeyMap.put(this.teName + "." + task, new ConcurrentHashMap());
            }
            for (String task : this.taskMap.keySet()) {
                this.blockedPrdMap.put(this.teName + "." + task, new ConcurrentHashMap());
            }
            logger.info("VS --> Sequential TaskEngine started tmname - " + this.tmName + " tename - " + this.teName + " bufSize - " + this.inMemBufSize + " workerThreads - " + this.workerThreads + " maxEntriesforMap - " + this.maxEntriesforMap + " isoThreshold - " + this.isoThreshold + " maxIsolationLimit - " + this.maxIsolationLimit + " isAREnabled - " + this.isAREnabled);
            return true;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "TES_ERR--> TE_INITIALIZATION_FAILED " + this.teName, e);
            StatsDB.recordError(ComponentConstants.TES.getModuleCode(), ComponentConstants.TES.TE_INITIALIZATION_FAILED.getErrorCode(), 1L);
            return false;
        }
    }

    public void shutdown() {
        for (TaskDispatcher dispatcher : this.threadsMap.keySet()) {
            dispatcher.shutdown();
            dispatcher.interrupt();
        }
        this.isoEngine.shutdown();
    }

    public void restart() {
        this.stopEngine = false;
        for (SequentialTaskQueue que : this.currentQueueMap.values()) {
            if (que == null) continue;
            que.open();
        }
        this.isoEngine.restart();
    }

    protected ArrayList<File> getARTransferFiles() {
        ArrayList<File> list = new ArrayList<File>();
        list.add(new File(this.seqDir + "isolatedSeqidFile.properties"));
        list.add(new File(this.seqDir + "tempIsoSeqIdFile.properties"));
        list.add(new File(this.seqDir + this.teName + ".meta"));
        list.add(new File(this.seqDir + this.teName + "_iso.meta"));
        return list;
    }

    public int getCurrentThreadCount() {
        return this.threadCount.get() + this.isoEngine.getCurrentThreadCount();
    }

    public int getActiveThreadCount() {
        return this.activeThreadCount.get() + this.isoEngine.getActiveThreadCount();
    }

    public int getNormalThreadCount() {
        return this.threadCount.get();
    }

    public int getIsolationThreadsCount() {
        return this.isoEngine.getActiveThreadCount();
    }

    public int getMaximumThreadCount() {
        return this.threadCount.get() + this.isoEngine.getMaxThreadCount(false);
    }

    public int getMaximumIsolationThreadCount() {
        return this.isoEngine.getMaxThreadCount(true);
    }

    public int getPoolSize() {
        return this.workerThreads + this.isolationThreads;
    }

    public int getNormalPoolSize() {
        return this.workerThreads;
    }

    public int getIsolatedPoolSize() {
        return this.isolationThreads;
    }

    public void setDrain(boolean isdrain) {
        this.drain = isdrain;
        this.isoEngine.setDrain(isdrain);
    }

    public int getMaxIsolatedSeqIDs() {
        return this.isoEngine.getMaxIsolatedSeqIDs();
    }

    public String startThreads(String threadID) {
        StringBuffer buffer = new StringBuffer();
        int count = 0;
        if (threadID.equalsIgnoreCase("all")) {
            for (int i = 0; i < this.workerThreads; ++i) {
                if (this.threadsIndexMap.contains(i)) continue;
                TaskDispatcher taskDispatcher = new TaskDispatcher(this.tmName, this.teName, this.currentQueueMap.get(i), i, true);
                taskDispatcher.start();
                this.threadsMap.put(taskDispatcher, 0);
                this.threadsIndexMap.put(i, taskDispatcher);
                if (count++ == 0) {
                    buffer.append("started ");
                }
                buffer.append(i).append(",");
            }
            if (count == 0) {
                buffer.append("All Threads are available");
            } else {
                buffer.deleteCharAt(buffer.length() - 1);
                buffer.append(" threads");
                buffer.toString();
            }
        } else {
            try {
                int i = Integer.parseInt(threadID);
                if (i < this.workerThreads && i >= 0) {
                    if (!this.threadsIndexMap.contains(i)) {
                        TaskDispatcher taskDispatcher = new TaskDispatcher(this.tmName, this.teName, this.currentQueueMap.get(i), i, true);
                        taskDispatcher.start();
                        this.threadsMap.put(taskDispatcher, 0);
                        this.threadsIndexMap.put(i, taskDispatcher);
                        buffer.append("started ").append(i).append(" thread");
                    }
                } else {
                    buffer.append("Invalid thread id");
                }
            }
            catch (NumberFormatException e) {
                buffer.append("Invalid thread id");
            }
        }
        return buffer.toString();
    }

    public String getThreadStatus() {
        StringBuffer buffer = new StringBuffer();
        String str = "";
        int count = 0;
        for (int i = 0; i < this.workerThreads; ++i) {
            if (this.threadsIndexMap.contains(i)) continue;
            buffer.append(i).append(",");
            ++count;
        }
        if (count == 0) {
            str = "All Threads are available";
        } else {
            buffer.deleteCharAt(buffer.length() - 1);
            str = buffer.toString();
        }
        return str;
    }

    public void stop() {
        this.stopEngine = true;
        for (Map.Entry<String, ConcurrentHashMap<Integer, SequentialTaskQueue>> entry : this.queuesMap.entrySet()) {
            ConcurrentHashMap<Integer, SequentialTaskQueue> versionQueueMap = entry.getValue();
            for (Map.Entry<Integer, SequentialTaskQueue> versionMapEntry : versionQueueMap.entrySet()) {
                versionMapEntry.getValue().close();
            }
        }
        this.isoEngine.stop();
    }

    public boolean isolate(String seqID) {
        return this.isoEngine.isolate(seqID);
    }

    public boolean deisolate(String seqID) {
        return this.isoEngine.deisolate(seqID);
    }

    public HashMap<String, ConcurrentHashMap<String, AtomicLong>> getIsolatedSeqIDs() {
        return this.isoEngine.getIsolatedSeqIDs();
    }

    public String enableDebug(int queueid, long duration) {
        if (this.currentQueueMap.containsKey(queueid)) {
            this.currentQueueMap.get(queueid).enableDebug(duration);
            return "Debug enabled for queue - " + queueid;
        }
        return "invalid queueID";
    }

    public String disableDebug(int queueid) {
        if (this.currentQueueMap.containsKey(queueid)) {
            this.currentQueueMap.get(queueid).disableDebug();
            return "Debug disabled for queue - " + queueid;
        }
        return "invalid queueID";
    }

    public String drainQueue(String queueID, int drainCount, boolean isIsolation) {
        int queueid;
        if (isIsolation) {
            return this.isoEngine.drainQueue(queueID, drainCount);
        }
        try {
            queueid = Integer.parseInt(queueID);
        }
        catch (NumberFormatException e) {
            return "invalid queue id";
        }
        if (this.currentQueueMap.containsKey(queueid)) {
            SequentialTaskQueue queue = this.currentQueueMap.get(queueid);
            int previousSize = queue.size();
            logger.info("VS --> drain initiated taskmanager - " + this.tmName + " taskengine - " + this.teName + " queueID - " + queueID + " drainCount - " + drainCount + " queue size - " + previousSize);
            String result = queue.drop(drainCount);
            logger.info("VS --> drain completed taskmanager - " + this.tmName + " taskengine - " + this.teName + " queueID - " + queueID + " drainCount - " + drainCount + " queue size - " + queue.size());
            StatsDB.addDataInstant(System.currentTimeMillis(), "drainstats", DC.getServertype(), DC.getCluster(), this.tmName, this.teName, queueID, previousSize - queue.size());
            return result;
        }
        return "invalid queue id";
    }

    public String blockEngine() {
        if (this.isBlocked) {
            return "TaskEngine - " + this.teName + " is already blocked";
        }
        for (String task : this.taskMap.keySet()) {
            if (this.blockedTaskMap.containsKey(task)) continue;
            this.blockedTaskMap.put(this.teName + "." + task, new AtomicLong());
        }
        this.isBlocked = true;
        return "Blocked TaskEngine - " + this.teName;
    }

    public String blockTask(String task) {
        if (this.isBlocked) {
            return "TaskEngine - " + this.teName + " is blocked";
        }
        if (!this.taskMap.containsKey(task)) {
            return "invalid task";
        }
        if (!this.blockedTaskMap.containsKey(this.teName + "." + task)) {
            this.blockedTaskMap.put(this.teName + "." + task, new AtomicLong());
            return "Blocked Task - " + this.teName + "." + task;
        }
        return "Task - " + this.teName + "." + task + " is alredy blocked";
    }

    public String dropTask(String task, int count) {
        if (count <= 0) {
            return "Invalid count - " + count;
        }
        if (this.isBlocked) {
            return "TaskEngine - " + this.teName + " is blocked";
        }
        if (!this.taskMap.containsKey(task)) {
            return "invalid task";
        }
        this.droppedTaskMap.put(this.teName + "." + task, new AtomicLong(count));
        return "Dropped Task - " + this.teName + "." + task;
    }

    public String blockRkey(String rkey) {
        for (String opr : this.blockedRKeyMap.keySet()) {
            this.blockedRKeyMap.get(opr).put(rkey, new AtomicLong());
        }
        return "Blocked Rkey - " + rkey;
    }

    public String blockRkey(String rkey, String task) {
        if (!this.taskMap.containsKey(task)) {
            return "invalid task";
        }
        this.blockedRKeyMap.get(this.teName + "." + task).put(rkey, new AtomicLong());
        return "RKey - " + rkey + " is blocked";
    }

    public String blockPrd(String prd) {
        for (String opr : this.blockedPrdMap.keySet()) {
            this.blockedPrdMap.get(opr).put(prd, new AtomicLong());
        }
        return "Blocked prd - " + prd;
    }

    public String blockPrd(String prd, String task) {
        if (!this.taskMap.containsKey(task)) {
            return "invalid task";
        }
        this.blockedPrdMap.get(this.teName + "." + task).put(prd, new AtomicLong());
        return "Prd - " + prd + " is blocked";
    }

    public String unblockEngine() {
        if (!this.isBlocked) {
            return "TaskEngine - " + this.teName + " is already unblocked";
        }
        this.blockedTaskMap = new ConcurrentHashMap();
        this.isBlocked = false;
        return "Unblocked TaskEngine - " + this.teName;
    }

    public String unblockTask(String task) {
        if (this.isBlocked) {
            return "TaskEngine - " + this.teName + " is blocked";
        }
        if (!this.taskMap.containsKey(task)) {
            return "invalid task";
        }
        if (this.blockedTaskMap.containsKey(this.teName + "." + task)) {
            this.blockedTaskMap.remove(this.teName + "." + task);
            return "Unblocked Task - " + this.teName + "." + task;
        }
        return "Task - " + this.teName + "." + task + " is not blocked";
    }

    public String unblockRkey(String rkey) {
        for (String opr : this.blockedRKeyMap.keySet()) {
            this.blockedRKeyMap.get(opr).remove(rkey);
        }
        return "UnBlocked Rkey - " + rkey;
    }

    public String unblockRkey(String rkey, String task) {
        if (!this.taskMap.containsKey(task)) {
            return "invalid task";
        }
        this.blockedRKeyMap.get(this.teName + "." + task).remove(rkey);
        return "RKey - " + rkey + " is unblocked";
    }

    public String unblockPrd(String prd) {
        for (String opr : this.blockedPrdMap.keySet()) {
            this.blockedPrdMap.get(opr).remove(prd);
        }
        return "UnBlocked prd - " + prd;
    }

    public String unblockPrd(String prd, String task) {
        if (!this.taskMap.containsKey(task)) {
            return "invalid task";
        }
        this.blockedPrdMap.get(this.teName + "." + task).remove(prd);
        return "Prd - " + prd + " is unblocked";
    }

    public ConcurrentHashMap<String, Object> getBlockedStatus() {
        ConcurrentHashMap<String, Object> map = new ConcurrentHashMap<String, Object>();
        if (!this.blockedTaskMap.isEmpty()) {
            map.put("task", this.blockedTaskMap);
        }
        ConcurrentHashMap<String, ConcurrentHashMap<String, AtomicLong>> rkeyMap = new ConcurrentHashMap<String, ConcurrentHashMap<String, AtomicLong>>();
        rkeyMap.putAll(this.blockedRKeyMap);
        for (Map.Entry entry : rkeyMap.entrySet()) {
            if (!((ConcurrentHashMap)entry.getValue()).isEmpty()) continue;
            rkeyMap.remove(entry.getKey());
        }
        if (!rkeyMap.isEmpty()) {
            map.put("rkey", rkeyMap);
        }
        ConcurrentHashMap<String, ConcurrentHashMap<String, AtomicLong>> prdMap = new ConcurrentHashMap<String, ConcurrentHashMap<String, AtomicLong>>();
        prdMap.putAll(this.blockedPrdMap);
        for (Map.Entry entry : prdMap.entrySet()) {
            if (!((ConcurrentHashMap)entry.getValue()).isEmpty()) continue;
            prdMap.remove(entry.getKey());
        }
        if (!prdMap.isEmpty()) {
            map.put("prd", prdMap);
        }
        return map;
    }

    public Hashtable<String, Hashtable<String, String>> getIsolationQueueStats() {
        return this.isoEngine.getIsolationQueueStats();
    }

    public int getQueueSize() {
        int size = 0;
        for (SequentialTaskQueue que : this.currentQueueMap.values()) {
            size += que.size();
        }
        return size += this.isoEngine.getQueueSize();
    }

    public void handle(WmsEvent event) {
        if (this.stopEngine) {
            StatsDB.addData("stopengine", DC.getServertype(), DC.getCluster(), this.tmName, this.teName, event.getOpr(), 1);
            StatsDB.recordError(ComponentConstants.TES.getModuleCode(), ComponentConstants.TES.TE_HANDLE_STOPPED.getErrorCode(), 1L);
            return;
        }
        if (this.isBlocked(event)) {
            return;
        }
        String seqID = event.getSeqID();
        if (seqID == null) {
            seqID = "null";
            event.putHeader("seqID", seqID);
        }
        try {
            if (this.seqIDTracker.containsKey(seqID)) {
                this.seqIDTracker.get(seqID).incrementAndGet();
            } else {
                this.seqIDTracker.put(seqID, new AtomicLong(1L));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.currentQueueMap.get(Math.abs(seqID.hashCode() % this.workerThreads)).add(event);
    }

    public boolean chain(WmsEvent event) {
        if (this.stopEngine) {
            StatsDB.addData("stopengine", DC.getServertype(), DC.getCluster(), this.tmName, this.teName, event.getOpr(), 1);
            StatsDB.recordError(ComponentConstants.TES.getModuleCode(), ComponentConstants.TES.TE_CHAIN_STOPPED.getErrorCode(), 1L);
            return false;
        }
        if (this.isBlocked(event)) {
            return false;
        }
        try {
            if (event.getOpr() == null) {
                throw new WMSEventException("Operation Not Defined");
            }
            WmsTask task = this.taskMap.get(event.getOpr().split("\\.")[1]);
            if (task == null) {
                StatsDB.recordError(ComponentConstants.TES.getModuleCode(), ComponentConstants.TES.INVALID_TASK.getErrorCode(), 1L);
                logger.log(Level.SEVERE, "TES_ERR --> INVALID_TASK Task {0} not found task manager - {1}", new Object[]{event.getOpr(), this.tmName});
                throw new WMSTaskNotFoundException("Task " + event.getOpr() + " not found");
            }
            if (!event.isBounced()) {
                event.putData("inqueuetime", (Object)("" + System.currentTimeMillis()));
                task.handle(event);
                return true;
            }
        }
        catch (Exception exp) {
            logger.log(Level.SEVERE, " TE_HANDLE_EXP Unable to chain task : " + exp.getMessage() + " : " + event.getOpr(), exp);
            StatsDB.recordError(ComponentConstants.TES.getModuleCode(), ComponentConstants.TES.TE_HANDLE_EXP.getErrorCode(), 1L);
        }
        return false;
    }

    public Hashtable<String, String> getStats() {
        int in = 0;
        int out = 0;
        int size = 0;
        int waiting = 0;
        for (SequentialTaskQueue que : this.currentQueueMap.values()) {
            if (que == null) continue;
            Hashtable<String, String> stats = que.getStats();
            in += Integer.parseInt(stats.get("in"));
            out += Integer.parseInt(stats.get("out"));
            size += Integer.parseInt(stats.get("size"));
            waiting += Integer.parseInt(stats.get("waitingthreads"));
        }
        Hashtable<String, String> isolationStats = this.isoEngine.getStats();
        out += Integer.parseInt("" + isolationStats.get("out"));
        waiting += Integer.parseInt("" + isolationStats.get("waitingthreads"));
        boolean overflow = (size += Integer.parseInt("" + isolationStats.get("size"))) > this.workerThreads * this.inMemBufSize;
        Hashtable<String, String> returnhash = new Hashtable<String, String>();
        returnhash.put("in", "" + (in += Integer.parseInt("" + isolationStats.get("in"))));
        returnhash.put("out", "" + out);
        returnhash.put("size", "" + size);
        returnhash.put("overflow", "" + overflow);
        returnhash.put("waitingthreads", "" + waiting);
        returnhash.put("totalthreads", "" + (this.threadCount.get() + this.isoEngine.getActiveThreadCount()));
        return returnhash;
    }

    public void clearStats() {
        for (SequentialTaskQueue que : this.currentQueueMap.values()) {
            if (que == null) continue;
            que.clearStats();
        }
        this.isoEngine.clearStats();
    }

    public ArrayList<Hashtable<String, String>> getWmsQStats() {
        ArrayList<Hashtable<String, String>> qstats = new ArrayList<Hashtable<String, String>>();
        long in = 0L;
        long out = 0L;
        long size = 0L;
        long createdfiles = 0L;
        long proccesdfiles = 0L;
        long savetofiletime = 0L;
        long loadfromfiletime = 0L;
        long remainingfiles = 0L;
        for (SequentialTaskQueue que : this.currentQueueMap.values()) {
            if (que == null) continue;
            Hashtable<String, String> stats = que.getWmsQStats();
            in += Long.parseLong("" + stats.get("in"));
            out += Long.parseLong("" + stats.get("out"));
            size += Long.parseLong("" + stats.get("size"));
            createdfiles += Long.parseLong("" + stats.get("createdfiles"));
            proccesdfiles += Long.parseLong("" + stats.get("proccesdfiles"));
            savetofiletime += Long.parseLong("" + stats.get("savetofiletime"));
            loadfromfiletime += Long.parseLong("" + stats.get("loadfromfiletime"));
            remainingfiles += Long.parseLong("" + stats.get("remainingfiles"));
        }
        Hashtable<String, String> isolationStats = this.isoEngine.getWmsQStats();
        boolean overflow = size > (long)(this.workerThreads * this.inMemBufSize);
        Hashtable<String, String> returnhash = new Hashtable<String, String>();
        returnhash.put("in", "" + in);
        returnhash.put("out", "" + out);
        returnhash.put("size", "" + size);
        returnhash.put("bqname", "seq-" + this.teName);
        returnhash.put("overflow", "" + overflow);
        returnhash.put("createdfiles", "" + createdfiles);
        returnhash.put("proccesdfiles", "" + proccesdfiles);
        returnhash.put("savetofiletime", "" + savetofiletime);
        returnhash.put("loadfromfiletime", "" + loadfromfiletime);
        returnhash.put("remainingfiles", "" + remainingfiles);
        qstats.add(returnhash);
        qstats.add(isolationStats);
        return qstats;
    }

    private boolean isBlocked(WmsEvent event) {
        if (event.getOpr() == null) {
            ServerUtil.logExternal(event, "delegate", "event_opr_not_present");
            return true;
        }
        if (this.blockedTaskMap.containsKey(event.getOpr())) {
            try {
                this.blockedTaskMap.get(event.getOpr()).incrementAndGet();
            }
            catch (NullPointerException e) {
                logger.fine("NullPointerException --> " + e.getMessage());
            }
            ServerUtil.logExternal(event, "delegate", "event_dropped_opr_blocked");
            StatsDB.addData("blockedevents", DC.getServertype(), DC.getCluster(), this.tmName, this.teName, event.getOpr(), 1);
            return true;
        }
        if (event.getRKey() != null && this.blockedRKeyMap.get(event.getOpr()).containsKey(event.getRKey())) {
            try {
                this.blockedRKeyMap.get(event.getOpr()).get(event.getRKey()).incrementAndGet();
            }
            catch (NullPointerException e) {
                logger.fine("NullPointerException --> " + e.getMessage());
            }
            ServerUtil.logExternal(event, "delegate", "event_dropped_rkey_blocked");
            StatsDB.addData("blockedevents", DC.getServertype(), DC.getCluster(), this.tmName, this.teName, event.getOpr(), 1);
            return true;
        }
        if (event.getDataAsString("prd") != null && this.blockedPrdMap.get(event.getOpr()).containsKey(event.getDataAsString("prd"))) {
            try {
                this.blockedPrdMap.get(event.getOpr()).get(event.getDataAsString("prd")).incrementAndGet();
            }
            catch (NullPointerException e) {
                logger.fine("NullPointerException --> " + e.getMessage());
            }
            ServerUtil.logExternal(event, "delegate", "event_dropped_prd_blocked");
            StatsDB.addData("blockedevents", DC.getServertype(), DC.getCluster(), this.tmName, this.teName, event.getOpr(), 1);
            return true;
        }
        if (event.getExpiryTime() > 0L && event.getExpiryTime() < System.currentTimeMillis()) {
            ServerUtil.logExternal(event, "delegate", "event_dropped_ttl");
            StatsDB.addData("droppedevents", DC.getServertype(), DC.getCluster(), this.tmName, this.teName, event.getOpr(), 1);
            return true;
        }
        return false;
    }

    private static void deleteRecursive(File file) {
        if (file.isDirectory()) {
            for (File subfiles : file.listFiles()) {
                SequentialTaskEngine.deleteRecursive(subfiles);
            }
        }
        file.delete();
    }

    public String toString() {
        return "Task Engine : " + this.teName + " - " + this.inMemBufSize + " - " + this.workerThreads;
    }

    private static class LruCacheMap<K, V>
    extends LinkedHashMap<K, V> {
        private final int maxEntries;

        public LruCacheMap(int maxEntries) {
            super(maxEntries + 1, 1.0f, true);
            this.maxEntries = maxEntries;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return super.size() > this.maxEntries;
        }
    }

    class VersionControler
    extends Thread {
        public VersionControler() {
            this.setName("TES/" + SequentialTaskEngine.this.tesVersion + "-" + SequentialTaskEngine.this.tmName + "-" + SequentialTaskEngine.this.teName + "-versioncontroler");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block40: {
                try {
                    Properties versionDetails = ServerUtil.getProperties(SequentialTaskEngine.this.seqDir + SequentialTaskEngine.this.teName + ".meta");
                    logger.info("VS --> versionDetails = " + versionDetails + " for taskmanager - " + SequentialTaskEngine.this.tmName + " taskengine - " + SequentialTaskEngine.this.teName);
                    if (versionDetails != null) {
                        String versions = versionDetails.get("versions").toString();
                        ArrayList versionList = CommonUtil.getList((String)versions);
                        ConcurrentHashMap<Integer, SequentialTaskQueue> map = null;
                        for (String version : versionList) {
                            if (!versionDetails.containsKey(version)) continue;
                            int queueSize = Integer.parseInt((String)versionDetails.get(version));
                            map = new ConcurrentHashMap();
                            for (int i = 0; i < queueSize; ++i) {
                                SequentialTaskQueue que = new SequentialTaskQueue(SequentialTaskEngine.this.tmName, SequentialTaskEngine.this.teName + "-" + i, SequentialTaskEngine.this.inMemBufSize, SequentialTaskEngine.this.isAREnabled, version);
                                map.put(i, que);
                            }
                            SequentialTaskEngine.this.queuesMap.put(version, map);
                        }
                        if (map == null) {
                            map = new ConcurrentHashMap<Integer, SequentialTaskQueue>();
                        }
                        if (map.size() == SequentialTaskEngine.this.workerThreads) {
                            SequentialTaskEngine.this.currentQueueMap = map;
                        } else {
                            map = new ConcurrentHashMap();
                            String version = Long.toString(System.currentTimeMillis());
                            for (int i = 0; i < SequentialTaskEngine.this.workerThreads; ++i) {
                                SequentialTaskQueue que = new SequentialTaskQueue(SequentialTaskEngine.this.tmName, SequentialTaskEngine.this.teName + "-" + i, SequentialTaskEngine.this.inMemBufSize, SequentialTaskEngine.this.isAREnabled, version);
                                map.put(i, que);
                            }
                            SequentialTaskEngine.this.queuesMap.put(version, map);
                            versions = versions + "," + version;
                            versionList.add(version);
                            versionDetails.setProperty("versions", versions);
                            versionDetails.setProperty(version, Long.toString(SequentialTaskEngine.this.workerThreads));
                            SequentialTaskEngine.this.currentQueueMap = map;
                            try {
                                versionDetails.store(new FileOutputStream(SequentialTaskEngine.this.seqDir + SequentialTaskEngine.this.teName + ".meta"), null);
                            }
                            catch (IOException e) {
                                logger.log(Level.SEVERE, "VS_ERR --> Exception in writing properties", e);
                            }
                            logger.info("VS --> New Version created versionID = " + version + " workers count = " + SequentialTaskEngine.this.workerThreads);
                        }
                        logger.info("VS --> Seq queuesMap = " + SequentialTaskEngine.this.queuesMap + " for taskmanager - " + SequentialTaskEngine.this.tmName + " taskengine - " + SequentialTaskEngine.this.teName);
                        try {
                            SequentialTaskEngine.this.versionLock.lock();
                            SequentialTaskEngine.this.versionCondition.signal();
                        }
                        finally {
                            SequentialTaskEngine.this.versionLock.unlock();
                        }
                        block28: for (int i = 0; i < versionList.size() - 1; ++i) {
                            String version;
                            version = (String)versionList.get(i);
                            if (!versionDetails.containsKey(version)) continue;
                            long time = System.currentTimeMillis();
                            logger.info("VS --> taskmanager - " + SequentialTaskEngine.this.tmName + " taskengine - " + SequentialTaskEngine.this.teName + " draining version id - " + version);
                            int queueSize = Integer.parseInt((String)versionDetails.get(version));
                            ConcurrentHashMap versionQueuemap = (ConcurrentHashMap)SequentialTaskEngine.this.queuesMap.get(version);
                            for (int j = 0; j < queueSize; ++j) {
                                TaskDispatcher taskDispatcher = new TaskDispatcher(SequentialTaskEngine.this.tmName, SequentialTaskEngine.this.teName, (SequentialTaskQueue)versionQueuemap.get(j), j, false);
                                taskDispatcher.start();
                                SequentialTaskEngine.this.threadsMap.put(taskDispatcher, 0);
                                SequentialTaskEngine.this.threadsIndexMap.put(j, taskDispatcher);
                            }
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException e) {
                                logger.fine("InterruptedException int VersionControler");
                            }
                            while (SequentialTaskEngine.this.threadCount.get() != 0) {
                                try {
                                    Thread.sleep(1000L);
                                }
                                catch (InterruptedException e) {
                                    logger.fine("InterruptedException int VersionControler");
                                }
                                if (!SequentialTaskEngine.this.stopEngine) continue;
                                break block28;
                            }
                            logger.info("VS --> taskmanager - " + SequentialTaskEngine.this.tmName + " taskengine - " + SequentialTaskEngine.this.teName + "version id = " + version + " is drained in " + (System.currentTimeMillis() - time) + " ms ");
                            versionDetails.remove(version);
                            ArrayList list = CommonUtil.getList((String)versions);
                            list.remove(version);
                            versionDetails.setProperty("versions", CommonUtil.getString((ArrayList)list));
                            try {
                                versionDetails.store(new FileOutputStream(SequentialTaskEngine.this.seqDir + SequentialTaskEngine.this.teName + ".meta"), null);
                            }
                            catch (IOException e) {
                                logger.log(Level.SEVERE, "VS_ERR --> Exception in writing properties", e);
                            }
                            SequentialTaskEngine.this.queuesMap.remove(version);
                            SequentialTaskEngine.deleteRecursive(new File(ServerUtil.dataHome + "newbqueue" + File.separator + "tes" + File.separator + SequentialTaskEngine.this.tmName + File.separator + version + File.separator));
                        }
                        if (!SequentialTaskEngine.this.stopEngine) {
                            String version = (String)versionList.get(versionList.size() - 1);
                            int queueSize = Integer.parseInt((String)versionDetails.get(version));
                            ConcurrentHashMap versionQueuemap = (ConcurrentHashMap)SequentialTaskEngine.this.queuesMap.get(version);
                            for (int j = 0; j < queueSize; ++j) {
                                TaskDispatcher taskDispatcher = new TaskDispatcher(SequentialTaskEngine.this.tmName, SequentialTaskEngine.this.teName, (SequentialTaskQueue)versionQueuemap.get(j), j, true);
                                taskDispatcher.start();
                                SequentialTaskEngine.this.threadsMap.put(taskDispatcher, 0);
                                SequentialTaskEngine.this.threadsIndexMap.put(j, taskDispatcher);
                            }
                            versionDetails.setProperty("versions", version);
                            try {
                                versionDetails.store(new FileOutputStream(SequentialTaskEngine.this.seqDir + SequentialTaskEngine.this.teName + ".meta"), null);
                            }
                            catch (IOException e) {
                                logger.log(Level.SEVERE, "VS_ERR --> Exception in writing properties", e);
                            }
                        }
                        break block40;
                    }
                    SequentialTaskEngine.this.currentQueueMap = new ConcurrentHashMap();
                    String version = Long.toString(System.currentTimeMillis());
                    for (int i = 0; i < SequentialTaskEngine.this.workerThreads; ++i) {
                        SequentialTaskQueue que = new SequentialTaskQueue(SequentialTaskEngine.this.tmName, SequentialTaskEngine.this.teName + "-" + i, SequentialTaskEngine.this.inMemBufSize, SequentialTaskEngine.this.isAREnabled, version);
                        SequentialTaskEngine.this.currentQueueMap.put(i, que);
                        TaskDispatcher taskDispatcher = new TaskDispatcher(SequentialTaskEngine.this.tmName, SequentialTaskEngine.this.teName, que, i, true);
                        taskDispatcher.start();
                        SequentialTaskEngine.this.threadsMap.put(taskDispatcher, 0);
                        SequentialTaskEngine.this.threadsIndexMap.put(i, taskDispatcher);
                    }
                    versionDetails = new Properties();
                    versionDetails.setProperty("versions", version);
                    versionDetails.setProperty(version, Long.toString(SequentialTaskEngine.this.workerThreads));
                    SequentialTaskEngine.this.queuesMap.put(version, SequentialTaskEngine.this.currentQueueMap);
                    try {
                        versionDetails.store(new FileOutputStream(SequentialTaskEngine.this.seqDir + SequentialTaskEngine.this.teName + ".meta"), null);
                    }
                    catch (IOException e) {
                        logger.log(Level.SEVERE, "VS_ERR --> Exception in writing properties", e);
                    }
                    logger.info("VS --> New Version created versionID = " + version + " workers count = " + SequentialTaskEngine.this.workerThreads);
                    try {
                        SequentialTaskEngine.this.versionLock.lock();
                        SequentialTaskEngine.this.versionCondition.signal();
                    }
                    finally {
                        SequentialTaskEngine.this.versionLock.unlock();
                    }
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "VS_ERR --> Exception in VersionController for SequentialTaskEngine ", e);
                    SequentialTaskEngine.this.currentQueueMap = new ConcurrentHashMap();
                    String version = Long.toString(System.currentTimeMillis());
                    for (int i = 0; i < SequentialTaskEngine.this.workerThreads; ++i) {
                        SequentialTaskQueue que = new SequentialTaskQueue(SequentialTaskEngine.this.tmName, SequentialTaskEngine.this.teName + "-" + i, SequentialTaskEngine.this.inMemBufSize, SequentialTaskEngine.this.isAREnabled, version);
                        SequentialTaskEngine.this.currentQueueMap.put(i, que);
                        TaskDispatcher taskDispatcher = new TaskDispatcher(SequentialTaskEngine.this.tmName, SequentialTaskEngine.this.teName, que, i, true);
                        taskDispatcher.start();
                        SequentialTaskEngine.this.threadsMap.put(taskDispatcher, 0);
                        SequentialTaskEngine.this.threadsIndexMap.put(i, taskDispatcher);
                    }
                    Properties versionDetails = new Properties();
                    versionDetails.setProperty("versions", version);
                    versionDetails.setProperty(version, Long.toString(SequentialTaskEngine.this.workerThreads));
                    SequentialTaskEngine.this.queuesMap.put(version, SequentialTaskEngine.this.currentQueueMap);
                    try {
                        versionDetails.store(new FileOutputStream(SequentialTaskEngine.this.seqDir + SequentialTaskEngine.this.teName + ".meta"), null);
                    }
                    catch (IOException exp) {
                        logger.log(Level.SEVERE, "VS_ERR --> Exception in writing properties", exp);
                    }
                    logger.info("VS --> New Version created versionID = " + version + " workers count = " + SequentialTaskEngine.this.workerThreads);
                    try {
                        SequentialTaskEngine.this.versionLock.lock();
                        SequentialTaskEngine.this.versionCondition.signal();
                    }
                    finally {
                        SequentialTaskEngine.this.versionLock.unlock();
                    }
                }
            }
        }
    }

    class SequentialTaskQueue {
        private BufferedQueue bq;
        private String queueName;
        private boolean isDebugEnabled = false;
        private long debugEnabledTime;
        private long debugDuration;

        public SequentialTaskQueue(String tmName, String queueName, int inMemBufSize, boolean isAREnabled, String version) {
            this.queueName = queueName;
            this.bq = new BufferedQueue(ServerUtil.dataHome + "newbqueue" + File.separator + "tes" + File.separator + tmName + File.separator + SequentialTaskEngine.this.teName + File.separator + "normal" + File.separator + version + File.separator + queueName + "_tmp", queueName, inMemBufSize, isAREnabled);
        }

        public void add(WmsEvent event) {
            this.bq.add(event);
        }

        public WmsEvent remove() {
            WmsEvent event = null;
            event = (WmsEvent)this.bq.poll();
            if (this.isDebugEnabled) {
                if (event != null) {
                    StatsDB.addData("seqdebug", DC.getServertype(), DC.getCluster(), SequentialTaskEngine.this.tmName, SequentialTaskEngine.this.teName, event.getOpr(), event.getSeqID(), 1);
                }
                if (System.currentTimeMillis() - this.debugEnabledTime > this.debugDuration) {
                    this.isDebugEnabled = false;
                }
            }
            return event;
        }

        public WmsEvent poll() {
            WmsEvent event = null;
            event = (WmsEvent)this.bq.poll(500L);
            return event;
        }

        public String drop(int drainCount) {
            if (drainCount < -1) {
                return "invalid count";
            }
            if (drainCount == -1 ? this.bq.dropAll() : this.bq.drop(drainCount)) {
                return "Drain completed for " + this.queueName;
            }
            return "Drain failed for " + this.queueName;
        }

        public int size() {
            return this.bq.size();
        }

        public boolean isEmpty() {
            return this.bq.isEmpty();
        }

        public Hashtable<String, String> getStats() {
            return this.bq.getStats();
        }

        public Hashtable<String, String> getWmsQStats() {
            return this.bq.getWmsQStats();
        }

        public void clearStats() {
            this.bq.clearStats();
        }

        public void open() {
            this.bq.open();
        }

        public void close() {
            this.bq.close();
        }

        public String getname() {
            return this.queueName;
        }

        protected void enableDebug(long debugDuration) {
            this.isDebugEnabled = true;
            this.debugDuration = debugDuration;
            this.debugEnabledTime = System.currentTimeMillis();
        }

        protected void disableDebug() {
            this.isDebugEnabled = false;
        }
    }

    class TaskDispatcher
    extends Thread {
        private int index;
        private String teName;
        private String tmName;
        private boolean isCurrentVersion;
        private SequentialTaskQueue queue;
        private boolean dispatchTask;
        private AtomicInteger processedCount;

        public TaskDispatcher(String tmName, String teName, SequentialTaskQueue queue, int index, boolean isCurrentVersion) {
            super("TES/" + SequentialTaskEngine.this.tesVersion + "-" + tmName + "-" + teName + "-" + index);
            this.dispatchTask = true;
            this.tmName = tmName;
            this.queue = queue;
            this.index = index;
            this.teName = teName;
            this.isCurrentVersion = isCurrentVersion;
            this.processedCount = new AtomicInteger();
        }

        @Override
        public void run() {
            SequentialTaskEngine.this.threadCount.incrementAndGet();
            while (this.dispatchTask) {
                WmsEvent event = null;
                try {
                    WmsTask task;
                    if (!this.isCurrentVersion) {
                        event = this.queue.poll();
                        if (event == null && this.queue.isEmpty()) {
                            this.dispatchTask = false;
                            continue;
                        }
                    } else {
                        event = this.queue.remove();
                    }
                    if (event == null || SequentialTaskEngine.this.isBlocked(event)) continue;
                    String opr = event.getOpr();
                    if (SequentialTaskEngine.this.droppedTaskMap.containsKey(opr)) {
                        try {
                            long count = ((AtomicLong)SequentialTaskEngine.this.droppedTaskMap.get(opr)).decrementAndGet();
                            if (count > 0L) continue;
                            SequentialTaskEngine.this.droppedTaskMap.remove(opr);
                        }
                        catch (NullPointerException e) {
                            logger.fine("NullPointerException --> " + e.getMessage());
                        }
                        continue;
                    }
                    this.processedCount.incrementAndGet();
                    SequentialTaskEngine.this.activeThreadCount.incrementAndGet();
                    String seqID = event.getSeqID();
                    AtomicLong count = SequentialTaskEngine.this.seqIDTracker.get(seqID);
                    if (count == null) {
                        count = new AtomicLong(1L);
                    }
                    if (count.decrementAndGet() == 0L) {
                        SequentialTaskEngine.this.seqIDTracker.remove(seqID);
                    }
                    if (SequentialTaskEngine.this.isoEngine.addIfIsolated(event, seqID)) {
                        SequentialTaskEngine.this.activeThreadCount.decrementAndGet();
                        continue;
                    }
                    if (count != null && count.get() > (long)SequentialTaskEngine.this.isoThreshold && SequentialTaskEngine.this.isoEngine.add(event, seqID)) {
                        SequentialTaskEngine.this.activeThreadCount.decrementAndGet();
                        continue;
                    }
                    long inqtime = -1L;
                    if (event.getData("inqueuetime") != null) {
                        inqtime = Long.parseLong((String)event.getData("inqueuetime"));
                    }
                    if ((task = (WmsTask)SequentialTaskEngine.this.taskMap.get(opr.split("\\.")[1])) == null) {
                        StatsDB.recordError(ComponentConstants.TES.getModuleCode(), ComponentConstants.TES.INVALID_TASK.getErrorCode(), 1L);
                        logger.log(Level.SEVERE, "TES_ERR --> INVALID_TASK Task {0} not found task manager - {1}", new Object[]{event.getOpr(), this.tmName});
                        continue;
                    }
                    WmsTask.setAsIsolatedTask(false);
                    long stime = System.currentTimeMillis();
                    String handleType = "";
                    try {
                        if (SequentialTaskEngine.this.drain) {
                            handleType = "drain";
                            task.handleDrain(event);
                        } else if (event.isBounced()) {
                            handleType = "bounce";
                            task.handleBounce(event.getBounceDetails(), event);
                        } else if (Boolean.parseBoolean(event.getHeader("isdeferredevent"))) {
                            handleType = "defer";
                            task.handle((List)event.getData("desdata"));
                        } else {
                            handleType = "handle";
                            task.handle(event);
                        }
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "TES_ERR --> TE_HANDLE_EXP Exception while handling Sequential Task Engine: opr - " + event.getOpr() + " isBounced - " + event.isBounced() + " drain - " + SequentialTaskEngine.this.drain, e);
                        StatsDB.recordError(ComponentConstants.TES.getModuleCode(), ComponentConstants.TES.TE_HANDLE_EXP.getErrorCode(), 1L);
                    }
                    catch (Error e) {
                        if (SequentialTaskEngine.this.threadCount.decrementAndGet() == 0) {
                            SequentialTaskEngine.this.isoEngine.shutdownIsolationManager();
                        }
                        SequentialTaskEngine.this.activeThreadCount.decrementAndGet();
                        SequentialTaskEngine.this.threadCount.decrementAndGet();
                        StatsDB.recordError(ComponentConstants.TES.getModuleCode(), ComponentConstants.TES.TE_HANDLE_ERR.getErrorCode(), 1L);
                        SequentialTaskEngine.this.threadsMap.remove(this);
                        SequentialTaskEngine.this.threadsIndexMap.remove(this.index);
                        logger.log(Level.SEVERE, "VS_ERR --> TE_HANDLE_ERR Error while processing in TaskEngine in " + this.tmName + " for event opr " + event.getOpr(), e);
                        throw e;
                    }
                    finally {
                        WmsTask.clear();
                    }
                    long currenttime = System.currentTimeMillis();
                    long executiontime = currenttime - stime;
                    StatsDB.addData("taskenginetime", this.tmName, this.teName, event.getOpr(), 1, currenttime - inqtime - executiontime, executiontime);
                    StatsDB.addData("tesoutstats", DC.getServertype(), DC.getCluster(), this.tmName, this.teName, event.getOpr(), handleType, 1, currenttime - inqtime - executiontime, executiontime);
                    StatsDB.addData("seqstats", DC.getServertype(), DC.getCluster(), this.tmName, this.teName, event.getOpr(), this.index, 1, currenttime - inqtime - executiontime, executiontime);
                    ServerUtil.logExternal(event, "delegate", "event_end");
                }
                catch (Exception exp) {
                    logger.log(Level.SEVERE, "TE_PROCESS_EXP Exception in task evt: opr = " + event.getOpr() + " tmname = " + this.tmName, exp);
                    StatsDB.recordError(ComponentConstants.TES.getModuleCode(), ComponentConstants.TES.TE_PROCESS_EXP.getErrorCode(), 1L);
                    ServerUtil.logExternal(event, "delegate", "event_error:" + exp.getMessage());
                }
                SequentialTaskEngine.this.activeThreadCount.decrementAndGet();
            }
            if (SequentialTaskEngine.this.threadCount.decrementAndGet() == 0 && this.isCurrentVersion) {
                logger.info("VS --> TES_SD SeqTaskManager - " + this.tmName + " SeqTaskEngine - " + this.teName + " is shutdown");
                SequentialTaskEngine.this.isoEngine.shutdownIsolationManager();
            }
            SequentialTaskEngine.this.threadsMap.remove(this);
            SequentialTaskEngine.this.threadsIndexMap.remove(this.index);
        }

        protected void shutdown() {
            this.dispatchTask = false;
        }
    }
}

