/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.executor;

import com.adventnet.wms.servercommon.components.executor.TaskExecutorService;
import com.adventnet.wms.servercommon.runtime.WmsRuntime;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SequentialIsolationHandler
extends WmsRuntime {
    private Logger logger = Logger.getLogger(SequentialIsolationHandler.class.getName());

    @Override
    public Hashtable getInfo(Hashtable prams) {
        Hashtable<String, Object> returnHash;
        block27: {
            returnHash = new Hashtable<String, Object>();
            try {
                if (prams == null) break block27;
                String opr = (String)prams.get("opr");
                if (opr != null) {
                    boolean result = false;
                    String tmName = (String)prams.get("taskmanager");
                    String teName = (String)prams.get("taskengine");
                    String id = (String)prams.get("id");
                    String[] seqid = id.split(",");
                    switch (opr) {
                        case "iso": {
                            for (String sid : seqid) {
                                result = tmName != null ? (teName != null ? TaskExecutorService.isolate(tmName, teName, sid) : TaskExecutorService.isolate(tmName, sid)) : TaskExecutorService.isolate(sid);
                                if (result) {
                                    returnHash.put(id + " is isolated", "");
                                    continue;
                                }
                                returnHash.put(" unable to  isolate " + id, "");
                            }
                            break block27;
                        }
                        case "deiso": {
                            for (String sid : seqid) {
                                result = tmName != null ? (teName != null ? TaskExecutorService.deisolate(tmName, teName, sid) : TaskExecutorService.deisolate(tmName, sid)) : TaskExecutorService.deisolate(sid);
                                if (result) {
                                    returnHash.put(id + " is deisolated", "");
                                    continue;
                                }
                                returnHash.put(" unable to  deisolate " + id, "");
                            }
                            break block27;
                        }
                        case "getthreads": {
                            returnHash.put("Status", TaskExecutorService.getThreadStatus(tmName, teName));
                            break;
                        }
                        case "start": {
                            returnHash.put("Status", TaskExecutorService.startThreads(tmName, teName, id));
                            break;
                        }
                        default: {
                            returnHash.put("invalid opr", "");
                        }
                    }
                    break block27;
                }
                HashMap<String, HashMap<String, HashMap<String, ConcurrentHashMap<String, AtomicLong>>>> map = TaskExecutorService.getIsolatedSeqIDs();
                Hashtable<String, Hashtable<String, Hashtable<String, Hashtable<String, String>>>> queueTable = TaskExecutorService.getSequentialIsolationQueueStats();
                for (Map.Entry<String, HashMap<String, HashMap<String, ConcurrentHashMap<String, AtomicLong>>>> managerEntry : map.entrySet()) {
                    Hashtable managerTable = new Hashtable();
                    String tmName = managerEntry.getKey();
                    HashMap<String, HashMap<String, ConcurrentHashMap<String, AtomicLong>>> managerMap = managerEntry.getValue();
                    for (Map.Entry<String, HashMap<String, ConcurrentHashMap<String, AtomicLong>>> engineEntry : managerMap.entrySet()) {
                        Hashtable<String, Object> seqIDTable = new Hashtable<String, Object>();
                        Hashtable<String, Long> autoTable = new Hashtable<String, Long>();
                        Hashtable<String, Long> manualTable = new Hashtable<String, Long>();
                        String teName = engineEntry.getKey();
                        ConcurrentHashMap<String, AtomicLong> isolatedList = engineEntry.getValue().get("auto");
                        ConcurrentHashMap<String, AtomicLong> manualIsolatedList = engineEntry.getValue().get("manual");
                        for (Map.Entry<String, AtomicLong> isoEntry : isolatedList.entrySet()) {
                            String seqID = isoEntry.getKey();
                            if (manualIsolatedList.containsKey(seqID)) {
                                manualTable.put(seqID, isoEntry.getValue().get() - 1L);
                                continue;
                            }
                            autoTable.put(seqID, isoEntry.getValue().get());
                        }
                        if (!autoTable.isEmpty()) {
                            seqIDTable.put("Auto Detected", autoTable);
                        } else {
                            seqIDTable.put("Auto Detected", "None");
                        }
                        if (!manualTable.isEmpty()) {
                            seqIDTable.put("Manual", manualTable);
                        } else {
                            seqIDTable.put("Manual", "None");
                        }
                        Hashtable<String, Hashtable<String, Object>> engineTable = new Hashtable<String, Hashtable<String, Object>>();
                        engineTable.put("seqids", seqIDTable);
                        if (queueTable.isEmpty()) continue;
                        engineTable.put("isolatedQueueStats", queueTable.get(tmName).get(teName));
                        managerTable.put(teName, engineTable);
                    }
                    returnHash.put(tmName, managerTable);
                }
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "VS--> Exception in SequentialIsolationHandler command", e);
            }
        }
        return returnHash;
    }
}

