/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.executor;

import com.adventnet.wms.common.WmsEvent;
import com.adventnet.wms.servercommon.components.executor.TaskExecutorService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DeferredDispatcher {
    private static Logger logger = Logger.getLogger(DeferredDispatcher.class.getName());
    private BlockingQueue<WmsEvent> dispatchQueue = new LinkedBlockingQueue<WmsEvent>();
    private Dispatcher dispatcher = new Dispatcher();

    public void start() {
        this.dispatcher.start();
    }

    public void dispatch(WmsEvent event) {
        this.dispatchQueue.add(event);
    }

    public int getQueueSize() {
        return this.dispatchQueue.size();
    }

    public boolean stop() {
        boolean result = false;
        int count = 0;
        long maxLimit = 333L;
        while ((long)count++ < maxLimit) {
            if (this.dispatchQueue.isEmpty()) {
                result = true;
                break;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                logger.fine("VS_ERR --> InterruptedException");
            }
        }
        this.dispatcher.shutDown();
        this.dispatcher.interrupt();
        return result;
    }

    class Dispatcher
    extends Thread {
        private boolean isthreadAlive;

        public Dispatcher() {
            super("DES/Dispatcher");
            this.isthreadAlive = true;
        }

        @Override
        public void run() {
            logger.info("VS --> DES Dispatcher started");
            while (this.isthreadAlive) {
                try {
                    WmsEvent event = (WmsEvent)DeferredDispatcher.this.dispatchQueue.take();
                    TaskExecutorService.execute(event, false);
                }
                catch (InterruptedException e) {
                    logger.fine("InterruptedException");
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "VS_ERR --> Exception in DeferredDispatcher", e);
                }
            }
            logger.info("VS --> DES Dispatcher stopped");
        }

        public void shutDown() {
            this.isthreadAlive = false;
        }
    }
}

