/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.backup.servlet;

import com.adventnet.wms.common.HttpDataWraper;
import com.adventnet.wms.servercommon.components.backup.BackupClient;
import com.adventnet.wms.servercommon.components.backup.BackupConfManager;
import com.adventnet.wms.servercommon.components.backup.wdb.BackupObject;
import com.adventnet.wms.servercommon.components.net.servlet.WCPRequest;
import com.adventnet.wms.servercommon.components.net.servlet.WCPResponse;
import com.adventnet.wms.servercommon.components.net.servlet.WCPServlet;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GetBackupList
implements WCPServlet {
    private static final Logger LOGGER = Logger.getLogger(GetBackupList.class.getName());

    @Override
    public void wcpService(WCPRequest request, WCPResponse response) throws Exception {
        int count = 0;
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            count = Integer.parseInt(request.getParam("count"));
            if (count > 0 && BackupConfManager.isBackupEnabled()) {
                if (!BackupClient.isInitialized()) {
                    BackupClient.initialize();
                }
                Hashtable<String, BackupObject> data = BackupClient.getBackupList(count);
                for (String filePath : data.keySet()) {
                    result.put(filePath, data.get(filePath).getBkpStringData());
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "SM-->[BKP][BKPEXCEPTION] Error while taking backup List in wcpservlet. Exception :{0}", new Object[]{e});
        }
        response.setResponseData(HttpDataWraper.getString(result));
        response.sendResponse();
    }
}

