/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.backup;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BackupConfManager {
    private static Logger logger = Logger.getLogger(BackupConfManager.class.getName());
    private static String storage = "chat";
    private static String folderName = "backup";
    private static boolean isBackupEnabled = false;
    private static int backupcachesize = 5000;
    private static int transmaxbuffsize = 0x200000;
    private static ArrayList backuprestoreenabledservers = new ArrayList();
    private static ArrayList backup_block_chids = new ArrayList();
    private static ArrayList restore_enabled_chids = new ArrayList();
    private static String bkpConfFile = System.getProperty("server.home") + File.separator + "conf" + File.separator + "bkpconf.properties";
    private static Properties bkpProps = new Properties();

    public static boolean initialize() {
        try {
            bkpProps.load(new FileInputStream(bkpConfFile));
            return BackupConfManager.initializeServerConfiguration();
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "BKP-->[BKPEXCEPTION] Error at ConfManager", ex);
            return false;
        }
    }

    public static boolean updateServerConfiguration(Hashtable newConf) {
        bkpProps.putAll((Map<?, ?>)newConf);
        return BackupConfManager.initializeServerConfiguration();
    }

    private static boolean initializeServerConfiguration() {
        try {
            storage = bkpProps.getProperty("storage", storage);
            folderName = bkpProps.getProperty("foldername", folderName);
            transmaxbuffsize = Integer.parseInt(bkpProps.getProperty("transmaxbuffsize", "" + transmaxbuffsize));
            backupcachesize = Integer.parseInt(bkpProps.getProperty("backupcachesize", "" + backupcachesize));
            isBackupEnabled = Boolean.parseBoolean(bkpProps.getProperty("isBackupEnabled", "" + isBackupEnabled));
            return true;
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "BKP-->[BKPEXCEPTION] Error at BKPConfManager initializeServerConfiguration", ex);
            return false;
        }
    }

    public static String getStorage() {
        return storage;
    }

    public static String getFolderName() {
        return folderName;
    }

    public static int getBackupCacheSize() {
        return backupcachesize;
    }

    public static boolean isBackupEnabled() {
        return isBackupEnabled;
    }

    public static int getTransMaxBuffSize() {
        return transmaxbuffsize;
    }
}

