/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.backup;

import com.adventnet.wms.common.HttpConnection;
import com.adventnet.wms.servercommon.components.backup.BackupClient;
import com.adventnet.wms.servercommon.components.backup.BackupClientDB;
import com.adventnet.wms.servercommon.components.backup.wdb.BackupObject;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BackupAPI {
    private static final Logger LOGGER = Logger.getLogger(BackupAPI.class.getName());

    public static void takeBackup(String filePath, BackupObject obj) {
        if (filePath != null && obj != null) {
            BackupClientDB.setCache(filePath, obj);
        } else {
            LOGGER.log(Level.SEVERE, "SM-->[BKP] Error takeBackup in BackupClient. filePath:{0} or BackupObject:{1}", new Object[]{filePath, obj});
        }
    }

    public static boolean restoreFileFromBackup(String entityID, String filePath, String destPath) {
        return BackupClient.restoreFileFromBackup(entityID, filePath, destPath);
    }

    public static boolean deleteFromBackup(String prd, String chid) {
        return BackupAPI.deleteFromBackup(prd, chid, null);
    }

    public static boolean deleteFromBackup(String prd, String chid, String remotefilePath) {
        try {
            if (BackupClient.getBkpServerIP() != null) {
                HttpConnection conn = new HttpConnection("http://" + BackupClient.getBkpServerIP() + ":6060/deletebkpfile");
                if (chid != null) {
                    conn.addParameter("chid", (Object)chid);
                }
                if (prd != null) {
                    conn.addParameter("prd", (Object)prd);
                }
                if (remotefilePath != null) {
                    conn.addParameter("remotefilePath", (Object)remotefilePath);
                }
                conn.doPost();
                if (conn.getStatusCode() == 200) {
                    LOGGER.log(Level.INFO, "SM-->[BKPDELETE] Chat deleted from backup server, chid: {0}", new Object[]{chid});
                    return true;
                }
                LOGGER.log(Level.SEVERE, "SM-->[BKPDELETE] Unable to delete chat from backup server, chid: {0}", new Object[]{chid});
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "SM-->[BKPDELETE][BKPEXCEPTION] Unable to delete chat from backup server, chid: {0} Exceptio: {1}", new Object[]{chid, ex});
        }
        return false;
    }
}

