/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.components.backup;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Backup {
    private static final Logger LOGGER = Logger.getLogger(Backup.class.getName());
    private static List<String> bsSeedsList;
    private static Map<String, List<String>> nodeBackupMap;

    public static boolean updateNBM(Map<String, List<String>> backupMap) {
        try {
            bsSeedsList = nodeBackupMap.remove("bo");
            if (bsSeedsList == null) {
                LOGGER.severe("NS --> \"BackUp - updateNBM\" -----> bkpOrder not present in map");
            }
            nodeBackupMap = backupMap;
            LOGGER.info("NS --> Successfully updated nbm " + backupMap);
            return true;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NS --> Error while updating nbm " + backupMap, e);
            return false;
        }
    }

    public static List<String> getServers() {
        String machineIP = null;
        try {
            machineIP = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            LOGGER.log(Level.SEVERE, "NS --> \"Backup - getServers()\" ----> Error in etLocalHost().getHostAddress()");
        }
        return Backup.getServers(machineIP);
    }

    public static List<String> getServers(String ip) {
        if (ip == null) {
            LOGGER.log(Level.SEVERE, "NS --> \"Backup - getServers(ip)\" ----> IP is null");
            return null;
        }
        if (nodeBackupMap != null) {
            return nodeBackupMap.get(ip);
        }
        LOGGER.severe("NS --> \"Backup - getServers(ip)\" ----> nodeBackupMap is NULL for ip=" + ip);
        return null;
    }

    public static String getBackupServer() {
        String machineIP = null;
        try {
            machineIP = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            LOGGER.log(Level.SEVERE, "NS --> \"Backup - getBackupServer()\" ----> Error in etLocalHost().getHostAddress()");
        }
        return Backup.getBackupServer(machineIP);
    }

    public static String getBackupServer(String ip) {
        if (ip == null) {
            LOGGER.log(Level.SEVERE, "NS --> \"Backup - getBackupServer(ip)\" ----> IP is null");
            return null;
        }
        if (nodeBackupMap != null) {
            for (Map.Entry<String, List<String>> entry : nodeBackupMap.entrySet()) {
                if (!entry.getValue().contains(ip)) continue;
                return entry.getKey();
            }
            return null;
        }
        LOGGER.severe("NS --> \"Backup - getBackupServer(ip)\" ----> nodeBackupMap is NULL for ip=" + ip);
        return null;
    }

    public static List<String> getSeedsList() {
        return bsSeedsList;
    }
}

