/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.cassandra.datastax.tablemodels.test;

import com.adventnet.wms.servercommon.cassandra.datastax.DatastaxSession;
import com.adventnet.wms.servercommon.cassandra.datastax.tablemodels.TimeSeriesModel;
import com.adventnet.wms.servercommon.cassandra.datastax.tablemodels.test.AbstractModelTest;
import com.adventnet.wms.servercommon.cassandra.datastax.tablemodels.test.UniqueKeyModelTest;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.utils.UUIDs;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.logging.Logger;

public class TimeSeriesModelTest
extends AbstractModelTest {
    private static final Logger LOGGER = Logger.getLogger(UniqueKeyModelTest.class.getName());
    private final TimeSeriesModel timeseriesmodel;
    private final boolean isreverse;

    public TimeSeriesModelTest(DatastaxSession dsession, boolean isthriftsupported, Integer preparetype, boolean isreverse) throws Exception {
        super(dsession, isthriftsupported, preparetype);
        this.isreverse = isreverse;
        this.init();
        this.timeseriesmodel = preparetype == null ? TimeSeriesModel.build(this.dsession, this.table, isreverse, "Key", "Column1", "Value") : TimeSeriesModel.build(this.dsession, this.table, isreverse, "Key", "Column1", "Value", preparetype, TimeSeriesModel.allPreparableIds());
    }

    @Override
    protected String getCreateTableQuery() {
        String cql = "create table \"" + this.table + "\" (\"Key\" text, \"Column1\" timeuuid, \"Value\" text, primary key (\"Key\", \"Column1\")) with COMPACT STORAGE";
        if (this.isreverse) {
            cql = cql + " AND CLUSTERING ORDER BY (\"Column1\" DESC)";
        }
        return cql + ";";
    }

    @Override
    protected void testAll() throws Exception {
        LOGGER.info("Testing all for " + this.table + " thriftsupported: " + this.isthriftsupported + " preparetype: " + this.preparetype + " isreverse: " + this.isreverse);
        this.testGets();
        this.testPuts();
        this.testGetRange();
        this.testGetAllRows();
        this.testDeletes();
    }

    void testGets() throws Exception {
        Hashtable value;
        int i;
        LOGGER.info("Testing Gets..");
        String rowkey = "1234567_tg";
        int limit = 20;
        ArrayList<String> uuids = new ArrayList<String>();
        for (i = 0; i < limit; ++i) {
            value = new Hashtable();
            value.put("key", i);
            uuids.add(this.timeseriesmodel.add(rowkey, value, 86400));
        }
        for (i = 0; i < limit; ++i) {
            value = this.timeseriesmodel.getColumn(rowkey, (String)uuids.get(i));
            TimeSeriesModelTest.dieUnless(value != null);
            TimeSeriesModelTest.dieUnless(value.size() == 1);
            TimeSeriesModelTest.dieUnless(Integer.valueOf(i).equals(value.get("key")));
        }
        String invalidcolumn = UUIDs.timeBased().toString();
        Hashtable value3 = this.timeseriesmodel.getColumn(rowkey, invalidcolumn, null);
        TimeSeriesModelTest.dieUnless(value3 == null);
        Hashtable value4 = this.timeseriesmodel.getColumn("invalidrow", invalidcolumn, null);
        TimeSeriesModelTest.dieUnless(value4 == null);
    }

    void testPuts() throws Exception {
        LOGGER.info("Testing Puts..");
        String rowkey = "1234567_tp";
        Hashtable<String, Object> test = new Hashtable<String, Object>();
        test.put("abc", 1);
        String cname = this.timeseriesmodel.add(rowkey, test, 86400, ConsistencyLevel.ONE);
        Hashtable value = this.timeseriesmodel.getColumn(rowkey, cname);
        TimeSeriesModelTest.dieUnless(value != null && value instanceof Hashtable);
        TimeSeriesModelTest.dieUnless(value.size() == 1);
        TimeSeriesModelTest.dieUnless(value.get("abc") instanceof Integer);
        TimeSeriesModelTest.dieUnless(Integer.valueOf(1).equals(value.get("abc")));
        test.put("abc", "hello");
        this.timeseriesmodel.updateColumn(rowkey, cname, test, 86400);
        TimeSeriesModelTest.dieUnless(this.timeseriesmodel.getColumn(rowkey, cname).get("abc").equals("hello"));
        String nonexistentcolumn = UUIDs.timeBased().toString();
        this.timeseriesmodel.updateColumn(rowkey, nonexistentcolumn, new Hashtable(), 86400);
        TimeSeriesModelTest.dieUnless(this.timeseriesmodel.getColumn(rowkey, nonexistentcolumn) != null);
        test = new Hashtable();
        test.put("abc", "hello");
        cname = this.timeseriesmodel.add(rowkey, test, 86400, null, 2L);
        test.put("abc", "world");
        this.timeseriesmodel.updateColumn(rowkey, cname, test, 86400, null, 1L);
        TimeSeriesModelTest.dieUnless(this.timeseriesmodel.getColumn(rowkey, cname).get("abc").equals("hello"));
    }

    void testGetRange() throws Exception {
        LOGGER.info("Testing Range Gets..");
        String rowkey = "1234567_trg_" + System.currentTimeMillis();
        int limit = 5;
        int maxcols = 11;
        String oldertimeuid = UUIDs.timeBased().toString();
        ArrayList<String> uuids = new ArrayList<String>();
        for (int i = 0; i < maxcols; ++i) {
            uuids.add(this.timeseriesmodel.add(rowkey, new Hashtable(), 86400));
        }
        String newertimeuid = UUIDs.timeBased().toString();
        String nonexisstarttimeuid = this.isreverse ? newertimeuid : oldertimeuid;
        String nonexisendtimeuid = this.isreverse ? oldertimeuid : newertimeuid;
        ArrayList arraylist = this.timeseriesmodel.getFirstN(rowkey, limit, null);
        TimeSeriesModelTest.dieUnless(!arraylist.equals(this.timeseriesmodel.getFirstN(rowkey, maxcols + 1, null)));
        TimeSeriesModelTest.dieUnless(this.timeseriesmodel.getFirstN("invalidrowkey", limit, null) == null);
        String uuid = (String)((Hashtable)arraylist.get(1)).get("_sys.cname");
        TimeSeriesModelTest.dieUnless(uuid != null);
        TimeSeriesModelTest.dieUnless(uuids.contains(uuid));
        ArrayList arraylist2 = this.timeseriesmodel.getNFromColumn(rowkey, uuid, limit, null);
        TimeSeriesModelTest.dieUnless(!arraylist2.equals(this.timeseriesmodel.getNFromColumn(rowkey, uuid, maxcols + 1, null)));
        TimeSeriesModelTest.dieUnless(this.timeseriesmodel.getNFromColumn(rowkey, nonexisendtimeuid, maxcols + 1, null) == null);
        TimeSeriesModelTest.dieUnless(this.timeseriesmodel.getNFromColumn("invalidrowkey", nonexisendtimeuid, maxcols + 1, null) == null);
        uuid = (String)uuids.get(5);
        ArrayList arraylist3 = this.timeseriesmodel.getNTillColumn(rowkey, uuid, limit, null);
        TimeSeriesModelTest.dieUnless(!arraylist3.equals(this.timeseriesmodel.getNTillColumn(rowkey, uuid, maxcols + 1, null)));
        TimeSeriesModelTest.dieUnless(this.timeseriesmodel.getNTillColumn(rowkey, nonexisstarttimeuid, maxcols + 1, null) == null);
        TimeSeriesModelTest.dieUnless(this.timeseriesmodel.getNTillColumn("invalidrowkey", nonexisstarttimeuid, maxcols + 1, null) == null);
        String startuuid = this.isreverse ? (String)uuids.get(uuids.size() - 1) : (String)uuids.get(0);
        String enduuid = this.isreverse ? (String)uuids.get(0) : (String)uuids.get(uuids.size() - 1);
        ArrayList arraylist4 = this.timeseriesmodel.getInRange(rowkey, startuuid, enduuid, null);
        TimeSeriesModelTest.dieUnlessExceptionThrown(new AbstractModelTest.TestableCode<String>(new String[]{rowkey, enduuid, startuuid}){

            @Override
            void test() throws Exception {
                TimeSeriesModelTest.this.timeseriesmodel.getInRange(((String[])this.args)[0], ((String[])this.args)[1], ((String[])this.args)[2], null);
                if (!TimeSeriesModelTest.this.dsession.isProtocolVersionV1()) {
                    throw new Exception();
                }
            }
        });
        ArrayList al1 = this.timeseriesmodel.getInRange(rowkey, startuuid, enduuid, null);
        ArrayList al2 = this.timeseriesmodel.getInRange(rowkey, nonexisstarttimeuid, nonexisendtimeuid, null);
        TimeSeriesModelTest.dieUnless(al1.equals(al2));
        TimeSeriesModelTest.dieUnlessExceptionThrown(new AbstractModelTest.TestableCode<String>(new String[]{rowkey, startuuid}){

            @Override
            public void test() throws Exception {
                TimeSeriesModelTest.this.timeseriesmodel.getInRange(((String[])this.args)[0], ((String[])this.args)[1], null, null);
            }
        });
        TimeSeriesModelTest.dieUnlessExceptionThrown(new AbstractModelTest.TestableCode<String>(new String[]{rowkey}){

            @Override
            void test() throws Exception {
                TimeSeriesModelTest.this.timeseriesmodel.getInRange(((String[])this.args)[0], "invaliduuidformat", "invaliduuidformat", null);
            }
        }, IllegalArgumentException.class);
        ArrayList rresult = this.timeseriesmodel.getNTillColumn(rowkey, enduuid, Integer.MAX_VALUE, null);
        Collections.reverse(rresult);
        TimeSeriesModelTest.dieUnless(this.timeseriesmodel.getInRange(rowkey, null, enduuid, null).equals(rresult));
        TimeSeriesModelTest.dieUnless(this.timeseriesmodel.getInRange("invalidrowkey", startuuid, enduuid, null) == null);
    }

    void testGetAllRows() throws Exception {
        ResultSet resultset;
        LOGGER.info("Testing Get All rows..");
        String rowkey = "testgetallrows";
        String column = "testcolumn";
        int i = 0;
        for (int rowindex = 1; rowindex <= 3; ++rowindex) {
            this.timeseriesmodel.add(rowkey + rowindex, new Hashtable(), 86400);
        }
        try {
            resultset = this.timeseriesmodel.getRowKeys(rowkey + 1, 10, null, null);
            for (Row row : resultset) {
                ++i;
            }
            TimeSeriesModelTest.dieUnless(i >= 3);
        }
        catch (UnsupportedOperationException e) {
            TimeSeriesModelTest.dieUnless(this.dsession.isProtocolVersionV1());
        }
        try {
            resultset = this.timeseriesmodel.getRowKeys(rowkey + 1, rowkey + 3, 10, null, null);
            for (Row row : resultset) {
                ++i;
            }
            TimeSeriesModelTest.dieUnless(i >= 3);
        }
        catch (UnsupportedOperationException e) {
            TimeSeriesModelTest.dieUnless(this.dsession.isProtocolVersionV1());
        }
    }

    void testDeletes() throws Exception {
        LOGGER.info("Testing Deletes..");
        String rowkey = "testdelete";
        int maxcols = 10;
        String invalidcolumn = UUIDs.timeBased().toString();
        ArrayList<String> uuids = new ArrayList<String>();
        for (int i = 0; i < maxcols; ++i) {
            uuids.add(this.timeseriesmodel.add(rowkey, new Hashtable(), 86400));
        }
        int size = this.timeseriesmodel.getFirstN(rowkey, maxcols, null).size();
        TimeSeriesModelTest.dieUnless(size >= 10);
        this.timeseriesmodel.deleteColumn(rowkey, new ArrayList<String>(Arrays.asList((String)uuids.get(0), (String)uuids.get(5))));
        TimeSeriesModelTest.dieUnless(size - this.timeseriesmodel.getFirstN(rowkey, maxcols, null).size() == 2);
        this.timeseriesmodel.deleteRow(rowkey);
        TimeSeriesModelTest.dieUnless(this.timeseriesmodel.getFirstColumn(rowkey, null) == null);
        this.timeseriesmodel.deleteColumn(rowkey, invalidcolumn);
    }
}

