/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.cassandra.datastax.tablemodels.test;

import com.adventnet.wms.servercommon.cassandra.datastax.DatastaxManager;
import com.adventnet.wms.servercommon.cassandra.datastax.DatastaxSession;
import com.adventnet.wms.servercommon.cassandra.datastax.tablemodels.test.CounterModelTest;
import com.adventnet.wms.servercommon.cassandra.datastax.tablemodels.test.TimeSeriesModelTest;
import com.adventnet.wms.servercommon.cassandra.datastax.tablemodels.test.UniqueKeyModelTest;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DatastaxTester {
    private static final Logger LOGGER = Logger.getLogger(DatastaxTester.class.getName());
    private final DatastaxSession dsession;
    public static final int DEFAULT_TTL = 86400;
    private static final boolean ISTHRIFTSUPPORTED = false;

    public DatastaxTester(DatastaxSession dsession) {
        this(dsession, false);
    }

    public DatastaxTester(DatastaxSession dsession, boolean ishectorcluster) {
        this.dsession = dsession;
    }

    public void testAll() throws Exception {
        LOGGER.info("\n\n\n\n\n\n\n\nTesting Datastax with \n" + this.dsession + ";\ntesting thrift?: " + false);
        this.testUniqueKeyModel();
        this.testCounterModel();
        this.testTimeSeriesModel();
        LOGGER.info("\n\n\n\n\n\n\n\nTesting Datastax completed with \n" + this.dsession + ";\ntesting thrift?: " + false);
    }

    public void testUniqueKeyModel() throws Exception {
        try {
            new UniqueKeyModelTest(this.dsession, false, null).test();
            new UniqueKeyModelTest(this.dsession, false, 1).test();
            LOGGER.info("All UniqueKeyModelTest test cases passed!");
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Test cases failed" + e.getMessage(), e);
            throw e;
        }
    }

    public void testCounterModel() throws Exception {
        try {
            new CounterModelTest(this.dsession, false, null).test();
            new CounterModelTest(this.dsession, false, 0).test();
            LOGGER.info("All CounterModelTest test cases passed!");
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Test cases failed" + e.getMessage(), e);
            throw e;
        }
    }

    public void testTimeSeriesModel() throws Exception {
        try {
            new TimeSeriesModelTest(this.dsession, false, 1, false).test();
            new TimeSeriesModelTest(this.dsession, false, 1, true).test();
            LOGGER.info("All TimeSeriesModelTest test cases passed!");
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Test cases failed" + e.getMessage(), e);
            throw e;
        }
    }

    public static void main(String[] args) throws Exception {
        String clusterid = args[0];
        String keyspacename = args[1];
        new DatastaxTester(DatastaxManager.getDatastaxSession(clusterid, keyspacename)).testAll();
    }
}

