/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.cassandra.datastax.tablemodels;

import com.adventnet.wms.common.HttpDataWraper;
import com.adventnet.wms.servercommon.cassandra.CassandraIDGenerator;
import com.adventnet.wms.servercommon.cassandra.datastax.DatastaxSession;
import com.adventnet.wms.servercommon.cassandra.datastax.QueryExecutor;
import com.adventnet.wms.servercommon.cassandra.datastax.QueryId;
import com.adventnet.wms.servercommon.cassandra.datastax.tablemodels.AbstractThriftCompatibleTableModel;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.Ordering;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TimeSeriesModel
extends AbstractThriftCompatibleTableModel {
    private static final Logger LOGGER = Logger.getLogger(TimeSeriesModel.class.getName());
    private static final String BM_START_CNAME = "startcname";
    private static final String BM_END_CNAME = "endcname";
    private final boolean reversed;

    public static QueryId[] allPreparableIds() {
        return TimeSeriesModel.allPreparableIds(TimeSeriesQuery.values());
    }

    public TimeSeriesModel(DatastaxSession dsession, String tablename, boolean reversed, String name_rowkey, String name_column1, String name_value) {
        super(dsession, tablename, name_rowkey, name_column1, name_value);
        this.reversed = reversed;
    }

    public static TimeSeriesModel build(DatastaxSession dsession, String tablename, boolean reversed, String name_rowkey, String name_column1, String name_value) throws Exception {
        return new TimeSeriesModel(dsession, tablename, reversed, name_rowkey, name_column1, name_value);
    }

    public static TimeSeriesModel build(DatastaxSession dsession, String tablename, boolean reversed, String name_rowkey, String name_column1, String name_value, int preparetype, QueryId ... queriestoprepare) throws Exception {
        TimeSeriesModel timeseriesmodel = new TimeSeriesModel(dsession, tablename, reversed, name_rowkey, name_column1, name_value);
        if (queriestoprepare != null) {
            for (QueryId query : queriestoprepare) {
                timeseriesmodel.prepareQuery(query, preparetype);
            }
        }
        return timeseriesmodel;
    }

    public static TimeSeriesModel build(DatastaxSession dsession, String tablename, boolean reversed, String name_rowkey, String name_column1, String name_value, Map<QueryId, Integer> queriestoprepare) throws Exception {
        TimeSeriesModel timeseriesmodel = new TimeSeriesModel(dsession, tablename, reversed, name_rowkey, name_column1, name_value);
        timeseriesmodel.prepareQueries(queriestoprepare);
        return timeseriesmodel;
    }

    @Override
    protected RegularStatement getStatementToPrepareForQuery(QueryId querytoprepare) throws Exception {
        Select statement = null;
        if (querytoprepare == TimeSeriesQuery.PUTONE) {
            if (!this.dsession.isProtocolVersionV1()) {
                LinkedHashMap<String, Object> criteria = new LinkedHashMap<String, Object>();
                criteria.put(this.name_column1, QueryBuilder.bindMarker((String)this.name_column1));
                criteria.put(this.name_value, QueryBuilder.bindMarker((String)this.name_value));
                statement = this.insert.values(QueryBuilder.bindMarker(), QueryBuilder.bindMarker(), QueryBuilder.bindMarker((String)this.name_rowkey), criteria);
            }
        } else if (querytoprepare == TimeSeriesQuery.GETONE) {
            statement = this.select.byFirstClusteringColumn(new String[]{this.name_value}, QueryBuilder.bindMarker(), this.name_column1, QueryBuilder.bindMarker());
        } else if (querytoprepare == TimeSeriesQuery.GETFIRSTN) {
            if (!this.dsession.isProtocolVersionV1()) {
                statement = this.select.byPartitionKey(new String[]{this.name_column1, this.name_value}, QueryBuilder.bindMarker(), QueryBuilder.bindMarker((String)this.name_rowkey));
            }
        } else if (querytoprepare == TimeSeriesQuery.GETSTARTINGFROMCOLUMN) {
            if (!this.dsession.isProtocolVersionV1()) {
                statement = this.reversed ? this.select.withLTEOnFirstClusteringColumn(new String[]{this.name_column1, this.name_value}, QueryBuilder.bindMarker(), QueryBuilder.bindMarker((String)this.name_rowkey), this.name_column1, QueryBuilder.bindMarker((String)this.name_column1)) : this.select.withGTEOnFirstClusteringColumn(new String[]{this.name_column1, this.name_value}, QueryBuilder.bindMarker(), QueryBuilder.bindMarker((String)this.name_rowkey), this.name_column1, QueryBuilder.bindMarker((String)this.name_column1));
            }
        } else if (querytoprepare == TimeSeriesQuery.GETENDINGTILLCOLUMN) {
            if (!this.dsession.isProtocolVersionV1()) {
                statement = this.reversed ? this.select.withGTEOnFirstClusteringColumn(new String[]{this.name_column1, this.name_value}, QueryBuilder.bindMarker(), QueryBuilder.bindMarker((String)this.name_rowkey), this.name_column1, QueryBuilder.bindMarker((String)this.name_column1)).orderBy(new Ordering[]{QueryBuilder.asc((String)QueryBuilder.quote((String)this.name_column1))}) : this.select.withLTEOnFirstClusteringColumn(new String[]{this.name_column1, this.name_value}, QueryBuilder.bindMarker(), QueryBuilder.bindMarker((String)this.name_rowkey), this.name_column1, QueryBuilder.bindMarker((String)this.name_column1)).orderBy(new Ordering[]{QueryBuilder.desc((String)QueryBuilder.quote((String)this.name_column1))});
            }
        } else if (querytoprepare == TimeSeriesQuery.GETINRANGE && !this.dsession.isProtocolVersionV1()) {
            statement = this.select.withBetweenOnFirstClusteringColumn(new String[]{this.name_column1, this.name_value}, null, QueryBuilder.bindMarker((String)this.name_rowkey), this.name_column1, QueryBuilder.bindMarker((String)BM_START_CNAME), QueryBuilder.bindMarker((String)BM_END_CNAME));
        }
        return statement;
    }

    private String put(String key, String timeuid, Hashtable cvalue, int ttl, ConsistencyLevel consistencylevel, Long timestamp) throws Exception {
        Insert statement = null;
        try {
            timestamp = timestamp == null ? CassandraIDGenerator.getTimeStamp() : timestamp;
            UUID uuid = UUID.fromString(timeuid);
            if (this.isPreparedQuery(TimeSeriesQuery.PUTONE)) {
                statement = this.getPreparedStatement(TimeSeriesQuery.PUTONE).bind().setString(this.name_rowkey, this.validated(QueryExecutor.Operation.PUT, key)).setUUID(this.name_column1, uuid).setString(this.name_value, HttpDataWraper.getString((Object)cvalue)).setLong("[timestamp]", timestamp.longValue()).setInt("[ttl]", ttl);
            } else {
                LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
                values.put(this.name_column1, uuid);
                values.put(this.name_value, HttpDataWraper.getString((Object)cvalue));
                statement = this.insert.values(ttl, timestamp, key, values);
            }
            if (consistencylevel != null) {
                statement.setConsistencyLevel(consistencylevel);
            }
            LOGGER.fine("TimeSeriesModel#add for key: " + key + " timeuid: " + timeuid + " cvalue: " + cvalue + " ttl: " + ttl + " cl: " + consistencylevel + " ts: " + timestamp);
            QueryExecutor.execute(this.dsession, QueryExecutor.Operation.PUT, this.table, (Statement)statement);
            return timeuid;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception in TimeSeriesModel#add", e);
            throw e;
        }
    }

    public String add(String key, Hashtable cvalue, int ttl) throws Exception {
        return this.add(key, cvalue, ttl, null);
    }

    public String add(String key, Hashtable cvalue, int ttl, ConsistencyLevel consistencylevel) throws Exception {
        return this.add(key, cvalue, ttl, consistencylevel, null);
    }

    public String add(String key, Hashtable cvalue, int ttl, ConsistencyLevel consistencylevel, Long timestamp) throws Exception {
        return this.put(key, CassandraIDGenerator.getTimeUUID(), cvalue, ttl, consistencylevel, timestamp);
    }

    public String updateColumn(String key, String cname, Hashtable cvalue, int ttl) throws Exception {
        return this.put(key, cname, cvalue, ttl, null, null);
    }

    public String updateColumn(String key, String cname, Hashtable cvalue, int ttl, ConsistencyLevel consistencylevel) throws Exception {
        return this.put(key, cname, cvalue, ttl, consistencylevel, null);
    }

    public String updateColumn(String key, String cname, Hashtable cvalue, int ttl, ConsistencyLevel consistencylevel, Long timestamp) throws Exception {
        return this.put(key, cname, cvalue, ttl, consistencylevel, timestamp);
    }

    public Hashtable getColumn(String key, String cname) throws Exception {
        return this.getColumn(key, cname, null);
    }

    public Hashtable getColumn(String key, String cname, ConsistencyLevel consistencylevel) throws Exception {
        ResultSet resultset = null;
        Object statement = null;
        try {
            Row row;
            statement = this.isPreparedQuery(TimeSeriesQuery.GETONE) ? this.getPreparedStatement(TimeSeriesQuery.GETONE).bind(new Object[]{this.validated(QueryExecutor.Operation.GET, key), UUID.fromString(cname)}) : this.select.byFirstClusteringColumn(new String[]{this.name_value}, key, this.name_column1, UUID.fromString(cname));
            if (consistencylevel != null) {
                statement.setConsistencyLevel(consistencylevel);
            }
            LOGGER.fine("TimeSeriesModel#getColumn for key: " + key + " cname: " + cname + " cl: " + consistencylevel);
            resultset = QueryExecutor.execute(this.dsession, QueryExecutor.Operation.GET, this.table, (Statement)statement);
            if (resultset != null && (row = resultset.one()) != null) {
                String value = row.getString(this.name_value);
                return value == null ? null : (Hashtable)HttpDataWraper.getObject((String)value);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception in TimeSeriesModel#getColumn", e);
            throw e;
        }
        return null;
    }

    public Hashtable getFirstColumn(String key, ConsistencyLevel consistencylevel) throws Exception {
        ArrayList results = this.getFirstN(key, 1, consistencylevel);
        if (results == null || results.isEmpty()) {
            return null;
        }
        return (Hashtable)results.get(0);
    }

    public ArrayList getFirstN(String key, int limit, ConsistencyLevel consistencylevel) throws Exception {
        Object statement = null;
        ResultSet resultset = null;
        try {
            statement = this.isPreparedQuery(TimeSeriesQuery.GETFIRSTN) ? this.getPreparedStatement(TimeSeriesQuery.GETFIRSTN).bind().setString(this.name_rowkey, this.validated(QueryExecutor.Operation.GET, key)).setInt("[limit]", limit) : this.select.byPartitionKey(new String[]{this.name_column1, this.name_value}, limit, key);
            if (consistencylevel != null) {
                statement.setConsistencyLevel(consistencylevel);
            }
            LOGGER.fine("TimeSeriesModel#getFirstN for key: " + key + " limit: " + limit + " cl: " + consistencylevel);
            resultset = QueryExecutor.execute(this.dsession, QueryExecutor.Operation.GET, this.table, (Statement)statement);
            if (resultset != null) {
                return this.packData(resultset);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception in TimeSeriesModel#getFirstN", e);
            throw e;
        }
        return null;
    }

    public ArrayList getNFromColumn(String key, String start_cname, int limit, ConsistencyLevel consistencylevel) throws Exception {
        if (start_cname == null) {
            return this.getFirstN(key, limit, consistencylevel);
        }
        Object statement = null;
        ResultSet resultset = null;
        try {
            statement = this.isPreparedQuery(TimeSeriesQuery.GETSTARTINGFROMCOLUMN) ? this.getPreparedStatement(TimeSeriesQuery.GETSTARTINGFROMCOLUMN).bind().setString(this.name_rowkey, this.validated(QueryExecutor.Operation.GET, key)).setUUID(this.name_column1, UUID.fromString(start_cname)).setInt("[limit]", limit) : (this.reversed ? this.select.withLTEOnFirstClusteringColumn(new String[]{this.name_column1, this.name_value}, limit, key, this.name_column1, UUID.fromString(start_cname)) : this.select.withGTEOnFirstClusteringColumn(new String[]{this.name_column1, this.name_value}, limit, key, this.name_column1, UUID.fromString(start_cname)));
            if (consistencylevel != null) {
                statement.setConsistencyLevel(consistencylevel);
            }
            LOGGER.fine("TimeSeriesModel#getNFromColumn for key: " + key + " start_cname: " + start_cname + " limit: " + limit + " cl: " + consistencylevel);
            resultset = QueryExecutor.execute(this.dsession, QueryExecutor.Operation.GET, this.table, (Statement)statement);
            if (resultset != null) {
                return this.packData(resultset);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception in TimeSeriesModel#getNFromColumn", e);
            throw e;
        }
        return null;
    }

    private ArrayList packData(ResultSet resultset) {
        List rows = resultset.all();
        if (rows == null || rows.isEmpty()) {
            return null;
        }
        ArrayList<Hashtable> arr = new ArrayList<Hashtable>();
        for (Row row : rows) {
            String cname = row.getUUID(this.name_column1).toString();
            String value = row.getString(this.name_value);
            if (value == null) continue;
            Hashtable data = (Hashtable)HttpDataWraper.getObject((String)value);
            data.put("_sys.cname", cname);
            arr.add(data);
        }
        return arr;
    }

    public ArrayList getInRange(String key, String start_cname, String end_cname, ConsistencyLevel consistencylevel) throws Exception {
        if (end_cname == null) {
            throw new IllegalArgumentException("end_cname null");
        }
        if (start_cname == null) {
            ArrayList result = this.getNTillColumn(key, end_cname, Integer.MAX_VALUE, consistencylevel);
            if (result != null) {
                Collections.reverse(result);
            }
            return result;
        }
        String older_timeuuid = this.reversed ? end_cname : start_cname;
        String newer_timeuuid = this.reversed ? start_cname : end_cname;
        Object statement = null;
        ResultSet resultset = null;
        try {
            statement = this.isPreparedQuery(TimeSeriesQuery.GETINRANGE) ? this.getPreparedStatement(TimeSeriesQuery.GETINRANGE).bind().setString(this.name_rowkey, this.validated(QueryExecutor.Operation.GET, key)).setUUID(BM_START_CNAME, UUID.fromString(older_timeuuid)).setUUID(BM_END_CNAME, UUID.fromString(newer_timeuuid)) : this.select.withBetweenOnFirstClusteringColumn(new String[]{this.name_column1, this.name_value}, null, key, this.name_column1, UUID.fromString(older_timeuuid), UUID.fromString(newer_timeuuid));
            if (consistencylevel != null) {
                statement.setConsistencyLevel(consistencylevel);
            }
            LOGGER.fine("TimeSeriesModel#getInRange for key: " + key + " start_cname: " + start_cname + " end_cname: " + end_cname + " cl: " + consistencylevel);
            resultset = QueryExecutor.execute(this.dsession, QueryExecutor.Operation.GET, this.table, (Statement)statement);
            if (resultset != null) {
                return this.packData(resultset);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception in TimeSeriesModel#getInRange", e);
            throw e;
        }
        return null;
    }

    public ArrayList getNTillColumn(String key, String end_cname, int limit, ConsistencyLevel consistencylevel) throws Exception {
        if (end_cname == null) {
            return this.getFirstN(key, limit, consistencylevel);
        }
        Object statement = null;
        ResultSet resultset = null;
        try {
            statement = this.isPreparedQuery(TimeSeriesQuery.GETENDINGTILLCOLUMN) ? this.getPreparedStatement(TimeSeriesQuery.GETENDINGTILLCOLUMN).bind().setString(this.name_rowkey, this.validated(QueryExecutor.Operation.GET, key)).setUUID(this.name_column1, UUID.fromString(end_cname)).setInt("[limit]", limit) : (this.reversed ? this.select.withGTEOnFirstClusteringColumn(new String[]{this.name_column1, this.name_value}, limit, key, this.name_column1, UUID.fromString(end_cname)).orderBy(new Ordering[]{QueryBuilder.asc((String)QueryBuilder.quote((String)this.name_column1))}) : this.select.withLTEOnFirstClusteringColumn(new String[]{this.name_column1, this.name_value}, limit, key, this.name_column1, UUID.fromString(end_cname)).orderBy(new Ordering[]{QueryBuilder.desc((String)QueryBuilder.quote((String)this.name_column1))}));
            if (consistencylevel != null) {
                statement.setConsistencyLevel(consistencylevel);
            }
            LOGGER.fine("TimeSeriesModel#getNTillColumn for key: " + key + " end_cname: " + end_cname + "limit: " + limit + " cl: " + consistencylevel);
            resultset = QueryExecutor.execute(this.dsession, QueryExecutor.Operation.GET, this.table, (Statement)statement);
            if (resultset != null) {
                return this.packData(resultset);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception in TimeSeriesModel#getNFromColumn", e);
            throw e;
        }
        return null;
    }

    public ResultSet getRowKeys(String startrowkey, int limit, ConsistencyLevel consistencylevel, Integer fetchsize) throws Exception {
        return this.getRowKeys(startrowkey, null, limit, consistencylevel, fetchsize);
    }

    public ResultSet getRowKeys(String startrowkey, String endrowkey, int limit, ConsistencyLevel consistencylevel, Integer fetchsize) throws Exception {
        if (this.dsession.isProtocolVersionV1()) {
            throw new UnsupportedOperationException("Row iteration not supported in protocol version v1. Apply the patch from https://issues.apache.org/jira/browse/CASSANDRA-4536 and use direct cql with QueryExecutor");
        }
        SimpleStatement statement = null;
        try {
            StringBuilder sb = new StringBuilder("SELECT DISTINCT \"" + this.name_rowkey + "\" FROM \"" + this.table + "\"").append(" WHERE token(\"" + this.name_rowkey + "\") >= token('" + this.validated(QueryExecutor.Operation.GET, startrowkey) + "')");
            if (endrowkey != null) {
                sb.append(" AND token(\"" + this.name_rowkey + "\") <= token('" + this.validated(QueryExecutor.Operation.GET, endrowkey) + "')");
            }
            sb.append(" LIMIT " + limit + ";");
            statement = new SimpleStatement(sb.toString());
            if (consistencylevel != null) {
                statement.setConsistencyLevel(consistencylevel);
            }
            if (fetchsize != null) {
                statement.setFetchSize(fetchsize.intValue());
            }
            LOGGER.fine("TimeSeriesModel#getRowKeys for startrowkey: " + startrowkey + "limit: " + limit + " fetchsize: " + fetchsize + " cl: " + consistencylevel);
            return QueryExecutor.execute(this.dsession, QueryExecutor.Operation.GET, this.table, (Statement)statement);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception in TimeSeriesModel#getRowKeys", e);
            throw e;
        }
    }

    @Override
    public void deleteColumn(String key, String cname) throws Exception {
        Object statement = null;
        try {
            statement = this.isPreparedQuery(AbstractThriftCompatibleTableModel.CommonQuery.DELETECOLUMN) ? this.getPreparedStatement(AbstractThriftCompatibleTableModel.CommonQuery.DELETECOLUMN).bind().setString(this.name_rowkey, this.validated(QueryExecutor.Operation.DEL, key)).setUUID(this.name_column1, UUID.fromString(cname)).setLong("[timestamp]", CassandraIDGenerator.getTimeStamp()) : this.delete.byFirstClusteringKey(CassandraIDGenerator.getTimeStamp(), key, this.name_column1, UUID.fromString(cname));
            LOGGER.fine("TimeSeriesModel#deleteColumn for key: " + key + "cname: " + cname);
            QueryExecutor.execute(this.dsession, QueryExecutor.Operation.DEL, this.table, (Statement)statement);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception in TimeSeriesModel#deleteColumn", e);
            throw e;
        }
    }

    public static enum TimeSeriesQuery implements QueryId
    {
        PUTONE(true),
        GETONE(true),
        GETFIRSTN(true),
        GETSTARTINGFROMCOLUMN(true),
        GETENDINGTILLCOLUMN(true),
        GETINRANGE(true);

        private final boolean ispreparable;

        private TimeSeriesQuery(boolean ispreparable) {
            this.ispreparable = ispreparable;
        }

        @Override
        public boolean isPreparable() {
            return this.ispreparable;
        }

        @Override
        public String getIdentifier() {
            return this.name();
        }
    }
}

