/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.cassandra.datastax.tablemodels;

import com.adventnet.wms.servercommon.cassandra.datastax.DatastaxSession;
import com.adventnet.wms.servercommon.cassandra.datastax.QueryId;
import com.adventnet.wms.servercommon.cassandra.datastax.tablemodels.TableModel;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;

public abstract class AbstractTableModel
implements TableModel {
    protected DatastaxSession dsession;
    protected String table;

    public AbstractTableModel(DatastaxSession dsession, String table) {
        this.dsession = dsession;
        this.table = table;
    }

    protected boolean isPreparedQuery(QueryId query) {
        return this.dsession.isPreparedQuery(this.table, query.getIdentifier());
    }

    protected PreparedStatement getPreparedStatement(QueryId query) throws Exception {
        return this.dsession.getPreparedStatement(this.table, query.getIdentifier());
    }

    protected void registerPreparedQuery(QueryId query, RegularStatement statement, Integer preparetype) throws Exception {
        this.dsession.registerPreparedQuery(this.table, query.getIdentifier(), statement, preparetype);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.table + ")";
    }
}

