/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.cassandra.datastax;

import com.adventnet.wms.servercommon.cassandra.datastax.DatastaxSession;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.ExecutionInfo;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Iterator;
import java.util.List;

class WrappedResultSet
implements ResultSet {
    private final ResultSet rs;
    private final DatastaxSession dsession;

    public WrappedResultSet(DatastaxSession dsession, ResultSet rs) {
        this.rs = rs;
        this.dsession = dsession;
        if (dsession.isInstrumentationEnabled()) {
            if (rs.getAvailableWithoutFetching() == 0) {
                WrappedResultSet.statEmptyResultSet();
            } else {
                WrappedResultSet.statRetrievedResultCount(rs.getAvailableWithoutFetching());
            }
        }
    }

    public ColumnDefinitions getColumnDefinitions() {
        return this.rs.getColumnDefinitions();
    }

    public boolean isExhausted() {
        return this.rs.isExhausted();
    }

    public Row one() {
        return this.rs.one();
    }

    public List<Row> all() {
        return this.rs.all();
    }

    public Iterator<Row> iterator() {
        return new WrappedIterator(this.rs.iterator());
    }

    public int getAvailableWithoutFetching() {
        return this.rs.getAvailableWithoutFetching();
    }

    public boolean isFullyFetched() {
        return this.rs.isFullyFetched();
    }

    public ListenableFuture<ResultSet> fetchMoreResults() {
        if (this.dsession.isInstrumentationEnabled()) {
            int alreadyavailable = this.rs.getAvailableWithoutFetching();
            ListenableFuture listenablefuture = this.rs.fetchMoreResults();
            WrappedResultSet.statRetrievedResultCount(this.rs.getAvailableWithoutFetching() - alreadyavailable);
            return listenablefuture;
        }
        return this.rs.fetchMoreResults();
    }

    public ExecutionInfo getExecutionInfo() {
        return this.rs.getExecutionInfo();
    }

    public List<ExecutionInfo> getAllExecutionInfo() {
        return this.rs.getAllExecutionInfo();
    }

    public boolean wasApplied() {
        return this.rs.wasApplied();
    }

    private static void statEmptyResultSet() {
    }

    private static void statRetrievedResultCount(int count) {
    }

    private static class WrappedIterator
    implements Iterator<Row> {
        private Iterator<Row> iterator;

        public WrappedIterator(Iterator<Row> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Row next() {
            return this.iterator.next();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

