/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.cassandra.datastax;

import com.adventnet.wms.servercommon.cassandra.datastax.DatastaxSession;
import com.adventnet.wms.servercommon.cassandra.datastax.QueryExecutor;
import com.adventnet.wms.servercommon.cassandra.datastax.validation.PartitionKeyValidator;
import com.adventnet.wms.servercommon.cassandra.datastax.validation.ValidatorException;
import com.datastax.driver.core.querybuilder.BindMarker;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.datastax.driver.core.querybuilder.Update;
import java.util.LinkedHashMap;
import java.util.Map;

public final class StatementBuilder {
    public static SelectStatement select(DatastaxSession dsession, String table, String partitionkeyname) {
        return new SelectStatement(dsession, table, partitionkeyname);
    }

    public static InsertStatement insert(DatastaxSession dsession, String table, String partitionkeyname) {
        return new InsertStatement(dsession, table, partitionkeyname);
    }

    public static UpdateStatement update(DatastaxSession dsession, String table, String partitionkeyname, String clusteringkeyname, String valuecolname) {
        return new UpdateStatement(dsession, table, partitionkeyname, clusteringkeyname, valuecolname);
    }

    public static DeleteStatement delete(DatastaxSession dsession, String table, String partitionkeyname) {
        return new DeleteStatement(dsession, table, partitionkeyname);
    }

    public static String[] quoted(String[] columnstoquote) {
        for (int i = 0; i < columnstoquote.length; ++i) {
            columnstoquote[i] = QueryBuilder.quote((String)columnstoquote[i]);
        }
        return columnstoquote;
    }

    public static final class DeleteStatement
    extends Statement {
        public DeleteStatement(DatastaxSession dsession, String table, String partitionkeyname) {
            super(QueryExecutor.Operation.DEL, dsession, table, partitionkeyname);
        }

        public Delete byPartitionKey(Object timestamp, Object partitionkeyvalue) throws Exception {
            Delete delete = QueryBuilder.delete().from(QueryBuilder.quote((String)this.table));
            delete.where(QueryBuilder.eq((String)QueryBuilder.quote((String)this.partitionkeyname), (Object)this.validated(partitionkeyvalue)));
            if (timestamp != null) {
                if (timestamp instanceof BindMarker) {
                    delete.using(QueryBuilder.timestamp((BindMarker)((BindMarker)timestamp)));
                } else {
                    delete.using(QueryBuilder.timestamp((long)((Long)timestamp)));
                }
            }
            return delete;
        }

        public Delete byFirstClusteringKey(Object timestamp, Object partitionkeyvalue, String clusteringkeyname, Object ... clusteringkeyvalues) throws Exception {
            Delete delete = this.byPartitionKey(timestamp, partitionkeyvalue);
            if (clusteringkeyvalues == null) {
                return null;
            }
            if (clusteringkeyvalues.length == 1) {
                delete.where(QueryBuilder.eq((String)QueryBuilder.quote((String)clusteringkeyname), (Object)clusteringkeyvalues[0]));
            } else {
                delete.where(QueryBuilder.in((String)QueryBuilder.quote((String)clusteringkeyname), (Object[])clusteringkeyvalues));
            }
            return delete;
        }
    }

    public static final class UpdateStatement
    extends Statement {
        private final String clusteringkeyname;
        private final String valuecolname;

        public UpdateStatement(DatastaxSession dsession, String table, String partitionkeyname, String clusteringkeyname, String valuecolname) {
            super(QueryExecutor.Operation.INCR, dsession, table, partitionkeyname);
            this.clusteringkeyname = clusteringkeyname;
            this.valuecolname = valuecolname;
        }

        public Update incrementValueColumn(Object partitionkeyvalue, Object clusteringkeyvalue, Object delta) throws Exception {
            Update update = QueryBuilder.update((String)QueryBuilder.quote((String)this.table));
            update.where(QueryBuilder.eq((String)QueryBuilder.quote((String)this.partitionkeyname), (Object)this.validated(partitionkeyvalue))).and(QueryBuilder.eq((String)QueryBuilder.quote((String)this.clusteringkeyname), (Object)clusteringkeyvalue));
            if (delta instanceof BindMarker) {
                update.with(QueryBuilder.incr((String)QueryBuilder.quote((String)this.valuecolname), (BindMarker)((BindMarker)delta)));
            } else {
                update.with(QueryBuilder.incr((String)QueryBuilder.quote((String)this.valuecolname), (long)((Long)delta)));
            }
            return update;
        }
    }

    public static final class InsertStatement
    extends Statement {
        public InsertStatement(DatastaxSession dsession, String table, String partitionkeyname) {
            super(QueryExecutor.Operation.PUT, dsession, table, partitionkeyname);
        }

        public Insert values(Object ttlinsecs, Object timestamp, Object partitionkeyvalue, LinkedHashMap<String, Object> values) throws Exception {
            Insert insert = QueryBuilder.insertInto((String)QueryBuilder.quote((String)this.table));
            insert.value(QueryBuilder.quote((String)this.partitionkeyname), this.validated(partitionkeyvalue));
            for (Map.Entry<String, Object> entry : values.entrySet()) {
                insert.value(QueryBuilder.quote((String)entry.getKey()), entry.getValue());
            }
            if (timestamp != null) {
                if (timestamp instanceof BindMarker) {
                    insert.using(QueryBuilder.timestamp((BindMarker)((BindMarker)timestamp)));
                } else {
                    insert.using(QueryBuilder.timestamp((long)((Long)timestamp)));
                }
            }
            if (ttlinsecs != null) {
                if (ttlinsecs instanceof BindMarker) {
                    insert.using(QueryBuilder.ttl((BindMarker)((BindMarker)ttlinsecs)));
                } else {
                    insert.using(QueryBuilder.ttl((int)((Integer)ttlinsecs)));
                }
            }
            return insert;
        }
    }

    public static final class SelectStatement
    extends Statement {
        public SelectStatement(DatastaxSession dsession, String table, String partitionkeyname) {
            super(QueryExecutor.Operation.GET, dsession, table, partitionkeyname);
        }

        private Select select(String[] columns, Object limit) throws Exception {
            Select select = QueryBuilder.select((String[])StatementBuilder.quoted(columns)).from(QueryBuilder.quote((String)this.table));
            if (limit != null) {
                if (limit instanceof BindMarker) {
                    select.limit((BindMarker)limit);
                } else {
                    select.limit(((Integer)limit).intValue());
                }
            }
            return select;
        }

        public Select getAllRowKeys(String[] columns) throws Exception {
            return this.select(columns, 500);
        }

        public Select byPartitionKey(String[] columns, Object limit, Object partitionkeyvalue) throws Exception {
            Select select = this.select(columns, limit);
            select.where(QueryBuilder.eq((String)QueryBuilder.quote((String)this.partitionkeyname), (Object)this.validated(partitionkeyvalue)));
            return select;
        }

        public Select byFirstClusteringColumn(String[] columns, Object partitionkeyvalue, String clusteringkeyname, Object ... clusteringkeyvalues) throws Exception {
            Select select = this.byPartitionKey(columns, null, partitionkeyvalue);
            if (clusteringkeyvalues != null) {
                if (clusteringkeyvalues.length == 1) {
                    select.where(QueryBuilder.eq((String)QueryBuilder.quote((String)clusteringkeyname), (Object)clusteringkeyvalues[0]));
                } else {
                    select.where(QueryBuilder.in((String)QueryBuilder.quote((String)clusteringkeyname), (Object[])clusteringkeyvalues));
                }
            }
            return select;
        }

        public Select withGTEOnFirstClusteringColumn(String[] columns, Object limit, Object partitionkeyvalue, String clusteringkeyname, Object clusteringkeystartvalue) throws Exception {
            Select select = this.byPartitionKey(columns, limit, partitionkeyvalue);
            select.where(QueryBuilder.gte((String)QueryBuilder.quote((String)clusteringkeyname), (Object)clusteringkeystartvalue));
            return select;
        }

        public Select withLTEOnFirstClusteringColumn(String[] columns, Object limit, Object partitionkeyvalue, String clusteringkeyname, Object clusteringkeystartvalue) throws Exception {
            Select select = this.byPartitionKey(columns, limit, partitionkeyvalue);
            select.where(QueryBuilder.lte((String)QueryBuilder.quote((String)clusteringkeyname), (Object)clusteringkeystartvalue));
            return select;
        }

        public Select withBetweenOnFirstClusteringColumn(String[] columns, Object limit, Object partitionkeyvalue, String clusteringkeyname, Object cluskeystartvalue, Object cluskeyendvalue) throws Exception {
            Select select = this.withGTEOnFirstClusteringColumn(columns, limit, partitionkeyvalue, clusteringkeyname, cluskeystartvalue);
            select.where(QueryBuilder.lte((String)QueryBuilder.quote((String)clusteringkeyname), (Object)cluskeyendvalue));
            return select;
        }

        public Select distinctPartitionKeys(Integer limit) throws Exception {
            Select select = QueryBuilder.select().distinct().column(QueryBuilder.quote((String)this.partitionkeyname)).from(QueryBuilder.quote((String)this.table));
            if (limit != null) {
                select.limit(limit.intValue());
            }
            return select;
        }
    }

    private static class Statement {
        protected final DatastaxSession dsession;
        protected final String table;
        protected final String partitionkeyname;
        protected final PartitionKeyValidator pkvalidator;
        protected final QueryExecutor.Operation opr;

        public Statement(QueryExecutor.Operation opr, DatastaxSession dsession, String table, String partitionkeyname) {
            this.opr = opr;
            this.dsession = dsession;
            this.table = table;
            this.partitionkeyname = partitionkeyname;
            this.pkvalidator = dsession.getPartitionKeyValidator(table);
        }

        protected Object validated(Object pkvalue) throws ValidatorException {
            if (this.pkvalidator != null && !(pkvalue instanceof BindMarker)) {
                this.pkvalidator.validate(this.opr, pkvalue);
            }
            return pkvalue;
        }
    }
}

